#include <OI/oi.H>			/* Tire.C */

	const	char	OI_n_severe0[] = "severity0";	// severity resource name 
	const	char	OI_n_severe1[] = "severity1";	// severity resource name 
	const	char	OI_n_severe2[] = "severity2";	// severity resource name 
	const	char	OI_n_severe3[] = "severity3";	// severity resource name 
	const	char	OI_n_severe4[] = "severity4";	// severity resource name 
	const	char	OI_c_Severity[] = "Severity";	// severity resource class 
	const	char	OI_n_tire[] = "tire";		// tire bitmap file name
	const	char	OI_c_Tire[] = "Tire";		// tire bitmap file name

		struct MyRes {							// structure to hold my resources 
			PIXEL		barActiveColor;
			char		*bitmapFile;
		};
	static	MyRes MyResources = {0,0};

	static	OI_resource		resources[] = {
		{OI_n_barActiveColor, OI_c_BarActiveColor, OI_r_Pixel, sizeof(PIXEL), offsetof(MyRes, barActiveColor)},
		{OI_n_tire, OI_c_Tire, OI_r_String, sizeof(char*), offsetof(MyRes, bitmapFile)},
		};

int main(int argc, char** argv)
{

		void set_air(OI_ctlr_1d*,void*,OI_scroll_event,long);

		OI_connection		*conp;
		OI_app_window		*wp;
		OI_gauge		*gp;
		OI_slider		*sp;
		OI_glyph		*picp;

	if (conp = OI_init(&argc,argv,"Tire")) {
		wp = oi_create_app_window("main",1,1,"Tire");
		wp->set_layout(OI_layout_row_aligned);
		gp = oi_create_gauge("my_gauge",200,OI_horizontal,200,0,"Air Remaining:",OI_gauge_ends_none, NULL,NULL,OI_no,6,OI_gauge_ticks_all);
		gp->layout_associated_object(wp,1,1,OI_active);
		picp = oi_create_glyph("tire","../bitmaps/tire0",NULL,OI_pic_mask,OI_no,OI_no);
		picp->layout_associated_object(wp,2,1,OI_active);
		sp = oi_create_slider("my_slider",200,OI_horizontal,200,0,&set_air,gp,"Set Air Remaining:");
		sp->set_handle_loc(sp->maximum());
		sp->layout_associated_object(wp,1,3,OI_active);
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
		OI_fini();
	}
}
void set_air(OI_ctlr_1d *sp, void *argp, OI_scroll_event, long)
{
	OI_gauge		*gp;
	OI_glyph		*picp;
	float			ratio;

	gp = (OI_gauge*)argp;
	picp = (OI_glyph*)gp->parent()->subobject("tire");
	ratio = (float)(sp->handle_loc())/float(sp->span());
	if (ratio < .2)
		gp->get_sub_resources(OI_n_severe4,OI_c_Severity,&resources[0],OI_count(resources),&MyResources);
	else if (ratio < .4)
		gp->get_sub_resources(OI_n_severe3,OI_c_Severity,&resources[0],OI_count(resources),&MyResources);
	else if (ratio < .6)
		gp->get_sub_resources(OI_n_severe2,OI_c_Severity,&resources[0],OI_count(resources),&MyResources);
	else if (ratio < .8)
		gp->get_sub_resources(OI_n_severe1,OI_c_Severity,&resources[0],OI_count(resources),&MyResources);
	else
		gp->get_sub_resources(OI_n_severe0,OI_c_Severity,&resources[0],OI_count(resources),&MyResources);
	gp->set_value(sp->handle_loc());
	gp->set_active_pixel(MyResources.barActiveColor);
	if (MyResources.bitmapFile)
		picp->set_file(MyResources.bitmapFile);
	return;
}
