#include <OI/oi.H>

/*
 *	KeyHelp_res
 *
 *	This program should be invoked as:
 *		./keyhelp_res -config keyhelp.res
 *	
 *	This program demonstrates the use of the OI help mechanism, as
 *	setup through the resource mechanism.
 *	The help text file, keyhelp.hp, must exist in this directory
 *	for this program to correctly function.  Please refer to the
 *	README file for information on a second program which demonstrates
 *	how to programmatically set up the help mechanism.
 *
 *	The reader should refer to xmodmap man pages for information
 *	on how to specify which key on the keyboard should initiate
 *	help.  In this example, I have the following line:
 *		xmodmap -e "keysym KP_F4 = Help"
 *	in my ~/.xsession (~/.Xdefaults) file, to specify that key PF4
 *	should initiate help.
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *		- OIIntro
 *			OI_init()
 *			OI_begin_interaction()
 *			OI_fini()
 *		- OI_resources
 *			For additional discussion on how to use the
 *			resource mechanism.
 *		- OI_d_tech
 *			layout_associated_object()
 *			set_associated_object()
 *			set_layout()
 *		- OI_app_window
 *			oi_create_app_window()
 *		- OI_static_text
 *			oi_create_static_text()
 *
 *	The general structure of a help file is discussed within the
 *	OI_app_window man pages under the set_help member function.
 *	However, in this example, the help text file would take the following form:
 *		@Topic@Hello
 *		@Sub Topics@World
 *		@Sub Topics@Universe
 *		@Related Topics@Query
 *		This is the help text for general "Hello".
 *		@Topic@World
 *		@Related Topics@Hello
 *		@Related Topics@Universe
 *		@Related Topics@Query
 *		This is the help text for "Hello World".
 *		@Topic@Universe
 *		@Related Topics@Hello
 *		@Related Topics@World
 *		@Related Topics@Query
 *		This is the help text for "Hello Universe".
 *		@Topic@Query
 *		@Related Topics@Hello
 *		This is the help text for "Is anyone home?"
 *	This indicates that 
 *		Topic (Hello) has subtopics (World, Universe) and a related
 *			topic (Query).  The help for topic (Hello) consists of:
 *				(This is the help text for general "Hello".)
 *		Topic (World) has no subtopics, but has related topics
 *			(Hello, Universe, Query).  The help for this topic 
 *			consists of:
 *				(This is the help text for "Hello World".)
 *		etc.
 */

void
main(int argc, char**argv)
{
	OI_connection	*conp ;
	OI_app_window	*wp ;
	OI_static_text	*tp ;

	/*
	 *	Open a connection.
	 */
	if (conp=OI_init(&argc,argv,"test")) {

		/*
		 *	Create application main window.  Make it row layout.
		 */
		wp = oi_create_app_window("main",300,200,"Main") ;
		wp->set_layout(OI_layout_row) ;

		/*
		 *	Create three static text objects, and place them
		 *	within the application window.
		 */
		tp = oi_create_static_text("world","Hello, World!") ;
		tp->layout_associated_object(wp,0,1,OI_ACTIVE) ;

		tp = oi_create_static_text("universe","Hello, Universe!") ;
		tp->layout_associated_object(wp,0,2,OI_ACTIVE) ;

		tp = oi_create_static_text("query","Is anyone home?") ;
		tp->layout_associated_object(wp,0,3,OI_ACTIVE) ;

		/*
		 *	Begin Interaction.
		 */
		wp->set_associated_object(wp->root(),OI_DEF_LOC,OI_DEF_LOC,OI_ACTIVE) ;
		OI_begin_interaction() ;

		/*
		 * Cleanup.  Make sure that we cleanup the library.
		 */
		OI_fini();
	}
}
