/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1992, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	pnbox.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Object Interface OI_paned_box class header
 *
 *	RCSid = "$Id: pnbox.H,v 4.24.1.1 1993/06/01 22:56:07 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_pnbox_H
#define OI_pnbox_H

#ifndef OI_box_H
#include <OI/box.H>
#endif /* OI_box_H */

#ifndef OI_pane_grip_H
#include <OI/pngrip.H>
#endif /* OI_pane_grip_H */

 /* private ctl_bits */
#define OI_PANED_BOX_IN_CONSTRUCTOR	0x01L
#define OI_PANED_BOX_ALLOW_DRAG		0x02L
#define OI_PANED_BOX_RESIZE_BY_GRIP	0x04L
#define OI_PANED_BOX_REAL_TIME_DRAG	0x08L
#define OI_PANED_BOX_IN_GRIP_MOVE	0x10L


	class OI_paned_box : public OI_box {

	 friend class OI_pane;
	 friend class OI_pane_grip;

	 private: // variables
			unsigned long	ctl_bits ;		/* object specific control bits */

			/**********************************************************************
			*  paned_box resources
			**********************************************************************/
			OI_orient	orient;
			/**********************************************************************
			*  end of paned_box resources
			**********************************************************************/

	 protected: // variables

	 public: // variables
		static	OI_class		*clsp ;								/* ptr to class record */
			OI_number		n_panes;

	 private: // functions
			void		adjust_for_grip_moved( OI_number grip_moved, long delta);
			void		allow_drag()			{ ctl_bits |= OI_PANED_BOX_ALLOW_DRAG; }
			void		clear_in_my_constructor()	{ctl_bits&= ~OI_PANED_BOX_IN_CONSTRUCTOR;}
			void		construct(OI_number,OI_number,OI_orient,OI_number) ;
			void		decrement_pos_for_panes(OI_number pos=0);
			void		disallow_drag()			{ ctl_bits &= ~OI_PANED_BOX_ALLOW_DRAG; }
			OI_bool		in_my_constructor()		{return((ctl_bits&OI_PANED_BOX_IN_CONSTRUCTOR) ? OI_YES : OI_NO);}
			void		increment_pos_for_panes(OI_number start_pos=0, OI_number stop_pos=OI_number_max);
			OI_bool		is_drag()			{ return ((ctl_bits & OI_PANED_BOX_ALLOW_DRAG) ? OI_YES : OI_NO); }
			OI_number	make_room_for_pane_at(OI_number pos);
			void		rename_panes();
			void		set_in_my_constructor()		{ctl_bits|=OI_PANED_BOX_IN_CONSTRUCTOR;}
			void		set_pane_sizes_to_stored_value();
			void		show_seps_in_new_locs();
			OI_number	store_pane_size(OI_number, long);
	 protected: // functions
					OI_paned_box(OI_class *clsp, const char *usr_namp, OI_number w, OI_number h, OI_orient, OI_number) ;
		//virtual	void		resize(OI_d_tech *, void *) ;
			void		inc_n_panes()			{ n_panes++; }
			OI_bool		is_at_separator(long);
			OI_pane_grip	*is_in_grip(long);
			void		dec_n_panes()			{ n_panes--; }
			OI_pane		*remove_pane(OI_pane*);
		virtual	void		val_unparent(OI_d_tech *childp);
	 public: // functions
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_paned_box(const char*,OI_number,OI_number,OI_orient, OI_number) ;	/* constructor */
					~OI_paned_box() ;
			void		add_grip(OI_number);
			void		clear_in_grip_move()				{ctl_bits&= ~OI_PANED_BOX_IN_GRIP_MOVE;}
			void		clone_adjust(OI_d_tech*);
		static	OI_bool		init(class OI_connection*) ;
			OI_bool		in_grip_move()					{return((ctl_bits&OI_PANED_BOX_IN_GRIP_MOVE) ? OI_YES : OI_NO);}
		static	OI_paned_box	*make_minimal(const char*,OI_minimal_type);
			void		new_orientation(OI_orient orient);
			void		res_new_orientation(void*);
			void		res_real_time_drag(void*);
			void		res_resize_by_grip(void*);
			void		restore_size_track();
			void		set_gc_for_me();
			void		set_gc_for_world();
			void		set_in_grip_move()				{ctl_bits|= OI_PANED_BOX_IN_GRIP_MOVE;}

		//-------------------------------------------------------------------------------------------------
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_bool		is_acceptable_child(OI_d_tech*) ;		/* chk if object is suitable as child */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		add_pane(
						const char	*usr_namep,
						OI_number	pos,
						OI_number	size_x,
						OI_number	size_y,
						OI_number	min=OI_def_pane_min,
						OI_number	max=OI_number_max,
						OI_number	grip_width=OI_PANE_GRIP_DEF_WIDTH,
						OI_number	grip_height=OI_PANE_GRIP_DEF_HEIGHT,
						OI_number	indent=OI_PANE_GRIP_DEF_INDENT,
						OI_bool		show_sep=OI_PANE_GRIP_DEF_SHOW_SEP) ;
			void		add_pane(OI_pane* panep, OI_number pos);
			void		allow_resize_by_grip()			{ ctl_bits |= OI_PANED_BOX_RESIZE_BY_GRIP; }
			void		allow_real_time_drag();
			void		disallow_resize_by_grip()		{ ctl_bits &= ~OI_PANED_BOX_RESIZE_BY_GRIP; }
			void		disallow_real_time_drag();
			OI_bool		is_resize_by_grip()			{ return ((ctl_bits & OI_PANED_BOX_RESIZE_BY_GRIP) ? OI_YES :OI_NO);}
			OI_bool		is_real_time_drag()			{ return ((ctl_bits & OI_PANED_BOX_REAL_TIME_DRAG) ? OI_YES :OI_NO);}
			OI_number	num_panes()				{ return(n_panes); }
			OI_pane		*numbered_pane(OI_number index);
			OI_pane		*next_pane(OI_pane*);
			OI_orient	orientation()				{ return(orient); }
			OI_pane		*prev_pane(OI_pane*);
			void		set_orientation(OI_orient orient);
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_paned_box	*oi_create_paned_box(const char *name, OI_number size_x, OI_number size_y, OI_orient orient, OI_number n_panes) ;

#endif /* OI_BOX_H */
