/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	defs.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Object Interface definitions (no functions, no global vars)
 *
 *	RCSid = "$Id: defs.H,v 4.25.1.3 1993/06/14 21:04:29 toml Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_defs_H
#define OI_defs_H

#include <stddef.h>				/* To get the "proper" definition of NULL for C++ */
#include <ctype.h>
#include <stdio.h>
#include <limits.h>
#include <OI/Xlib.H>
#include <OI/Xutil.H>
#include <OI/Xresource.H>
#include <OI/callback.H>

#ifndef offsetof
#define offsetof(ty,mem) ((size_t)&(((ty*)0)->mem))
#endif

#if defined(__encotech_zCC)
typedef void SIG_FUNC_TYP(int);
typedef SIG_FUNC_TYP *SIG_TYP;
#define SIG_PF SIG_TYP
 
typedef void COMPLETE_SIG_FUNC_TYP(int, int, struct sigcontext*, char*);
typedef COMPLETE_SIG_FUNC_TYP *COMPLETE_SIG_TYP;
#define COMPLETE_SIG_PF COMPLETE_SIG_TYP
#endif

	// class forward reference declarations
	class	OI_cb_inf;
	class	OI_class;
	class	OI_connection;
	class	OI_d_tech;
	class	OI_glyph;
	class	OI_font_bounds;
	class	OI_font;
	struct	_OINameValueRec;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OUT_OF_PLACE DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		They are presented here to solve forward reference problems.
		//
		//-------------------------------------------------------------------------------------------------		

#define	OI_compiled_action_table	struct _OINameValueRec*

	typedef	short		OI_number ;	/* signed, relatively small numbers */
	typedef	unsigned long	PIXEL ;		/* X windows pixel */
	typedef	OI_class*	OI_layout ;	/* layout is ptr to class record for layout method */

#ifdef AIX
#define OI_number_max   MAXSHORT
#else
#ifndef SHRT_MAX
#define SHRT_MAX 32767		/* BAD -- imp, but needed for Linux.  Need a better way. */
#endif
#define OI_number_max   SHRT_MAX
#endif

		enum OI_state {			/* state of a object, exclusive bits to allow checking for combinations easily */
			OI_no_state		= 0,
			OI_NO_STATE		= OI_no_state,
			OI_same			= 0x1,			/* same state as previous */
			OI_SAME			= OI_same,
			OI_active		= 0x2,			/* can receive input and is displayed (but may be obscured) */
			OI_ACTIVE		= OI_active,
			OI_inactive		= 0x4,			/* cannot receive input and is displayed (but may be obscured) */
			OI_INACTIVE		= OI_inactive,
			OI_not_displayed	= 0x8,			/* is inactive and no display updates are necessary */
			OI_NOT_DISPLAYED	= OI_not_displayed,
			OI_active_not_displayed	= 0x10,			/* is eligible to receive input, but is not displayed */
			OI_ACTIVE_NOT_DISPLAYED	= OI_active_not_displayed
		} ;

		// These are the character sets that the Compound Text Encoding document defines:
		enum OI_charset {
			OI_charset_none,	// internal OI use only

			OI_charset_latin1,	// the default (includes ASCII)
			OI_charset_latin2,	//
			OI_charset_latin3,	//
			OI_charset_latin4,	//
			OI_charset_latin5,	//
			OI_charset_greek,	//
			OI_charset_arabic,	//
			OI_charset_hebrew,	//
			OI_charset_cyrillic,	//
			OI_charset_katakana,	// Japanese

			OI_charset_hanzi,	// Chinese
			OI_charset_kanji,	// Japanese
			OI_charset_korean,	//

			OI_charset_last		// internal OI use only
		};

#define		OI_mod_shift		ShiftMask	/* modifier bits for shift key */
#define		OI_MOD_SHIFT		OI_mod_shift
#define		OI_mod_lock		LockMask
#define		OI_MOD_LOCK		OI_mod_lock
#define		OI_mod_control		ControlMask
#define		OI_MOD_CONTROL		OI_mod_control
#define		OI_mod_meta		Mod1Mask
#define		OI_MOD_META		OI_mod_meta
#define		OI_mod_meta_l		Mod1Mask
#define		OI_MOD_META_L		OI_mod_meta_l
#define		OI_mod_meta_r		Mod1Mask
#define		OI_MOD_META_R		OI_mod_meta_r
#define		OI_mod_mod1		Mod1Mask
#define		OI_MOD_MOD1		OI_mod_mod1
#define		OI_mod_mod2		Mod2Mask
#define		OI_MOD_MOD2		OI_mod_mod2
#define		OI_mod_mod3		Mod3Mask
#define		OI_MOD_MOD3		OI_mod_mod3
#define		OI_mod_mod4		Mod4Mask
#define		OI_MOD_MOD4		OI_mod_mod4
#define		OI_mod_mod5		Mod5Mask
#define		OI_MOD_MOD5		OI_mod_mod5

// for compatibility with 3.x
#define		OI_click_delta		(OI_def_conp->click_delta())
#define		OI_multi_click_delta	(OI_def_conp->multi_click_delta())

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

 /* miscellaneous definitions for portability and convenience */
#ifndef NULL
#define NULL 0
#endif
#define			OI_max(a,b)	((a)>(b) ? (a) : (b))	/* greater of two quantities */
#define			OI_min(a,b)	((a)<(b) ? (a) : (b))	/* lesser of two quantities */
#define			OI_abs(a)	((a<0) ? -(a) : (a))	/* absolute value */
#define			OI_FAST		register		/* for optimization, OI_FAST are most desireable register vars (up to 3) */
#define			OI_FAST2				/* for optimization, OI_FAST2 are next most desireable register vars (after OI_FAST's) */

//#define OI_MAX(x,y) ((((int)x)>((int)y))?x:y)

#define OI_UNKNOWN_PIXEL ((PIXEL)-1)
#define OI_unknown_pixel OI_UNKNOWN_PIXEL

#define		OI_DEF_LABEL_RIGHT_SPACE	5

#define		OI_MX_C_FILNAM	255	/* max # chars we deal with in a file name */ /* should be MAXPATHLEN from sys/param.h */
#define		OI_MX_C_OBJNAM	400	/* max # chars we deal with in a complete object name */


#define		OI_def_arg		((void*)0xaaaaaaaa)	/* default arg, arbitrary; can't be zero; chosen to be a likely bad address and unlikely user arg */
#define		OI_DEF_ARG		OI_def_arg

#define		OI_BTN_SELECT		1		/* SELECT mouse button (not necessarily button 1 after mapping */
#define		OI_BTN_ADJUST		2		/* ADJUST mouse button (not necessarily button 2 after mapping */
#define		OI_BTN_MENU		3		/* MENU mouse button (not necessarily button 3 after mapping */

#define		OI_MOD_MENU_DEFAULT	OI_MOD_CONTROL		/* Modifier key for OI_BTN_MENU to change menu defaults */

		enum OI_wm_decoration {
			OI_wm_title		= 0x01,
			OI_wm_resize		= 0x02,
			OI_wm_menu_button	= 0x04,
			OI_wm_minimize		= 0x08,
			OI_wm_maximize		= 0x10,
			OI_wm_pushpin		= 0x20,
			OI_wm_pushpin_in	= 0x40,
			OI_wm_pushpin_out	= 0x80
		};

		enum OI_bevel {		/* top, bottom, down enhancement 3D bevel */
			OI_3d_top,
			OI_3D_TOP	= OI_3d_top,
			OI_3d_bottom,
			OI_3D_BOTTOM	= OI_3d_bottom,
			OI_3d_down,
			OI_3D_DOWN	= OI_3d_down
		} ;
		enum OI_focus_indicator {
			OI_focus_indicator_none,
			OI_focus_indicator_super_caret,
			OI_focus_indicator_color
		};
		enum OI_mnemonic_style {
			OI_mnemonic_none,
			OI_mnemonic_underline,
			OI_mnemonic_reverse,
			OI_mnemonic_parens
		};

		struct OI_xy {		/* x,y position or size */
			OI_number	x ;
			OI_number	y ;
		};
		struct OI_origin {	/* x,y position or size */
			long		x ;
			long		y ;
		} ;
		struct OI_dnd_clip_rectangle {
			int		x;
			int		y;
			unsigned long	width;
			unsigned long	height;
		};

		struct OI_bevel_pixels {
			PIXEL		top_pixel;
			PIXEL		bottom_pixel;
			PIXEL		down_pixel;
		} ;
		struct OI_configure {
			long		x;
			long		y;
			OI_number	width;
			OI_number	height;
			OI_number	border_width;
			OI_number	bevel_width;
			OI_state	state;
			XrmQuark	langq;
			unsigned long	mask;
		} ;
		enum OI_configure_mask {
			OIC_x			= 0x1,
			OIC_y			= 0x2,
			OIC_width		= 0x4,
			OIC_height		= 0x8,
			OIC_border_width	= 0x10,
			OIC_state		= 0x20,
			OIC_bevel_width		= 0x40,
			OIC_language		= 0x80,
			OIC_row			= 0x100,		/* y is a row number, not a pixel location */
			OIC_col			= 0x200,		/* x is a column number, not a pixel location */
			OIC_negative_x		= 0x400,
			OIC_negative_y		= 0x800,
			OIC_gravity		= 0x1000,
			OIC_layout		= 0x2000		/* there is layout specific geometry information */
		};

		enum	OI_severity	{
			OI_severity_internal_warning	= 0,			/* internal toolkit warning, never prints */
			OI_severity_fatal		= 1,			/* fatal error */
			OI_severity_warning		= 2			/* warning */
		} ;

		enum OI_minimal_type {	/* type of minimal object to make */
			OI_minimal	= 0,		/* absolute minimal object */
			OI_MINIMAL	= OI_minimal,
			OI_uib_minimal	= 1,		/* minimal object for builder */
			OI_UIB_MINIMAL	= OI_uib_minimal,
			OI_uib_abstract	= 2,		/* minimal abstract object for builder */
			OI_UIB_ABSTRACT	= OI_uib_abstract
		} ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

#define OI_count(m) (sizeof(m)/sizeof(m[0]))

 /* bits used for OI_io_dispatch_* interface */
#define		OI_user_input	0x1	/* look for input on fd */
#define		OI_USER_INPUT	OI_user_input
#define		OI_user_output	0x2	/* look for input on fd */
#define		OI_USER_OUTPUT	OI_user_output
#define		OI_user_except	0x4	/* look for exceptions on fd */
#define		OI_USER_EXCEPT	OI_user_except

	typedef	int		OI_stat ;	/* status value, >=0 => ok, <0 => fatal */

// OI_max_win_size is used when setting WM_NORMAL_HINTS so that the window cannout be 
// resized in one or both directions.  It is used in the dimension that can be resized.
// This value started life as 32000.  Unfortunately, when you execute the olwm "maximize"
// command, it looks for max_size being set in WM_NORMAL_HINTS and resizes it to the max_size
// if it's set.  If OI_max_win_size is anything greater than 16384 minus the screen width or height,
// olwm has problems painting outlines and we've even got reports of crashing the OpenWindows server.
#define		OI_max_win_size	15000

#define		OI_def_loc	-16384	/* indicator for default location */
#define		OI_DEF_LOC	OI_def_loc
#define		OI_undefined	(-32000)				/* undefined (non-existant) value */

		enum OI_model_type {	/* Interaction model, must fit type bits */
			OI_model_none	= 0,
			OI_MODEL_NONE	= OI_model_none,
			OI_openlook	= 0x10000000,
			OI_OPENLOOK	= OI_openlook,
			OI_motif	= 0x20000000,
			OI_MOTIF	= OI_motif,
			OI_openlook_3d	= 0x30000000,
			OI_OPENLOOK_3D	= OI_openlook_3d
		} ;

	typedef	OI_class*	OI_type ;			/* for backward compatibility */
#define	OI_APP_WINDOW		OI_app_window::clsp
#define	OI_ABBR_MENU		OI_abbr_menu::clsp
#define	OI_BOX			OI_box::clsp
#define	OI_BUTTON_MENU		OI_button_menu::clsp
#define	OI_DIALOG_BOX		OI_dialog_box::clsp
#define	OI_ENTRY_FIELD		OI_entry_field::clsp
#define	OI_EXCL_CHECK_MENU	OI_excl_check_menu::clsp
#define	OI_EXCL_MENU		OI_excl_menu::clsp
#define	OI_EXCL_RECT_MENU	OI_excl_rect_menu::clsp
#define	OI_GAUGE		OI_gauge::clsp
#define	OI_GLYPH		OI_glyph::clsp
#define	OI_HELP			OI_help::clsp
#define	OI_MENU_CELL		OI_menu_cell::clsp
#define	OI_MULTI_TEXT		OI_multi_text::clsp
#define	OI_ORPHANAGE		OI_orphanage::clsp
#define	OI_PANNER		OI_panner::clsp
#define	OI_POLY_CHECK_MENU	OI_poly_check_menu::clsp
#define	OI_POLY_MENU		OI_poly_menu::clsp
#define	OI_POLY_RECT_MENU	OI_poly_rect_menu::clsp
#define	OI_ROOT			OI_root::clsp
#define	OI_SCROLL_BAR		OI_scroll_bar::clsp
#define	OI_SCROLL_BOX		OI_scroll_box::clsp
#define	OI_SCROLL_MENU		OI_scroll_menu::clsp
#define	OI_SCROLL_TEXT		OI_scroll_text::clsp
#define	OI_SEPARATOR		OI_separator::clsp
#define	OI_SEQ_ENTRY_FIELD	OI_seq_entry_field::clsp
#define	OI_SLIDER		OI_slider::clsp
#define	OI_STATIC_TEXT		OI_static_text::clsp

		enum OI_bool {	/* boolean */
			OI_no	= 0,
			OI_NO	= OI_no,
			OI_yes	= 1,
			OI_YES	= OI_yes
		} ;

		enum OI_orient {			/* orientation of object */
			OI_vertical     = 0x1,		/* major axis is vertical */
			OI_VERTICAL	= OI_vertical,
			OI_horizontal   = 0x2,		/* major axis is horizontal */
			OI_HORIZONTAL	= OI_horizontal
		} ;
		enum OI_alignment {
			OI_alignment_default	= 0,
			OI_alignment_left	= 1,
			OI_alignment_right	= 2
		};
		enum OI_bevel_style {
			OI_bevel_none	= 0,
			OI_bevel_in	= 1,
			OI_bevel_out	= 2,
			OI_chisel_in	= 3,
			OI_chisel_out	= 4
		};
		enum OI_gravity {		/* gravity for objects */
			OI_grav_unknown		= 0,
			OI_grav_north		= 0x1,
			OI_grav_south		= 0x2,
			OI_grav_east		= 0x4,
			OI_grav_west		= 0x8,
			OI_grav_northwest	= (OI_grav_north|OI_grav_west),
			OI_grav_northeast	= (OI_grav_north|OI_grav_east),
			OI_grav_southwest	= (OI_grav_south|OI_grav_west),
			OI_grav_southeast	= (OI_grav_south|OI_grav_east),
			OI_grav_center		= 0x10
		} ;
		enum OI_size_track {		/* how to track the parent's size */
			OI_size_track_none				= 0,
			OI_size_track_parent_horizontal_expand		= 0x01,	/* expand horizontal size when parent is expanded */
			OI_size_track_parent_horizontal_collapse	= 0x02,	/* collapse horizontal size when parent is collapsed */
			OI_size_track_parent_vertical_expand		= 0x04,	/* expand vertical size when parent is expand */
			OI_size_track_parent_vertical_collapse		= 0x08,	/* collapse vertical size when parent is collapsed */
			OI_size_track_sibling_horizontal_expand		= 0x10,	/* expand horizontal size when sibling is expand */
			OI_size_track_sibling_horizontal_collapse	= 0x20,	/* collapse horizontal size when sibling is collapsed */
			OI_size_track_sibling_vertical_expand		= 0x40,	/* expand vertical size when sibling is expand */
			OI_size_track_sibling_vertical_collapse		= 0x80,	/* collapse vertical size when sibling is collapsed */
			OI_size_track_parent_horizontal			= (OI_size_track_parent_horizontal_expand |
										OI_size_track_parent_horizontal_collapse),
			OI_size_track_parent_vertical			= (OI_size_track_parent_vertical_expand |
										OI_size_track_parent_vertical_collapse),
			OI_size_track_sibling_horizontal		= (OI_size_track_sibling_horizontal_expand |
										OI_size_track_sibling_horizontal_collapse),
			OI_size_track_sibling_vertical			= (OI_size_track_sibling_vertical_expand |
										OI_size_track_sibling_vertical_collapse),
			OI_size_track_parent_full			= (OI_size_track_parent_horizontal |
										OI_size_track_parent_vertical),
			OI_size_track_sibling_full			= (OI_size_track_sibling_horizontal |
										OI_size_track_sibling_vertical),
			OI_size_track_horizontal			= (OI_size_track_parent_horizontal |
										OI_size_track_sibling_horizontal),
			OI_size_track_vertical				= (OI_size_track_parent_vertical |
										OI_size_track_sibling_vertical),
			OI_size_track_full				= (OI_size_track_horizontal | OI_size_track_vertical),
			OI_size_track_horizontal_expand			= (OI_size_track_parent_horizontal_expand |
										OI_size_track_sibling_horizontal_expand),
			OI_size_track_vertical_expand			= (OI_size_track_parent_vertical_expand |
										OI_size_track_sibling_vertical_expand),
			OI_size_track_expand				= (OI_size_track_vertical_expand |
										OI_size_track_horizontal_expand),
			OI_size_track_parent_expand			= (OI_size_track_parent_horizontal_expand |
										OI_size_track_parent_vertical_expand),
			OI_size_track_sibling_expand			= (OI_size_track_sibling_horizontal_expand |
										OI_size_track_sibling_vertical_expand),
			OI_size_track_horizontal_collapse		= (OI_size_track_parent_horizontal_collapse |
										OI_size_track_sibling_horizontal_collapse),
			OI_size_track_vertical_collapse			= (OI_size_track_parent_vertical_collapse |
										OI_size_track_sibling_vertical_collapse),
			OI_size_track_collapse				= (OI_size_track_vertical_collapse |
										OI_size_track_horizontal_collapse),
			OI_size_track_parent_collapse			= (OI_size_track_parent_horizontal_collapse |
										OI_size_track_parent_vertical_collapse),
			OI_size_track_sibling_collapse			= (OI_size_track_sibling_horizontal_collapse |
										OI_size_track_sibling_vertical_collapse)
		} ;
		enum OI_enhance {
			OI_enhance_none		= 0,
			OI_enhance_reverse	= 0x001,
			OI_enhance_underline	= 0x002,
			OI_enhance_centerline	= 0x004,
			OI_enhance_overline	= 0x008,
			OI_enhance_bold		= 0x010,
			OI_enhance_italic	= 0x020,
			OI_enhance_font_change	= 0x040,
			OI_enhance_foreground	= 0x100,
			OI_enhance_background	= 0x200
		};
		enum OI_psn_type {		/* positioning type */
			OI_psn_horz_default	= 0x0001,
			OI_psn_horz_left	= 0x0002,
			OI_psn_horz_right	= 0x0004,
			OI_psn_horz_center	= 0x0008,
			OI_psn_horz_keep	= 0x0010,
			OI_psn_vert_default	= 0x0100,
			OI_psn_vert_top		= 0x0200,
			OI_psn_vert_bottom	= 0x0400,
			OI_psn_vert_center	= 0x0800,
			OI_psn_vert_keep	= 0x1000,
			OI_psn_default		= (OI_psn_horz_default|OI_psn_vert_default|OI_psn_horz_keep|OI_psn_vert_keep)
		} ;

		enum OI_menu_cell_type {
			OI_text_cell		= 0x0,		/* Std. cell defined by a text string; 0 to allow default in OI_cell_spec */
			OI_TEXT_CELL		= OI_text_cell,
			OI_icon_cell		= 0x2,		/* Iconic cell defined by a pixmap file */
			OI_ICON_CELL		= OI_icon_cell,
			OI_icon_data_cell	= 0x4,		/* Iconic cell defined by pixmap static data */
			OI_ICON_DATA_CELL	= OI_icon_data_cell,
			OI_icon_pixmap_cell	= 0x8,		/* Iconic cell defined by a Pixmap */
			OI_ICON_PIXMAP_CELL	= OI_icon_pixmap_cell,
			OI_separator_cell	= 0x10,		/* Empty slot */
			OI_SEPARATOR_CELL	= OI_separator_cell
		} ;

		enum OI_char_encode_type {	/* encoding type of characters */
			OI_char_encode_none	= 0,	/* not encoded, ASCII/Latin1 */
			OI_char_encode_ctxt	= 1,	/* use compound text encoding */
			OI_char_encode_jis	= 2,	/* use JIS encoding */
			OI_char_encode_euc	= 3	/* use EUC encoding */
		} ;

		enum	OI_controller_visibility	{		/* Controller behavior when not needed */
			OI_controller_visibility_no_change	= 0,	/* Leave visible */
			OI_controller_visibility_disappear	= 1,	/* Don't expand or collapse anything; leave a hole */
			OI_controller_visibility_expand		= 2,	/* expand rest of object to use up extra space */
			OI_controller_visibility_collapse	= 3	/* collapse to get rid of extra space */
		} ;

		struct OI_animate_item {		/* single element of an animation sequence */
			Pixmap		pm ;			/* pixmap to paint */
			long		ms ;			/* time interval to next picture */
			OI_origin	psn ;			/* new position for pixmap */
			OI_xy		siz ;			/* size of pixmap */
			OI_bool		pm_chg ;		/* OI_YES => pixmap contents have changed, even if pm unchanged */
			void		*usr_datp ;		/* ptr to arbitrary user data structure */
		} ;

		enum OI_position {
			OI_right,
			OI_left,
			OI_top,
			OI_bottom,
			OI_default_position
		};

/* callback function types */
/* the following is a backward compatiblity kludge, to work around compilers that do not accept typedef of member function */
#if !defined(_AIX) && !defined(ultrix) && !defined(__encotech_zCC)
#define TYPEDEF_MEMFN
#endif

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_fn)(...) ;					/* to do OI_fn *fp; (*fp)(...); */
	typedef	void	(OI_callback::OI_memfn)(...) ;
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_fnp)(...) ;				/* to do OI_fn *fp; (*fp)(...); */
	typedef	void	(OI_callback::*OI_memfnp)(...) ;

#ifdef TYPEDEF_MEMFN
	typedef	int	(OI_chk_fn)(...) ;				/* function to check validity of something */
	typedef	int	(OI_callback::OI_chk_memfn)(...) ;		/* function to check validity of something */
#endif /* TYPEDEF_MEMFN */
	typedef	int	(*OI_chk_fnp)(...) ;				/* function to check validity of something */
	typedef	int	(OI_callback::*OI_chk_memfnp)(...) ;		/* function to check validity of something */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_obj_fn)(OI_d_tech*, void*) ;			/* callback with no extra args */
	typedef	void	(OI_callback::OI_obj_memfn)(OI_d_tech*, void*) ;
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_obj_fnp)(OI_d_tech*, void*) ;			/* callback with no extra args */
	typedef	void	(OI_callback::*OI_obj_memfnp)(OI_d_tech*, void*) ;

#ifdef TYPEDEF_MEMFN
	typedef	int	(OI_obj_chk_fn)(OI_d_tech*, void*) ;		/* check callback with no extra args */
	typedef	int	(OI_callback::OI_obj_chk_memfn)(OI_d_tech*, void*) ;
#endif /* TYPEDEF_MEMFN */
	typedef	int	(*OI_obj_chk_fnp)(OI_d_tech*, void*) ;		/* check callback with no extra args */
	typedef	int	(OI_callback::*OI_obj_chk_memfnp)(OI_d_tech*, void*) ;

#ifdef TYPEDEF_MEMFN
	typedef	char*	(OI_text_fn)() ;				/* function to get next line of text */
	typedef	char*	(OI_callback::OI_text_memfn)() ;		/* member function to get next line of text */
#endif /* TYPEDEF_MEMFN */
	typedef	char*	(*OI_text_fnp)() ;				/* function to get next line of text */
	typedef	char*	(OI_callback::*OI_text_memfnp)() ;		/* member function to get next line of text */

#ifdef TYPEDEF_MEMFN
	typedef	void*	(OI_ptr_fn)(...) ;				/* function to return ptr */
	typedef	void*	(OI_callback::OI_ptr_memfn)(...) ;		/* member function to return ptr */
#endif /* TYPEDEF_MEMFN */
	typedef	void*	(*OI_ptr_fnp)(...) ;				/* function to return ptr */
	typedef	void*	(OI_callback::*OI_ptr_memfnp)(...) ;		/* member function to return ptr */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_event_fn)(const XEvent *,void*) ;			/* function to handle XEvents on arbitrary window */
	typedef	void	(OI_callback::OI_event_memfn)(const XEvent *,void*) ;	/* member function to handle XEvents on arbitrary window */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_event_fnp)(const XEvent *,void*) ;			/* function to handle XEvents on arbitrary window */
	typedef	void	(OI_callback::*OI_event_memfnp)(const XEvent *,void*) ;	/* member function to handle XEvents on arbitrary window */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_obj_event_fn)(OI_d_tech*, void*, const XEvent*) ;
				/* function to handle XEvents for an object */
	typedef	void	(OI_callback::OI_obj_event_memfn)(OI_d_tech*, void*, const XEvent*) ;
				/* member function to handle XEvents for an object */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_obj_event_fnp)(OI_d_tech*, void*, const XEvent*) ;
				/* function to handle XEvents for an object */
	typedef	void	(OI_callback::*OI_obj_event_memfnp)(OI_d_tech*, void*, const XEvent*) ;
				/* member function to handle XEvents for an object */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_click_fn)(OI_d_tech*,void*,OI_number,OI_number,OI_number,OI_number=0,OI_number=0) ;
				/* function to exec on n-click of OI_d_tech */
	typedef	void	(OI_callback::OI_click_memfn)(OI_d_tech*,void*,OI_number,OI_number,OI_number,OI_number=0,OI_number=0) ;
				/* member function to exec on n-click of OI_d_tech */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_click_fnp)(OI_d_tech*,void*,OI_number,OI_number,OI_number,OI_number=0,OI_number=0) ;
				/* function to exec on n-click of OI_d_tech */
	typedef	void	(OI_callback::*OI_click_memfnp)(OI_d_tech*,void*,OI_number,OI_number,OI_number,OI_number=0,OI_number=0) ;
				/* member function to exec on n-click of OI_d_tech */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_pre_popup_fn)(OI_d_tech*, void*) ;				/* timeout callback function */
	typedef	void	(OI_callback::OI_pre_popup_memfn)(OI_d_tech*, void*) ;		/* timeout callback member function */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_pre_popup_fnp)(OI_d_tech*, void*) ;			/* timeout callback function */
	typedef	void	(OI_callback::*OI_pre_popup_memfnp)(OI_d_tech*, void*) ;	/* timeout callback member function */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_pin_fn)(OI_d_tech*, void*) ;			/* mnu/dlgbox pin/unpin callback function */
	typedef	void	(OI_callback::OI_pin_memfn)(OI_d_tech*, void*) ;	/* mnu/dlgbox pin/unpin callback member function */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_pin_fnp)(OI_d_tech*, void*) ;			/* mnu/dlgbox pin/unpin callback function */
	typedef	void	(OI_callback::*OI_pin_memfnp)(OI_d_tech*, void*) ;	/* mnu/dlgbox pin/unpin callback member function */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_timeout_fn)(void*) ;			/* timeout callback function */
	typedef	void	(OI_callback::OI_timeout_memfn)(void*) ;	/* timeout callback member function */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_timeout_fnp)(void*) ;			/* timeout callback function */
	typedef	void	(OI_callback::*OI_timeout_memfnp)(void*) ;	/* timeout callback member function */

#ifdef TYPEDEF_MEMFN
	typedef	int	(OI_io_fn)(int,void*) ;			/* io callback function */
	typedef	int	(OI_callback::OI_io_memfn)(int,void*) ;	/* io callback member function */
#endif /* TYPEDEF_MEMFN */
	typedef	int	(*OI_io_fnp)(int,void*) ;			/* io callback function */
	typedef	int	(OI_callback::*OI_io_memfnp)(int,void*) ;	/* io callback member function */

#ifdef TYPEDEF_MEMFN
	typedef void	(OI_translation_fn)(OI_d_tech*, const XEvent*, const char* const *, unsigned int*);	/* translation activated function */
	typedef	void	(OI_callback::OI_translation_memfn)(OI_d_tech*, const XEvent*, const char* const *, unsigned int*);
#endif /* TYPEDEF_MEMFN */
	typedef void	(*OI_translation_fnp)(OI_d_tech*, const XEvent*, const char* const *, unsigned int*);
	typedef	void	(OI_callback::*OI_translation_memfnp)(OI_d_tech*, const XEvent*, const char* const *, unsigned int*);

#ifdef TYPEDEF_MEMFN
	typedef	int	(OI_stderr_fn)(const char*, void*, OI_stat) ;	/* function to handle XEvents for an object */
	typedef	int	(OI_callback::OI_stderr_memfn)(const char*, void*, OI_stat) ;
								/* member function to handle XEvents for an object */
#endif /* TYPEDEF_MEMFN */
	typedef	int	(*OI_stderr_fnp)(const char*, void*, OI_stat) ;	/* function to handle XEvents for an object */
	typedef	int	(OI_callback::*OI_stderr_memfnp)(const char*, void*, OI_stat) ;
								/* member function to handle XEvents for an object */

#ifdef TYPEDEF_MEMFN
	typedef	OI_animate_item*	(OI_animate_fn)(OI_glyph*, void*) ;
	typedef	OI_animate_item*	(OI_callback::OI_animate_memfn)(OI_glyph*, void*) ;
#endif /* TYPEDEF_MEMFN */
	typedef	OI_animate_item*	(*OI_animate_fnp)(OI_glyph*, void*) ;
	typedef	OI_animate_item*	(OI_callback::*OI_animate_memfnp)(OI_glyph*, void*) ;

#ifdef TYPEDEF_MEMFN
	typedef	int	(OI_help_fn)(OI_d_tech*, void*) ;	/* callback to set key help context w/pointer over object */
	typedef	int	(OI_callback::OI_help_memfn)(OI_d_tech*, void*) ;	/* member function to set key help context w/pointer over object */
#endif /* TYPEDEF_MEMFN */
	typedef	int	(*OI_help_fnp)(OI_d_tech*, void*) ;
				/* callback to set context for key help w/pointer over object */
	typedef	int	(OI_callback::*OI_help_memfnp)(OI_d_tech*, void*) ;
				/* member callback to set context for key help w/pointer over object */

		struct OI_actions_rec {
			char			*string;
			OI_translation_fnp	proc;
			OI_callback		*objp ;		/* ptr to user object if callback is a C++ member function */
			OI_translation_memfnp	memfnp ;	/* member function to execute */
		} ;

typedef struct {                        /* _MOTIF_WM_HINTS */
	long unsigned allow_bits;	// not used by mwm
	long unsigned disallow_bits;	// not used by mwm
        long unsigned flags;
        long unsigned functions;
        long unsigned decorations;
        long unsigned input_mode;
} OI_motif_wm_hints;

/* bit definitions for MwmHints.flags */
#define OI_MWM_HINTS_FUNCTIONS		(1L << 0)
#define OI_MWM_HINTS_DECORATIONS	(1L << 1)
#define OI_MWM_HINTS_INPUT_MODE		(1L << 2)

/* bit definitions for MwmHints.functions */
#define OI_MWM_FUNC_ALL			(1L << 0)
#define OI_MWM_FUNC_RESIZE		(1L << 1)
#define OI_MWM_FUNC_MOVE		(1L << 2)
#define OI_MWM_FUNC_MINIMIZE		(1L << 3)
#define OI_MWM_FUNC_MAXIMIZE		(1L << 4)
#define OI_MWM_FUNC_CLOSE		(1L << 5)

/* bit definitions for MwmHints.decorations */
#define OI_MWM_DECOR_ALL		(1L << 0)
#define OI_MWM_DECOR_BORDER		(1L << 1)
#define OI_MWM_DECOR_RESIZEH		(1L << 2)
#define OI_MWM_DECOR_TITLE		(1L << 3)
#define OI_MWM_DECOR_MENU		(1L << 4)
#define OI_MWM_DECOR_MINIMIZE		(1L << 5)
#define OI_MWM_DECOR_MAXIMIZE		(1L << 6)

/* values for MwmHints.input_mode */
#define OI_MWM_INPUT_MODELESS		0
#define OI_MWM_INPUT_APPLICATION_MODAL	1
#define OI_MWM_INPUT_SYSTEM_MODAL	2

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

// Don't move the OI_cb_refresh definition!  #include ordering forces it here.
// d_tech.H requires layout.H
// layout.H requires class.H for the OI_register_layout_method declaration (for OI_make_minimal_memfnp)
// class.H requires OI_cb_refresh definition
#ifdef TYPEDEF_MEMFN
	typedef	OI_bool	OI_callback::OI_cb_refresh(OI_cb_inf*) ;
#endif /* TYPEDEF_MEMFN */
	typedef	OI_bool	(OI_callback::*OI_cb_refresh_memfnp)(OI_cb_inf*) ;

#endif /* OI_defs_H */
