/******************************************************************************
*******************************************************************************
*
*  (c) Copyright 1989, DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.
*  ALL RIGHTS RESERVED
*  
*  	THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT
*  NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY OPEN DIGITAL
*  EQUIPMENT CORPORATION OR ITS THIRD PARTY SUPPLIERS  
*  
*  DIGITAL EQUIPMENT CORPORATION AND ITS THIRD PARTY SUPPLIERS,
*  ASSUME NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE ANY OF ITS
*  SOFTWARE .   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
*  KIND, AND DIGITAL EQUIPMENT CORPORATION EXPRESSLY DISCLAIMS ALL IMPLIED 
*  WARRANTIES, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
*  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*  
* DEC is a registered trademark of Digital Equipment Corporation
* DIGITAL is a registered trademark of Digital Equipment Corporation
* X Window System is a trademark of the Massachusetts Institute of Technology
*
*******************************************************************************
******************************************************************************/

/*
 * File:	cdutil.h
 * Author:	Robin T. Miller
 * Date:	January 25, 1991
 *
 * Modified: 	Mark Clement
 * Date:	April 4, 1991
 *
 * Modified: 	Mark Longo
 * Date:	November 19, 1991
 * 	Removed default volume level definition.  It's now in the UIL file.
 * 
 * Description:
 *	This file contains defines for the utility functions.
 */

/*
 * Common include file used by 'cdplayer' Program.
 */

#include <sys/types.h>
#include <sys/cdrom.h>

/*
 * Local Defines:
 */
#define MAXTRACKS CDROM_MAX_TRACK
#define CD_SUCCESS 0
#define FAILURE -1
#define WARNING		1			/* Warning status code.	*/
#define TERMINATE	0
#define CD_FATAL_ERROR	255			/* Fatal error code.	*/
#define	equal(s1,s2)	(strcmp(s1, s2) == 0)	/* Compare two strings.	*/

/*
 * External Declarations:
 */
extern int CdrFd; /* Contains the file descriptor for the device */

/*
 * External Functions:
 */
extern int GetStatus(), StopUnit(), PlayTrack(), EjectUnit();
extern int ResumePlay(), PausePlay(), PreventRemoval(), AllowRemoval();
extern int GetTotalTracks(), GetPlayPosition(), GetTOCHeader();
extern int GetTOC(), SetVolume(), SetAddrFormatMsf(), GetPlaybackStatus();

/* When a Table of Contents command is issued, the drive fills in both
 * a header structure and the actual TOC.  This structure matches
 * the data that the drive returns.
 */
struct cd_toc_head_and_entries {
	/* The read Table of Contents command prepends the header, so put the
	 * two structures together.
	 */
	struct cd_toc_header cdth;
	struct cd_toc_entry cdte[MAXTRACKS];
};
