/*
 *	Turn an elapsed time into a readable string.
 */
char	*format_time(etime)
double	etime ;
{
	static	 char	buf[BUFSIZ] ;
	double	 fract ;
	register seconds, minutes, hours, days ;

	seconds = etime ;
	fract = (etime - seconds) + (seconds % 60) ;

	days = seconds / (24 * 60 * 60) ;
	seconds %= (24 * 60 * 60) ;
	hours = seconds / (60 * 60) ;
	seconds %= (60 * 60) ;
	minutes = seconds / 60 ;

	if( days )
		(void)sprintf(buf, "%d %2d:%02.2d:%05.2f",
			days, hours, minutes, fract) ;
	else if( hours )
		(void)sprintf(buf, "%d:%02.2d:%05.2f", hours, minutes, fract) ;
	else if( minutes )
		(void)sprintf(buf, "%d:%05.2f", minutes, fract) ;
	else
		(void)sprintf(buf, "%.2f", fract) ;

	return buf ;
}

/*
 *	Dump the contents of the FIRST record.
 */
f_first(p)
struct mon_first *p ;
{
	char	*strchr(), *newline ;

	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_FIRST].string) ;

	/*
	 *	If the version string has a newline in it, replace it
	 *	with a NULL.  Otherwise force a NULL at the end of the
	 *	allocated space.
	 */
	if((newline = strchr(p->mon_version, '\n')) != NULL )
		*newline = '\0' ;
	else
		p->mon_version[MON$S_VERSION] = '\0' ;

	printf("\tversion:  %s\n", p->mon_version);
	printf("\tboot:     %s", ctime((long *)&p->mon_boot.tv_sec)) ;
	printf("\tsdate:    %s", ctime((long *)&p->mon_sdate));
	printf("\tmonitor:  V%d.%d\n", major(p->mon_record),
		minor(p->mon_record)) ;

	printf("\tarch:     %s\n", str_arch(p->mon_arch)) ;
	printf("\thostname: %s\n", p->mon_hostname);
	printf("\tsleep:    %d seconds\n", p->mon_sleep);
	printf("\tcpu:      %d\n", p->mon_cpu);
	printf("\tdisk:     %d\n", p->mon_disk);
	printf("\tnetif:    %d\n", p->mon_netif);
	printf("\tbuf:      %d\n", p->mon_buf);
	printf("\tphysmem:  %d Kb.\n", pgtok(p->mon_physmem));
	printf("\thz:       %d\n", p->mon_hz);
	printf("\tnbpg:     %d\n", p->mon_nbpg) ;
	printf("\tbsize:    %d\n", p->mon_bsize) ;
	printf("\tpid:      %d\n", p->mon_pid);

	printf("\toptions:  <%s>\n", str_data(p->mon_options));
}

/*
 *	Print the contents of the "last" record.
 */
f_last(p)
struct mon_last *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_LAST].string) ;

	printf("\tedate:   %s", ctime((long *)&p->mon_edate));
	printf("\tsignal:  %d\n", p->mon_signal);
	printf("\tcode:    %d\n", p->mon_code);

	printf("\tusage:\n") ;
	print_rusage(&p->mon_usage, "\t\t") ;
}

/*
 *	Print the contents of the sample record.
 */
f_sample(p)
struct mon_sample *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_SAMPLE].string) ;

	printf("\ttimestamp: %s", ctime((long *)&p->mon_timestamp));
	printf("\tdatalen:   %d\n", p->mon_datalen);
	printf("\tticks:     %d ticks\n", p->mon_ticks) ;
}

char	*str_arch(arch)
int	arch ;
{
	if( arch == MON$C_VAX )
		return "VAX" ;
	else if( arch == MON$C_MIPS )
		return "MIPS" ;
	else
		return "Unknown archtecture." ;
}
