/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 tty.c
 *	Date:	 3/29/90
 *	Version: 1.3
 *
 *	tty.c - Functions for dealing with the tty data.  
 */
#ifndef	lint
static	char	SccsId[] = "@(#)tty.c	1.3 (monitor) 3/29/90" ;
#endif

/*
 * Modification History
 * 
 * Dec. 27, 1989 -- arr
 *
 *	New file.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>
#include <curses.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/cpudata.h>

#include <net/if.h>
#include <netinet/in.h>

#include "include.h"
#include "options.h"
#include "monitor.h"
#include "extern.h"

/*
 *	Functions that don't return an (int).
 */
double	delta_tty() ;

/*
 *	Assorted local data.
 */
static int	tty_ticks  = 0 ;	/* clock ticks at previous sample */
static int	old_ttyin  = 0 ;
static int	old_ttyout = 0 ;

static char	module[] = "tty" ;

/*
 *	Default display.
 */
extern	int	lines ;		/* length of the screen being used. */
extern	WINDOW	*wp ;

collect_tty()
{
#ifdef	V4_ULTRIX
	register ttyin = 0, ttyout = 0, i ;
	struct cpudata *array[MAXCPU], *cpuaddr, cpudata ;

	cpuaddr = (struct cpudata *)namelist[NM_CPUDATA].n_value ;

	readk((long)cpuaddr, (char *)array, sizeof(array)) ;

	for(i = 0; i < MAXCPU; i++) {
		if( array[i] == 0 )
			continue ;

		readk((long)array[i], (char *)&cpudata, sizeof(cpudata)) ;

		ttyin  += cpudata.cpu_ttyin ;
		ttyout += cpudata.cpu_ttyout ;
	}

	tty.mon_ttyin  = ttyin ;
	tty.mon_ttyout = ttyout ;
#else
	tty.mon_ttyin  = get_word((long)namelist[NM_TTY_IN].n_value) ;
	tty.mon_ttyout = get_word((long)namelist[NM_TTY_OUT].n_value) ;
#endif
}

/*
 *	Constants for placement of TTY data.
 */
#define	TTY_TITLE	(3)
#define	TTY_DATA	(3)
#define	TTY_RUNNING	(6)
#define	TTY_DELTA	(9)
#define	TTY_AVERAGE	(12)
#define	TTY_X		(26)

#define	TTY_LINES	(15)

/*
 *	Print and format the heading for the tty info.
 *
 *	ARGSUSED
 */
open_tty(op)
OPTION	*op ;
{
	sample_header() ;

	lines = TTY_LINES ;

	wmove(wp, TTY_TITLE, 0) ;

	wprintw(wp, "Total TTY input:          %10d\n", 0) ;
	wprintw(wp, "Total TTY output:         %10d\n\n", 0) ;

	wprintw(wp, "Running average: input:   %10.2f cps\n", 0) ;
	wprintw(wp, "Running average: output:  %10.2f cps\n\n", 0) ;

	wprintw(wp, "Input since last sample:  %10d\n", 0) ;
	wprintw(wp, "Output since last sample: %10d\n\n", 0) ;

	wprintw(wp, "Sample average: input:    %10.2f cps\n", 0) ;
	wprintw(wp, "Sample average: output:   %10.2f cps\n", 0) ;
}

/*
 *	Print the tty info.
 *
 *	ARGSUSED
 */
magnify_tty(op)
OPTION	*op ;
{
	double	etime, btime ;

	wmove(wp, TTY_DATA, TTY_X) ;
	wprintw(wp, "%10d", tty.mon_ttyin) ;

	wmove(wp, TTY_DATA + 1, TTY_X) ;
	wprintw(wp, "%10d", tty.mon_ttyout) ;

	btime = (double)sample.mon_ticks / first.mon_hz ;

	wmove(wp, TTY_RUNNING, TTY_X) ;
	wprintw(wp, "%10.2f", tty.mon_ttyin / btime) ;

	wmove(wp, TTY_RUNNING + 1, TTY_X) ;
	wprintw(wp, "%10.2f", tty.mon_ttyout / btime) ;

	etime = delta_tty(sample.mon_ticks) ;

	wmove(wp, TTY_DELTA, TTY_X) ;
	wprintw(wp, "%10d", tty.mon_ttyin) ;

	wmove(wp, TTY_DELTA + 1, TTY_X) ;
	wprintw(wp, "%10d", tty.mon_ttyout) ;

	wmove(wp, TTY_AVERAGE, TTY_X) ;
	wprintw(wp, "%10.2f", tty.mon_ttyin / etime) ;

	wmove(wp, TTY_AVERAGE + 1, TTY_X) ;
	wprintw(wp, "%10.2f", tty.mon_ttyout / etime) ;

	sample_body(etime) ;
}

init_tty_data()
{
	old_ttyin = 0 ;
	old_ttyout = 0 ;
	tty_ticks = 0 ;
}

f_tty(p)
struct mon_tty *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_TTY].string) ;

	printf("\tttyin:  %d chars.\n", p->mon_ttyin);
	printf("\tttyout: %d chars.\n", p->mon_ttyout);
}

/*
 *	Calculate the change in the tty stats.
 *
 *	Given the current number of clock ticks, find and return
 *	the elapsed time since the last sample.
 */
double	delta_tty(ticks)
int	ticks ;
{
	register t ;
	double	 etime = (double)(ticks - tty_ticks) / first.mon_hz ;

	t = tty.mon_ttyin; 
	    tty.mon_ttyin -= old_ttyin ; 
	    old_ttyin = t ;

	t = tty.mon_ttyout ; 
	    tty.mon_ttyout -= old_ttyout ; 
	    old_ttyout = t ;

	tty_ticks = ticks ;

	return etime ;
}

check_tty_namelist(op)
OPTION	*op ;
{
	/*
	 *	Check to see if the tty data is available.
	 */
#ifdef	V4_ULTRIX
	if( namelist[NM_CPUDATA].n_value == 0 ) {
		info("TTY I/O data is not available.\n", module);
		op->opt_tty = 0 ;
	}
#else
	if( !namelist[NM_TTY_IN].n_value || !namelist[NM_TTY_OUT].n_value ) {
		info("TTY I/O data is not available.\n", module);
		op->opt_tty = 0 ;
	}
#endif
}
