/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 strings.c
 *	Date:	 8/21/90
 *	Version: 1.14
 *
 *	strings.c - Functions to print out names of bits, as opposed
 *	to bit values.
 *
 *	Derived from print.c V1.6.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)strings.c	1.14 (monitor) 8/21/90" ;
#endif

/*
 * Modification History
 *
 * 27-June-1988 - arr
 *
 *	Moved OS dependent strings to string_data.c.
 *
 *	Change include of monitor.h to include.h.
 *
 * Feb. 10, 1989 -- arr
 *
 *	Changed rectype3 to reconf.
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/dir.h>
#include <sys/param.h>
#include <sys/user.h>

#include <net/if.h>
#include <netinet/in.h>

#include "monitor.h"
#include "include.h"
#include "options.h"

/*
 *	A convient MACRO to initialize the bit_names structure.
 */
#define	MACRO(s)	{ s, sizeof(s) - 1, }

/*
 *	Functions that don't return (int).
 */
char	*sprintf(),
	*str_data(),
	*str_netif(),
	*str_opt_flags() ;

/*
 *	Common code used by all the str_ functions.
 */
char	*str_generic(mask, buf, bnp)
int	mask ;
char	*buf ;
struct bit_names *bnp ;
{
	register int	i, comma = 0 ;
	register char 	*p = buf ;

	for(i = 0; i < sizeof(mask) * NBBY; i++) {
		if( bnp[i].string == NULL )
			break ;

		if( mask & (1 << i)) {
			if( comma++ )
				*p++ = ',' ;

			(void)sprintf(p, "%s", bnp[i].string) ;

			p += bnp[i].length ;
		}
	}

	*p = '\0' ;

	return buf ;
}

/*
 *	The names of all the data options.
 */
struct bit_names data_names[] = {
	MACRO("control-1"),
	MACRO("control-2"),
	MACRO("sample"),
	MACRO("reconf"),
	MACRO("cpu"),
	MACRO("tty"),
	MACRO("disk"),
	MACRO("free"),
	MACRO("fork"),
	MACRO("page"),
	MACRO("proc"),
	MACRO("swap"),
	MACRO("tape"),
	MACRO("user"),
	MACRO("netif"),
	MACRO("memory"),
	MACRO("loadave"),
	MACRO("pid"),
	MACRO("buf"),
	MACRO("nfs"),
	MACRO("namei"),
	{ 0, 0, },
};

char	*str_data(data)
int	data ;
{	
	static	 char	buf[BUFSIZ] ;

	return str_generic(data, buf, data_names) ;
}

/*
 *	Functions and data to take the netif flag field and turn it into
 *	something "meaningful".
 */
extern struct bit_names netif_names[] ;

char	*str_netif(flags)
short	flags ;
{
	static char 	buf[BUFSIZ] ;

	return str_generic(flags, buf, netif_names) ;
}


/* 
 *	The names and function to turn the process flag into a
 *	readable string.
 */
extern struct bit_names flag_names[] ;

char	*str_flags(flag)
int	flag ;
{
	static	char	buf[BUFSIZ] ;

	return str_generic(flag, buf, flag_names) ;
}

/*
 *	Turn a timeval structure into a readable string.
 */
char	*str_timeval(p)
struct timeval *p ;
{
	static	char	buf[32] ;
	int	hours, minutes, seconds, fract ;

	fract = p->tv_usec / 10000 ;

	seconds = p->tv_sec % 60 ; p->tv_sec /= 60 ;
	minutes = p->tv_sec % 60 ; p->tv_sec /= 60 ;
	hours   = p->tv_sec % 24 ;

	return sprintf(buf, "%5d:%.2d:%.2d.%.2d", hours, minutes, seconds, fract) ;
}

/*
 *	Print the rusage structure.
 */
print_rusage(p, s)
struct rusage *p ;
char	*s ;
{
	printf("%sru_utime:    %s\n", s, str_timeval(&p->ru_utime)) ;
	printf("%sru_stime:    %s\n", s, str_timeval(&p->ru_stime)) ;
	printf("%sru_maxrss:   %d\n", s, p->ru_maxrss) ;
	printf("%sru_minflt:   %d\n", s, p->ru_minflt) ;
	printf("%sru_majflt:   %d\n", s, p->ru_majflt) ;
	printf("%sru_nswap:    %d\n", s, p->ru_nswap) ;
	printf("%sru_inblock:  %d\n", s, p->ru_inblock) ;
	printf("%sru_oublock:  %d\n", s, p->ru_oublock) ;
	printf("%sru_msgsnd:   %d\n", s, p->ru_msgsnd) ;
	printf("%sru_msgrcv:   %d\n", s, p->ru_msgrcv) ;
	printf("%sru_nsignals: %d\n", s, p->ru_nsignals) ;
	printf("%sru_nvcsw:    %d\n", s, p->ru_nvcsw) ;
	printf("%sru_nivcsw:   %d\n", s, p->ru_nivcsw) ;
}

/*
 *	Print the credential structure.
 */
print_cred(p, s)
struct mon_ucred *p ;
char	*s ;
{
	register i ;

	printf("%scr_ref:    %d\n", s, p->cr_ref) ;
	printf("%scr_uid:    %d\n", s, p->cr_uid) ;
	printf("%scr_gid:    %d\n", s, p->cr_gid) ;
	printf("%scr_ruid:   %d\n", s, p->cr_ruid) ;
	printf("%scr_rgid:   %d\n", s, p->cr_rgid) ;

	printf("%scr_groups: ", s) ;

	for(i = 0; i < NGROUPS; i++) {
		if( p->cr_groups[i] == -1 )
			break ;

		if( i )
			putchar(',') ;

		printf("%d", p->cr_groups[i]) ;
	}

	putchar('\n') ;
}

/*
 *	The names and function to turn process states into a readable
 *	string.
 */
extern int   n_proc_states ;
extern char *proc_states[] ;

char	*str_stats(state)
int	state ;
{
	if( 0 <= state && state < n_proc_states )
		return proc_states[state] ;
	else
		return "?" ;
}

#ifdef	DEBUG
/*
 *	The names and function to take the options flag and turn
 *	into a readable string.
 */
struct bit_names opt_flags[] = {
	MACRO("unused"),
	MACRO("interactive"),
	MACRO("total"),
	MACRO("curses"),
	MACRO("standard"),
	MACRO("sleep_set"),
	MACRO("output_set"),
	0, 0,
};

char	*str_opt_flags(flags)
int	flags ;
{
	static	char	buf[BUFSIZ] ;

	return str_generic(flags, buf, opt_flags) ;
}
#endif
