/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 signals.c
 *	Date:	 3/29/90
 *	Version: 1.22
 *
 *	signals.c - Various functions to handle signals which might be recieved.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)signals.c	1.22 (monitor) 3/29/90" ;
#endif

/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of record.h to monitor.h.
 *
 * 28-December-1988 -- arr
 *
 *	Dust off V3.0 lint.
 *
 * Feb. 15, 1989 -- arr
 *
 *	Correctly set mon_flag with MON$M_VALID.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <signal.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "options.h"
#include "monitor.h"

/*
 *	Data objects define somewhere else.
 */
extern	char	*sys_siglist[] ;
extern	OPTION	option ;
extern	int	killed ;
extern	struct mon_last last ;

/*
 *	Module name for error messages.
 */
static	char	*module = "signals" ;

/*
 *	Catch() - Attempt to die gracefully.
 *
 *	Do whatever is necessary to clean up, then send ourselves a
 *	wakeup, so we don't have to wait for sleep to expire.
 *
 *	Since most exit paths will go through here, we'll also save
 *	the time stamp, just before returning.
 *
 *	Tell lint that scp is being used even though it isn't.
 *
 *	ARGSUSED
 */
void	catch(sig, code, scp)
int	sig, code ;
struct sigcontext *scp ;
{
	long	time() ;

	killed = 1 ;

	last.mon_signal = sig ;
	last.mon_code = code ;

	if( option.opt_sleep && !option.opt_inter )
		if( kill(getpid(), SIGALRM) == -1 )
			warning("Can't cancel sleep: %s.\n", module);

	info("Killed by signal: %s.\n", module, sys_siglist[sig]);

	last.mon_edate = time((long *)0) ;
	last.mon_flag  = MON$M_VALID ;

	if( getrusage(RUSAGE_SELF, &last.mon_usage) == -1 )
		warning("Can't get resource information: %s.\n", module) ;
}
