/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 read.c
 *	Date:	 3/29/90
 *	Version: 1.37
 *
 *	read.c - Display functions to provide the functionality of
 *	the old "read" program.
 *
 *	Taken from ~alan/src/mon/record/read.c Labeled:
 *
 *		"@(#)read.c	1.2 5/2/86"
 *
 *	Adapted from ~alan/src/monitor/read/read.c V1.18.
 *
 */
#ifndef	lint
static	char	SccsId[] = "@(#)read.c	1.37 (monitor) 3/29/90" ;
#endif

/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
 *
 * 29-June-1988 -- arr
 *
 *	Remove the special code for reading saved data files.  I'm
 *	going to use the regular replay instead.
 *
 *	Dusted off some lint.
 *
 *	Remove the include of options.h since it wasn't needed.
 *
 * Jan. 15, 1989 -- arr
 *
 *	Move record dump function table to tables.c.
 *
 * Feb. 10, 1989 -- arr
 *
 *	Added case to switch for BUF records.	
 *
 * Feb. 15, 1989 -- arr
 *
 *	Moved header printf's to f_...() functions.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
#include <sys/uio.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include <machine/param.h>

#include "include.h"
#include "monitor.h"
#include "extern.h"

/*
 *	In tables.c
 */
extern	int	(*dump_functions[])() ;

/*
 *	Print the contents of the FIRST record.
 */
open_read()
{
	(*dump_functions[MON$C_FIRST])((struct mon_first *)records[MON$C_FIRST].addr) ;
}

/*
 *	Call print_record() for each data record in the sample.
 */
display_read()
{
	register options, type ;

	options = first.mon_options ;

	for(type = 0; type < MON$N_RECORDS; type++)
		if( options & (1 << type))
			print_record(type) ;
}

/*
 *	Call the approproiate f_...() function for each data record.
 */
static	print_record(type)
register type ;
{
	register i ;

	switch( type ) {
	case MON$C_CPU:
		for(i = 0; i < n_cpu ; i++)
			(*dump_functions[type])(cpu + i) ;

		break ;
	case MON$C_BUF:
		for(i = 0; i < n_buf ; i++)
			(*dump_functions[type])(mon_buf + i) ;

		break ;
	case MON$C_DISK:
		for(i = 0; i < n_disk ; i++)
			(*dump_functions[type])(disk + i) ;

		break ;
	case MON$C_NETIF:
		for(i = 0; i < n_netif ; i++)
			(*dump_functions[type])(netif + i) ;

		break ;
	default:
		(*dump_functions[type])(records[type].addr) ;
	}
}

/*
 *	Print the LAST record.
 */
close_read()
{
	(*dump_functions[MON$C_LAST])((struct mon_last *)records[MON$C_LAST].addr) ;
}
