/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 pgtok.h
 *	Date:	 1/12/89
 *	Version: 1.2
 *
 *	pgtok.h - Macro to turn translate number of pages of memory to number
 *	kilobytes of memory (intelligently).
 */

/*
 *	This include file is needed.
 *
 *	#include <machine/param.h>
 */

/*
 *	This macro assumes that 1024 and the value of NBPG are
 *	multiples, depending on their relative values.  I believe
 *	this is a safe assumption on a binary computer.
 */
#if NBPG < 1024
#	define	pgtok(x)	((x) / (1024 / NBPG))
#else
#	define	pgtok(x)	((x) * (NBPG / 1024))
#endif

/*
 *	A macro for turning number of sectors into one Kilobyte
 *	units.  It uses the block size constant.
 */
#define btok(x) ((x) / (1024 / DEV_BSIZE))
