/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 namei.c
 *	Date:	 3/29/90
 *	Version: 1.10
 *
 *	namei.c - Deal with the namei cache stats.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)namei.c	1.10 (monitor) 3/29/90" ;
#endif

/*
 * Modification history.
 *
 * Jan. 18, 1989 -- arr
 *
 *	Redesigned magnification screen.
 *
 * Jan. 24, 1989 -- arr
 *
 *	Moved f_namei() from functions.c.
 *
 * Feb. 15, 1989 -- arr
 *
 *	Fix f_namei() to use mon_flag.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/param.h>
#include <sys/user.h>

#include <net/if.h>
#include <netinet/in.h>

#include "monitor.h"
#include "options.h"
#include "include.h"
#include "extern.h"

/*
 *	Data declared elsewhere.  These aren't in extern.h because
 *	they don't need to be known by the whole world.
 */
extern	WINDOW	*wp ;
extern	int	lines ;

/*
 *	Local data.
 */
static	int	namei_ticks = 0,
		prev_goodhits = 0,
		prev_badhits = 0,
		prev_falsehits = 0,
		prev_miss = 0,
		prev_long = 0,
		prev_pass2 = 0,
		prev_2passes = 0 ;


/*
 *	Function to dump a record for easy reading.
 */
f_namei(p)
struct mon_namei *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
                return ;

        printf("%s.\n", records[MON$C_NAMEI].string) ;

	printf("\tgoodhits:  %d\n", p->mon_goodhits) ;
	printf("\tbadhits:   %d\n", p->mon_badhits) ;
	printf("\tfalsehits: %d\n", p->mon_falsehits) ;
	printf("\tmiss:      %d\n", p->mon_miss) ;
	printf("\tlong:      %d\n", p->mon_long) ;
	printf("\tpass2:     %d\n", p->mon_pass2) ;
	printf("\t2passes:   %d\n", p->mon_2passes) ;
}

/*
 *	Number of lines used by the namei cache screen.
 */
#define	NAMEI_LINES	(17)

#define	NAMEI_X		(16)
#define	NAMEI_Y		(3)

/*
 *      Setup the static screen for displaying namei cache 
 *      information.
 *
 *      ARGSUSED
 */
open_namei(op)
OPTION	*op ;
{
	sample_header() ;

	lines = NAMEI_LINES ;

	wprintw(wp, "Good Hits:      %6.2f %% : %10u\n", 0.0, 0) ;
	wprintw(wp, "Bad Hits:       %6.2f %% : %10u\n", 0.0, 0) ;
	wprintw(wp, "False Hits:     %6.2f %% : %10u\n", 0.0, 0) ;
	wprintw(wp, "Misses:         %6.2f %% : %10u\n", 0.0, 0) ;
	wprintw(wp, "Long names:     %6.2f %% : %10u\n", 0.0, 0) ;
	wprintw(wp, "Two pass names: %6.2f %% : %10u of %10u\n\n", 0.0, 0, 0) ;

	wprintw(wp, "Good Hits:      %6.2f %% : %10.2f / sec.\n", 0.0, 0.0) ;
	wprintw(wp, "Bad Hits:       %6.2f %% : %10.2f / sec.\n", 0.0, 0.0) ;
	wprintw(wp, "False Hits:     %6.2f %% : %10.2f / sec.\n", 0.0, 0.0) ;
	wprintw(wp, "Misses:         %6.2f %% : %10.2f / sec.\n", 0.0, 0.0) ;
	wprintw(wp, "Long names:     %6.2f %% : %10.2f / sec.\n", 0.0, 0.0) ;
	wprintw(wp, "Two pass names: %6.2f %% : %10u of %10u", 0.0, 0, 0) ;
}

/*
 *      Display the dynamic data of the namei cache information.
 *
 *      ARGSUSED
 */
magnify_namei(op)
OPTION	*op ;
{
	double	 etime, delta_namei() ;
	register total ;

	total = namei.mon_goodhits + namei.mon_badhits + namei.mon_falsehits +
		namei.mon_miss + namei.mon_long ;

	if( total == 0 )
		total = 1 ;

	wmove(wp, NAMEI_Y, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10u", (100.0 * namei.mon_goodhits)/total,
		namei.mon_goodhits) ;

	wmove(wp, NAMEI_Y + 1, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10u", (100.0 * namei.mon_badhits)/total,
		namei.mon_badhits) ;

	wmove(wp, NAMEI_Y + 2, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10u", (100.0 * namei.mon_falsehits)/total,
		namei.mon_falsehits) ;

	wmove(wp, NAMEI_Y + 3, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10u", (100.0 * namei.mon_miss)/total,
		namei.mon_miss) ;

	wmove(wp, NAMEI_Y + 4, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10u", (100.0 * namei.mon_long)/total,
		namei.mon_long) ;

	wmove(wp, NAMEI_Y + 5, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10u of %10u", namei.mon_2passes == 0 ? 0.0 :
		(100.0 * namei.mon_pass2)/namei.mon_2passes,
		namei.mon_pass2, namei.mon_2passes) ;

	etime = delta_namei(sample.mon_ticks) ;

	if( etime == 0 )
		etime = 1.0 ;

	total = namei.mon_goodhits + namei.mon_badhits + namei.mon_falsehits +
		namei.mon_miss + namei.mon_long ;

	if( total == 0 )
		total = 1 ;

	wmove(wp, NAMEI_Y + 7, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10.2f", (100.0 * namei.mon_goodhits)/total,
		namei.mon_goodhits/etime) ;

	wmove(wp, NAMEI_Y + 8, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10.2f", (100.0 * namei.mon_badhits)/total,
		namei.mon_badhits/etime) ;

	wmove(wp, NAMEI_Y + 9, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10.2f", (100.0 * namei.mon_falsehits)/total,
		namei.mon_falsehits/etime) ;

	wmove(wp, NAMEI_Y + 10, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10.2f", (100.0 * namei.mon_miss)/total,
		namei.mon_miss/etime) ;

	wmove(wp, NAMEI_Y + 11, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10.2f", (100.0 * namei.mon_long)/total,
		namei.mon_long/etime) ;

	wmove(wp, NAMEI_Y + 12, NAMEI_X) ;
	wprintw(wp, "%6.2f %% : %10u of %10u", namei.mon_2passes == 0 ? 0.0 :
		(100.0 * namei.mon_pass2)/namei.mon_2passes,
		namei.mon_pass2, namei.mon_2passes) ;

	sample_body(etime) ;
}

double	delta_namei(ticks)
int	ticks ;
{
	register tmp ;
	double   etime ;

	etime = (double)(ticks - namei_ticks) / first.mon_hz ;
	namei_ticks = ticks ;

	tmp = namei.mon_goodhits ;
	      namei.mon_goodhits -= prev_goodhits ;
	      prev_goodhits = tmp ;

	tmp = namei.mon_badhits ;
	      namei.mon_badhits -= prev_badhits ;
	      prev_badhits = tmp ;

	tmp = namei.mon_falsehits ;
	      namei.mon_falsehits -= prev_falsehits ;
	      prev_falsehits = tmp ;

	tmp = namei.mon_miss ;
	      namei.mon_miss -= prev_miss ;
	      prev_miss = tmp ;

	tmp = namei.mon_long ;
	      namei.mon_long -= prev_long ;
	      prev_long = tmp ;

	tmp = namei.mon_pass2 ;
	      namei.mon_pass2 -= prev_pass2 ;
	      prev_pass2 = tmp ;

	tmp = namei.mon_2passes ;
	      namei.mon_2passes -= prev_2passes ;
	      prev_2passes = tmp ;

	return etime ;
}
