/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 include.h
 *	Date:	 12/25/89
 *	Version: 1.35
 *
 *	include.h - This file contains #define's for namelist indexes and
 *	some extras for general use.
 */

/*
 * Modification History
 *
 * 28-june-1988 -- arr
 *
 *	Added struct cpu_type.
 *
 *  4-january-1988 -- arr
 *
 *	Added NM_ indices for MIPS specific data structures.
 *
 * Jan. 13, 1989 -- arr
 *
 *	Added NM_ constants for swap space collection.
 *
 * Jan. 16, 1989 -- arr
 *
 *	Added NM_ constants for namei and buffer cache data.
 *
 * Dec. 25, 1989 -- arr
 *
 *	Removed NM constants that aren't being used.
 */

/*
 *	The uba_device() code can find a variety of devices.  The following
 *	constants are used to identify some of the devices by class.
 */
#define	NET		0		/* Device is network interface */
#define	TAPE		1		/* Device is a tape */
#define	DISK		2		/* Device is a disk */
#define	CPU		3		/* Device is a CPU */
#define	COMM		4		/* reserved for future use */

#define	KEY_SIZE	(sizeof(char *))

/*
 *	Constants used as an index into the an array of rusage
 *	structures.
 */
#define	SELF	0
#define	CHILD	1

/*
 *	The amount of space to save for a date string.
 */
#define	M_DATESIZE	(32)

/*
 *      Constants that get_command() returns.
 */
#define G_UNKNOWN       (0)
#define G_UP            (1)
#define G_DOWN          (2)
#define G_SELECT        (3)
#define G_HELP          (4)
#define G_REDRAW        (5)
#define G_DUMP          (6)
#define G_EXIT          (7)
#define G_UNMAGNIFY     (8)
#define G_MAGNIFY       (9)

/*
 *	Memory and process info
 */
#define	NM_FREE		(0)	/* free memory */
#define	NM_TOTAL	(1)	/* memory/process totals - struct vmtotal */
/*
 *	pageing, CPU instrumentation and fork data.
 */
#define	NM_LOADAVE	(2)	/* load averages */
#define	NM_RATE		(3)	/* page stats - struct vmmeter */
#define	NM_SUM		(4)	/* total page stats - struct vmmeter */
#define	NM_DEFICIT	(5)	/* deficit - more paging info */
#define	NM_FORK		(6)	/* fork/vfork stats - struct forkstat */
/*
 *	Disk I/O
 */
#define	NM_DK_BUSY	(7)	/* disk info - <sys/dk.h> */
#define	NM_DK_TIME	(8)
#define	NM_DK_SEEK	(9)
#define	NM_DK_XFER	(10)
#define	NM_DK_WDS	(11)
/*
 *	TTY I/O
 */
#define	NM_TTY_IN	(12)	/* input */
#define	NM_TTY_OUT	(13)	/* output */
/*
 *	names and other static data.
 */
#define	NM_DK_MSPW	(14)	/* milli/micro seconds / word transfer speed */
#define	NM_UBDINIT	(15)	/* start of UNIBUS/QBUS devices */
#define	NM_MBDINIT	(16)	/* start of MASSBUS devices */
#define	NM_IFNET	(17)	/* start of network interfaces */
#define	NM_HZ		(18)	/* clock frequency? */
#define	NM_PHYSMEM	(19)	/* amount of physical memory */
#define	NM_VERSION	(20)	/* system version string */
#define	NM_CPU		(21)	/* High byte of SID register */
#define	NM_CPUDATA	(22)	/* array of per CPU data */
#define	NM_MAXCPU	(23)	/* number of configured processors */
#define	NM_CPU_SUBTYPE	(24)	/* CPU subtype in V2.0 */
/*
 *	When the system booted.
 */
#define	NM_BOOT		(25)	/* a timeval structure */
/*
 *	MIPS stuff.
 */
#define	NM_CPU_SYSTYPE	(26)
/*
 *	Namei cache.
 */
#define	NM_NAMEI	(27)
/*
 *	Buffer cache.
 */
#define	NM_BUF		(28)
#define	NM_NBUF		(29)
#define	NM_BUFPAGES	(30)
/*
 *	V4.0 specific stuff.
 */
#define	NM_SMP		(31)

/*
 *	The "save" and "replay" functions find it convient to use
 *	a table of all the records.  This is the structure of the
 *	table.
 */
struct	records {
	char	*addr ;
	int	size ;
	char	*string ;
};

/*
 *	The unit selection feature uses a pair of data objects
 *	(base and nel) to do much of the work.  The element size 
 *	is included for possible extension.  For now all the list 
 *	element sizes are the same (char *).
 */
struct	list {
	char	**base ;		/* beginning of list */
	int	nel ;			/* number of things in the list */
	int	size ;			/* size of an element */
};

/*
 *	A structure for naming bits and other useful things.
 */
struct bit_names {
	char	*string ;
	int	length ;
};

/*
 *	A structure for maintaing a table of CPU names.  For CPUs
 *	that divided by _subtype, the pointer subtype is the address
 *	of another table of the subtypes.
 */
struct cpu_type {
	int	type ;
	char	*string ;
	struct cpu_type *subtype ;
};

/*
 *	The structure of the magnification function table.
 */
struct magnify_table {
	int	(*mag_open)(),
		(*mag_display)(),
		(*mag_help)() ;
} ; 
