/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 help.c
 *	Date:	 5/23/90
 *	Version: 1.29
 *
 *	help.c - Print some real simple help.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)help.c	1.29	(monitor) 5/23/90" ;
#endif

#include <curses.h>

#include "options.h"

/*
 *	Default display.
 */
extern	WINDOW	*wp ;

help()
{
	printf("usage: monitor [ options ] [ mode and data selection ]\n");
	putchar('\n');

	printf("\t-magnify 'data'  - magnify data option.\n") ;
	printf("\t-prompt 'prompt' - Use 'prompt' instead of the default.\n");
	printf("\t-output 'file'   - Output file for screen dump.\n") ;
	printf("\t-file 'file'     - Save output in file.\n");
	printf("\t-sleep #         - Sleep for # seconds.\n");
	printf("\t-version         - Print the version string and exit.\n");
	printf("\t-sample          - Enable magnification of sample.\n") ;
	printf("\t-total           - Print disk totals (screen mode only).\n");

#ifdef	DEBUG
	printf("\t-debug           - Enable printing of debug messages.\n") ;
#endif
	printf("\t-help            - This help listing.\n");
	putchar('\n');

	printf("\tCollection: { live+ replay names }\n");
	putchar('\n');

	printf("\tDisplay: { save screen+ nop read }\n");
	putchar('\n');

	printf("\tData: { pid=value cpu tty disk free fork process page users\n");
	printf("\t\t  netif memory loadave buf swap namei }\n");
	putchar('\n');

	printf("\tUnit Selection: { disk=value[,value] netif=value[,value]\n");
	printf("\t\t\t  cpu=value[,value] }\n");
	putchar('\n');

	printf("\tGrouped data: { io os mon all }\n");
	putchar('\n');

	printf("\tCommands in screen/replay mode:\n");
	printf("\t\t^L - redraw\n\t\tr  - redraw\n");
	printf("\t\tq  - quit, same as exit\n\t\te  - exit, same as quit\n");
	printf("\t\th  - help\n\t\t?  - help\n") ;
	printf("\t\tp  - pause\n") ;
	printf("\t\td  - dump, dump a copy of the screen to ./screen.dump\n");
	printf("\t\tm  - magnify, give more information about a record.\n");
	printf("\t\tu  - unmagnify, return to the normal screen after magnify.\n");
	putchar('\n');

	printf("\tThe 'pid' data option disables other data options.\n") ;
	printf("\tOptions with a '+' are the defaults.\n");
	printf("\tOptions may be abbreviated.\n");
	putchar('\n');
}

/*
 *	Common code for the continuation prompt.  This will be called
 *	by the various help functions.
 */
continue_prompt()
{
	wmove(wp, LINES - 1, 0) ;
	wprintw(wp, "Type any character to continue.") ;

	wrefresh(wp) ;

	(void)wgetch(wp) ;
}
