/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 extern.h
 *	Date:	 2/13/89
 *	Version: 1.26
 *
 *	extern.h - This file contains declarations for external and global
 *	data.
 */

/*
 * Modification history.
 * 
 * Feb. 10, 1989 -- arr
 *
 *	Added modified declarations for BUF and RECONF records.	
 */

/*
 *	Assorted tables and variables.
 */
extern	struct	nlist		namelist[] ;
extern	int			architecture ;
extern	int			kmem ;
extern	int			killed ;
extern	int			maxcpu ;
extern	int			activecpu ;

/*
 *	Number of CPU's, disks, tape and network interfaces.
 */
extern	unsigned		n_cpu ;
extern	unsigned		n_disk ;
extern	unsigned		n_netif ;
extern	unsigned		n_buf ;

/*
 *	Data records.
 */
extern	struct	mon_first	first ;
extern	struct	mon_last	last ;
extern	struct	mon_sample	sample ;
extern  struct  mon_reconf	reconf ;

extern	struct	mon_tty		tty ;
extern	struct	mon_free	mon_free ;
extern	struct	mon_fork	mon_fork ;
extern	struct	mon_page	mon_page ;
extern	struct	mon_proc	mon_proc ;
extern  struct	mon_swap	mon_swap ;
extern	struct	mon_user	mon_user ;
extern	struct	mon_memory	memory ;
extern	struct	mon_loadave	loadave ;
extern	struct	mon_pid		mon_pid ;
extern	struct	mon_namei	namei ;
extern	struct  mon_kmem	mon_kmem ;

extern	struct	mon_disk	disk[] ;

extern	struct	mon_cpu		*cpu ;
extern	struct	mon_netif	*netif ;
extern	struct	mon_buf		*mon_buf ;

/*
 *	Table of records.
 */
extern	struct	records		records[] ;

/*
 *	Lists of "interesting" devices.
 */
extern	struct	list	cpu_list ;
extern	struct	list	disk_list ;
extern	struct	list	netif_list ;

/*
 *	The array of I/O vectors and number of things in the array.
 */
extern	struct	iovec	iov[] ;
extern	int		n_records ;

/*
 *	These are located in os.c and used primarily in screen.c.
 */
extern	tty_ticks,
	fork_ticks,
	proc_ticks,
	memory_ticks,
	sample_ticks,
	paging_ticks ;
