/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 dumpit.c
 *	Date:	 8/10/87
 *	Version: 1.10
 *
 *	dumpit.c - Function to dump the "screen" to a file.  Originally labeled:
 *
 *		@(#)dumpit.c	9.1 (Cyb) 12/28/84
 *
 */
#ifndef	lint
static	char	SccsId[] = "@(#)dumpit.c	1.10 (monitor) 8/10/87" ;
#endif

/*
 *	dump_screen(fp)
 *	char *fp ;
 *
 *	Write the curses current screen (except for the last line) to
 *	to the file *fp.  This is modified version of the code taken
 *	from "mon" by Philip Dykstra.
 */

#include <stdio.h>
#include <curses.h>

#include "options.h"

/*
 *	Default display.
 */
extern	OPTION	option ;
extern	WINDOW	*wp ;
extern	int	lines ;
extern	int	cols ;

dump_screen(fp)
FILE	*fp ;
{
	int	i, z;

	/*
	 *  For all lines but the last one ...
	 */
	for (i = 0; i < lines; i++) {
		if( option.opt_inter )
			print_line_counter(i) ;

		/*
		 * Search backwards on each line for a non-space.  Z is 
		 * the count of significant characters.
		 */
		for (z = cols - 1; z > 0; z--) {
	    		if ( wp->_y[i][z] != ' ') {

				/*
				 *  Non-space found, increment Z and exit loop
				 */
				z++;
				break;
	    		}
		}

		/*
		 *	fprintf exactly 'z' character from the current line to
		 *	the file *fp.
		 */
		fprintf(fp, "%*.*s\n", z, z, wp->_y[i]) ;
	}
}

print_line_counter(i)
{
	wmove(wp, LINES - 1, 0);
	wprintw(wp, "Dumping Screen Line %d", i) ;
	wclrtoeol(wp) ;
	wrefresh(wp) ;
}
