h20642
s 00021/00010/00076
d D 1.8 87/05/20 17:14:14 alan 8 7
c changed all curses calls to use w... versions
e
s 00000/00000/00086
d D 1.7 87/04/17 15:47:14 alan 7 6
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00001/00001/00085
d D 1.6 86/11/18 12:42:49 alan 6 5
c See commentary on V0.55 in version.c
c 
e
s 00006/00001/00080
d D 1.5 86/11/17 18:42:24 alan 5 4
c See commentary on V0.54 in version.c
c 
e
s 00005/00004/00076
d D 1.4 86/11/16 16:32:00 alan 4 3
c See comments for V0.51 in version.c
c 
e
s 00009/00004/00071
d D 1.3 86/09/29 20:02:46 alan 3 2
c remove the lint
e
s 00055/00002/00020
d D 1.2 86/08/26 17:01:22 alan 2 1
c added code for changeing window size and modified SccsId
c 
e
s 00022/00000/00000
d D 1.1 86/08/26 15:19:18 alan 1 0
c date and time created 86/08/26 15:19:18 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Window handleing functions.
 */
#ifndef	lint
D 2
static	char	SccsId[] = "%W% %G%" ;
E 2
I 2
D 4
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 4
I 4
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 4
E 2
#endif

#include <sys/types.h>
#include <sys/ioctl.h>

I 2
#include <stdio.h>
E 2
#include <signal.h>
I 2
#include <errno.h>
#include <curses.h>
E 2

D 2
winch(sig, code, scp)
E 2
I 2
#include "options.h"

I 5
/*
 *	Module name for error functions.
 */
static	char	*module = "window" ;

I 8
/*
 *	Stuff defined else where.
 */
E 8
E 5
D 4
extern	int	using_curses, changed_size ;
E 4
I 4
extern	int	changed_size ;
E 4
extern	OPTION	option ;
I 8
extern	int	lines ;			/* length of the screen */
extern	int	width ;			/* width of the screen */
extern	WINDOW	*wp ;			/* the default display */
E 8

D 3
catch_sigwinch(sig, code, scp)
E 2
int	sig, code ;
struct sigcontext *scp ;
E 3
I 3
/*
 *	Catch the signal that a window changed size, find out what
 *	the new size is.  We rely on the fact that if LINES and COLS
 *	are already set, curses appears to use the larger size.
 *
 *	I don't want to think about how unreliable this is...
 */
catch_sigwinch()
E 3
{
I 2
	struct winsize window ;

D 8
	if( getwindowsize(&window) == -1 ) {
D 5
		warning("monitor: window: can't get window size: %s.\n");
E 5
I 5
		warning("can't get window size: %s.\n", module);
E 5
		return ;
E 8
I 8
	if( getwindowsize(&window) != -1 ) {
		LINES = lines = window.ws_row ;
		COLS  = width = window.ws_col ;
E 8
	}
I 8
	else {
		lines = LINES ;
		width = COLS ;
	}
E 8

D 4
	if( using_curses ) {
E 4
I 4
	if( option.opt_curses ) {
E 4
D 8
		endwin() ;
E 8
I 8
		if( wp )
			delwin(wp) ;
E 8

D 8
		LINES = window.ws_row ;
		COLS = window.ws_col ;
E 8
I 8
		if((wp = newwin(lines, width, 0, 0)) == NULL )
			fatal("can't create window.\n", module) ;
E 8

D 8
		if( initscr() == NULL )
D 6
			fatal("monitor: window: can't change size: %s.\n");
E 6
I 6
			fatal("can't change size: %s.\n", module);
E 6

E 8
		crmode() ;
		noecho() ;
	}

	changed_size = 1 ;

D 4
	(*option.redraw_display)(&option);
E 4
I 4
	if( option.redraw_display )
		(*option.redraw_display)(&option);
E 4
}

/*
 *	Use the "get window size" ioctl() to:
 *
 *	a.  If we are on a windowing terminal, get the window
 *	    size.
 *
 *	b.  If we aren't on a windowing terminal, punt...
 */
getwindowsize(w)
struct winsize *w ;
{
D 3
	if( ioctl(fileno(stdin), TIOCGWINSZ, (char *)w) == -1 )
E 3
I 3
D 8
	if( ioctl(fileno(stdin), (int)TIOCGWINSZ, (char *)w) == -1 )
E 8
I 8
	if( ioctl(fileno(stdin), (int)TIOCGWINSZ, (char *)w) == -1 ) {
		warning("ioctl on window failed", module) ;
E 8
E 3
		return -1 ;
I 8
	}
E 8

	if( w->ws_xpixel == 0 || w->ws_ypixel == 0 ) {
I 8
		info("window size is 0 x 0.\n", module) ;
E 8
		errno = EOPNOTSUPP ;
		return -1 ;
	}

	return 0 ;
E 2
}
E 1
