h56333
s 00001/00000/00114
d D 1.5 89/02/13 14:29:58 alan 5 4
c Dust off assorted lint and added KMEM option
c 
e
s 00000/00005/00114
d D 1.4 89/01/29 10:03:47 alan 4 3
c dusted off lint
e
s 00066/00053/00053
d D 1.3 89/01/16 18:53:32 alan 3 2
c pound out bugs in the data collection for swap, namei cache and buffer cache
e
s 00004/00007/00102
d D 1.2 89/01/16 16:07:42 alan 2 1
c Added code and data namei and buffer cache.
c 
e
s 00109/00000/00000
d D 1.1 89/01/16 11:43:57 alan 1 0
c date and time created 89/01/16 11:43:57 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Keep the many tables in one place.
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

/*
 * Modification History
I 3
 *
 * Jan. 15, 1989 -- arr
 *
 *	Move record dump functions from read.c.
E 3
 */

#include "include.h"

/*
D 4
 *	Module name for error functions.
 */
static	char	*module = "tables" ;

/*
E 4
D 3
 *	Function declarations for the array.
E 3
I 3
 *	Function declarations for the tables.
E 3
 */
D 3
int	open_cpu(),
	open_buf(),
	open_tty(),
	open_disk(),
	open_fork(),
	open_swap(),
	open_namei(),
	open_netif(),
	open_memory(),		/* used for memory and free */
	open_paging(),
	open_sample(),
	open_process() ;
E 3
I 3
int	f_first(),
	f_last(),
	f_sample(),
	f_loadave(),
	f_user(),
	f_free(),
	f_panic(),
	open_buf(),     f_buf(),     magnify_buf(),     help_buf(),
	open_cpu(),     f_cpu(),     magnify_cpu(),     help_cpu(),
	redraw_pid(),   f_pid(),     magnify_pid(),     help_pid(),
	open_tty(),     f_tty(),     magnify_tty(),     help_tty(),
	open_disk(),    f_disk(),    magnify_disk(),    help_disk(),
	open_fork(),    f_fork(),    magnify_fork(),    help_fork(),
	open_swap(),    f_swap(),    magnify_swap(),    help_swap(),
	open_namei(),   f_namei(),   magnify_namei(),   help_namei(),
	open_netif(),   f_netif(),   magnify_netif(),   help_netif(),
	open_memory(),  f_memory(),  magnify_memory(),  help_memory(),
	open_paging(),  f_paging(),  magnify_paging(),  help_paging(),
	open_sample(),  f_sample(),  magnify_sample(),  help_sample(),
	open_process(), f_process(), magnify_process(), help_process() ;
E 3

D 3
int	redraw_pid() ;
E 3
I 3
int	help_screen(), f_ni(), f_nop() ;
E 3

D 3
int	magnify_cpu(),
	magnify_pid(),
	magnify_buf(),
	magnify_tty(),
	magnify_disk(),
	magnify_fork(),
	magnify_swap(),
	magnify_namei(),
	magnify_netif(),
	magnify_memory(),	/* used for memory and free */
	magnify_paging(),
	magnify_sample(),
	magnify_process() ;

int	help_screen(),
	help_cpu(),
	help_pid(),
	help_tty(),
	help_disk(), 
	help_fork(),
	help_netif(),
	help_memory(),	/* used for memory and free */
	help_paging(),
	help_sample(),
	help_process() ;

E 3
/*
 *	The mag_open function is used:
 *
 *	a.  To print the headers for that data record.
 *	b.  To determine if a function is available.  Only records with
 *	    a display function will show up on the list.
 *	c.  As the redraw function.
 *
 *	The mag_display function is used as the main display function.
 *	In the interests of better performance, it should only display
 *	what it has to.
 *
 *	There are no plans to ever have a magnify function for the user
 *	or loadave data records.
 */
D 2
struct {
	int	(*mag_open)(),
		(*mag_display)(),
		(*mag_help)() ;
} mag_array[] = {
E 2
I 2
struct magnify_table mag_array[] = {
E 2
	0, 0, 0,					/* first */
	0, 0, 0,					/* last */
D 3
	open_sample, magnify_sample, help_screen,	/* sample */
E 3
I 3
	open_sample,  magnify_sample,  help_screen,	/* sample */
E 3
	0, 0, 0,					/* record type 3 */
D 3
	open_cpu, magnify_cpu, help_screen,		/* cpu */
	open_tty, magnify_tty, help_screen,		/* tty */
	open_disk, magnify_disk, help_screen,		/* disk */
	open_memory, magnify_memory, help_screen,	/* free */
	open_fork, magnify_fork, help_screen,		/* fork */
	open_paging, magnify_paging, help_screen,	/* page */
E 3
I 3
	open_cpu,     magnify_cpu,     help_screen,	/* cpu */
	open_tty,     magnify_tty,     help_screen,	/* tty */
	open_disk,    magnify_disk,    help_screen,	/* disk */
	open_memory,  magnify_memory,  help_screen,	/* free */
	open_fork,    magnify_fork,    help_screen,	/* fork */
	open_paging,  magnify_paging,  help_screen,	/* page */
E 3
	open_process, magnify_process, help_screen,	/* proc */
D 3
	open_swap, magnify_swap, help_screen,		/* swap */
E 3
I 3
	open_swap,    magnify_swap,    help_screen,	/* swap */
E 3
	0, 0, 0,					/* tape */
	0, 0, 0,					/* user */
D 3
	open_netif, magnify_netif, help_screen,		/* netif */
	open_memory, magnify_memory, help_screen,	/* memory */
E 3
I 3
	open_netif,   magnify_netif,   help_screen,	/* netif */
	open_memory,  magnify_memory,  help_screen,	/* memory */
E 3
	0, 0, 0,					/* loadave */
D 3
	redraw_pid, magnify_pid, help_screen,		/* pid */
D 2
	0, 0, 0,
	0, 0, 0,
E 2
I 2
	open_buf, magnify_buf, help_screen,		/* buffer cache */
E 3
I 3
	redraw_pid,   magnify_pid,     help_screen,	/* pid */
	open_buf,     magnify_buf,     help_screen,	/* buffer cache */
E 3
	0, 0, 0,					/* nfs */
D 3
	open_namei, magnify_namei, help_screen,		/* namei cache */
E 3
I 3
	open_namei,   magnify_namei,   help_screen,	/* namei cache */
I 5
	0, 0, 0,					/* kmem stats */
E 5
E 3
E 2
};

I 3
/*
 *	Array of function pointers, one for each record type.
 */
int	(*dump_functions[])() = {
	f_first, 				/* FIRST */
	f_last, 				/* LAST */
	f_sample, 				/* SAMPLE */
	f_nop,					/* unused control record */
	f_cpu, 					/* CPU */
	f_tty,					/* TTY */
	f_disk, 				/* DISK */
	f_free, 				/* Free memory */
	f_fork,					/* FORK */
	f_paging, 				/* PAGE */
	f_process, 				/* PROC */
	f_swap,					/* Swap space */
	f_ni, 					/* TAPE */
	f_user,					/* USER */
	f_netif,				/* network interface */
	f_memory,				/* memory */
	f_loadave,				/* load average */
	f_pid,					/* process by id */
	f_buf, 					/* buffer cache */
	f_ni, 					/* NFS */
	f_namei,				/* namei_cache */
	f_panic,				/* The Panic! record */
};
E 3
E 1
