h25752
s 00020/00004/00254
d D 1.14 90/08/21 22:43:17 alan 14 13
c dust off lint
e
s 00005/00001/00253
d D 1.13 89/02/10 15:21:43 alan 13 12
c Change for new BUF record and RECONF record.
c 
e
s 00004/00001/00250
d D 1.12 88/06/27 18:17:29 alan 12 11
c changed include of monitor.h and record.h
e
s 00059/00060/00192
d D 1.11 88/06/27 17:35:24 alan 11 10
c Moved OS dependent strings into string_data.c
c 
e
s 00003/00000/00249
d D 1.10 87/11/18 16:39:58 alan 10 9
c V0.99 -> T1.0-1
e
s 00108/00007/00141
d D 1.9 87/03/03 15:43:03 alan 9 8
c see the commentary for V0.83 in version.c
e
s 00000/00064/00148
d D 1.8 87/01/21 16:37:55 alan 8 7
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00010/00044/00202
d D 1.7 86/12/30 11:21:25 alan 7 6
c See commentary on V0.64 in version.c
e
s 00049/00127/00197
d D 1.6 86/12/07 22:23:32 alan 6 5
c See V0.57 in version.c
e
s 00043/00001/00281
d D 1.5 86/11/16 16:56:27 alan 5 4
c See comments on V0.52 in version.c
c 
e
s 00023/00025/00259
d D 1.4 86/10/30 13:43:37 alan 4 3
c Use a switch instead of a table to return the CPU type string.
c 
e
s 00019/00005/00265
d D 1.3 86/10/30 13:00:09 alan 3 2
c 1.  Modify getsid() to build something which looks like an SID.
c 2.  Modify str_cpuid() to understand what was built by getsid().
c 
e
s 00001/00001/00269
d D 1.2 86/08/26 18:05:08 alan 2 1
c modify all SccsId strings
e
s 00270/00000/00000
d D 1.1 86/07/13 14:48:56 alan 1 0
c date and time created 86/07/13 14:48:56 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Functions to print out names of bits, as opposed
 *	to bit values.
 *
 *	Derived from print.c V1.6.
 */
#ifndef	lint
D 2
static	char	SccsId[] = "%W% %G%" ;
E 2
I 2
D 6
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 6
I 6
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 6
E 2
#endif

I 11
/*
 * Modification History
 *
 * 27-June-1988 - arr
 *
 *	Moved OS dependent strings to string_data.c.
I 12
 *
 *	Change include of monitor.h to include.h.
I 13
 *
 * Feb. 10, 1989 -- arr
 *
 *	Changed rectype3 to reconf.
E 13
E 12
 */

I 14
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
E 14
I 12

E 12
E 11
I 3
#include <sys/types.h>
I 9
D 14
#include <sys/param.h>
E 14
I 14
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 14
#include <sys/dir.h>
I 14
#include <sys/param.h>
E 14
#include <sys/user.h>
E 9
D 8
#include <machine/cpu.h>
E 8

I 7
D 8
/*
 *	If VAX_8800 isn't defined by <machine/cpu.h> we'll define it.
 */
#ifndef	VAX_8800
#	define	VAX_8800	(6)
#endif

E 8
E 7
E 3
D 14
#include <stdio.h>
E 14
I 14
#include <net/if.h>
#include <netinet/in.h>
E 14

D 14
#include "options.h"
E 14
I 14
#include "monitor.h"
E 14
I 9
D 12
#include "monitor.h"
E 12
I 12
#include "include.h"
I 14
#include "options.h"
E 14
E 12
E 9

/*
D 11
 *	"A rose by any other name..." - W.S.
E 11
I 11
 *	A convient MACRO to initialize the bit_names structure.
E 11
 */
#define	MACRO(s)	{ s, sizeof(s) - 1, }

I 6
/*
 *	Functions that don't return (int).
 */
E 6
D 9
char	*str_data(),
E 9
I 9
char	*sprintf(),
	*str_data(),
E 9
D 7
	*str_disk(),
	*str_tape(),
E 7
	*str_netif(),
D 5
	*str_cpuid() ;
E 5
I 5
D 8
	*str_cpuid(),
E 8
	*str_opt_flags() ;
E 5

D 9
struct	bit_names {			/* names of things */
	char	*string ;
	int	length ;
};

E 9
/*
I 6
 *	Common code used by all the str_ functions.
 */
char	*str_generic(mask, buf, bnp)
int	mask ;
char	*buf ;
struct bit_names *bnp ;
{
	register int	i, comma = 0 ;
	register char 	*p = buf ;

D 9
	for(i = 0; i < sizeof(mask) * 8; i++) {
E 9
I 9
	for(i = 0; i < sizeof(mask) * NBBY; i++) {
E 9
		if( bnp[i].string == NULL )
			break ;

		if( mask & (1 << i)) {
			if( comma++ )
				*p++ = ',' ;

			(void)sprintf(p, "%s", bnp[i].string) ;

			p += bnp[i].length ;
		}
	}

	*p = '\0' ;

	return buf ;
}

/*
E 6
D 11
 *	Functions and data to take the data option bit field and turn it into
 *	something "meaningful".
E 11
I 11
 *	The names of all the data options.
E 11
 */
struct bit_names data_names[] = {
	MACRO("control-1"),
	MACRO("control-2"),
	MACRO("sample"),
D 13
	MACRO("rectype3"),
E 13
I 13
	MACRO("reconf"),
E 13
	MACRO("cpu"),
	MACRO("tty"),
	MACRO("disk"),
	MACRO("free"),
	MACRO("fork"),
	MACRO("page"),
	MACRO("proc"),
	MACRO("swap"),
	MACRO("tape"),
	MACRO("user"),
	MACRO("netif"),
	MACRO("memory"),
	MACRO("loadave"),
I 9
	MACRO("pid"),
I 10
	MACRO("buf"),
	MACRO("nfs"),
	MACRO("namei"),
I 11
	{ 0, 0, },
E 11
E 10
E 9
};

char	*str_data(data)
int	data ;
{	
D 6
	register int	i, comma = 0 ;
	register char 	*p ;
E 6
	static	 char	buf[BUFSIZ] ;

D 6
	p = buf ;

	for(i = 0; i < sizeof(data) * 8; i++)
		if( data & (1 << i)) {
			if( data_names[i].string == NULL )
				break ;

			if( comma++ )
				*p++ = ',' ;

			(void)sprintf(p, "%s", data_names[i].string);

			p += data_names[i].length ;
		}

	*p = '\0' ;

	return buf ;
E 6
I 6
	return str_generic(data, buf, data_names) ;
E 6
}

/*
 *	Functions and data to take the netif flag field and turn it into
 *	something "meaningful".
 */
D 11
struct bit_names netif_names[] = {
	MACRO("up"), 			/* 01 */
	MACRO("broadcast"), 		/* 02 */
	MACRO("debug"), 		/* 04 */
	MACRO("route"),			/* 010 */
	MACRO("point-to-point"),	/* 020 */
	MACRO("notrailers"),		/* 040 */
	MACRO("running"),		/* 0100 */
	MACRO("noarp"),			/* 0200 */
	MACRO("local"),			/* 0400 */
	MACRO("dynproto"),		/* 01000 */
	MACRO("loopback"),		/* 02000 */
I 6
D 7
#ifdef	V20
E 7
	MACRO("mop"),			/* 04000 */
D 7
#endif
E 7
E 6
	{ 0, 0, }
};
E 11
I 11
extern struct bit_names netif_names[] ;
E 11

char	*str_netif(flags)
short	flags ;
{
D 6
	register int 	i, comma = 0 ;
	register char	*p ;
E 6
	static char 	buf[BUFSIZ] ;

D 6
	p = buf ;

	for(i = 0 ; i < sizeof(flags) * 8; i++)
		if( flags & (1 << i)) {
			if( netif_names[i].string == NULL )
				break ;

			if( comma++ )
				*p++ = ',' ;

				(void)sprintf(p, "%s", netif_names[i].string);

			p += netif_names[i].length ;
		}

	*p = '\0' ;

	return buf ;
E 6
I 6
	return str_generic(flags, buf, netif_names) ;
E 6
D 8
}

/*
D 7
 *	Functions and data to take the disk flag field (once it exists)
 *	and turn it into something "meaningful".
 */
struct bit_names disk_names[] = {
	{ 0, 0, }
};

char	*str_disk(disk)
int	disk ;
{
D 6
	register int	i, comma = 0 ;
	register char	*p ;
E 6
	static	 char	buf[BUFSIZ] ;

D 6
	p = buf ;

	for(i = 0; i < sizeof(disk) * 8; i++) {
		if( disk_names[i].string == NULL )
			break ;

		if( disk & (1 << i)) {
			if( comma++ )
				*p++ = ',' ;

			(void)sprintf(p, "%s", disk_names[i].string);

			p += disk_names[i].length ;
		}
	}

	*p = '\0' ;

	return buf ;
E 6
I 6
	return str_generic(disk, buf, disk_names) ;
E 6
}


/*
 *	Functions and data to take the tape flags (once they exist) and 
 *	turn it into something "meaningful".
 */
struct bit_names tape_names[] = {
	0, 0,
};

char	*str_tape(tape)
int	tape ;
{
D 6
	register int	i, comma = 0 ;
	register char	*p ;
E 6
	static	 char	buf[BUFSIZ] ;

D 6
	p = buf ;

	for(i = 0; i < sizeof(tape) * 8; i++) {
		if( tape_names[i].string == NULL )
			break ;

		if( tape & (1 << i)) {
			if( comma++ )
				*p++ = ',' ;

			(void)sprintf(p, "%s", tape_names[i].string);

			p += tape_names[i].length ;
		}
	}

	*p = '\0' ;

	return buf ;
E 6
I 6
	return str_generic(tape, buf, tape_names) ;
E 6
}

/*
E 7
D 3
 *	Functions and data to take the CPU id and turn it info something
 *	"meaningfull".  This assumes that I can actually get the CPU id
 *	out of UEG.
E 3
I 3
 *	Functions and data to take the CPU id and turn it into something
D 7
 *	"meaningful".  This assumes that I can actually get the CPU id
 *	out of UEG.  Until that happens my getsid() function will get
D 4
 *	the CPU type and encode it into a long word so it looks like
E 4
I 4
 *	the CPU type and encode it into a longword so it looks like
E 4
 *	an SID.  This function will decode that number.
E 7
I 7
 *	"meaningful".  Another part of monitor takes the cpu type and 
 *	turns it into something that looks a little like the CPU id.
E 7
E 3
 */
D 4
char	*cpu_names[] = {
	"undefined",
	"VAX 11/780 or 11/785",
	"VAX 11/750 or 11/751",
	"VAX 11/730 or 11/725",
	"VAX 8600 or 8650",
	"VAX 8200",
	"undefined",
	"MicroVAX I",
	"MicroVAX II",
	0,
};

I 3
/*
 *	Shorthand names for some of the fields in the cpusid union.
 */
#define	cpu_type	cpu.cpuany.cp_type

E 3
char	*str_cpuid(id)
int	id ;
E 4
I 4
char	*str_cpuid(ident)
int	ident ;
E 4
{
D 3
	if( id > (sizeof(cpu_names)/sizeof(cpu_names[0])))
E 3
I 3
	union cpusid cpu ;
I 4
	int	type ;
E 4

D 4
	cpu.cpusid = id ;
E 4
I 4
	cpu.cpusid = ident ;
	type = cpu.cpuany.cp_type ;
E 4

D 4
	if( cpu_type > (sizeof(cpu_names)/sizeof(cpu_names[0])))
E 4
I 4
	switch( type ) {
	case VAX_780:
		return "VAX 11/780 or 11/785" ;
	case VAX_750:
		return "VAX 11/750 or 11/751" ;
	case VAX_730:
		return "VAX 11/730 or 11/725" ;
	case VAX_8600:
D 6
		return "VAX 8600 or 8650" ;
E 6
I 6
		return "VAX 8600/8650" ;
E 6
	case VAX_8200:
D 6
		return "VAX 8200" ;
E 6
I 6
		return "VAX 8200/8300" ;
D 7
#ifdef	V20
E 7
	case VAX_8800:
		return "VAX 8800/8700/8550/8500" ;
D 7
#endif
E 7
E 6
	case MVAX_I:
		return "MicroVAX I" ;
	case MVAX_II:
		return "MicroVAX II" ;
	default:
E 4
E 3
		return "reserved for future use" ;
D 4
	else
D 3
		return cpu_names[id] ;
E 3
I 3
		return cpu_names[cpu_type] ;
E 4
I 4
	}
E 4
E 3
}

/*
 *	Functions and data to take the CPU state bits and turn them into
 *	something "meaningful".
 */
struct bit_names state_names[] = {
	MACRO("run"),
	MACRO("tbi"),
	MACRO("panic"),
	0, 0,
};

char	*str_state(state)
int	state ;
{
D 6
	register int	i, comma = 0 ;
	register char	*p ;
E 6
	static	char	buf[BUFSIZ] ;

D 6
	p = buf ;

	for(i = 0; i < sizeof(state) * 8; i++) {
		if( state_names[i].string == NULL )
			break ;

		if( state & (1 << i)) {
			if( comma++ )
				*p++ = ',' ;

			(void)sprintf(p, "%s", state_names[i].string);

			p += state_names[i].length;
		}
	}

	*p = '\0' ;

	return buf ;
E 6
I 6
	return str_generic(state, buf, state_names) ;
E 8
E 6
}
I 5

D 11
#ifdef	DEBUG
struct bit_names opt_flags[] = {
D 7
	MACRO("eatit"),
E 7
I 7
	MACRO("unused"),
E 7
	MACRO("interactive"),
	MACRO("total"),
	MACRO("curses"),
	MACRO("standard"),
	MACRO("sleep_set"),
	MACRO("output_set"),
	0, 0,
};
E 11

D 11
char	*str_opt_flags(flags)
int	flags ;
{
D 6
	register int	i, comma = 0 ;
	register char	*p ;
E 6
	static	char	buf[BUFSIZ] ;

D 6
	p = buf ;

	for(i = 0; i < sizeof(flags) * 8; i++) {
		if( opt_flags[i].string == NULL )
			break ;

		if( flags & (1 << i)) {
			if( comma++ )
				*p++ = ',' ;

			(void)sprintf(p, "%s", opt_flags[i].string);

			p += opt_flags[i].length;
		}
	}

	*p = '\0' ;

	return buf ;
E 6
I 6
	return str_generic(flags, buf, opt_flags) ;
E 6
}
#endif
I 9

E 11
/* 
D 11
 *	Variable in other places.
E 11
I 11
 *	The names and function to turn the process flag into a
 *	readable string.
E 11
 */
D 11
struct bit_names flag_names[] = {
	MACRO("sload"), MACRO("ssys"), MACRO("slock"), MACRO("sswap"),
	MACRO("strc"), MACRO("swted"), MACRO("sulock"), MACRO("spage"),
	MACRO("skeep"), MACRO("somask"), MACRO("swexit"), MACRO("sphysio"),
	MACRO("svfork"), MACRO("svfdone"), MACRO("snovm"), MACRO("spagi"),
	MACRO("sseql"), MACRO("suanom"), MACRO("stimo"), MACRO("*sdetach*"),
	MACRO("sousig"), MACRO("soweupc"), MACRO("ssel"), MACRO("slogin"),
	MACRO("sptechg"), MACRO("smaster"),
};
E 11
I 11
extern struct bit_names flag_names[] ;
E 11

char	*str_flags(flag)
int	flag ;
{
	static	char	buf[BUFSIZ] ;

	return str_generic(flag, buf, flag_names) ;
}

I 11
/*
 *	Turn a timeval structure into a readable string.
 */
E 11
char	*str_timeval(p)
struct timeval *p ;
{
	static	char	buf[32] ;
	int	hours, minutes, seconds, fract ;

	fract = p->tv_usec / 10000 ;

	seconds = p->tv_sec % 60 ; p->tv_sec /= 60 ;
	minutes = p->tv_sec % 60 ; p->tv_sec /= 60 ;
	hours   = p->tv_sec % 24 ;

	return sprintf(buf, "%5d:%.2d:%.2d.%.2d", hours, minutes, seconds, fract) ;
}

I 11
/*
 *	Print the rusage structure.
 */
E 11
print_rusage(p, s)
struct rusage *p ;
char	*s ;
{
	printf("%sru_utime:    %s\n", s, str_timeval(&p->ru_utime)) ;
	printf("%sru_stime:    %s\n", s, str_timeval(&p->ru_stime)) ;
	printf("%sru_maxrss:   %d\n", s, p->ru_maxrss) ;
	printf("%sru_minflt:   %d\n", s, p->ru_minflt) ;
	printf("%sru_majflt:   %d\n", s, p->ru_majflt) ;
	printf("%sru_nswap:    %d\n", s, p->ru_nswap) ;
	printf("%sru_inblock:  %d\n", s, p->ru_inblock) ;
	printf("%sru_oublock:  %d\n", s, p->ru_oublock) ;
	printf("%sru_msgsnd:   %d\n", s, p->ru_msgsnd) ;
	printf("%sru_msgrcv:   %d\n", s, p->ru_msgrcv) ;
	printf("%sru_nsignals: %d\n", s, p->ru_nsignals) ;
	printf("%sru_nvcsw:    %d\n", s, p->ru_nvcsw) ;
	printf("%sru_nivcsw:   %d\n", s, p->ru_nivcsw) ;
}

I 11
/*
 *	Print the credential structure.
 */
E 11
print_cred(p, s)
D 14
struct ucred *p ;
E 14
I 14
struct mon_ucred *p ;
E 14
char	*s ;
{
	register i ;

	printf("%scr_ref:    %d\n", s, p->cr_ref) ;
	printf("%scr_uid:    %d\n", s, p->cr_uid) ;
	printf("%scr_gid:    %d\n", s, p->cr_gid) ;
	printf("%scr_ruid:   %d\n", s, p->cr_ruid) ;
	printf("%scr_rgid:   %d\n", s, p->cr_rgid) ;

	printf("%scr_groups: ", s) ;

	for(i = 0; i < NGROUPS; i++) {
		if( p->cr_groups[i] == -1 )
			break ;

		if( i )
			putchar(',') ;

		printf("%d", p->cr_groups[i]) ;
	}

	putchar('\n') ;
}

D 11
char	*stats[] = {
	"-",
	"sleeping",
	"<waiting>",
	"running",
	"idle",
	"zombie",
	"stopped",
};
E 11
I 11
/*
 *	The names and function to turn process states into a readable
 *	string.
 */
extern int   n_proc_states ;
extern char *proc_states[] ;
E 11

D 11
char	*str_stats(i)
E 11
I 11
char	*str_stats(state)
int	state ;
E 11
{
D 11
	if( 0 <= i && i < sizeof(stats)/sizeof(stats[0]))
		return stats[i] ;
E 11
I 11
	if( 0 <= state && state < n_proc_states )
		return proc_states[state] ;
E 11
	else
		return "?" ;
}
I 11

#ifdef	DEBUG
/*
 *	The names and function to take the options flag and turn
 *	into a readable string.
 */
struct bit_names opt_flags[] = {
	MACRO("unused"),
	MACRO("interactive"),
	MACRO("total"),
	MACRO("curses"),
	MACRO("standard"),
	MACRO("sleep_set"),
	MACRO("output_set"),
	0, 0,
};

char	*str_opt_flags(flags)
int	flags ;
{
	static	char	buf[BUFSIZ] ;

	return str_generic(flags, buf, opt_flags) ;
}
#endif
E 11
E 9
E 5
E 1
