h50969
s 00061/00011/00225
d D 1.13 90/07/21 10:36:16 alan 13 12
c added new CPUs
e
s 00014/00017/00222
d D 1.12 89/12/27 16:11:10 alan 12 11
c Clean up architecture and version differences
e
s 00005/00005/00234
d D 1.11 89/12/25 17:24:52 alan 11 10
c added CPU type for VAX 9000
e
s 00010/00005/00229
d D 1.10 89/12/25 17:24:07 alan 10 9
c added a CPU type for the VAX 9000
e
s 00047/00001/00187
d D 1.9 89/10/05 13:32:16 alan 9 8
c added more CPU names
e
s 00010/00001/00178
d D 1.8 89/04/28 23:20:53 alan 8 7
c added Rigel and fixed a bug that would cause the CPU name lookup to fail if the CPU type wasn't recognized.
e
s 00003/00000/00176
d D 1.7 89/03/20 17:39:35 alan 7 6
c added Firefox
e
s 00001/00001/00175
d D 1.6 89/01/11 16:14:51 alan 6 5
c fix bug in VAX_8820 reference
e
s 00003/00001/00173
d D 1.5 89/01/08 22:49:57 alan 5 4
c fix bug to needed to compile on V2.0
e
s 00045/00002/00129
d D 1.4 89/01/04 10:45:50 alan 4 3
c V1.1 changes for MIPS support.  This is a check-point of the current
c support.
c 
e
s 00045/00000/00086
d D 1.3 88/06/28 00:13:49 alan 3 2
c seperate the code and data used to determine the CPU name
e
s 00009/00001/00077
d D 1.2 88/06/27 18:17:26 alan 2 1
c changed include of monitor.h and record.h
e
s 00078/00000/00000
d D 1.1 88/06/27 17:35:43 alan 1 0
c date and time created 88/06/27 17:35:43 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
D 10
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
E 10
I 10
D 11
 *	File:	 string_data.c
 *	Date:	 12/21/89
 *	Version: 1.1
E 11
I 11
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
E 11
E 10
 *
D 10
 *	%M% - Bring all the operating system string data together
E 10
I 10
D 11
 *	string_data.c - Bring all the operating system string data together
E 11
I 11
 *	%M% - Bring all the operating system string data together
E 11
E 10
 *	into one place.  Another set of strings local to monitor
 *	are kept in the source file using them.
 */
#ifndef	lint
D 10
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 10
I 10
D 11
static	char	SccsId[] = "@(#)string_data.c	1.1 (monitor) 12/21/89" ;
E 11
I 11
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 11
E 10
#endif

D 2
#include "monitor.h"
E 2
I 2
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
I 3
 *	New file.
 *
E 3
 *	Change include of monitor.h to include.h.
I 3
 *
 *	Added initializations of cpu_data structure.
I 4
 *
 * 29-November-1988 -- arr
 *
 *	Added changes for MIPS support.
 *
 * 28-December-1988 -- arr
 *
 *	Added data to cpu_types for MIPS based systems.
I 8
 *
 * April 28, 1989 -- arr
 *
 *	Added Rigel to the CPU list and NULL terminated the
 *	VAX list.
E 8
E 4
E 3
 */

I 3
#include <stdio.h>
#include <sys/types.h>
D 4
#include <machine/cpu.h>
E 4

I 10
#ifdef	V4_ULTRIX
D 12
#	include <sys/cpuconf.h>
E 12
I 12
#	include <machine/cpuconf.h>
#elif	mips
#	include <machine/cpuconf.h>
E 12
#else
E 10
I 4
D 12
#ifdef	vax
E 12
#	include <machine/cpu.h>
#endif
D 12
#ifdef	mips
#	include <machine/hwconf.h>
#endif
I 10
#endif
E 12
E 10

E 4
E 3
#include "include.h"
E 2

/*
 *	A convient macro for initializing the bit_names structure.
 */
#define	MACRO(s) { s, sizeof(s) - 1 }

/*
 *	The names of the CPU states.
 */
struct bit_names state_names[] = {
D 13
	MACRO("run"),
	MACRO("tbi"),
	MACRO("panic"),
E 13
I 13
	MACRO("run"),			/* 0x1 */
	MACRO("tbi"),			/* 0x2 (moved to own field in V4) */
	MACRO("panic"),			/* 0x4 */
	MACRO("soft_disable"),		/* 0x8 */

	MACRO("boot"),			/* 0x10 */
	MACRO("stop"),			/* 0x20 */
	MACRO("timeout"),		/* 0x40 */
	MACRO("sigparent"),		/* 0x80 */

	MACRO("idle"),			/* 0x100 */
	MACRO("sigprof"),		/* 0x200 */
	MACRO("sigxcpu"),		/* 0x400 */
	MACRO("sigvtalrm"),		/* 0x800 */

E 13
	{ 0, 0, }
};

/*
 *	The names of the network interface bits.
 */
struct bit_names netif_names[] = {
	MACRO("up"), 			/* 01 */
	MACRO("broadcast"), 		/* 02 */
	MACRO("debug"), 		/* 04 */
	MACRO("route"),			/* 010 */
	MACRO("point-to-point"),	/* 020 */
	MACRO("notrailers"),		/* 040 */
	MACRO("running"),		/* 0100 */
	MACRO("noarp"),			/* 0200 */
	MACRO("local"),			/* 0400 */
	MACRO("dynproto"),		/* 01000 */
	MACRO("loopback"),		/* 02000 */
	MACRO("mop"),			/* 04000 */
	{ 0, 0, }
};

/* 
 *	The names of the process flags.
 */
struct bit_names flag_names[] = {
	MACRO("sload"), MACRO("ssys"), MACRO("slock"), MACRO("sswap"),
	MACRO("strc"), MACRO("swted"), MACRO("sulock"), MACRO("spage"),
	MACRO("skeep"), MACRO("somask"), MACRO("swexit"), MACRO("sphysio"),
	MACRO("svfork"), MACRO("svfdone"), MACRO("snovm"), MACRO("spagi"),
	MACRO("sseql"), MACRO("suanom"), MACRO("stimo"), MACRO("*sdetach*"),
	MACRO("sousig"), MACRO("soweupc"), MACRO("ssel"), MACRO("slogin"),
	MACRO("sptechg"), MACRO("smaster"),
	{ 0, 0, },
};

/*
 *	The names of the process states.
 */
char	*proc_states[] = {
	"-",
	"sleeping",
	"<waiting>",
	"running",
	"idle",
	"zombie",
	"stopped",
};

int	n_proc_states = sizeof(proc_states)/sizeof(proc_states[0]) ;
I 3

I 4
D 9
#ifdef	vax
E 9
E 4
/*
 *	These arrays will allow cpu.c to get a CPU string from
 *	a type and subtype.
 */
struct cpu_type vax8200[] = {
I 9
#ifdef	VAX8200
E 9
	ST_8200, "VAX 8200/8250", NULL,
	ST_8300, "VAX 8300/8350", NULL,
	ST_8400, "VAX 8400/8450", NULL,
I 9
#endif
E 9
	{ 0, 0, 0, },
};

struct cpu_type vax8800[] = {
I 9
#ifdef	VAX_8800
E 9
	ST_8500, "VAX 8500/8530", NULL,
	ST_8550, "VAX 8550", NULL,
	ST_8700, "VAX 8700", NULL,
	ST_8800, "VAX 8800", NULL,
I 9
#endif
E 9
	{ 0, 0, 0, },
};

struct cpu_type microvax2[] = {
I 9
#ifdef	MVAX_II
E 9
I 4
	ST_MVAXII,  "MicroVAX/VAXstation II",   NULL,
E 4
	ST_VAXSTAR, "MicroVAX/VAXstation 2000", NULL,
I 9
#endif
E 9
	{ 0, 0, 0, },
};

I 9
#ifdef	vax
E 9
struct cpu_type cpu_types[] = {
I 4
/*
 *	The VAX list.
 */
E 4
	VAX_780,  "VAX 11/780 or 11/785", NULL,
	VAX_750,  "VAX 11/750 or 11/751", NULL,
	VAX_730,  "VAX 11/730 or 11/725", NULL,
	VAX_8600, "VAX 8600/8650", NULL,
	VAX_8200, "VAX 8200/8250/8300/8350", vax8200,
	VAX_8800, "VAX 8800/8700/8550/8530/8500", vax8800,
	MVAX_I,   "MicroVAX I", NULL,
	MVAX_II,  "MicroVAX/VAXstation II", microvax2,
D 5
	C_VAX,    "MicroVAX/VAXstation 3200/3500/3600", NULL,
E 5
D 4
	{ 0, 0, 0, },
E 4
I 4
/*
 *	Future CPU types will need to be #ifdef'd as these
 *	are.  This lets the data be updated for newer versions
 *	but still be backward compatiable.
 */
I 5
#ifdef	C_VAX
	C_VAX,    "MicroVAX/VAXstation 3200/3500/3600", NULL,
#endif
E 5
#ifdef	VAX_6200
D 8
	VAX_6200, "VAX 6210/6220/6230/6240", NULL,
E 8
I 8
	VAX_6200, "VAX 62xx/63xx", NULL,
E 8
#endif
#ifdef	C_VAXSTAR
	C_VAXSTAR, "VAXstation 3100", NULL,
#endif
D 6
#ifdef	
E 6
I 6
#ifdef	VAX_8820
E 6
	VAX_8820, "VAX 8820/8830/8840", NULL,
#endif
I 7
#ifdef	VAX_60
	VAX_60, "VAXstation 3520/3540", NULL,
#endif
I 13
#ifdef	V_VAX
	V_VAX, "A Virtual VAX", NULL,
#endif
#ifdef	VAXSTAR
	VAXSTAR, "MicroVAX/VAXStation 2000", NULL,
#endif
E 13
I 8
#ifdef	VAX_6500
D 13
	VAX_6500, "VAX 65xx", NULL,
E 13
I 13
	VAX_6500, "VAX 6000-500", NULL,
E 13
#endif
I 13
#ifdef	VAX_6400
	VAX_6400, "VAX 6000-400", NULL,
#endif
#ifdef	VAX_3600
	VAX_3600, "MicroVAX 3600", NULL,
#endif
#ifdef	VAX_3400
	VAX_3400, "MicroVAX 3400", NULL,
#endif
#ifdef	VAX_3900
	VAX_3900, "MicroVAX 3900", NULL,
#endif
/*
 *	Once the VAX 9000 is properly defined, it should use
 *	this one first.  If not, I hopefully got the right
 *	magick number.
 */
#ifdef	VAX_9000
	VAX_9000, "VAX 9000", NULL,
#endif
E 13
I 10
	0xe, "VAX 9000", NULL,
E 10
	{ 0, 0, 0, },
E 8
E 7
E 4
};
I 4
#endif

I 9
struct cpu_type r2000a[] = {
#ifdef	ST_DS3100
D 12
	{ ST_DS3100, "DECstation 3100", NULL },
E 12
I 12
	{ ST_DS3100, "DECstation/DECsystem 3100/2100", NULL },
E 12
#endif
#ifdef	ST_3MAX
	{ ST_3MAX,   "Unannounced CPU type", NULL },
#endif
I 13
#ifdef	ST_DS5000
	{ ST_DS5000, "DECstation/DECsystem 5000", NULL },
#endif
E 13
#ifdef	ST_DS5800
D 13
	{ ST_DS5800, "DECsystem 5810/5820", NULL },
E 13
I 13
	{ ST_DS5800, "DECsystem 5810/5820/5830/5840", NULL },
E 13
#endif
#ifdef	ST_DS5400
D 13
	{ ST_DS5400, "DECsystem 5410", NULL },
E 13
I 13
	{ ST_DS5400, "DECsystem 5400", NULL },
E 13
#endif
I 13
#ifdef	ST_DS5500
	{ ST_DS5400, "DECsystem 5500", NULL },
#endif
E 13
	{ 0, 0, 0, },
} ;

struct cpu_type r3000[] = {
#ifdef	ST_DS3100
D 12
	{ ST_DS3100, "DECstation 3100", NULL },
E 12
I 12
	{ ST_DS3100, "DECstation/DECsystem 3100/2100", NULL },
E 12
#endif
#ifdef	ST_3MAX
	{ ST_3MAX,   "Unannounced CPU type", NULL },
#endif
I 13
#ifdef	ST_DS5000
	{ ST_DS5000, "DECstation/DECsystem 5000", NULL },
#endif
E 13
#ifdef	ST_DS5800
D 13
	{ ST_DS5800, "DECsystem 5810/5820", NULL },
E 13
I 13
	{ ST_DS5800, "DECsystem 5810/5820/5830/5840", NULL },
E 13
#endif
#ifdef	ST_DS5400
D 13
	{ ST_DS5400, "DECsystem 5410", NULL },
E 13
I 13
	{ ST_DS5400, "DECsystem 5400", NULL },
E 13
#endif
I 13
#ifdef	ST_DS5500
	{ ST_DS5400, "DECsystem 5500", NULL },
#endif
E 13
	{ 0, 0, 0, },
} ;

E 9
/*
 *	The MIPS list.
 */
#ifdef	mips
struct cpu_type cpu_types[] = {
I 9
D 12
#ifdef	PMAX
E 9
	{ PMAX, "DECstation 3100", NULL, },
I 9
#endif
#ifdef	R2000a_CPU
	{ R2000a_CPU, "R2000a Based System", r2000a, },
#endif
#ifdef	R3000_CPU
	{ R3000_CPU, "R3000 Based Systems", r3000, },
#endif
E 12
I 12
#	ifdef	PMAX
		{ PMAX, "DECstation/DECsystem 3100/2100", NULL, },
#	endif
D 13
#	ifdef	R2000a_CPU
		{ R2000a_CPU, "R2000a Based System", r2000a, },
#	endif
E 13
#	ifdef	R3000_CPU
		{ R3000_CPU, "R3000 Based Systems", r3000, },
I 13
#	endif
#	ifdef	R2000a_CPU
		{ R2000a_CPU, "R2000a Based System", r2000a, },
E 13
#	endif
E 12
E 9
	{ 0, 0, 0, },
} ;
#endif
E 4
E 3
E 1
