h15133
s 00010/00000/00546
d D 1.30 90/03/29 16:17:25 alan 30 29
c The hack to fix the DECmumble include file problem.
e
s 00003/00124/00543
d D 1.29 89/12/27 10:54:06 alan 29 28
c moved tty code to it's own file
e
s 00001/00001/00666
d D 1.28 89/03/11 17:21:56 alan 28 27
c editorial change
e
s 00012/00138/00655
d D 1.27 89/02/26 11:13:29 alan 27 26
c Move FORK functions and data to fork.c
c 
e
s 00037/00005/00756
d D 1.26 89/02/16 19:02:39 alan 26 25
c convert pgtok() and btok() macros to functions that uses data set in the FIRST record
e
s 00027/00023/00734
d D 1.25 89/01/15 20:37:25 alan 25 24
c changes for CPU and PAGEing data
e
s 00012/00002/00745
d D 1.24 88/06/27 18:15:48 alan 24 23
c changed include of monitor.h and record.h
e
s 00039/00012/00708
d D 1.23 87/08/10 21:28:18 alan 23 22
c See commentary on V0.92 in version.c
e
s 00202/00194/00518
d D 1.22 87/05/20 17:13:48 alan 22 21
c changed all curses calls to use w... versions
e
s 00316/00131/00396
d D 1.21 87/04/17 15:47:17 alan 21 20
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00001/00001/00526
d D 1.20 87/04/03 14:31:47 alan 20 19
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00024/00019/00503
d D 1.19 87/03/06 10:41:40 alan 19 18
c see commenary on V0.86
e
s 00027/00009/00495
d D 1.18 87/03/03 15:42:43 alan 18 17
c see the commentary for V0.83 in version.c
e
s 00003/00008/00501
d D 1.17 87/02/05 16:28:58 alan 17 16
c See comment on V0.81 in version.c.
c 
e
s 00040/00010/00469
d D 1.16 87/01/30 16:09:23 alan 16 15
c See commenary on V0.76 in version.c
e
s 00031/00020/00448
d D 1.15 87/01/30 10:16:43 alan 15 14
c fixes to delta_disk()
e
s 00016/00006/00452
d D 1.14 87/01/29 13:09:40 alan 14 13
c changes to delta_fork(), V0.71
c 
e
s 00039/00010/00419
d D 1.13 87/01/28 21:06:06 alan 13 12
c V0.70
e
s 00045/00044/00384
d D 1.12 87/01/22 10:59:50 alan 12 11
c added free memory to paging magnification - V0.69
e
s 00004/00000/00424
d D 1.11 87/01/21 16:36:47 alan 11 10
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00051/00026/00373
d D 1.10 86/12/30 11:21:05 alan 10 9
c See commentary on V0.64 in version.c
e
s 00029/00046/00370
d D 1.9 86/12/07 22:23:12 alan 9 8
c See V0.57 in version.c
e
s 00003/00002/00413
d D 1.8 86/11/19 09:40:13 alan 8 7
c See commentary on V0.56 in version.c
c 
e
s 00001/00001/00414
d D 1.7 86/08/26 18:04:43 alan 7 6
c modify all SccsId strings
e
s 00076/00010/00339
d D 1.6 86/08/01 14:18:06 alan 6 5
c 1.  Remove some lint caused by the addition of extra arguments on 
c     error function.  It has been reduced to a  mininium but is still
c     there.
c 2.  Make totals for disk and tapes static instead of dynamic.
c 3.  Merged stack.c code into uba.c and mba.c.  There were some pointers
c     that needed to be changed.
c 
c TODO: There is still a bug in multiple session replay that causes the
c first disk I/O data to be negitive numbers.  Wierd...
c 
e
s 00005/00005/00344
d D 1.5 86/07/30 16:07:25 alan 5 4
c force the width of the process field
e
s 00013/00000/00336
d D 1.4 86/07/11 19:32:37 alan 4 3
c Dust off LOTS of lint...
c 
e
s 00172/00057/00164
d D 1.3 86/07/01 13:03:19 alan 3 2
c Added code for fork()'s, processes, (probably paging).
c Moved delta_fork, delta_tty and init_statics from delta.c.
c 
e
s 00119/00000/00102
d D 1.2 86/06/30 17:20:06 alan 2 1
c Filled out code for doing pageing info.  Added entry points for doing
c process and fork stats.
c 
e
s 00102/00000/00000
d D 1.1 86/06/30 12:34:39 alan 1 0
c date and time created 86/06/30 12:34:39 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Functions to magnify general O/S info (paging, memory,
D 3
 *	processes, etc).
E 3
I 3
 *	processes, etc).  Also contains the code for calculating
D 27
 *	changes in fork()'s and tty's.
E 27
I 27
 *	changes in tty's.
E 27
E 3
 */
#ifndef	lint
D 7
static	char	SccsId[] = "%W% %G%" ;
E 7
I 7
D 9
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 9
I 9
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 9
E 7
#endif

I 24
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 25
 * 
 * Jan. 6, 1989 -- arr
 *
D 26
 *	
E 26
I 26
 *	?
 *
 * Feb. 15, 1989 -- arr
 *
 *	Turned pgtok() macro into a function.  I had to do this because
 *	the page size on the VAX and MIPS are different.  In order to
 *	have data be portable between architectures, I have to store
 *	the page size in the first record.
I 27
 *
 * Feb. 26, 1989 -- arr
 *
 *	Move the FORK functions and data to their own file.
I 30
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 30
E 27
E 26
E 25
 */

E 24
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
#include <curses.h>

#include <sys/types.h>
I 11
D 13
#include <sys/devio.h>
E 13
I 13
D 15
#ifdef	V20
#	include <sys/devio.h>
#endif
E 15
E 13
E 11
#include <sys/dk.h>
I 11
#include <sys/param.h>
#include <sys/dir.h>
I 30

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 30
#include <sys/user.h>
E 11
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

D 26
#include <machine/param.h>

I 15
D 17
#ifdef	V20
#	include <sys/devio.h>
#endif

E 17
E 15
D 23
#define	pgtok(x)	((x) * NBPG / 1024)
E 23
I 23
#include "pgtok.h"
E 23

E 26
I 3
D 24
#include "monitor.h"
E 24
I 24
#include "include.h"
E 24
E 3
D 20
#include "extern.h"
E 20
#include "options.h"
D 24
#include "record.h"
E 24
I 24
#include "monitor.h"
E 24
I 20
#include "extern.h"
E 20

I 10
D 21
#define	TTY_X	(26)

E 21
E 10
I 4
D 9
char	*ctime() ;

E 9
I 9
/*
I 13
D 29
 *	Functions that don't return an (int).
 */
D 14
double	delta_tty() ;
E 14
I 14
D 27
double	delta_tty(),
	delta_fork() ;
E 27
I 27
double	delta_tty() ;
E 27
E 14

/*
E 29
I 16
 *	Each magnify function has to remember when it was last run
 *	so that it can maintain the correct elapsed time.
 *
 *	These will need to be external and have to be reset for
 *	session being replayed.
 */
D 29
int	tty_ticks = 0,		/* clock ticks at previous sample */
D 27
	fork_ticks = 0,
E 27
	proc_ticks = 0,
E 29
I 29
int	proc_ticks = 0,		/* clock ticks at previous sample */
E 29
	memory_ticks = 0,
	sample_ticks = 0,
	paging_ticks = 0 ;

I 22
/*
 *	Default display.
 */
I 23
extern	int	lines ;		/* length of the screen being used. */
E 23
extern	WINDOW	*wp ;

/*
 *	Other globals, defined in screen.c unless otherwise noted.
 */
E 22
I 18
extern	pid_ticks[],		/* clock ticks at previous sample: in pid.c */
	soft_faults[],
	hard_faults[],
	in_block[],
	out_block[],
	send_message[],
	rcv_message[] ;

E 18
/*
I 21
D 29
 *	Constants for placement of TTY data.
 */
#define	TTY_TITLE	(3)
#define	TTY_DATA	(3)
#define	TTY_RUNNING	(6)
#define	TTY_DELTA	(9)
#define	TTY_AVERAGE	(12)
#define	TTY_X		(26)

I 23
#define	TTY_LINES	(15)

E 23
/*
E 21
E 16
E 13
I 10
 *	Print and format the heading for the tty info.
 *
 *	ARGSUSED
 */
open_tty(op)
OPTION	*op ;
{
	sample_header() ;

I 23
	lines = TTY_LINES ;

E 23
D 21
	move(3, 0) ;
E 21
I 21
D 22
	wmove(stdscr, TTY_TITLE, 0) ;
E 22
I 22
	wmove(wp, TTY_TITLE, 0) ;
E 22
E 21

D 21
	printw("Total TTY input:          %10d\n", 0) ;
	printw("Total TTY output:         %10d\n\n", 0) ;
E 21
I 21
D 22
	wprintw(stdscr, "Total TTY input:          %10d\n", 0) ;
	wprintw(stdscr, "Total TTY output:         %10d\n\n", 0) ;
E 22
I 22
	wprintw(wp, "Total TTY input:          %10d\n", 0) ;
	wprintw(wp, "Total TTY output:         %10d\n\n", 0) ;
E 22
E 21

I 13
D 21
	printw("Running average: input:   %10.2f cps\n", 0) ;
	printw("Running average: output:  %10.2f cps\n\n", 0) ;
E 21
I 21
D 22
	wprintw(stdscr, "Running average: input:   %10.2f cps\n", 0) ;
	wprintw(stdscr, "Running average: output:  %10.2f cps\n\n", 0) ;
E 22
I 22
	wprintw(wp, "Running average: input:   %10.2f cps\n", 0) ;
	wprintw(wp, "Running average: output:  %10.2f cps\n\n", 0) ;
E 22
E 21

E 13
D 21
	printw("Input since last sample:  %10d\n", 0) ;
	printw("Output since last sample: %10d\n\n", 0) ;
E 21
I 21
D 22
	wprintw(stdscr, "Input since last sample:  %10d\n", 0) ;
	wprintw(stdscr, "Output since last sample: %10d\n\n", 0) ;
E 22
I 22
	wprintw(wp, "Input since last sample:  %10d\n", 0) ;
	wprintw(wp, "Output since last sample: %10d\n\n", 0) ;
E 22
E 21

D 13
	printw("Average TTY input:        %10.2f cps\n", 0) ;
	printw("Average TTY output:       %10.2f cps\n", 0) ;
E 13
I 13
D 21
	printw("Sample average: input:    %10.2f cps\n", 0) ;
	printw("Sample average: output:   %10.2f cps\n", 0) ;
E 21
I 21
D 22
	wprintw(stdscr, "Sample average: input:    %10.2f cps\n", 0) ;
	wprintw(stdscr, "Sample average: output:   %10.2f cps\n", 0) ;
E 22
I 22
	wprintw(wp, "Sample average: input:    %10.2f cps\n", 0) ;
	wprintw(wp, "Sample average: output:   %10.2f cps\n", 0) ;
E 22
E 21
E 13
}

/*
 *	Print the tty info.
 *
 *	ARGSUSED
 */
magnify_tty(op)
OPTION	*op ;
{
I 13
	double	etime, btime ;

E 13
D 16
	sample_body(14) ;

E 16
D 21
	mvprintw(3, TTY_X, "%10d", tty.mon_ttyin) ;
	mvprintw(4, TTY_X, "%10d", tty.mon_ttyout) ;
E 21
I 21
D 22
	wmove(stdscr, TTY_DATA, TTY_X) ;
	wprintw(stdscr, "%10d", tty.mon_ttyin) ;
E 22
I 22
	wmove(wp, TTY_DATA, TTY_X) ;
	wprintw(wp, "%10d", tty.mon_ttyin) ;
E 22
E 21

I 21
D 22
	wmove(stdscr, TTY_DATA + 1, TTY_X) ;
	wprintw(stdscr, "%10d", tty.mon_ttyout) ;
E 22
I 22
	wmove(wp, TTY_DATA + 1, TTY_X) ;
	wprintw(wp, "%10d", tty.mon_ttyout) ;
E 22

E 21
D 13
	delta_tty() ;
E 13
I 13
	btime = (double)sample.mon_ticks / first.mon_hz ;
E 13

D 13
	mvprintw(6, TTY_X, "%10d", tty.mon_ttyin) ;
	mvprintw(7, TTY_X, "%10d", tty.mon_ttyout) ;
E 13
I 13
D 21
	mvprintw(6, TTY_X, "%10.2f", tty.mon_ttyin / btime) ;
	mvprintw(7, TTY_X, "%10.2f", tty.mon_ttyout / btime) ;
E 21
I 21
D 22
	wmove(stdscr, TTY_RUNNING, TTY_X) ;
	wprintw(stdscr, "%10.2f", tty.mon_ttyin / btime) ;
E 22
I 22
	wmove(wp, TTY_RUNNING, TTY_X) ;
	wprintw(wp, "%10.2f", tty.mon_ttyin / btime) ;
E 22
E 21
E 13

I 21
D 22
	wmove(stdscr, TTY_RUNNING + 1, TTY_X) ;
	wprintw(stdscr, "%10.2f", tty.mon_ttyout / btime) ;
E 22
I 22
	wmove(wp, TTY_RUNNING + 1, TTY_X) ;
	wprintw(wp, "%10.2f", tty.mon_ttyout / btime) ;
E 22

E 21
D 13
	mvprintw(9, TTY_X, "%10.2f", tty.mon_ttyin / sample.mon_etime) ;
	mvprintw(10, TTY_X, "%10.2f", tty.mon_ttyout / sample.mon_etime) ;
E 13
I 13
	etime = delta_tty(sample.mon_ticks) ;

D 21
	mvprintw(9, TTY_X, "%10d", tty.mon_ttyin) ;
	mvprintw(10, TTY_X, "%10d", tty.mon_ttyout) ;
E 21
I 21
D 22
	wmove(stdscr, TTY_DELTA, TTY_X) ;
	wprintw(stdscr, "%10d", tty.mon_ttyin) ;
E 22
I 22
	wmove(wp, TTY_DELTA, TTY_X) ;
	wprintw(wp, "%10d", tty.mon_ttyin) ;
E 22
E 21

D 21
	mvprintw(12, TTY_X, "%10.2f", tty.mon_ttyin / etime) ;
	mvprintw(13, TTY_X, "%10.2f", tty.mon_ttyout / etime) ;
E 21
I 21
D 22
	wmove(stdscr, TTY_DELTA + 1, TTY_X) ;
	wprintw(stdscr, "%10d", tty.mon_ttyout) ;
E 22
I 22
	wmove(wp, TTY_DELTA + 1, TTY_X) ;
	wprintw(wp, "%10d", tty.mon_ttyout) ;
E 22
E 21
I 16

I 21
D 22
	wmove(stdscr, TTY_AVERAGE, TTY_X) ;
	wprintw(stdscr, "%10.2f", tty.mon_ttyin / etime) ;
E 22
I 22
	wmove(wp, TTY_AVERAGE, TTY_X) ;
	wprintw(wp, "%10.2f", tty.mon_ttyin / etime) ;
E 22

D 22
	wmove(stdscr, TTY_AVERAGE + 1, TTY_X) ;
	wprintw(stdscr, "%10.2f", tty.mon_ttyout / etime) ;
E 22
I 22
	wmove(wp, TTY_AVERAGE + 1, TTY_X) ;
	wprintw(wp, "%10.2f", tty.mon_ttyout / etime) ;
E 22

E 21
	sample_body(etime) ;
E 16
E 13
}

I 21
/*
E 29
 *	Constants for the placement of the memory data.
 */
E 21
I 19
#define	MEMORY_PHYS	(3)
#define	MEMORY_X	(23)

I 23
#define	MEMORY_LINES	(16)
#define	FREE_LINES	(6)

E 23
E 19
/*
E 10
D 21
 *	The magnify function for memory.
E 21
I 21
 *	Print the headers and static information for the memory
 *	and freemem records.  If we are printing the freemem
 *	record then we'll return after printing the "Free Memory".
I 23
 *
 *	Lines will initial set for displaying free memory, but
 *	reset if all memory is being displayed.
E 23
E 21
 */
E 9
E 4
D 21
magnify_memory(op)
E 21
I 21
open_memory(op)
E 21
OPTION	*op ;
{
D 18
	register free = op->opt_free ? freemem.mon_freemem : memory.mon_free ;
E 18
I 18
D 21
	register free = op->opt_free ? mon_free.mon_freemem : memory.mon_free ;
E 21
I 21
	sample_header() ;
E 21
E 18

D 3
	mvprintw(1, 23, "%.2f", sample.mon_etime);
	mvprintw(2, 23, "%24.24s", ctime(&sample.mon_timestamp));
E 3
I 3
D 9
	mvprintw(0, 23, "%.2f", sample.mon_etime);
	mvprintw(1, 23, "%24.24s", ctime(&sample.mon_timestamp));
E 9
I 9
D 10
	sample_body(23) ;
E 10
I 10
D 16
	sample_body(14) ;
E 16
I 16
D 21
	sample_body((double)(sample.mon_ticks - memory_ticks)/first.mon_hz) ;
	memory_ticks = sample.mon_ticks ;
E 21
I 21
D 22
	wmove(stdscr, MEMORY_PHYS, 0) ;
E 22
I 22
	wmove(wp, MEMORY_PHYS, 0) ;
E 22
E 21
E 16
E 10
E 9
E 3

I 23
	lines = FREE_LINES ;

E 23
D 19
	mvprintw(4, 23, "%5d", pgtok(free));
E 19
I 19
D 21
	mvprintw(MEMORY_PHYS+1, MEMORY_X, "%10d", pgtok(free));
E 21
I 21
D 22
	wprintw(stdscr, "Physical memory:       %10d Kb.\n", pgtok(first.mon_physmem));
	wprintw(stdscr, "Free Memory:           %10d Kb.\n\n", 0);
E 22
I 22
	wprintw(wp, "Physical memory:       %10d Kb.\n", pgtok(first.mon_physmem));
	wprintw(wp, "Free Memory:           %10d Kb.\n\n", 0);
E 22
E 21
E 19

	if( op->opt_free )
		return ;

I 23
	lines = MEMORY_LINES ;

E 23
D 19
	mvprintw(6, 23, "%5d", pgtok(memory.mon_vm));
	mvprintw(7, 23, "%5d", pgtok(memory.mon_avm));
	mvprintw(8, 23, "%5d", pgtok(memory.mon_rm));
	mvprintw(9, 23, "%5d", pgtok(memory.mon_arm));
E 19
I 19
D 21
	mvprintw(MEMORY_PHYS+3, MEMORY_X, "%10d", pgtok(memory.mon_vm));
	mvprintw(MEMORY_PHYS+4, MEMORY_X, "%10d", pgtok(memory.mon_avm));
	mvprintw(MEMORY_PHYS+5, MEMORY_X, "%10d", pgtok(memory.mon_rm));
	mvprintw(MEMORY_PHYS+6, MEMORY_X, "%10d", pgtok(memory.mon_arm));
E 21
I 21
D 22
	wprintw(stdscr, "Total virtual memory:  %10d Kb.\n", 0);
	wprintw(stdscr, "Active virtual memory: %10d Kb.\n", 0);
	wprintw(stdscr, "Total real memory:     %10d Kb.\n", 0);
	wprintw(stdscr, "Active real memory:    %10d Kb.\n\n", 0);
E 22
I 22
	wprintw(wp, "Total virtual memory:  %10d Kb.\n", 0);
	wprintw(wp, "Active virtual memory: %10d Kb.\n", 0);
	wprintw(wp, "Total real memory:     %10d Kb.\n", 0);
	wprintw(wp, "Active real memory:    %10d Kb.\n\n", 0);
E 22
E 21
E 19

D 19
	mvprintw(11, 23, "%5d", pgtok(memory.mon_vmtxt));
	mvprintw(12, 23, "%5d", pgtok(memory.mon_avmtxt));
	mvprintw(13, 23, "%5d", pgtok(memory.mon_rmtxt));
	mvprintw(14, 23, "%5d", pgtok(memory.mon_armtxt));
E 19
I 19
D 21
	mvprintw(MEMORY_PHYS+8, MEMORY_X, "%10d", pgtok(memory.mon_vmtxt));
	mvprintw(MEMORY_PHYS+9, MEMORY_X, "%10d", pgtok(memory.mon_avmtxt));
	mvprintw(MEMORY_PHYS+10, MEMORY_X, "%10d", pgtok(memory.mon_rmtxt));
	mvprintw(MEMORY_PHYS+11, MEMORY_X, "%10d", pgtok(memory.mon_armtxt));
E 21
I 21
D 22
	wprintw(stdscr, "Total virtual text:    %10d Kb.\n", 0);
	wprintw(stdscr, "Active virtual text:   %10d Kb.\n", 0);
	wprintw(stdscr, "Total real text:       %10d Kb.\n", 0);
	wprintw(stdscr, "Active real text:      %10d Kb.\n", 0);
E 22
I 22
	wprintw(wp, "Total virtual text:    %10d Kb.\n", 0);
	wprintw(wp, "Active virtual text:   %10d Kb.\n", 0);
	wprintw(wp, "Total real text:       %10d Kb.\n", 0);
	wprintw(wp, "Active real text:      %10d Kb.\n", 0);
E 22
E 21
E 19
}

/*
D 21
 *	Print the headers and static information for the memory
 *	and freemem records.  If we are printing the freemem
 *	record then we'll return after printing the "Free Memory".
E 21
I 21
 *	The magnify function for memory.
E 21
 */
D 21
open_memory(op)
E 21
I 21
magnify_memory(op)
E 21
OPTION	*op ;
{
D 9
	clear() ;
E 9
I 9
D 21
	sample_header() ;
E 21
I 21
	register free = op->opt_free ? mon_free.mon_freemem : memory.mon_free ;
E 21
E 9

D 9
	move(0, 0);

D 3
	printw("Physical memory:       %d Kb.\n", pgtok(first.mon_physmem));
E 3
	printw("Elapsed Time:\n");
	printw("Timestamp:\n\n");

E 9
I 3
D 19
	printw("Physical memory:       %5d Kb.\n", pgtok(first.mon_physmem));
E 3
	printw("Free Memory:           %5d Kb.\n\n", 0);
E 19
I 19
D 21
	move(MEMORY_PHYS, 0) ;
E 21
I 21
	sample_body((double)(sample.mon_ticks - memory_ticks)/first.mon_hz) ;
	memory_ticks = sample.mon_ticks ;
E 21
E 19

I 19
D 21
	printw("Physical memory:       %10d Kb.\n", pgtok(first.mon_physmem));
	printw("Free Memory:           %10d Kb.\n\n", 0);
E 21
I 21
D 22
	wmove(stdscr, MEMORY_PHYS + 1, MEMORY_X) ;
	wprintw(stdscr, "%10d", pgtok(free));
E 22
I 22
	wmove(wp, MEMORY_PHYS + 1, MEMORY_X) ;
	wprintw(wp, "%10d", pgtok(free));
E 22
E 21

E 19
	if( op->opt_free )
		return ;

D 19
	printw("Total virtual memory:  %5d Kb.\n", 0);
	printw("Active virtual memory: %5d Kb.\n", 0);
	printw("Total real memory:     %5d Kb.\n", 0);
	printw("Active real memory:    %5d Kb.\n\n", 0);
E 19
I 19
D 21
	printw("Total virtual memory:  %10d Kb.\n", 0);
	printw("Active virtual memory: %10d Kb.\n", 0);
	printw("Total real memory:     %10d Kb.\n", 0);
	printw("Active real memory:    %10d Kb.\n\n", 0);
E 21
I 21
D 22
	wmove(stdscr, MEMORY_PHYS + 3, MEMORY_X) ;
	wprintw(stdscr, "%10d", pgtok(memory.mon_vm));
	wmove(stdscr, MEMORY_PHYS + 4, MEMORY_X) ;
	wprintw(stdscr, "%10d", pgtok(memory.mon_avm));
	wmove(stdscr, MEMORY_PHYS + 5, MEMORY_X) ;
	wprintw(stdscr, "%10d", pgtok(memory.mon_rm));
	wmove(stdscr, MEMORY_PHYS + 6, MEMORY_X) ;
	wprintw(stdscr, "%10d", pgtok(memory.mon_arm));
E 22
I 22
	wmove(wp, MEMORY_PHYS + 3, MEMORY_X) ;
	wprintw(wp, "%10d", pgtok(memory.mon_vm));
	wmove(wp, MEMORY_PHYS + 4, MEMORY_X) ;
	wprintw(wp, "%10d", pgtok(memory.mon_avm));
	wmove(wp, MEMORY_PHYS + 5, MEMORY_X) ;
	wprintw(wp, "%10d", pgtok(memory.mon_rm));
	wmove(wp, MEMORY_PHYS + 6, MEMORY_X) ;
	wprintw(wp, "%10d", pgtok(memory.mon_arm));
E 22
E 21
E 19

D 19
	printw("Total virtual text:    %5d Kb.\n", 0);
	printw("Active virtual text:   %5d Kb.\n", 0);
	printw("Total real text:       %5d Kb.\n", 0);
	printw("Active real text:      %5d Kb.\n", 0);
E 19
I 19
D 21
	printw("Total virtual text:    %10d Kb.\n", 0);
	printw("Active virtual text:   %10d Kb.\n", 0);
	printw("Total real text:       %10d Kb.\n", 0);
	printw("Active real text:      %10d Kb.\n", 0);
E 21
I 21
D 22
	wmove(stdscr, MEMORY_PHYS + 8, MEMORY_X) ;
	wprintw(stdscr, "%10d", pgtok(memory.mon_vmtxt));
	wmove(stdscr, MEMORY_PHYS + 9, MEMORY_X) ;
	wprintw(stdscr, "%10d", pgtok(memory.mon_avmtxt));
	wmove(stdscr, MEMORY_PHYS + 10, MEMORY_X) ;
	wprintw(stdscr, "%10d", pgtok(memory.mon_rmtxt));
	wmove(stdscr, MEMORY_PHYS + 11, MEMORY_X) ;
	wprintw(stdscr, "%10d", pgtok(memory.mon_armtxt));
E 22
I 22
	wmove(wp, MEMORY_PHYS + 8, MEMORY_X) ;
	wprintw(wp, "%10d", pgtok(memory.mon_vmtxt));
	wmove(wp, MEMORY_PHYS + 9, MEMORY_X) ;
	wprintw(wp, "%10d", pgtok(memory.mon_avmtxt));
	wmove(wp, MEMORY_PHYS + 10, MEMORY_X) ;
	wprintw(wp, "%10d", pgtok(memory.mon_rmtxt));
	wmove(wp, MEMORY_PHYS + 11, MEMORY_X) ;
	wprintw(wp, "%10d", pgtok(memory.mon_armtxt));
E 22
E 21
E 19
}

I 3
D 21
#define	HALF	(COLS / 2)
E 21
I 21
/*
 *	The page data is divided up into 5 areas.  These are the
 *	Y origins and X offsets for that data.
 */
#define	PAGE_AREA_1	(3)
#define	PAGE_AREA_3	(11)
#define	PAGE_AREA_4	(18)
#define	PAGE_OFF_1	(25)
#define	PAGE_OFF_2	(58)
#define	PAGE_OFF_3	(37)
#define	PAGE_OFF_4	(25)
#define	PAGE_OFF_5	(64)
E 21

I 4
D 9
/* ARGSUSED */

E 9
I 9
/*
 *	ARGSUSED
 */
E 9
E 4
E 3
magnify_paging(op)
OPTION	*op ;
{
I 2
D 3
	register half = COLS / 2, y = 0 ;

E 3
D 9
	move(0, 0) ;
E 9
I 9
D 10
	sample_body(23) ;
E 10
I 10
D 16
	sample_body(14) ;
E 16
I 16
	sample_body((double)(sample.mon_ticks - paging_ticks)/first.mon_hz) ;
	paging_ticks = sample.mon_ticks ;
E 16
E 10
E 9

D 9
	mvprintw(0, 23, "%.2f\n", sample.mon_etime);
	mvprintw(1, 23, "%24.24s", ctime(&sample.mon_timestamp));

E 9
D 3
	y = 3 ;
E 3
I 3
D 12
	mvprintw(3, 23, "%10d", Page.v_pswpin);
	mvprintw(4, 23, "%10d", Page.v_pswpout);
	mvprintw(5, 23, "%10d", Page.v_pgin);
	mvprintw(6, 23, "%10d", Page.v_pgout);
	mvprintw(7, 23, "%10d", Page.v_swpin);
	mvprintw(8, 23, "%10d", Page.v_swpout);
E 12
I 12
D 21
	mvprintw(3, 25, "%10d", Page.v_faults);
	mvprintw(4, 25, "%10d", Page.v_dfree);
	mvprintw(5, 25, "%10d", Page.v_intrans);
	mvprintw(6, 25, "%10d", Page.v_pgrec);
	mvprintw(7, 25, "%10d", Page.v_fastpgrec);
D 18
	mvprintw(8, 25, "%10d", page.mon_deficit);
E 18
I 18
	mvprintw(8, 25, "%10d", mon_page.mon_deficit);
E 21
I 21
	/*
	 *	Area 1 - Page faults, pages free by daemon, reclaims,
	 *	deficit and free memory.
	 */
D 22
	wmove(stdscr, PAGE_AREA_1, PAGE_OFF_1) ;
	wprintw(stdscr, "%10d", Page.v_faults);
E 22
I 22
	wmove(wp, PAGE_AREA_1, PAGE_OFF_1) ;
D 25
	wprintw(wp, "%10d", Page.v_faults);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_faults);
E 25
E 22
E 21
E 18
E 12
E 3

D 3
	mvprintw(y++, 23, "%10d", page.mon_meter.v_pswpin);
	mvprintw(y++, 23, "%10d", page.mon_meter.v_pswpout);
	mvprintw(y++, 23, "%10d", page.mon_meter.v_pgin);
	mvprintw(y++, 23, "%10d", page.mon_meter.v_pgout);
	mvprintw(y++, 23, "%10d", page.mon_meter.v_swpin);
	mvprintw(y++, 23, "%10d", page.mon_meter.v_swpout);
E 3
I 3
D 12
	mvprintw(3, HALF+25, "%10d", Page.v_faults);
	mvprintw(4, HALF+25, "%10d", Page.v_dfree);
	mvprintw(5, HALF+25, "%10d", Page.v_intrans);
	mvprintw(6, HALF+25, "%10d", Page.v_pgrec);
	mvprintw(7, HALF+25, "%10d", Page.v_fastpgrec);
	mvprintw(8, HALF+25, "%10d", page.mon_deficit);
E 12
I 12
D 21
	mvprintw(3, HALF+23, "%10d", Page.v_pswpin);
	mvprintw(4, HALF+23, "%10d", Page.v_pswpout);
	mvprintw(5, HALF+23, "%10d", Page.v_pgin);
	mvprintw(6, HALF+23, "%10d", Page.v_pgout);
	mvprintw(7, HALF+23, "%10d", Page.v_swpin);
	mvprintw(8, HALF+23, "%10d", Page.v_swpout);
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 1, PAGE_OFF_1) ;
	wprintw(stdscr, "%10d", Page.v_dfree);
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 1, PAGE_OFF_1) ;
D 25
	wprintw(wp, "%10d", Page.v_dfree);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_dfree);
E 25
E 22
E 21
E 12
E 3

D 3
	y = 3 ;
E 3
I 3
D 12
	mvprintw(10, 37, "%10d", Page.v_pgfrec);
	mvprintw(11, 37, "%10d", Page.v_scan);
	mvprintw(12, 37, "%10d", Page.v_rev);
	mvprintw(13, 37, "%10d", Page.v_seqfree);
	mvprintw(14, 37, "%10d", Page.v_xsfrec);
	mvprintw(15, 37, "%10d", Page.v_xifrec);
E 12
I 12
D 18
	mvprintw(9, 25, "%10d", pgtok(page.mon_freemem)) ;
E 18
I 18
D 21
	mvprintw(9, 25, "%10d", pgtok(mon_page.mon_freemem)) ;
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 2, PAGE_OFF_1) ;
	wprintw(stdscr, "%10d", Page.v_intrans);
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 2, PAGE_OFF_1) ;
D 25
	wprintw(wp, "%10d", Page.v_intrans);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_intrans);
E 25
E 22
E 21
E 18
E 12
E 3

D 3
	mvprintw(y++, half+25, "%10d", page.mon_meter.v_faults);
	mvprintw(y++, half+25, "%10d", page.mon_meter.v_dfree);
	mvprintw(y++, half+25, "%10d", page.mon_meter.v_intrans);
	mvprintw(y++, half+25, "%10d", page.mon_meter.v_pgrec);
	mvprintw(y++, half+25, "%10d", page.mon_meter.v_fastpgrec);
	mvprintw(y++, half+25, "%10d", page.mon_deficit);
E 3
I 3
D 12
	mvprintw(17, 25, "%10d", Page.v_vrfod);
	mvprintw(18, 25, "%10d", Page.v_nvrfod);
E 12
I 12
D 21
	mvprintw(11, 37, "%10d", Page.v_pgfrec);
	mvprintw(12, 37, "%10d", Page.v_scan);
	mvprintw(13, 37, "%10d", Page.v_rev);
	mvprintw(14, 37, "%10d", Page.v_seqfree);
	mvprintw(15, 37, "%10d", Page.v_xsfrec);
	mvprintw(16, 37, "%10d", Page.v_xifrec);
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 3, PAGE_OFF_1) ;
	wprintw(stdscr, "%10d", Page.v_pgrec);
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 3, PAGE_OFF_1) ;
D 25
	wprintw(wp, "%10d", Page.v_pgrec);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_pgrec);
E 25
E 22
E 21
E 12
E 3

D 3
	y = 10 ;
E 3
I 3
D 12
	mvprintw(17, HALF+25, "%10d", Page.v_zfod);
	mvprintw(18, HALF+25, "%10d", Page.v_nzfod);
E 12
I 12
D 21
	mvprintw(18, 25, "%10d", Page.v_zfod);
	mvprintw(19, 25, "%10d", Page.v_vrfod);
	mvprintw(20, 25, "%10d", Page.v_exfod);
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 4, PAGE_OFF_1) ;
	wprintw(stdscr, "%10d", Page.v_fastpgrec);
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 4, PAGE_OFF_1) ;
D 25
	wprintw(wp, "%10d", Page.v_fastpgrec);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_fastpgrec);
E 25
E 22
E 21
E 12
E 3

D 3
	mvprintw(y++, 37, "%10d", page.mon_meter.v_pgfrec);
	mvprintw(y++, 37, "%10d", page.mon_meter.v_scan);
	mvprintw(y++, 37, "%10d", page.mon_meter.v_rev);
	mvprintw(y++, 37, "%10d", page.mon_meter.v_seqfree);
	mvprintw(y++, 37, "%10d", page.mon_meter.v_xsfrec);
	mvprintw(y++, 37, "%10d", page.mon_meter.v_xifrec);

	mvprintw(17, 25, "%10d", page.mon_meter.v_vrfod);
	mvprintw(18, 25, "%10d", page.mon_meter.v_nvrfod);

	mvprintw(17, half+25, "%10d", page.mon_meter.v_zfod);
	mvprintw(18, half+25, "%10d", page.mon_meter.v_nzfod);

	y = 20 ;

	mvprintw(y++, 31, "%10d", page.mon_meter.v_exfod);
	mvprintw(y++, 31, "%10d", page.mon_meter.v_nexfod);
E 3
I 3
D 12
	mvprintw(20, 31, "%10d", Page.v_exfod);
	mvprintw(21, 31, "%10d", Page.v_nexfod);
E 12
I 12
D 21
	mvprintw(18, HALF+25, "%10d", Page.v_nzfod);
	mvprintw(19, HALF+25, "%10d", Page.v_nvrfod);
	mvprintw(20, HALF+25, "%10d", Page.v_nexfod);
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 5, PAGE_OFF_1) ;
	wprintw(stdscr, "%10d", mon_page.mon_deficit);
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 5, PAGE_OFF_1) ;
	wprintw(wp, "%10d", mon_page.mon_deficit);
E 22

D 22
	wmove(stdscr, PAGE_AREA_1 + 6, PAGE_OFF_1) ;
	wprintw(stdscr, "%10d", pgtok(mon_page.mon_freemem)) ;
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 6, PAGE_OFF_1) ;
	wprintw(wp, "%10d", pgtok(mon_page.mon_freemem)) ;
E 22

	/*
	 *	Area 2 - Pages swapped in/out, pageins/pageouts and
	 *	swaps.
	 */
D 22
	wmove(stdscr, PAGE_AREA_1, PAGE_OFF_2) ;
	wprintw(stdscr, "%10d", Page.v_pswpin);
E 22
I 22
	wmove(wp, PAGE_AREA_1, PAGE_OFF_2) ;
D 25
	wprintw(wp, "%10d", Page.v_pswpin);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_pswpin);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_1 + 1, PAGE_OFF_2) ;
	wprintw(stdscr, "%10d", Page.v_pswpout);
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 1, PAGE_OFF_2) ;
D 25
	wprintw(wp, "%10d", Page.v_pswpout);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_pswpout);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_1 + 2, PAGE_OFF_2) ;
	wprintw(stdscr, "%10d", Page.v_pgin);
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 2, PAGE_OFF_2) ;
D 25
	wprintw(wp, "%10d", Page.v_pgin);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_pgin);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_1 + 3, PAGE_OFF_2) ;
	wprintw(stdscr, "%10d", Page.v_pgout);
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 3, PAGE_OFF_2) ;
D 25
	wprintw(wp, "%10d", Page.v_pgout);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_pgout);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_1 + 4, PAGE_OFF_2) ;
	wprintw(stdscr, "%10d", Page.v_swpin);
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 4, PAGE_OFF_2) ;
D 25
	wprintw(wp, "%10d", Page.v_swpin);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_swpin);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_1 + 5, PAGE_OFF_2) ;
	wprintw(stdscr, "%10d", Page.v_swpout);
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 5, PAGE_OFF_2) ;
D 25
	wprintw(wp, "%10d", Page.v_swpout);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_swpout);
E 25
E 22

	/*
	 *	Area 3 - Misc. paging stats.
	 */
D 22
	wmove(stdscr, PAGE_AREA_3, PAGE_OFF_3) ;
	wprintw(stdscr, "%10d", Page.v_pgfrec);
E 22
I 22
	wmove(wp, PAGE_AREA_3, PAGE_OFF_3) ;
D 25
	wprintw(wp, "%10d", Page.v_pgfrec);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_pgfrec);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_3 + 1, PAGE_OFF_3) ;
	wprintw(stdscr, "%10d", Page.v_scan);
E 22
I 22
	wmove(wp, PAGE_AREA_3 + 1, PAGE_OFF_3) ;
D 25
	wprintw(wp, "%10d", Page.v_scan);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_scan);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_3 + 2, PAGE_OFF_3) ;
	wprintw(stdscr, "%10d", Page.v_rev);
E 22
I 22
	wmove(wp, PAGE_AREA_3 + 2, PAGE_OFF_3) ;
D 25
	wprintw(wp, "%10d", Page.v_rev);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_rev);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_3 + 3, PAGE_OFF_3) ;
	wprintw(stdscr, "%10d", Page.v_seqfree);
E 22
I 22
	wmove(wp, PAGE_AREA_3 + 3, PAGE_OFF_3) ;
D 25
	wprintw(wp, "%10d", Page.v_seqfree);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_seqfree);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_3 + 4, PAGE_OFF_3) ;
	wprintw(stdscr, "%10d", Page.v_xsfrec);
E 22
I 22
	wmove(wp, PAGE_AREA_3 + 4, PAGE_OFF_3) ;
D 25
	wprintw(wp, "%10d", Page.v_xsfrec);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_xsfrec);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_3 + 5, PAGE_OFF_3) ;
	wprintw(stdscr, "%10d", Page.v_xifrec);
E 22
I 22
	wmove(wp, PAGE_AREA_3 + 5, PAGE_OFF_3) ;
D 25
	wprintw(wp, "%10d", Page.v_xifrec);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_xifrec);
E 25
E 22

	/*
	 *	Area 4 - 
	 */
D 22
	wmove(stdscr, PAGE_AREA_4, PAGE_OFF_4) ;
	wprintw(stdscr, "%10d", Page.v_zfod);
E 22
I 22
	wmove(wp, PAGE_AREA_4, PAGE_OFF_4) ;
D 25
	wprintw(wp, "%10d", Page.v_zfod);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_zfod);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_4 + 1, PAGE_OFF_4) ;
	wprintw(stdscr, "%10d", Page.v_vrfod);
E 22
I 22
	wmove(wp, PAGE_AREA_4 + 1, PAGE_OFF_4) ;
D 25
	wprintw(wp, "%10d", Page.v_vrfod);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_vrfod);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_4 + 2, PAGE_OFF_4) ;
	wprintw(stdscr, "%10d", Page.v_exfod);
E 22
I 22
	wmove(wp, PAGE_AREA_4 + 2, PAGE_OFF_4) ;
D 25
	wprintw(wp, "%10d", Page.v_exfod);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_exfod);
E 25
E 22

	/*
	 *	Area 5 - 
	 */
D 22
	wmove(stdscr, PAGE_AREA_4, PAGE_OFF_5) ;
	wprintw(stdscr, "%10d", Page.v_nzfod);
E 22
I 22
	wmove(wp, PAGE_AREA_4, PAGE_OFF_5) ;
D 25
	wprintw(wp, "%10d", Page.v_nzfod);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_nzfod);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_4 + 1, PAGE_OFF_5) ;
	wprintw(stdscr, "%10d", Page.v_nvrfod);
E 22
I 22
	wmove(wp, PAGE_AREA_4 + 1, PAGE_OFF_5) ;
D 25
	wprintw(wp, "%10d", Page.v_nvrfod);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_nvrfod);
E 25
E 22

D 22
	wmove(stdscr, PAGE_AREA_4 + 2, PAGE_OFF_5) ;
	wprintw(stdscr, "%10d", Page.v_nexfod);
E 22
I 22
	wmove(wp, PAGE_AREA_4 + 2, PAGE_OFF_5) ;
D 25
	wprintw(wp, "%10d", Page.v_nexfod);
E 25
I 25
	wprintw(wp, "%10d", mon_page.mon_nexfod);
E 25
E 22
E 21
E 12
E 3
E 2
}

I 21
/*
 *	Offsets of the various field titles.
 */
#define	PAGE_TITLE_1	(0)
#define	PAGE_TITLE_2	(40)
#define	PAGE_TITLE_3	(0)
#define	PAGE_TITLE_4	(0)
#define	PAGE_TITLE_5	(40)
E 21
I 10

I 23
#define	PAGE_LINES	(22)

E 23
E 10
I 2
/*
D 3
 *
E 3
I 3
 *	Print and format the heading for the paging info.
I 9
 * 
 *	ARGSUSED
E 9
E 3
 */
I 4
D 9
/* ARGSUSED */
E 9
E 4
E 2
open_paging(op)
I 2
OPTION	*op ;
{
D 3
	register half = COLS / 2, y = 0 ;

E 3
D 9
	clear() ;
E 9
I 9
	sample_header() ;
E 9

I 23
	lines = PAGE_LINES ;

E 23
D 9
	move(0, 0) ;

	printw("Elapsed time:\n");
	printw("Timestamp:");

E 9
D 3
	y = 3 ;
E 3
I 3
D 12
	mvprintw(3, 0, "Pages swapped in:");
	mvprintw(3, HALF, "Total page faults:");
E 12
I 12
D 21
	mvprintw(3, 0, "Total page faults:");
	mvprintw(3, HALF, "Pages swapped in:");
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1, 0) ;
	wprintw(stdscr, "Total page faults:");
	wmove(stdscr, PAGE_AREA_1, PAGE_TITLE_2) ;
	wprintw(stdscr, "Pages swapped in:");
E 22
I 22
	wmove(wp, PAGE_AREA_1, 0) ;
	wprintw(wp, "Total page faults:");
	wmove(wp, PAGE_AREA_1, PAGE_TITLE_2) ;
	wprintw(wp, "Pages swapped in:");
E 22
E 21
E 12
E 3

D 3
	mvprintw(y++, 0, "Pages swapped in:");
	mvprintw(y++, 0, "Pages swapped out:");
	mvprintw(y++, 0, "Pageins:");
	mvprintw(y++, 0, "Pageouts:");
	mvprintw(y++, 0, "Swap in's:");
	mvprintw(y++, 0, "Swap out's:");
E 3
I 3
D 12
	mvprintw(4, 0, "Pages swapped out:");
	mvprintw(4, HALF, "pages freed by daemon:");
E 12
I 12
D 21
	mvprintw(4, 0, "pages freed by daemon:");
	mvprintw(4, HALF, "Pages swapped out:");
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 1, 0) ;
	wprintw(stdscr, "pages freed by daemon:");
	wmove(stdscr, PAGE_AREA_1 + 1, PAGE_TITLE_2) ;
	wprintw(stdscr, "Pages swapped out:");
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 1, 0) ;
D 28
	wprintw(wp, "pages freed by daemon:");
E 28
I 28
	wprintw(wp, "Pages freed by daemon:");
E 28
	wmove(wp, PAGE_AREA_1 + 1, PAGE_TITLE_2) ;
	wprintw(wp, "Pages swapped out:");
E 22
E 21
E 12
E 3

D 3
	y = 3 ;
E 3
I 3
D 12
	mvprintw(5, 0, "Pageins:");
	mvprintw(5, HALF, "Intransit page Faults:");
E 12
I 12
D 21
	mvprintw(5, 0, "Intransit page Faults:");
	mvprintw(5, HALF, "Pageins:");
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 2, 0) ;
	wprintw(stdscr, "Intransit page Faults:");
	wmove(stdscr, PAGE_AREA_1 + 2, PAGE_TITLE_2) ;
	wprintw(stdscr, "Pageins:");
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 2, 0) ;
	wprintw(wp, "Intransit page Faults:");
	wmove(wp, PAGE_AREA_1 + 2, PAGE_TITLE_2) ;
	wprintw(wp, "Pageins:");
E 22
E 21
E 12
E 3

D 3
	mvprintw(y++, half, "Total page faults:");
	mvprintw(y++, half, "pages freed by daemon:");
	mvprintw(y++, half, "Intransit page Faults:");
	mvprintw(y++, half, "Page reclaims:");
	mvprintw(y++, half, "Fast reclaims in locore:");
	mvprintw(y++, half, "Short term deficit:");
E 3
I 3
D 12
	mvprintw(6, 0, "Pageouts:");
	mvprintw(6, HALF, "Page reclaims:");
E 12
I 12
D 21
	mvprintw(6, 0, "Page reclaims:");
	mvprintw(6, HALF, "Pageouts:");
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 3, 0) ;
	wprintw(stdscr, "Page reclaims:");
	wmove(stdscr, PAGE_AREA_1 + 3, PAGE_TITLE_2) ;
	wprintw(stdscr, "Pageouts:");
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 3, 0) ;
	wprintw(wp, "Page reclaims:");
	wmove(wp, PAGE_AREA_1 + 3, PAGE_TITLE_2) ;
	wprintw(wp, "Pageouts:");
E 22
E 21
E 12
E 3

I 3
D 12
	mvprintw(7, 0, "Swap in's:");
	mvprintw(7, HALF, "Fast reclaims in locore:");
E 12
I 12
D 21
	mvprintw(7, 0, "Fast reclaims in locore:");
	mvprintw(7, HALF, "Swap in's:");
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 4, 0) ;
	wprintw(stdscr, "Fast reclaims in locore:");
	wmove(stdscr, PAGE_AREA_1 + 4, PAGE_TITLE_2) ;
	wprintw(stdscr, "Swap in's:");
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 4, 0) ;
	wprintw(wp, "Fast reclaims in locore:");
	wmove(wp, PAGE_AREA_1 + 4, PAGE_TITLE_2) ;
	wprintw(wp, "Swap in's:");
E 22
E 21
E 12

D 12
	mvprintw(8, 0, "Swap out's:");
	mvprintw(8, HALF, "Short term deficit:");
E 12
I 12
D 21
	mvprintw(8, 0, "Short term deficit:");
	mvprintw(8, HALF, "Swap out's:");
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 5, 0) ;
	wprintw(stdscr, "Short term deficit:");
	wmove(stdscr, PAGE_AREA_1 + 5, PAGE_TITLE_2) ;
	wprintw(stdscr, "Swap out's:");
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 5, 0) ;
	wprintw(wp, "Short term deficit:");
	wmove(wp, PAGE_AREA_1 + 5, PAGE_TITLE_2) ;
	wprintw(wp, "Swap out's:");
E 22
E 21
E 12

E 3
D 12
	move(10, 0);
E 12
I 12
D 21
	mvprintw(9, 0, "Free Memory in Kb.:") ;
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_1 + 6, 0) ;
	wprintw(stdscr, "Free Memory in Kb.:") ;
E 22
I 22
	wmove(wp, PAGE_AREA_1 + 6, 0) ;
	wprintw(wp, "Free Memory in Kb.:") ;
E 22
E 21
E 12

I 12
D 21
	move(11, 0);
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_3, 0);
	wprintw(stdscr, "Page reclaims from free list:\n");
	wprintw(stdscr, "Pages scanned by clock daemon:\n");
	wprintw(stdscr, "Revolutions of the clock hand:\n");
	wprintw(stdscr, "Sequential process pages freed:\n");
	wprintw(stdscr, "Swap text pages found in free list:\n");
	wprintw(stdscr, "Inode text pages found in free list:\n");
E 22
I 22
	wmove(wp, PAGE_AREA_3, 0);
	wprintw(wp, "Page reclaims from free list:\n");
	wprintw(wp, "Pages scanned by clock daemon:\n");
	wprintw(wp, "Revolutions of the clock hand:\n");
	wprintw(wp, "Sequential process pages freed:\n");
	wprintw(wp, "Swap text pages found in free list:\n");
	wprintw(wp, "Inode text pages found in free list:\n");
E 22
E 21

E 12
D 21
	printw("Page reclaims from free list:\n");
	printw("Pages scanned by clock daemon:\n");
	printw("Revolutions of the clock hand:\n");
	printw("Sequential process pages freed:\n");
	printw("Swap text pages found in free list:\n");
	printw("Inode text pages found in free list:\n");
E 21
I 21
	/*
	 *	Area 4 - 
	 */
D 22
	wmove(stdscr, PAGE_AREA_4, 0) ;
	wprintw(stdscr, "Zero fill page faults:");
E 22
I 22
	wmove(wp, PAGE_AREA_4, 0) ;
	wprintw(wp, "Zero fill page faults:");
E 22
E 21

D 12
	mvprintw(17, 0, "File fill page faults:");
	mvprintw(18, 0, "File fill pages created:");
E 12
I 12
D 21
	mvprintw(18, 0, "Zero fill page faults:");
	mvprintw(19, 0, "File fill page faults:");
	mvprintw(20, 0, "a.out fill page faults:");
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_4 + 1, 0) ;
	wprintw(stdscr, "File fill page faults:");
E 22
I 22
	wmove(wp, PAGE_AREA_4 + 1, 0) ;
	wprintw(wp, "File fill page faults:");
E 22
E 21
E 12

D 3
	mvprintw(17, half, "Zero fill page faults:");
	mvprintw(18, half, "Zero fill pages created:");
E 3
I 3
D 12
	mvprintw(17, HALF, "Zero fill page faults:");
E 12
D 21
	mvprintw(18, HALF, "Zero fill pages created:");
I 12
	mvprintw(19, HALF, "File fill pages created:");
	mvprintw(20, HALF, "a.out fill pages created:");
E 21
I 21
D 22
	wmove(stdscr, PAGE_AREA_4 + 2, 0) ;
	wprintw(stdscr, "a.out fill page faults:");
E 22
I 22
	wmove(wp, PAGE_AREA_4 + 2, 0) ;
	wprintw(wp, "a.out fill page faults:");
E 22
E 21
E 12
E 3

I 21
	/*
	 *	Area 5 - 
	 */
D 22
	wmove(stdscr, PAGE_AREA_4, PAGE_TITLE_5) ;
	wprintw(stdscr, "Zero fill pages created:");
E 22
I 22
	wmove(wp, PAGE_AREA_4, PAGE_TITLE_5) ;
	wprintw(wp, "Zero fill pages created:");
E 22

D 22
	wmove(stdscr, PAGE_AREA_4 + 1, PAGE_TITLE_5) ;
	wprintw(stdscr, "File fill pages created:");
E 22
I 22
	wmove(wp, PAGE_AREA_4 + 1, PAGE_TITLE_5) ;
	wprintw(wp, "File fill pages created:");
E 22

D 22
	wmove(stdscr, PAGE_AREA_4 + 2, PAGE_TITLE_5) ;
	wprintw(stdscr, "a.out fill pages created:");
E 22
I 22
	wmove(wp, PAGE_AREA_4 + 2, PAGE_TITLE_5) ;
	wprintw(wp, "a.out fill pages created:");
E 22
E 21
D 12
	move(20, 0) ;

	printw("Executable fill page faults:\n");
	printw("Executable fill pages created:");
E 12
}

I 23
#define	PROC_ORIGIN	(3)
#define	PROC_OFFSET	(18)

#define	PROC_LINES	(9)

E 23
/*
 *	Functions for doing the process counts.
I 9
 *
 *	ARGSUSED
E 9
 */
I 4
D 9
/* ARGSUSED */
E 9
E 4
open_process(op)
OPTION	*op ;
{
I 3
D 9
	clear() ;
E 9
I 9
	sample_header() ;
E 9

I 23
	lines = PROC_LINES ;

E 23
D 9
	move(0, 0);

	printw("Elapsed time:\n");
	printw("Timestamp:\n\n");

E 9
D 21
	printw("Run Queue:\n");
	printw("Disk Wait:\n");
	printw("Page Wait:\n");
	printw("Sleeping in core:\n");
	printw("Swapped jobs:");
E 21
I 21
D 22
	wprintw(stdscr, "Run Queue:\n");
	wprintw(stdscr, "Disk Wait:\n");
	wprintw(stdscr, "Page Wait:\n");
	wprintw(stdscr, "Sleeping in core:\n");
	wprintw(stdscr, "Swapped jobs:");
E 22
I 22
	wprintw(wp, "Run Queue:\n");
	wprintw(wp, "Disk Wait:\n");
	wprintw(wp, "Page Wait:\n");
	wprintw(wp, "Sleeping in core:\n");
	wprintw(wp, "Swapped jobs:");
E 22
E 21
E 3
}

I 21
D 23
#define	PROC_ORIGIN	(3)
#define	PROC_OFFSET	(18)

E 23
E 21
I 4
D 9
/* ARGSUSED */
E 9
I 9
/*
 *	ARGSUSED
 */
E 9
E 4
magnify_process(op)
OPTION	*op ;
{
I 3
D 9
	mvprintw(0, 18, "%.2f", sample.mon_etime);
	mvprintw(1, 18, "%24.24s", ctime(&sample.mon_timestamp));
E 9
I 9
D 10
	sample_body(18) ;
E 10
I 10
D 16
	sample_body(14) ;
E 16
I 16
	sample_body((double)(sample.mon_ticks - proc_ticks)/first.mon_hz) ;
	proc_ticks = sample.mon_ticks ;
E 16
E 10
E 9

D 5
	mvprintw(3, 18, "%d", proc.mon_rq);
	mvprintw(4, 18, "%d", proc.mon_dw);
	mvprintw(5, 18, "%d", proc.mon_pw);
	mvprintw(6, 18, "%d", proc.mon_sl);
	mvprintw(7, 18, "%d", proc.mon_sw);
E 5
I 5
D 18
	mvprintw(3, 18, "%3d", proc.mon_rq);
	mvprintw(4, 18, "%3d", proc.mon_dw);
	mvprintw(5, 18, "%3d", proc.mon_pw);
	mvprintw(6, 18, "%3d", proc.mon_sl);
	mvprintw(7, 18, "%3d", proc.mon_sw);
E 18
I 18
D 21
	mvprintw(3, 18, "%3d", mon_proc.mon_rq);
	mvprintw(4, 18, "%3d", mon_proc.mon_dw);
	mvprintw(5, 18, "%3d", mon_proc.mon_pw);
	mvprintw(6, 18, "%3d", mon_proc.mon_sl);
	mvprintw(7, 18, "%3d", mon_proc.mon_sw);
E 21
I 21
D 22
	wmove(stdscr, PROC_ORIGIN, PROC_OFFSET) ;
	wprintw(stdscr, "%3d", mon_proc.mon_rq);
E 22
I 22
	wmove(wp, PROC_ORIGIN, PROC_OFFSET) ;
	wprintw(wp, "%3d", mon_proc.mon_rq);
E 22

D 22
	wmove(stdscr, PROC_ORIGIN + 1, PROC_OFFSET) ;
	wprintw(stdscr, "%3d", mon_proc.mon_dw);
E 22
I 22
	wmove(wp, PROC_ORIGIN + 1, PROC_OFFSET) ;
	wprintw(wp, "%3d", mon_proc.mon_dw);
E 22

D 22
	wmove(stdscr, PROC_ORIGIN + 2, PROC_OFFSET) ;
	wprintw(stdscr, "%3d", mon_proc.mon_pw);
E 22
I 22
	wmove(wp, PROC_ORIGIN + 2, PROC_OFFSET) ;
	wprintw(wp, "%3d", mon_proc.mon_pw);
E 22

D 22
	wmove(stdscr, PROC_ORIGIN + 3, PROC_OFFSET) ;
	wprintw(stdscr, "%3d", mon_proc.mon_sl);
E 22
I 22
	wmove(wp, PROC_ORIGIN + 3, PROC_OFFSET) ;
	wprintw(wp, "%3d", mon_proc.mon_sl);
E 22

D 22
	wmove(stdscr, PROC_ORIGIN + 4, PROC_OFFSET) ;
	wprintw(stdscr, "%3d", mon_proc.mon_sw);
E 22
I 22
	wmove(wp, PROC_ORIGIN + 4, PROC_OFFSET) ;
	wprintw(wp, "%3d", mon_proc.mon_sw);
E 22
E 21
E 18
E 5
E 3
}

D 29
/*
I 23
D 27
 *	Constants for the placement of the FORK data.
E 27
I 27
 *	Local data for delta_tty() and init_statics().
E 27
 */
D 27
#define	FORK_OFFSET	(29)
#define	FORK_TOTAL	(3)
#define	FORK_AVERAGE	(8)
#define	FORK_DELTA	(11)

#define	FORK_LINES	(16)

/*
E 23
 *	Functions for doing fork stats.
I 8
 *
 *	ARGSUSED
E 8
 */
I 4
D 8
/* ARGSUSED */
E 8
E 4
open_fork(op)
OPTION	*op ;
{
I 3
D 9
	clear() ;
E 9
I 9
	sample_header() ;
E 9

I 23
	lines = FORK_LINES ;

E 23
D 9
	move(0, 0);

	printw("Elapsed time:\n");
	printw("Timestamp:\n\n");

E 9
D 21
	printw("Total fork()'s:\n");
	printw("Total vfork()'s:\n");
	printw("Total size of fork()'s:      %10d Kb.\n", 0);
	printw("Total size of vfork()'s:     %10d Kb.\n\n", 0);
E 21
I 21
D 22
	wprintw(stdscr, "Total fork()'s:\n");
	wprintw(stdscr, "Total vfork()'s:\n");
	wprintw(stdscr, "Total size of fork()'s:      %10d Kb.\n", 0);
	wprintw(stdscr, "Total size of vfork()'s:     %10d Kb.\n\n", 0);
E 22
I 22
	wprintw(wp, "Total fork()'s:\n");
	wprintw(wp, "Total vfork()'s:\n");
	wprintw(wp, "Total size of fork()'s:      %10d Kb.\n", 0);
	wprintw(wp, "Total size of vfork()'s:     %10d Kb.\n\n", 0);
E 22
E 21

D 9
	printw("Average size of fork():      %10.2f Kb.\n");
	printw("Average size of vfork():     %10.2f Kb.\n\n");
E 9
I 9
D 21
	printw("Average size of fork():      %10.2f Kb.\n", 0);
	printw("Average size of vfork():     %10.2f Kb.\n\n", 0);
E 21
I 21
D 22
	wprintw(stdscr, "Average size of fork():      %10.2f Kb.\n", 0);
	wprintw(stdscr, "Average size of vfork():     %10.2f Kb.\n\n", 0);
E 22
I 22
	wprintw(wp, "Average size of fork():      %10.2f Kb.\n", 0);
	wprintw(wp, "Average size of vfork():     %10.2f Kb.\n\n", 0);
E 22
E 21
E 9

D 21
	printw("Change in fork()'s:\n");
	printw("Change in vfork()'s:\n");
	printw("Change in size of fork()'s:  %10d Kb.\n", 0);
	printw("Change in size of vfork()'s: %10d Kb.", 0);
E 21
I 21
D 22
	wprintw(stdscr, "Change in fork()'s:\n");
	wprintw(stdscr, "Change in vfork()'s:\n");
	wprintw(stdscr, "Change in size of fork()'s:  %10d Kb.\n", 0);
	wprintw(stdscr, "Change in size of vfork()'s: %10d Kb.", 0);
E 22
I 22
	wprintw(wp, "Change in fork()'s:\n");
	wprintw(wp, "Change in vfork()'s:\n");
	wprintw(wp, "Change in size of fork()'s:  %10d Kb.\n", 0);
	wprintw(wp, "Change in size of vfork()'s: %10d Kb.", 0);
E 22
E 21
E 3
}
D 23

I 4
D 9
/* ARGSUSED */
E 9
I 9
/*
I 21
 *	Constants for the placement of the FORK data.
 */
#define	FORK_OFFSET	(29)
#define	FORK_TOTAL	(3)
#define	FORK_AVERAGE	(8)
#define	FORK_DELTA	(11)
E 23

/*
E 21
 *	ARGSUSED
 */
E 9
E 4
magnify_fork(op)
E 2
OPTION	*op ;
{
I 3
D 9
	mvprintw(0, 14, "%.2f", sample.mon_etime);
	mvprintw(1, 14, "%24.24s", ctime(&sample.mon_timestamp));
E 9
I 9
D 16
	sample_body(14) ;
E 16
I 16
	double	etime ;
E 16
E 9

D 21
	mvprintw(3, 29, "%10d", Fork.cntfork);
	mvprintw(4, 29, "%10d", Fork.cntvfork);
	mvprintw(5, 29, "%10d", pgtok(Fork.sizfork));
	mvprintw(6, 29, "%10d", pgtok(Fork.sizvfork));
E 21
I 21
	/*
	 *	The fork totals.
	 */
D 22
	wmove(stdscr, FORK_TOTAL, FORK_OFFSET) ;
	wprintw(stdscr, "%10d", Fork.cntfork);
E 22
I 22
	wmove(wp, FORK_TOTAL, FORK_OFFSET) ;
	wprintw(wp, "%10d", Fork.cntfork);
E 22
E 21

D 21
	mvprintw(8, 29, "%10.2f", (double)pgtok(Fork.sizfork) / Fork.cntfork);
	mvprintw(9, 29, "%10.2f", (double)pgtok(Fork.sizvfork) / Fork.cntvfork);
E 21
I 21
D 22
	wmove(stdscr, FORK_TOTAL + 1, FORK_OFFSET) ;
	wprintw(stdscr, "%10d", Fork.cntvfork);
E 22
I 22
	wmove(wp, FORK_TOTAL + 1, FORK_OFFSET) ;
	wprintw(wp, "%10d", Fork.cntvfork);
E 22
E 21

I 21
D 22
	wmove(stdscr, FORK_TOTAL + 2, FORK_OFFSET) ;
	wprintw(stdscr, "%10d", pgtok(Fork.sizfork));
E 22
I 22
	wmove(wp, FORK_TOTAL + 2, FORK_OFFSET) ;
	wprintw(wp, "%10d", pgtok(Fork.sizfork));
E 22

D 22
	wmove(stdscr, FORK_TOTAL + 3, FORK_OFFSET) ;
	wprintw(stdscr, "%10d", pgtok(Fork.sizvfork));
E 22
I 22
	wmove(wp, FORK_TOTAL + 3, FORK_OFFSET) ;
	wprintw(wp, "%10d", pgtok(Fork.sizvfork));
E 22

	/*
	 *	The running average.
	 */
D 22
	wmove(stdscr, FORK_AVERAGE, FORK_OFFSET) ;
	wprintw(stdscr, "%10.2f", (double)pgtok(Fork.sizfork) / Fork.cntfork);
E 22
I 22
	wmove(wp, FORK_AVERAGE, FORK_OFFSET) ;
	wprintw(wp, "%10.2f", (double)pgtok(Fork.sizfork) / Fork.cntfork);
E 22

D 22
	wmove(stdscr, FORK_AVERAGE + 1, FORK_OFFSET) ;
	wprintw(stdscr, "%10.2f", (double)pgtok(Fork.sizvfork) / Fork.cntvfork);
E 22
I 22
	wmove(wp, FORK_AVERAGE + 1, FORK_OFFSET) ;
	wprintw(wp, "%10.2f", (double)pgtok(Fork.sizvfork) / Fork.cntvfork);
E 22

	/*
	 *	The amount of change since the last sample.
	 */
E 21
D 14
	delta_fork() ;
E 14
I 14
D 16
	(void)delta_fork(sample.mon_ticks) ;
E 16
I 16
	etime = delta_fork(sample.mon_ticks) ;
E 16
E 14

D 21
	mvprintw(11, 29, "%10d", Fork.cntfork);
	mvprintw(12, 29, "%10d", Fork.cntvfork);
	mvprintw(13, 29, "%10d", pgtok(Fork.sizfork));
	mvprintw(14, 29, "%10d", pgtok(Fork.sizvfork));
E 21
I 21
D 22
	wmove(stdscr, FORK_DELTA, FORK_OFFSET) ;
	wprintw(stdscr, "%10d", Fork.cntfork);
E 22
I 22
	wmove(wp, FORK_DELTA, FORK_OFFSET) ;
	wprintw(wp, "%10d", Fork.cntfork);
E 22

D 22
	wmove(stdscr, FORK_DELTA + 1, FORK_OFFSET) ;
	wprintw(stdscr, "%10d", Fork.cntvfork);
E 22
I 22
	wmove(wp, FORK_DELTA + 1, FORK_OFFSET) ;
	wprintw(wp, "%10d", Fork.cntvfork);
E 22

D 22
	wmove(stdscr, FORK_DELTA + 2, FORK_OFFSET) ;
	wprintw(stdscr, "%10d", pgtok(Fork.sizfork));
E 22
I 22
	wmove(wp, FORK_DELTA + 2, FORK_OFFSET) ;
	wprintw(wp, "%10d", pgtok(Fork.sizfork));
E 22

D 22
	wmove(stdscr, FORK_DELTA + 3, FORK_OFFSET) ;
	wprintw(stdscr, "%10d", pgtok(Fork.sizvfork));
E 22
I 22
	wmove(wp, FORK_DELTA + 3, FORK_OFFSET) ;
	wprintw(wp, "%10d", pgtok(Fork.sizvfork));
E 22
E 21
I 16

	sample_body(etime) ;
E 16
}

/*
 *	Local data for delta_fork(), delta_tty() and init_statics().
 */
E 27
static	old_ttyin = 0,
D 13
	old_ttyout = 0 ;
E 13
I 13
D 14
	old_ttyout = 0,
	tty_ticks = 0 ;		/* ticks at previous sample */
E 14
I 14
	old_ttyout = 0 ;
E 14
E 13

E 29
I 14
D 16
static	fork_ticks = 0,		/* ticks at previous sample */
D 15
	disk_ticks = 0,
E 15
	tty_ticks = 0 ;

E 16
E 14
D 27
static	struct forkstat old_fork = {
		0, 0, 0, 0
};

E 27
I 6
struct	tot_disk {
I 15
	int	t_ticks ;	/* clock ticks at previous sample */
E 15
	int	t_xfer,
		t_seek,
		t_wds,
		t_time ;
} ;

struct	tot_disk	t_disk[DK_NDRIVE] ;
D 10
struct	tot_disk	t_tape[DK_NDRIVE] ;
E 10

E 6
/*
D 27
 *	Calculate the change in the interesting fork stats.
 */
D 14
delta_fork()
E 14
I 14
double	delta_fork(ticks)
int	ticks ;
E 14
{
	register t ;
D 8
	register struct forkstat *p = &fork.mon_fork ;
E 8
I 8
D 18
	register struct forkstat *p = &forkstat.mon_fork ;
E 18
I 18
	register struct forkstat *p = &mon_fork.mon_fork ;
E 18
I 14
	double	 etime ;
E 14
E 8

I 14
	etime = (double)(ticks - fork_ticks)/first.mon_hz ;

E 14
	t = p->cntfork ; 
	    p->cntfork -= old_fork.cntfork ;
	    old_fork.cntfork = t ;

	t = p->cntvfork ; 
	    p->cntvfork -= old_fork.cntvfork ;
	    old_fork.cntvfork = t ;

	t = p->sizfork ;
	    p->sizfork -= old_fork.sizfork ;
	    old_fork.sizfork = t ;

	t = p->sizvfork ;
	    p->sizvfork -= old_fork.sizvfork ;
	    old_fork.sizvfork = t ;
I 13

D 14
	return ;
E 14
I 14
	fork_ticks = ticks ;

	return etime ;
E 14
E 13
}

/*
E 27
D 29
 *	Calculate the change in the tty stats.
I 13
 *
 *	Given the current number of clock ticks, find and return
 *	the elapsed time since the last sample.
E 13
 */
D 13
delta_tty()
E 13
I 13
double	delta_tty(ticks)
int	ticks ;
E 13
{
	register t ;
I 13
	double	 etime = (double)(ticks - tty_ticks) / first.mon_hz ;
E 13

	t = tty.mon_ttyin; 
	    tty.mon_ttyin -= old_ttyin ; 
	    old_ttyin = t ;

	t = tty.mon_ttyout ; 
	    tty.mon_ttyout -= old_ttyout ; 
	    old_ttyout = t ;
I 13

	tty_ticks = ticks ;

	return etime ;
E 13
}

/*
E 29
 *	Initialize whatever static counters need to be initialized.
D 6
 *
 *	Currently there is only fork and tty.  I may add page later.
E 6
I 6
 * 
 *	Previously only fork and tty were initialized.  Since I made
D 17
 *	disk and tape static structures, I added code to initialize
 *	those.  I have also included the delta functions for disk
 *	and tape.
E 17
I 17
 *	disk structures static, I added code to initialize those.  I 
D 27
 *	have also included the delta functions for disk.
E 27
I 27
 *	have also included the delta functions for disk.  I later moved
 *	the fork setup code into fork.c.  Eventually I'll do the same
 *	with ttys.
E 27
E 17
E 6
 */
I 4
D 29

E 29
D 6
/* ARGSUSED */

E 6
E 4
init_statics(op)
I 4
OPTION	*op ;
E 4
{
D 6
	old_fork.cntfork = 0 ;
	old_fork.cntvfork = 0 ;
	old_fork.sizfork = 0 ;
	old_fork.sizvfork = 0 ;
E 6
I 6
D 27
	if( op->opt_fork ) {
		old_fork.cntfork = 0 ;
		old_fork.cntvfork = 0 ;
		old_fork.sizfork = 0 ;
		old_fork.sizvfork = 0 ;
I 16
		fork_ticks = 0 ;
E 16
	}
E 27
I 27
	if( op->opt_fork )
		setup_fork() ;
E 27
E 6

D 6
	old_ttyin = 0 ;
	old_ttyout = 0 ;
E 6
I 6
D 29
	if( op->opt_tty ) {
		old_ttyin = 0 ;
		old_ttyout = 0 ;
I 16
		tty_ticks = 0 ;
E 16
	}
E 29
I 29
	if( op->opt_tty )
		init_tty_data() ;
E 29
I 16

	if( op->opt_free || op->opt_memory )
		memory_ticks = 0 ;

	if( op->opt_page )
		paging_ticks = 0 ;

	if( op->opt_sample )
		sample_ticks = 0 ;

	if( op->opt_proc )
		proc_ticks = 0 ;
I 18

	if( op->opt_pid ) {
		pid_ticks[CHILD]    = pid_ticks[SELF] = 0 ;
		soft_faults[CHILD]  = soft_faults[SELF] = 0 ;
		hard_faults[CHILD]  = hard_faults[SELF] = 0 ;
		in_block[CHILD]     = in_block[SELF] = 0 ;
		out_block[CHILD]    = out_block[SELF] = 0 ;
		send_message[CHILD] = send_message[SELF] = 0 ;
		rcv_message[CHILD]  = rcv_message[SELF] = 0 ;
	}
E 18
E 16

D 10
	if( op->opt_tape )
		bzero((char *)t_disk, n_disk * sizeof(struct tot_disk));

E 10
	if( op->opt_disk )
D 10
		bzero((char *)t_tape, n_tape * sizeof(struct tot_disk));
E 10
I 10
D 17
		bzero((char *)t_disk, n_tape * sizeof(struct tot_disk));
E 17
I 17
		bzero((char *)t_disk, n_disk * sizeof(struct tot_disk));
E 17
E 10
}

/*
 *	Calculate the change in the disk I/O stats.
I 15
 *
 *	The sample time (ticks) is maintained for each disk in the
 *	list so that a future feature will be easier to impliment
 *	(add and subtract data).
 *
 *	Note: This module is here because it keeps previous sample
 *	data local.
E 15
 */
D 15
delta_disk(dp)
register struct mon_disk *dp ;
E 15
I 15
double	delta_disk(index, ticks)
register index, ticks ;
E 15
{
	register tmp ;
D 15
	register struct tot_disk *tp ;
E 15
I 15
	double	 etime ;
E 15

D 15
	tp = t_disk + dp->mon_index ;
E 15
I 15
	etime = (double)(ticks - t_disk[index].t_ticks)/first.mon_hz ;
	t_disk[index].t_ticks = ticks ;
E 15

D 15
	tmp = dp->mon_xfer ;
	      dp->mon_xfer -= tp->t_xfer ;
	      tp->t_xfer = tmp ;
E 15
I 15
	tmp = disk[index].mon_xfer ;
	      disk[index].mon_xfer -= t_disk[index].t_xfer ;
	      t_disk[index].t_xfer = tmp ;
E 15

D 15
	tmp = dp->mon_seek ;
	      dp->mon_seek -= tp->t_seek ;
	      tp->t_seek = tmp ;
E 15
I 15
	tmp = disk[index].mon_seek ;
	      disk[index].mon_seek -= t_disk[index].t_seek ;
	      t_disk[index].t_seek = tmp ;
E 15

D 15
	tmp = dp->mon_wds ;
	      dp->mon_wds -= tp->t_wds ;
	      tp->t_wds = tmp ;
E 15
I 15
	tmp = disk[index].mon_wds ;
	      disk[index].mon_wds -= t_disk[index].t_wds ;
	      t_disk[index].t_wds = tmp ;
E 15

D 15
	tmp = dp->mon_time ;
	      dp->mon_time -= tp->t_time ;
	      tp->t_time = tmp ;
E 15
I 15
	tmp = disk[index].mon_time ;
	      disk[index].mon_time -= t_disk[index].t_time ;
	      t_disk[index].t_time = tmp ;

	return etime ;
I 26
}

/*
 *	This function assumes that 1024 and the value of NBPG are
 *	multiples, depending on their relative values.  I believe
 *	this is a safe assumption on a binary computer.
 */
pgtok(x)
int	x ;
{
	if( first.mon_nbpg < 1024 )
		return (x) / (1024 / first.mon_nbpg) ;
	else
		return (x) * (first.mon_nbpg / 1024) ;
}

/*
 *	Might as well make this one a function also...
 *
 *	A function for turning number of sectors into one Kilobyte
 *	units.  It uses the block size constant.
 */
btok(x)
int	x ;
{
	if( first.mon_bsize < 1024 )
		return (x) / (1024 / first.mon_bsize) ;
	else
		return (x) * (first.mon_bsize / 1024) ;
E 26
E 15
D 10
}

/*
 *	Due to the severe lack of useful tape information this function
 *	doesn't do anything.  The body of the function is commented out
 *	to keep lint happy.
I 9
 *
 *	ARGSUSED
E 9
 */
D 9
/* ARGSUSED */
E 9
delta_tape(p)
struct mon_tape *p ;
{
/*
 *	register tmp ;
 *	register struct tot_disk *tp ;
 *
 *	tp = t_disk + p->mon_index ;
 */
E 10
E 6
E 3
}
E 1
