h44264
s 00010/00000/00282
d D 1.39 90/03/29 16:17:08 alan 39 38
c The hack to fix the DECmumble include file problem.
e
s 00004/00008/00278
d D 1.38 89/02/25 22:20:19 alan 38 37
c fix bug in the check to limit the width of the display to the available screen space
e
s 00001/00001/00285
d D 1.37 89/02/25 09:56:59 alan 37 36
c editorial change to rec_ elements
e
s 00102/00045/00184
d D 1.36 89/02/25 09:42:15 alan 36 35
c reformatted display
e
s 00005/00001/00224
d D 1.35 89/02/15 19:28:47 alan 35 34
c properly set mon_flag in all records
e
s 00011/00001/00214
d D 1.34 88/06/27 18:15:25 alan 34 33
c changed include of monitor.h and record.h
e
s 00001/00001/00214
d D 1.33 87/11/18 16:39:50 alan 33 32
c V0.99 -> T1.0-1
e
s 00002/00000/00213
d D 1.32 87/11/18 12:17:09 alan 32 31
c V0.98
e
s 00001/00001/00212
d D 1.31 87/08/12 15:26:01 alan 31 30
c error message clean up - V0.95
e
s 00010/00004/00203
d D 1.30 87/08/10 21:27:16 alan 30 29
c See commentary on V0.92 in version.c
e
s 00014/00009/00193
d D 1.29 87/05/20 17:14:56 alan 29 28
c changed all curses calls to use w... versions
e
s 00013/00007/00189
d D 1.28 87/04/17 15:46:49 alan 28 27
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00001/00001/00195
d D 1.27 87/04/03 14:31:19 alan 27 26
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00000/00004/00196
d D 1.26 87/02/05 16:28:29 alan 26 25
c See comment on V0.81 in version.c.
c 
e
s 00006/00003/00194
d D 1.25 87/01/30 16:09:10 alan 25 24
c See commenary on V0.76 in version.c
e
s 00016/00022/00181
d D 1.24 87/01/29 15:13:47 alan 24 23
c Changes to delta_netif(), V0.72
c 
e
s 00004/00000/00199
d D 1.23 87/01/21 16:36:25 alan 23 22
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00016/00016/00183
d D 1.22 86/12/07 22:22:32 alan 22 21
c See V0.57 in version.c
e
s 00038/00007/00161
d D 1.21 86/11/18 12:41:58 alan 21 20
c See commentary on V0.55 in version.c
c 
e
s 00001/00001/00167
d D 1.20 86/08/26 18:04:07 alan 20 19
c modify all SccsId strings
e
s 00023/00040/00145
d D 1.19 86/07/30 17:27:44 alan 19 18
c Much code changed.  Most of it involved turning disks and tapes into array
c instead of linked lists, and netif and cpu in dynamically allocated arrays.
c I also combined some of the I/O vector code into one place and changed all
c the various references.
c 
c The code at this point is reasonably lint free but needs a LOT of clean up
c work.  There is a lot of inconsistant usage of "first.mon_..." and "n_...".
c 
c TODO: All the code needs to looked over and cleaned up.  The "total"
c structure for disks and tapes need to become static instead of dynamic.
c I need to merge the stack code into the approproiate mba and uba code.
c 
c The multiple CPU code needs to be tested.  I can probably simulate a
c save file from a Multiple CPU run, but...
c 
e
s 00008/00005/00177
d D 1.18 86/07/25 14:51:26 alan 18 17
c Fixed bug that was causeing magnify function to walk off the end of the
c arrays in replay-mode.
c 
c This is bug is another example of why I should rewrite the disk, tape, netif
c and cpu lists to be array's everywhere.  For disk and tape I can statically
c allocate space for the data structures, for cpu's I can dynamically allocate
c based on the size of _cpudata and for netif's I can make two passes on the
c internal list, one quick pass to size the list and the other to fill the
c static info.
c 
e
s 00002/00002/00180
d D 1.17 86/07/13 14:39:54 alan 17 16
c dust off even more lint
e
s 00012/00005/00170
d D 1.16 86/07/11 19:27:35 alan 16 15
c Dust off LOTS of lint...
c 
e
s 00002/00002/00173
d D 1.15 86/07/03 08:14:16 alan 15 14
c change a display_mode to collect_mode
e
s 00068/00000/00107
d D 1.14 86/07/02 16:39:39 alan 14 13
c fleshed out code for magnifying network info.
c 
e
s 00020/00000/00087
d D 1.13 86/07/01 17:10:52 alan 13 12
c add prototype function for doing magnifyy and open
e
s 00003/00008/00084
d D 1.12 86/06/29 15:47:54 alan 12 11
c Changed the handleing of "word=value" lists.
c 
e
s 00006/00004/00086
d D 1.11 86/05/30 11:25:29 alan 11 10
c Added initial value of "mon_flag" to all the data records.  This will be
c used to dynamically add and remove data from a display.
c 
e
s 00015/00011/00075
d D 1.10 86/05/28 15:57:39 alan 10 9
c First pass of changes in order to get data selection to work.  Data
c selection during the replay function still needs to be written.
c 
c 1.  Due to the heavy use of the code like:
c 
c 	if( nel ) {
c 		p = sprintf(buf, "%s%d", name, unit);
c 
c 		if( !bsearch(&p, base, nel, sizeof(key *), compare))
c 			;
c 	}
c I sould impliment it as a function somewhere.  Probably in the 2nd or
c third pass.
c 
e
s 00000/00001/00086
d D 1.9 86/05/23 19:38:28 alan 9 8
c remove reference to tot_netif
e
s 00006/00011/00081
d D 1.8 86/05/23 19:32:04 alan 8 7
c Rather than use a structure hanging off the data record for keeping totals
c and deltas, I decided to allocate an array of structures once I know how
c many I need.  This is done in replay and gather.  The functions to free
c and allocate memory are in delta.c
c 
e
s 00000/00032/00092
d D 1.7 86/05/18 18:10:19 alan 7 6
c moved the delta_netif() code to delta.c
e
s 00046/00007/00078
d D 1.6 86/05/16 09:02:48 alan 6 5
c added changes and code for delta_netif()
c 
e
s 00002/00000/00083
d D 1.5 86/05/08 18:00:11 alan 5 4
c initialized mon_type and mon_length
e
s 00003/00006/00080
d D 1.4 86/05/07 10:07:20 alan 4 3
c changed lseek/read pairs to readk
e
s 00038/00045/00048
d D 1.3 86/05/06 17:56:32 alan 3 2
c cleaned up for real use.  Added code to netif.c for link listing interfaces
e
s 00000/00000/00093
d D 1.2 86/05/05 12:45:12 alan 2 1
c taken from ../names V1.1
e
s 00093/00000/00000
d D 1.1 86/05/05 12:44:06 alan 1 0
c date and time created 86/05/05 12:44:06 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 10
 *	%M% - Read device names from kernal.
E 10
I 10
 *	%M% - Read network interface device names from kernal.
E 10
 */
#ifndef	lint
D 20
static	char	SccsId[] = "%W% %G%" ;
E 20
I 20
D 21
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 21
I 21
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 21
E 20
#endif

I 34
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 35
 *
 * Feb. 15, 1989 -- arr
 *
 *	Correctly set mon_flag with MON$M_VALID.
I 36
 *
 * Week ending Feb. 25, 1989 -- arr
 *
 *	Reformatted netif magnification screen.  Also moved f_netif()
 *	from functions.c to netif.c.
I 39
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 39
E 36
E 35
 */

E 34
#include <nlist.h>
#include <stdio.h>
I 3
#include <signal.h>
I 13
#include <curses.h>
E 13
E 3

#include <sys/types.h>
I 23
D 25
#include <sys/devio.h>
E 25
E 23
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
I 3
#include <sys/dk.h>
I 23
#include <sys/param.h>
#include <sys/dir.h>
I 39

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 39
#include <sys/user.h>
E 23
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 3

#include <net/if.h>
#include <netinet/in.h>

I 34
#include "include.h"
E 34
I 25
D 26
#ifdef	V20
#	include <sys/devio.h>
#endif

E 26
E 25
D 27
#include "extern.h"
E 27
D 3
#include "names.h"
E 3
I 3
#include "monitor.h"
D 34
#include "record.h"
E 34
I 13
#include "options.h"
I 27
#include "extern.h"
E 27
E 13
E 3

I 21
/*
 *	Module name for error functions.
 */
static	char	*module = "netif" ;

E 21
I 16
D 19
char	*malloc(),
E 19
I 19
D 22
char	*calloc(),
E 19
D 21
	*index(),
	*rindex(),
E 21
I 21
	*strrchr(),
E 21
	*str_netif(),
E 22
I 22
/*
 *	Functions that don't return (int).
 */
char	*ctime(),
	*calloc(),
E 22
	*strcpy(),
I 36
	*sprintf(),
E 36
D 22
	*ctime() ;
E 22
I 22
	*strrchr(),
	*str_netif() ;
E 22

I 21
/*
I 29
 *	Default display.
 */
I 30
extern	int	lines ;			/* length of screen being used. */
I 36
extern	int	cols ;			/* width of screen being used */
E 36
E 30
extern	WINDOW	*wp ;

/*
E 29
 *	Walk through the list of network interfaces and setup
 *	the array for monitor to use.
 */
E 21
E 16
I 3
D 19
static	struct mon_netif *current_netif = 0 ;

E 19
E 3
net_devices()
{
D 10
	off_t	firstif, ip ;
I 6
	char	*p ;
E 6
I 3

E 10
E 3
D 6
	struct ifnet ifnet ;
D 3
	int	numif = 0;
	char	interface[IFNAMSIZ] ;
E 3
I 3
	struct mon_netif *ifp ;
E 6
I 6
	struct	ifnet		ifnet ;
	struct	mon_netif	*ifp ;
I 10
D 12
	char	buf[BUFSIZ], device[BUFSIZ], *p, *sprintf() ;
E 12
I 12
	char	device[BUFSIZ] ;
E 12
	off_t	firstif, ip ;
I 19
	unsigned n = 0 ; 
E 19
D 12
	int	cmp() ;
E 12
E 10
D 9
	struct	tot_netif	*tp ;
E 9
E 6
E 3

I 21
	/*
	 *	Make sure there is a list of network
	 *	interfaces to read and if there is
	 *	read the address of the first one.
	 */
E 21
	if((ip = (off_t)namelist[NM_IFNET].n_value) == 0 )
		return ;
D 3
	else
		printf("#\n#\tNetwork Interfaces\n#\n");
E 3

D 3
	lseek(kmem, ip, 0);
E 3
I 3
D 4
	lseek(kmem, ip, L_SET);
E 3
	read(kmem, &firstif, sizeof(firstif));
E 4
I 4
D 16
	readk(ip, &firstif, sizeof(firstif));
E 16
I 16
	readk((long)ip, (char *)&firstif, sizeof(firstif));
E 16
E 4

I 21
	/*
	 *	Make a quick pass of the list to count the
	 *	number of interfaces and allocate space for
	 *	mon_netif structures.
	 */
E 21
D 19
	ip = firstif ;
E 19
I 19
	for(ip = firstif; ip; ip = (off_t)ifnet.if_next ) {
		readk((long)ip, (char *)&ifnet, sizeof(ifnet));
		n++ ;
	}
E 19

I 19
	if((netif = (struct mon_netif *)calloc(n, MON$S_NETIF)) == NULL )
D 21
		fatal("monitor: netif: no space for mon_netif: %s.\n");
E 21
I 21
D 31
		fatal("no space for mon_netif: %s.\n", module);
E 31
I 31
		fatal("Can't allocate space for netif structures: %s.\n", module);
E 31
E 21

E 19
D 10
	while( ip ) {
E 10
I 10
	for(ip = firstif; ip; ip = (off_t)ifnet.if_next ) {
I 21
		/*
		 *	Read the ifnet structure and the interface
		 *	name.  Using the name and unit number see if
		 *	this is an "interesting" interface.
		 */
E 21
E 10
D 3
		lseek(kmem, (long)ip, 0);
E 3
I 3
D 4
		lseek(kmem, (long)ip, L_SET);
E 3
		read(kmem, &ifnet, sizeof(ifnet));
E 4
I 4
D 16
		readk((long)ip, &ifnet, sizeof(ifnet));
I 10
		readk((long)ifnet.if_name, device, IFNAMSIZ);
E 16
I 16
		readk((long)ip, (char *)&ifnet, sizeof(ifnet));
I 19

E 19
		readk((long)ifnet.if_name, (char *)device, IFNAMSIZ);
E 16
E 10
E 4

I 10
D 12
		if( netif_nel ) {
			p = sprintf(buf, "%s%d", device, ifnet.if_unit);

			if( !bsearch(&p, netif_base, netif_nel, KEY_SIZE, cmp))
				continue ;
		}
E 12
I 12
		if( find_value(&netif_list, device, ifnet.if_unit) == 0 )
			continue ;
E 12

E 10
D 3
		numif++ ;
E 3
I 3
D 19
		if((ifp = (struct mon_netif *)malloc(MON$S_NETIF)) == NULL )
D 16
			fatal("monitor: no space for network interface: %s.\n");
E 16
I 16
			fatal("monitor: netif: no space for mon_netif: %s.\n");
E 19
I 19
		ifp = netif + n_netif ;
E 19
E 16
E 3

D 3
		lseek(kmem, (long)ifnet.if_name, 0);
		read(kmem, interface, IFNAMSIZ);
E 3
I 3
D 4
		lseek(kmem, (long)ifnet.if_name, L_SET);
		read(kmem, ifp->mon_name, IFNAMSIZ);
E 4
I 4
D 10
		readk((long)ifnet.if_name, ifp->mon_name, IFNAMSIZ);
E 4
E 3

E 10
D 3
		printf("%s%d is <", interface, ifnet.if_unit);
		print_if(&ifnet);
E 3
I 3
		/*
		 *	Initialize static data.
		 */
I 5
D 11
		ifp->mon_type = MON$K_NETIF ;
E 11
I 11
D 33
		ifp->mon_type   = MON$K_NETIF ;
E 33
I 33
		ifp->mon_type   = MON$C_NETIF ;
E 33
D 35
		ifp->mon_flag   = 1 ;
E 35
I 35
		ifp->mon_flag   = MON$M_VALID ;
E 35
E 11
		ifp->mon_length = MON$S_NETIF ;
E 5
D 11
		ifp->mon_ifnet = (struct ifnet *)ip ;
		ifp->mon_next = NULL ;
		ifp->mon_unit = ifnet.if_unit ;
E 11
I 11
		ifp->mon_ifnet  = (struct ifnet *)ip ;
D 19
		ifp->mon_next   = NULL ;
E 19
		ifp->mon_unit   = ifnet.if_unit ;
I 19
		ifp->mon_index  = ifp->mon_if = n_netif++ ;
E 19

E 11
E 3
D 10

E 10
I 10
D 17
		strcpy(ifp->mon_name, device);
E 17
I 17
		(void)strcpy(ifp->mon_name, device);
I 32
		ifp->mon_name[IFNAMSIZ] = '\0' ;

E 32
E 17
E 10
D 3
		ip = (off_t)ifnet.if_next ;
	}
}
E 3
I 3
		/*
		 *	Initialize the first pass of dynamic data.
		 */
D 6
		ifp->mon_collisions = ifnet.if_collisions ;
		ifp->mon_ipackets = ifnet.if_ipackets ;
		ifp->mon_opackets = ifnet.if_opackets ;
		ifp->mon_ierrors = ifnet.if_ierrors ;
		ifp->mon_oerrors = ifnet.if_oerrors ;
E 6
I 6
D 8
		if((p = (char *)malloc(sizeof(struct tot_netif))) == NULL )
			fatal("monitor: no space for total structure: %s.\n");
E 8
I 8
		ifp->mon_collisions = ifnet.if_collisions ;
		ifp->mon_ipackets = ifnet.if_ipackets ;
		ifp->mon_opackets = ifnet.if_opackets ;
		ifp->mon_ierrors = ifnet.if_ierrors ;
		ifp->mon_oerrors = ifnet.if_oerrors ;
E 8
E 6
E 3
D 19

I 6
D 8
		tp = ifp->mon_total = (struct tot_netif *)p ;

		tp->t_collisions = ifp->mon_collisions = ifnet.if_collisions ;
		tp->t_ipackets = ifp->mon_ipackets = ifnet.if_ipackets ;
		tp->t_opackets = ifp->mon_opackets = ifnet.if_opackets ;
		tp->t_ierrors = ifp->mon_ierrors = ifnet.if_ierrors ;
		tp->t_oerrors = ifp->mon_oerrors = ifnet.if_oerrors ;

E 6
D 3
char	*array[] = {
	"up", 			/* 01 */
	"broadcast", 		/* 02 */
	"debug", 		/* 04 */
	"route",		/* 010 */
	"pointopoint",		/* 020 */
	"notrailers",		/* 040 */
	"running",		/* 0100 */
	"noarp",		/* 0200 */
	"local",		/* 0400 */
	"dynproto",		/* 01000 */
	"loopback",		/* 02000 */
	"04000",		/* 04000 */
	"010000",
	"020000",
	"040000",
	"0100000",
};
E 3
I 3
		n_netif++ ;
E 8
I 8
D 10
		ifp->mon_if = n_netif++ ;
E 10
I 10
		ifp->mon_index = ifp->mon_if = n_netif++ ;
E 10
E 8
E 3

D 3
print_if(ip)
struct ifnet *ip ;
{
	int	i, comma = 0 ;

	for(i = 0; i < sizeof(ip->if_flags) * 8; i++) {
		if((1 << i) & ip->if_flags ) {
			if( comma++ )
				putchar(',');
			printf("%s", array[i]);
E 3
I 3
		if( netif == 0 )
			netif = current_netif = ifp ;
		else {
			current_netif->mon_next = ifp ;
			current_netif = ifp ;
E 3
		}
E 19
D 3
	}
E 3
D 10

D 3
	printf("> with %d collisions.\n", ip->if_collisions);
E 3
I 3
		ip = (off_t)ifnet.if_next ;
E 10
	}
I 13
}

I 28
D 36
#define	NETIF_OFFSET	(7)
#define	NETIF_DATA	(5)
E 36
I 36
#define	NETIF_OFFSET	(12)
#define	NETIF_X		(15)
#define	NETIF_Y		(3)
E 36

I 30
D 36
#define	NETIF_BASE_LINES (6)
E 36
I 36
#define	NETIF_BOOT	(NETIF_Y+4)
#define	NETIF_SAMPLE	(NETIF_Y+12)
E 36

I 36
#define	NETIF_LINES 	(21)
#define	NETIF_WIDTH	(12)

E 36
E 30
E 28
I 19
D 21
/* ARGSUSED */
E 21
I 21
/*
 *	Setup for netif magnify function. 
 *
 *	ARGSUSED
 */
E 21
E 19
open_netif(op)
OPTION	*op ;
{
I 14
D 18
	register y = 5, lines = LINES - 6 ;
E 18
I 18
D 19
	register y = 5, lines = LINES - 6, n_netif = 0 ;
E 18
	struct mon_netif *np = netif ;
E 19
I 19
D 24
	register y = 5, lines = LINES - 6 ;
	struct mon_netif *np, *lastp ;
E 24
I 24
D 28
	register y = 5, lines = LINES - 6, i ;
E 28
I 28
D 30
	register y = NETIF_DATA, lines = LINES - 6, i ;
E 30
I 30
D 36
	register y = NETIF_DATA, max_lines = LINES - NETIF_BASE_LINES, i ;
E 36
I 36
	lines = NETIF_LINES ;
E 36
E 30
E 28
E 24
E 19

I 30
D 36
	lines = NETIF_BASE_LINES ;	/* +1 for dump_screen() */

E 36
E 30
E 14
D 22
	clear() ;
E 22
I 22
	sample_header() ;
E 22

D 22
	move(0, 0);

	printw("Elapsed Time:\n");
	printw("Timestamp:\n\n");
I 14

E 22
D 28
	printw("Netif:    ipkts   ierrs    opkts   oerrs   collis if_flags\n");
	printw("--------------------------------------------------------------------------------\n");
E 28
I 28
D 29
	wprintw(stdscr, "Netif:    ipkts   ierrs    opkts   oerrs   collis if_flags\n");
	wprintw(stdscr, "--------------------------------------------------------------------------------\n");
E 29
I 29
D 36
	wprintw(wp, "Netif:    ipkts   ierrs    opkts   oerrs   collis if_flags\n");
D 30
	wprintw(wp, "--------------------------------------------------------------------------------\n");
E 30
I 30
	wprintw(wp, "------------------------------------------------------------------------------\n");
E 30
E 29
E 28

D 19
	if( np == NULL )
		return ;
E 19
I 19
D 24
	lastp = netif + n_netif ;
E 24
I 24
	for(i = 0; i < n_netif; i++) {
D 28
		mvprintw(y, 0, "%s%d", netif[i].mon_name, netif[i].mon_unit);
E 28
I 28
D 29
		wmove(stdscr, y, 0) ;
		wprintw(stdscr, "%s%d", netif[i].mon_name, netif[i].mon_unit);
E 29
I 29
		wmove(wp, y, 0) ;
		wprintw(wp, "%s%d", netif[i].mon_name, netif[i].mon_unit);
E 29
E 28
E 24
E 19

D 19
	while( np ) {
I 18
		if( n_netif++ == first.mon_netif )
			break ;

E 19
I 19
D 24
	for(np = netif; np < lastp; np++) {
E 19
E 18
		mvprintw(y, 0, "%s%d", np->mon_name, np->mon_unit);

E 24
		y += 2 ;
D 30
		lines -= 2 ;
E 30
I 30
		max_lines -= 2 ;
		lines += 2 ;
E 30

D 30
		if( lines < 2 )
E 30
I 30
		if( max_lines < 2 )
E 30
			break ;
D 19

D 15
		if( op->display_mode == OPT_REPLAY )
E 15
I 15
		if( op->collect_mode == OPT_REPLAY )
E 15
			np++ ;
		else
			np = np->mon_next ;
E 19
	}
E 36
I 36
	wmove(wp, NETIF_Y, 0) ;
	wprintw(wp, "Interface\n\nSince boot (packets/sec.):\n\n") ;
	wprintw(wp, "Input\nInput errors\nOutput\nOutput errors\nCollisions\n\n") ;
	wprintw(wp, "Sample rate (packets/sec.):\n\n") ;
	wprintw(wp, "Input\nInput errors\nOutput\nOutput errors\nCollisions") ;
E 36
E 14
}

I 19
D 21
/* ARGSUSED */
E 21
I 21
/* 
 *	Network interface magnify function.
 *
 *	ARGSUSED
 */
E 21
E 19
magnify_netif(op)
OPTION	*op ;
{
I 14
D 19
	register struct mon_netif *np = netif ;
D 18
	register int	y = 5, lines = LINES - 6 ;
E 18
I 18
	register int	y = 5, lines = LINES - 6, n_netif = 0 ;
E 19
I 19
D 24
	register struct mon_netif *np, *lastp ;
	register int	y = 5, lines = LINES - 6 ;
I 22
	double	 etime = sample.mon_etime ;
E 24
I 24
D 36
	register y = 5, lines = LINES - 6, i ;
E 36
I 36
D 38
	register i, x = NETIF_X, limit, display ;
E 38
I 38
	register i, x = NETIF_X, limit ;
E 38
	char	 name[DEV_SIZE+11] ;
E 36
	double	 delta_netif(), etime ;
E 24
E 22
E 19
E 18

I 36
	limit = (cols - (NETIF_X + 2)) / NETIF_WIDTH ;
D 38
	display = 0 ;
E 38

E 36
E 14
D 22
	mvprintw(0, 14, "%.2f", sample.mon_etime);
	mvprintw(1, 14, "%24.24s", ctime(&sample.mon_timestamp));
E 22
I 22
D 25
	sample_body(14) ;
E 22
I 14

E 25
D 18
	if( np == NULL )
		return ;

E 18
D 19
	while( np ) {
E 19
I 19
D 24
	lastp = netif + n_netif ;

	for(np = netif; np < lastp; np++) {
E 24
I 24
D 38
	for(i = 0; i < n_netif; i++) {
E 38
I 38
	for(i = 0; i < n_netif && limit ; i++) {
E 38
E 24
E 19
D 16
		char	*flags, *comma, *rindex(), *str_netif() ;
E 16
I 16
D 36
		char	*flags, *comma ;
E 36
I 36
		if((netif[i].mon_flag & MON$M_VALID) == 0 )
			continue ;
I 38
		else
			limit-- ;
E 38
E 36
I 18

D 19
		if( n_netif++ == first.mon_netif )
			break ;
E 18
E 16

E 19
D 24
		flags = str_netif(np->mon_if_flags);
E 24
I 24
D 36
		flags = str_netif(netif[i].mon_if_flags);
E 36
I 36
		/*
		 *	Build a string for the name.
		 */
		(void)sprintf(name, "%s%d", netif[i].mon_name,
			netif[i].mon_unit) ;
E 36
E 24

D 36
		if( strlen(flags) > 26 )
D 21
			if((comma = rindex(flags, ',')) != NULL ) {
E 21
I 21
			if((comma = strrchr(flags, ',')) != NULL ) {
E 21
D 17
				sprintf(comma, "...");
E 17
I 17
				(void)sprintf(comma, "...");
E 17
				*(comma + 3) = '\0' ;
			}
			else
				flags = "Help me Savvik..." ;
E 36
I 36
		wmove(wp, NETIF_Y, x) ;
		wprintw(wp, "  %10s", name);
E 36

D 28
		mvprintw(y++, 7, "%8d %7d %8d %7d %8d <%s>",
E 28
I 28
D 29
		wmove(stdscr, y++, NETIF_OFFSET) ;
		wprintw(stdscr, "%8d %7d %8d %7d %8d <%s>",
E 29
I 29
D 36
		wmove(wp, y++, NETIF_OFFSET) ;
		wprintw(wp, "%8d %7d %8d %7d %8d <%s>",
E 29
E 28
D 24
			np->mon_ipackets, np->mon_ierrors,
			np->mon_opackets, np->mon_oerrors,
			np->mon_collisions, flags);
E 24
I 24
			netif[i].mon_ipackets, netif[i].mon_ierrors,
			netif[i].mon_opackets, netif[i].mon_oerrors,
			netif[i].mon_collisions, flags);
E 36
I 36
		/*
		 *	The elapsed time since boot.
		 */
		etime = sample.mon_ticks / first.mon_hz ;
E 36
E 24

D 28
		clrtoeol() ;
E 28
I 28
D 29
		wclrtoeol(stdscr) ;
E 29
I 29
D 36
		wclrtoeol(wp) ;
E 36
I 36
		/*
		 *	This is where all the "since boot" rates will
		 *	be printed.
		 */
		wmove(wp, NETIF_BOOT, x) ;
		wprintw(wp, "  %10.2f", netif[i].mon_ipackets / etime) ;
E 36
E 29
E 28

I 36
		wmove(wp, NETIF_BOOT+1, x) ;
		wprintw(wp, "  %10.2f", netif[i].mon_ierrors / etime) ;

		wmove(wp, NETIF_BOOT+2, x) ;
		wprintw(wp, "  %10.2f", netif[i].mon_opackets / etime) ;

		wmove(wp, NETIF_BOOT+3, x) ;
		wprintw(wp, "  %10.2f", netif[i].mon_oerrors / etime) ;

		wmove(wp, NETIF_BOOT+4, x) ;
		wprintw(wp, "  %10.2f", netif[i].mon_collisions / etime) ;

		/*
		 *	The elasped time since the last sample.
		 */
E 36
D 24
		delta_netif(np);
E 24
I 24
		etime = delta_netif(netif[i].mon_index, sample.mon_ticks);
E 24

D 22
		mvprintw(y++, 7, "%8d %7d %8d %7d %8d",
			np->mon_ipackets, np->mon_ierrors,
			np->mon_opackets, np->mon_oerrors,
			np->mon_collisions);
E 22
I 22
D 28
		mvprintw(y++, 7, "%8.0f %7.0f %8.0f %7.0f %8.0f",
E 28
I 28
D 29
		wmove(stdscr, y++, NETIF_OFFSET) ;
		wprintw(stdscr, "%8.0f %7.0f %8.0f %7.0f %8.0f",
E 29
I 29
D 36
		wmove(wp, y++, NETIF_OFFSET) ;
		wprintw(wp, "%8.0f %7.0f %8.0f %7.0f %8.0f",
E 29
E 28
D 24
			np->mon_ipackets / etime,
			np->mon_ierrors / etime,
			np->mon_opackets / etime,
			np->mon_oerrors / etime,
			np->mon_collisions / etime);
E 24
I 24
			netif[i].mon_ipackets / etime,
			netif[i].mon_ierrors / etime,
			netif[i].mon_opackets / etime,
			netif[i].mon_oerrors / etime,
			netif[i].mon_collisions / etime);
E 36
I 36
		/*
		 *	Then do all the sample rates.
		 */
		wmove(wp, NETIF_SAMPLE, x) ;
		wprintw(wp, "  %10.2f", netif[i].mon_ipackets / etime) ;
E 36
E 24
E 22

D 36
		lines -= 2 ;
E 36
I 36
		wmove(wp, NETIF_SAMPLE+1, x) ;
		wprintw(wp, "  %10.2f", netif[i].mon_ierrors / etime) ;
E 36

D 36
		if( lines < 2 )
E 36
I 36
		wmove(wp, NETIF_SAMPLE+2, x) ;
		wprintw(wp, "  %10.2f", netif[i].mon_opackets / etime) ;

		wmove(wp, NETIF_SAMPLE+3, x) ;
		wprintw(wp, "  %10.2f", netif[i].mon_oerrors / etime) ;

		wmove(wp, NETIF_SAMPLE+4, x) ;
		wprintw(wp, "  %10.2f", netif[i].mon_collisions / etime) ;
D 38

		if( display >= limit )
E 36
			break ;
I 36
		else
			display++ ;
E 38

		x += NETIF_OFFSET ;
E 36
D 19

D 15
		if( op->display_mode == OPT_REPLAY )
E 15
I 15
		if( op->collect_mode == OPT_REPLAY )
E 15
			np++ ;
		else
			np = np->mon_next ;
E 19
	}
I 25

	sample_body(etime) ;
I 36
}

/*
 *	Function to dump a NETIF record.
 */
f_netif(p)
struct mon_netif *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 37
	printf("%s.\n", records[MON$C_NETIF].rec_string) ;
E 37
I 37
	printf("%s.\n", records[MON$C_NETIF].string) ;
E 37

	printf("\tname:       %s%d\n", p->mon_name, p->mon_unit);
	printf("\tif_flags:   <%s>\n", str_netif(p->mon_if_flags));
	printf("\tipackets:   %d\n", p->mon_ipackets);
	printf("\tierrors:    %d\n", p->mon_ierrors);
	printf("\topackets:   %d\n", p->mon_opackets);
	printf("\toerrors:    %d\n", p->mon_oerrors);
	printf("\tcollisions: %d\n", p->mon_collisions);
	printf("\taddr:       %x\n", p->mon_ifnet);
E 36
E 25
E 14
E 13
I 6
}
D 7

/*
 *	How much did the network counters change...
 */
delta_netif(p)
register struct mon_netif *p ;
{
	register struct tot_netif *tp ;
	register tmp ;

	tp = p->mon_total ;

	tmp = p->mon_collisions ;
	      p->mon_collisions -= tp->t_collisions ;
	      tp->t_collisions = tmp ;

	tmp = p->mon_ipackets ;
	      p->mon_ipackets -= tp->t_ipackets ;
	      tp->t_ipackets = tmp ;

	tmp = p->mon_opackets ;
	      p->mon_opackets -= tp->t_opackets ;
	      tp->t_opackets = tmp ;

	tmp = p->mon_ierrors ;
	      p->mon_ierrors -= tp->t_ierrors ;
	      tp->t_ierrors = tmp ;

	tmp = p->mon_oerrors ;
	      p->mon_oerrors -= tp->t_oerrors ;
	      tp->t_oerrors = tmp ;
E 6
E 3
}
E 7
E 1
