h04842
s 00010/00000/00462
d D 1.35 90/03/29 16:17:17 alan 35 34
c The hack to fix the DECmumble include file problem.
e
s 00001/00001/00461
d D 1.34 89/02/25 10:10:21 alan 34 33
c editorial change to rec_ elements
e
s 00000/00014/00462
d D 1.33 89/02/17 17:03:33 alan 33 32
c moved get_command() constants to include.h
e
s 00114/00010/00362
d D 1.32 89/02/14 14:23:02 alan 32 31
c added arrow key support in menu
e
s 00005/00001/00367
d D 1.31 89/02/10 15:21:34 alan 31 30
c Change for new BUF record and RECONF record.
c 
e
s 00006/00075/00362
d D 1.30 89/01/15 20:38:36 alan 30 29
c changes for CPU, PAGE and SWAP
e
s 00012/00002/00425
d D 1.29 88/06/27 18:14:51 alan 29 28
c changed include of monitor.h and record.h
e
s 00004/00005/00423
d D 1.28 87/08/12 15:26:06 alan 28 27
c error message clean up - V0.95
e
s 00027/00002/00401
d D 1.27 87/08/10 21:27:23 alan 27 26
c See commentary on V0.92 in version.c
e
s 00030/00025/00373
d D 1.26 87/05/20 17:15:06 alan 26 25
c changed all curses calls to use w... versions
e
s 00025/00021/00373
d D 1.25 87/04/17 15:47:31 alan 25 24
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00001/00001/00393
d D 1.24 87/04/03 14:31:57 alan 24 23
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00005/00000/00389
d D 1.23 87/03/03 15:42:55 alan 23 22
c see the commentary for V0.83 in version.c
e
s 00000/00004/00389
d D 1.22 87/02/05 16:28:06 alan 22 21
c See comment on V0.81 in version.c.
c 
e
s 00004/00006/00389
d D 1.21 87/01/30 11:11:23 alan 21 20
c #2 and #3 of V0.75
e
s 00000/00034/00395
d D 1.20 87/01/28 18:42:07 alan 20 19
c V0.70
e
s 00004/00000/00425
d D 1.19 87/01/21 16:35:53 alan 19 18
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00019/00018/00406
d D 1.18 86/12/30 21:16:48 alan 18 17
c see commentary on V0.65
e
s 00049/00049/00375
d D 1.17 86/12/30 11:21:15 alan 17 16
c See commentary on V0.64 in version.c
e
s 00083/00027/00341
d D 1.16 86/12/24 23:32:15 alan 16 15
c See commentary on V0.63 in version.c.  Cpu.c may not have changed.
c 
e
s 00162/00058/00206
d D 1.15 86/12/17 14:26:05 alan 15 14
c see V0.62 in version.c
e
s 00007/00002/00257
d D 1.14 86/11/17 18:42:29 alan 14 13
c See commentary on V0.54 in version.c
c 
e
s 00000/00000/00259
d D 1.13 86/11/16 16:57:40 alan 13 12
c Previous reference should have been to V0.52.
c 
e
s 00004/00002/00255
d D 1.12 86/11/16 16:32:03 alan 12 11
c See comments for V0.51 in version.c
c 
e
s 00001/00001/00256
d D 1.11 86/08/26 18:04:54 alan 11 10
c modify all SccsId strings
e
s 00020/00001/00237
d D 1.10 86/08/21 13:02:05 alan 10 9
c Unmagnify no longer hoses the screen because it run the necessary
c delta functions.
c 
e
s 00001/00001/00237
d D 1.9 86/08/13 13:23:27 alan 9 8
c clean up panic message
e
s 00018/00003/00220
d D 1.8 86/07/31 13:20:29 alan 8 7
c 1.  Fixed bug that caused "unmagify" to produce a very off the wall error
c message and exit without cleaning up.
c 2.  Fixed bug in magnify that would cause a panic when selecting a non-
c existing function.
c 3.  Enhanced replay and options to remember what the original display
c functions for multi session save files.
c 
e
s 00003/00002/00220
d D 1.7 86/07/11 19:33:58 alan 7 6
c Dust off LOTS of lint...
c 
e
s 00039/00013/00183
d D 1.6 86/07/01 08:35:17 alan 6 5
c Added code to allow selection of only those records that have magnify
c functions and added entries for all records that I intend to
c have functions:
c 
c 	disk, cpu, netif, memory, freemem, proc, page, sample and fork
c 
e
s 00006/00002/00190
d D 1.5 86/06/30 17:33:40 alan 5 4
c added functions for fork and proc.  I need to add code that will only
c give magnify options for those records that have functions.
c 
e
s 00001/00001/00191
d D 1.4 86/06/30 08:45:59 alan 4 3
c Fix a bug in the initial help line.
c 
e
s 00045/00027/00147
d D 1.3 86/06/30 08:22:38 alan 3 2
c Added code for a generalized redraw_display function.
c 
e
s 00148/00003/00026
d D 1.2 86/06/29 15:27:12 alan 2 1
c Assorted work on the magnify function and general cleanup.
c 
e
s 00029/00000/00000
d D 1.1 86/06/24 17:14:34 alan 1 0
c date and time created 86/06/24 17:14:34 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - The general work of the magnify function.
 */
#ifndef	lint
D 11
static	char	SccsId[] = "%W% %G%" ;
E 11
I 11
D 14
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 14
I 14
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 14
E 11
#endif

I 29
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 30
 *
 * Jan. 15, 1989 -- arr
 *
 *	Move mag_array[] to tables.c
I 31
 *
 * Feb. 10, 1989 -- arr
 *
 *	Changed RECTYPE3 to RECONF.
I 32
 *
 * Feb. 14, 1989 -- arr
 *
 *	Added arrow key support.
I 35
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 35
E 32
E 31
E 30
 */

E 29
#include <curses.h>
I 2
#include <stdio.h>
E 2

I 2
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
I 15
#include <limits.h>
E 15

#include <sys/types.h>
I 19
D 21
#include <sys/devio.h>
E 21
E 19
#include <sys/dk.h>
I 19
#include <sys/param.h>
#include <sys/dir.h>
I 35

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 35
#include <sys/user.h>
E 19
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

I 21
D 22
#ifdef	V20
#	include <sys/devio.h>
#endif

E 22
E 21
D 29
#include "monitor.h"
E 29
I 29
#include "include.h"
E 29
D 24
#include "extern.h"
E 24
E 2
#include "options.h"
I 2
D 29
#include "record.h"
E 29
I 29
#include "monitor.h"
E 29
I 24
#include "extern.h"
E 24
E 2
D 21

I 14
/*
I 15
 *	Function's which don't return (int).
 */
double	delta_cpu() ;
E 21

/*
I 32
D 33
 *	Constants that get_command() returns.
 */
#define	G_UNKNOWN	(0)
#define	G_UP		(1)
#define	G_DOWN		(2)
#define	G_SELECT	(3)
#define	G_HELP		(4)
#define	G_REDRAW	(5)
#define	G_DUMP		(6)
#define	G_EXIT		(7)
#define	G_UNMAGNIFY	(8)
#define	G_MAGNIFY	(9)

/*
E 33
E 32
I 26
 *	Default display.
 */
I 27
extern	int	lines ;			/* length of screen being used. */
E 27
extern	WINDOW	*wp ;

/*
E 26
E 15
 *	Module name for error functions.
 */
static	char	*module = "magnify" ;

E 14
I 2
#define	Y_ORIG	2

I 15
/*
D 17
 *	Function declarations for the relational operators
 *	used by deltas().
 */
int	eq(), neq() ;

/*
E 17
D 30
 *	Function declarations for the array.
E 30
I 30
 *	This lives in tables.c
E 30
 */
E 15
D 3
int	open_sample() ;
int	magnify_sample() ;
E 3
I 3
D 6
int	open_sample(),
	open_memory(),		/* used for memory and free */
I 5
	open_process(),
E 6
I 6
D 30
int	open_cpu(),
I 17
	open_tty(),
E 17
	open_disk(),
E 6
	open_fork(),
E 5
D 6
	open_paging() ;
int	magnify_sample(),
	magnify_memory(),	/* used for memory and free */
E 6
I 6
	open_netif(),
	open_memory(),		/* used for memory and free */
	open_paging(),
	open_sample(),
	open_process() ;

I 23
int	redraw_pid() ;

E 23
int	magnify_cpu(),
I 23
	magnify_pid(),
E 23
I 17
	magnify_tty(),
E 17
	magnify_disk(),
E 6
I 5
	magnify_fork(),
D 6
	magnify_process(),
E 5
	magnify_paging() ;
E 6
I 6
	magnify_netif(),
	magnify_memory(),	/* used for memory and free */
	magnify_paging(),
	magnify_sample(),
	magnify_process() ;
E 6
E 3

I 17
D 18
int	help_cpu(),
E 18
I 18
int	help_screen(),
	help_cpu(),
I 23
	help_pid(),
E 23
E 18
	help_tty(),
	help_disk(), 
	help_fork(),
	help_netif(),
	help_memory(),	/* used for memory and free */
	help_paging(),
	help_sample(),
	help_process() ;

E 17
I 6
/*
 *	The mag_open function is used:
 *
 *	a.  To print the headers for that data record.
 *	b.  To determine if a function is available.  Only records with
 *	    a display function will show up on the list.
 *	c.  As the redraw function.
 *
 *	The mag_display function is used as the main display function.
 *	In the interests of better performance, it should only display
 *	what it has to.
 *
 *	There are no plans to ever have a magnify function for the user
 *	or loadave data records.
 */
E 6
struct {
	int	(*mag_open)(),
D 17
		(*mag_display)() ;
E 17
I 17
		(*mag_display)(),
		(*mag_help)() ;
E 17
} mag_array[] = {
D 3
	0, 0,					/* */
	0, 0,					/* */
E 3
I 3
D 17
	0, 0,					/* first */
	0, 0,					/* last */
E 3
	open_sample, magnify_sample,		/* sample */
D 3
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
	0, 0,					/* */
E 3
I 3
	0, 0,					/* record type 3 */
D 6
	0, 0,					/* cpu */
E 6
I 6
	open_cpu, magnify_cpu,			/* cpu */
E 6
	0, 0,					/* tty */
D 6
	0, 0,					/* disk */
E 6
I 6
	open_disk, magnify_disk,		/* disk */
E 6
	open_memory, magnify_memory,		/* free */
D 5
	0, 0,					/* fork */
E 5
I 5
	open_fork, magnify_fork,		/* fork */
E 5
	open_paging, magnify_paging,		/* page */
D 5
	0, 0,					/* proc */
E 5
I 5
	open_process, magnify_process,		/* proc */
E 5
	0, 0,					/* swap */
	0, 0,					/* tape */
	0, 0,					/* user */
D 6
	0, 0,					/* netif */
E 6
I 6
	open_netif, magnify_netif,		/* netif */
E 6
	open_memory, magnify_memory,		/* memory */
	0, 0,					/* loadave */
E 17
I 17
D 18
	0, 0, 0,				/* first */
	0, 0, 0,				/* last */
	open_sample, magnify_sample, 0,		/* sample */
	0, 0, 0,				/* record type 3 */
	open_cpu, magnify_cpu, 0,		/* cpu */
	open_tty, magnify_tty, 0,		/* tty */
	open_disk, magnify_disk, 0,		/* disk */
	open_memory, magnify_memory, 0,		/* free */
	open_fork, magnify_fork, 0,		/* fork */
	open_paging, magnify_paging, 0,		/* page */
	open_process, magnify_process, 0,	/* proc */
	0, 0, 0,				/* swap */
	0, 0, 0,				/* tape */
	0, 0, 0,				/* user */
	open_netif, magnify_netif, 0,		/* netif */
	open_memory, magnify_memory, 0,		/* memory */
	0, 0, 0,				/* loadave */
E 18
I 18
	0, 0, 0,					/* first */
	0, 0, 0,					/* last */
	open_sample, magnify_sample, help_screen,	/* sample */
	0, 0, 0,					/* record type 3 */
	open_cpu, magnify_cpu, help_screen,		/* cpu */
	open_tty, magnify_tty, help_screen,		/* tty */
	open_disk, magnify_disk, help_screen,		/* disk */
	open_memory, magnify_memory, help_screen,	/* free */
	open_fork, magnify_fork, help_screen,		/* fork */
	open_paging, magnify_paging, help_screen,	/* page */
	open_process, magnify_process, help_screen,	/* proc */
	0, 0, 0,					/* swap */
	0, 0, 0,					/* tape */
	0, 0, 0,					/* user */
	open_netif, magnify_netif, help_screen,		/* netif */
	open_memory, magnify_memory, help_screen,	/* memory */
	0, 0, 0,					/* loadave */
I 23
	redraw_pid, magnify_pid, help_screen,		/* pid */
E 23
E 18
E 17
E 3
};
E 30
I 30
extern struct magnify_table mag_array[] ;
E 30

E 2
/*
I 2
 *	This is the display function being used before magnify was
 *	called.  Magnify current assumes that the screen function
 *	is the only place that magnify will be called from.  This
 *	is not necessarily reasonable.
I 3
 *
D 10
 *	"Current_data" is used to remember what the current magnify
E 10
I 10
 *	"Current_function" is used to remember what the current magnify
E 10
 *	function is.  When there is no current magnify function
 *	it should be -1.
E 3
 */
static	(*display_function)() = 0 ;
I 3
static	(*redraw_function)() = 0 ;
I 17
static	(*help_function)() = 0 ;
E 17
static	current_function = -1 ;
E 3

/*
E 2
 *	Inquire of the user what he wants to magnify and select
 *	the approproiate output function.
 */
magnify(op)
OPTION	*op ;
{
D 2
	register c ;
E 2
I 2
D 15
	register i, command, y = Y_ORIG, lasty = Y_ORIG ;
	int	 data_selected = 0 ;
E 15
I 15
	register i, mask ;
	int	 choices[MON$N_RECORDS], n_choices = 0 ;
E 15
E 2

I 8
/*
D 15
 *	The first pass of the data flag is to determine if there
 *	are any magnify function to run.  If not, we'll return.
E 15
I 15
 *	Build a table which will map the indexs used by the
 *	simple menu into mag_array indexs.  If there is 
 *	only one entry in the table then use that function.
E 15
 */
D 15
	for(i = 0; i < sizeof(op->opt_data) * 8; i++)
E 15
I 15
	for(i = 0; i < sizeof(op->opt_data) * CHAR_BIT; i++)
E 15
		if((op->opt_data & (1 << i)) && mag_array[i].mag_open )
D 15
			lasty++ ;
E 15
I 15
			choices[n_choices++] = i ;
E 15

D 15
	if( lasty == Y_ORIG )
E 15
I 15
/*
 *	There isn't anything to magnify.
 */
	if( n_choices == 0 )
E 15
		return ;

I 15
/*
 *	Magnify the one choice.  The loop already verified that a
 *	function exists, so select_function WILL succede.
 */
	if( n_choices == 1 ) {
		if( select_function(1 << choices[0], op) == 0 )
D 28
			panic("function doesn't really exist.", module) ;
E 28
I 28
			panic("Function doesn't really exist!\n", module) ;
E 28

		return ;
	}

/*
 *	Run the menu until one of the options is selected.
 */
D 16
	mask = magnify_menu(op->opt_data, n_choices, choices) ;
E 16
I 16
	mask = magnify_menu(op, n_choices, choices) ;
E 16

/*
 *	Once again, we KNOW that there is a magnify function
 *	available if the mask is non-zero.
 */
	if( mask && select_function(mask, op) == 0 )
D 28
		panic("function doesn't really exist.", module) ;
E 28
I 28
		panic("Function doesn't really exist!\n", module) ;
E 28
}

/*
 *	A simple menu to select the magnify function from
 *	those available.  This function will either return
 *	a mask useable by select_function or zero.
 */
D 16
magnify_menu(flags, n_choices, choices)
int	flags, n_choices ;
E 16
I 16
magnify_menu(op, n_choices, choices)
int	n_choices ;
E 16
int	*choices ;
I 16
OPTION	*op ;
E 16
{
D 16
	int	i, lasty, command, y = Y_ORIG ;
E 16
I 16
D 27
	int	lasty, command, y = Y_ORIG ;
E 27
I 27
	int	lasty, command, y = Y_ORIG, save_lines ;
E 27
	FILE	*fp, *fopen() ;
E 16

I 27
	/*
	 *	Save the number of lines used by the previous
	 *	display function.
	 */
	save_lines = lines ;

E 27
D 16
	lasty = Y_ORIG + n_choices ;
E 16
I 16
	lasty = Y_ORIG + n_choices - 1 ;
E 16

E 15
E 8
D 2
	mvprintw(LINES-1, 0, "What do you want to magnify? ");
E 2
I 2
D 16
	clear() ;
E 16
I 16
	redraw_magnify(op->opt_data, y) ;
E 16

D 3
	mvprintw(0, 0, "Use 'j' to move up, 'k' to move down and 's' to select a record.");
E 3
I 3
D 4
	mvprintw(0, 0, "Use 'j' to move up, 'k' to move down, 's' to select a record and 'e' to exit.");
E 4
I 4
D 15
	mvprintw(0, 0, "Use 'j' to move down, 'k' to move up, 's' to select a record and 'e' to exit.");
E 15
I 15
D 16
	move(0, 0) ;
	printw("Use 'j' to move down, 'k' to move up, 's' to select a record and 'e' to exit.");
E 16
I 16
	for( ; ; ) {
D 32
		switch( command = getch()) {
		case 'h':
		case '?':
E 32
I 32
		switch( command = get_command()) {
		case G_HELP:
E 32
			help_magnify() ;
			/* yes, there isn't a break here. */
D 32
		case 'r':
E 32
I 32
		case G_REDRAW:
E 32
			redraw_magnify(op->opt_data, y) ;
			break ;
D 32
		case 'd':			/* screen dump */
E 32
I 32
		case G_DUMP:
E 32
			if((fp = fopen(op->opt_output, "a")) == NULL ) {
D 28
				warning("can't open output file: %s (%s).\n",
E 28
I 28
				warning("Can't open output file: %s (%s).\n",
E 28
					module, op->opt_output) ;
				continue ;
			}
E 16
E 15
E 4
E 3

D 16
	move(Y_ORIG, 0);
E 16
I 16
D 26
			dump_screen(fp);
E 26
I 26
			dump_screen(fp) ;
E 26
E 16

I 8
D 16
/*
D 15
 *	The second pass is to print out which are available.
E 15
I 15
 *	Print out which are available.
E 15
 */
E 8
D 15
	for(i = 0 ; i < sizeof(op->opt_data) * 8; i++)
D 6
		if( op->opt_data & (1 << i)) {
E 6
I 6
D 8
		if((op->opt_data & (1 << i)) && mag_array[i].mag_open ) {
E 6
			lasty++ ;
E 8
I 8
		if((op->opt_data & (1 << i)) && mag_array[i].mag_open )
E 15
I 15
	for(i = 0 ; i < sizeof(flags) * CHAR_BIT; i++)
		if((flags & (1 << i)) && mag_array[i].mag_open )
E 15
E 8
			printw("    %s\n", records[i].rec_string);
E 16
I 16
			if( fclose(fp) == EOF )
D 28
				warning("can't close dump file: %s.\n",
					module) ;
E 28
I 28
				warning("Can't close dump file: %s.\n", module) ;
E 28
E 16
D 8
		}
E 8

I 27
			/*
			 *	Clear the bottom line.
			 */
			wmove(wp, LINES - 1, 0) ;
			wclrtoeol(wp) ;

			/*
			 *	Redraw the cursor.
			 */
			wmove(wp, y, 0) ;
			wprintw(wp, "==>") ;

E 27
I 15
D 16
/*
 *	The true location of the last entry is kept so that
 *	the menu will wrap correctly.
 */
E 15
	lasty-- ;

	mvprintw(y, 0, "==>");

E 2
	refresh() ;
D 2
	c = getch() ;
E 2
I 2

	for( ; ; ) {
		switch( command = getch()) {
E 16
I 16
			break ;
E 16
D 32
		case 'j':			/* up */
		case 'k':			/* down */
E 32
I 32
		case G_UP:
		case G_DOWN:
E 32
D 25
			mvprintw(y, 0, "   ");
E 25
I 25
D 26
			wmove(stdscr, y, 0) ;
			wprintw(stdscr, "   ");
E 26
I 26
			wmove(wp, y, 0) ;
			wprintw(wp, "   ");
E 26
E 25

D 32
			if( command == 'j' )
E 32
I 32
			if( command == G_DOWN )
E 32
				y = (y == lasty) ? Y_ORIG : y + 1 ;
			else
				y = (y == Y_ORIG) ? lasty : y - 1 ;

D 25
			mvprintw(y, 0, "==>") ;
E 25
I 25
D 26
			wmove(stdscr, y, 0) ;
			wprintw(stdscr, "==>") ;
E 26
I 26
			wmove(wp, y, 0) ;
			wprintw(wp, "==>") ;
E 26

E 25
			break ;
D 15
		case 's':			/* select */
			if((command = select_data(y - Y_ORIG, op)) == 'e' )
				data_selected = 1 ;

			break ;
E 15
I 15
D 32
		case 's':			 /* select */
E 32
I 32
		case G_SELECT:
E 32
I 27
			lines = save_lines ;
E 27
			return 1 << choices[y - Y_ORIG] ;
D 32
		case 'e':
E 32
I 32
		case G_EXIT:
E 32
I 27
			lines = save_lines ;
E 27
			return 0 ;
E 15
		default:
			break ;
		}

D 25
		refresh() ;
E 25
I 25
D 26
		wrefresh(stdscr) ;
E 26
I 26
		wrefresh(wp) ;
E 26
E 25
D 15

		if( command == 'e' )
			break ;
E 15
	}
D 15

D 3
	if( data_selected == 0 )
		screen_redraw(op) ;
E 3
I 3
D 12
	if( data_selected == 0 && display_function == 0 )
		(*op->redraw_display)(op) ;
E 12
I 12
	if( data_selected == 0 && display_function == 0 ) {
		if( op->redraw_display )
			(*op->redraw_display)(op) ;
	}
E 12
	else
		(*mag_array[current_function].mag_open)(op) ;
E 15
E 3
}

I 32
/*
 *	Read characters and return a command based on the 
 *	input.  It tries to do the reasonable thing when
 *	it sees an ESC.  Currently it works for <HELP>,
 *	<SELECT>, the UP-ARROW and DOWN-ARROW.  It should
 *	be possible to generalize for the main loop input
 *	parser.
 */
get_command()
{
	register command, ch1, ch2 ;

	switch( getch() ) {
	case 'h':
	case '?':
		command = G_HELP ;
		break ;
	case 'r':
	case 12:
		command = G_REDRAW ;
		break ;
	case 'd':
		command = G_DUMP ;
		break ;
	case 'j':
		command = G_DOWN ;
		break ;
	case 'k':
		command = G_UP ;
		break ;
	case 's':
		command = G_SELECT ;
		break ;
	case 'e':
	case 'q':
		command = G_EXIT ;
		break ;
	case '\033':
		command = getch() ;

		if( command != '[' && command != 'O' )
			command = G_UNKNOWN ;
		else {
			switch( getch()) {
			case 'A':
				command = G_UP ;
				break ;
			case 'B':
				command = G_DOWN ;
				break ;
			case 'C':
				command = G_UNKNOWN ;
				break ;
			case 'D':
				command = G_UNKNOWN ;
				break ;
			case '4':
				if( getch() == '~' )
					command = G_SELECT ;
				else
					command = G_UNKNOWN ;

				break ;
			case '2':
				ch1 = getch() ;
				ch2 = getch() ;

				if( ch1 == '8' && ch2 == '~' )
					command = G_HELP ;
				else
					command = G_UNKNOWN ;

				break ;
			default:
				command = G_UNKNOWN ;
				break ;
			}
		}

		break ;
	default:
		command = G_UNKNOWN ;
		break ;
	}

	return command ;
}
E 32
I 6
/*
I 16
 *	Draw the initial menu.
 */
redraw_magnify(flags, y)
int	flags, y ;
{
	int	i ;

I 27
	lines = Y_ORIG ;

E 27
D 25
	clear() ;
E 25
I 25
D 26
	wclear(stdscr) ;
E 26
I 26
	wclear(wp) ;
E 26
E 25

D 25
	move(0, 0) ;
E 25
I 25
D 26
	wmove(stdscr, 0, 0) ;
E 26
I 26
	wmove(wp, 0, 0) ;
E 26
E 25
	
D 25
	printw("Type '?' or 'h' for help.") ;
E 25
I 25
D 26
	wprintw(stdscr, "Type '?' or 'h' for help.") ;
E 26
I 26
	wprintw(wp, "Type '?' or 'h' for help.") ;
E 26
E 25

D 25
	move(Y_ORIG, 0);
E 25
I 25
D 26
	wmove(stdscr, Y_ORIG, 0);
E 26
I 26
	wmove(wp, Y_ORIG, 0);
E 26
E 25

/*
 *	Print out which are available.
 */
	for(i = 0 ; i < sizeof(flags) * CHAR_BIT; i++)
D 27
		if((flags & (1 << i)) && mag_array[i].mag_open )
E 27
I 27
		if((flags & (1 << i)) && mag_array[i].mag_open ) {
E 27
D 25
			printw("    %s\n", records[i].rec_string);
E 25
I 25
D 26
			wprintw(stdscr, "    %s\n", records[i].rec_string);
E 26
I 26
D 34
			wprintw(wp, "    %s\n", records[i].rec_string);
E 34
I 34
			wprintw(wp, "    %s\n", records[i].string);
E 34
I 27
			lines++ ;
		}
E 27
E 26
E 25

	/*
	 *	Draw the pointer.
	 */
D 25
	mvprintw(y, 0, "==>");
E 25
I 25
D 26
	wmove(stdscr, y, 0) ;
	wprintw(stdscr, "==>") ;
E 26
I 26
	wmove(wp, y, 0) ;
	wprintw(wp, "==>") ;
E 26
E 25

D 25
	refresh() ;
E 25
I 25
D 26
	wrefresh(stdscr) ;
E 26
I 26
	wrefresh(wp) ;
E 26
E 25
}


/*
E 16
D 15
 *	Figure out what function the user wants and arrange for it
 *	and its open function to be called.
E 15
I 15
 *	The documentation says the error flag is -1.  Experience
 *	shows that the error flag is equal to 0.
E 15
 */
E 6
D 15
select_data(y, op)
int	y ;
E 15
I 15
#define	FFS_ERROR	0

/*
 *	Given a bit mask of possible magnify available, check
 *	each bit to see if there is a corresponding magnify
 *	function and set it up if there is.  If there isn't
 *	a function available return 0, otherwise a non-zero
 *	value.
 */
select_function(mask, op)
int	mask ;
E 15
OPTION	*op ;
{
D 15
	register i, rel = 0 ;
E 15
I 15
	int	bit ;
E 15

D 15
	for(i = 0; i < sizeof(op->opt_data)*8; i++)
D 6
		if( op->opt_data & (1 << i))
E 6
I 6
		if((op->opt_data & (1 << i)) && mag_array[i].mag_open )
E 6
			if( rel++ == y )
				break ;
E 15
I 15
	/*
	 *  1.  Turn off the control records, except sample.
	 */
D 31
	mask &= ~(MON$M_FIRST | MON$M_LAST | MON$M_RECTYPE3) ;
E 31
I 31
	mask &= ~(MON$M_FIRST | MON$M_LAST | MON$M_RECONF) ;
E 31
E 15

D 15
	if( i >= MON$K_PANIC )
D 7
		panic("monitor: select in magnify failed: no such option") ;
E 7
I 7
D 9
		panic("monitor: magnify: i >= MON$K_PANIC") ;
E 9
I 9
D 14
		panic("monitor: magnify: i >= MON$K_PANIC.\n") ;
E 14
I 14
		panic("i >= MON$K_PANIC.\n", module) ;
E 15
I 15
	/*
	 *	Until the mask is zero or a magnify function is
	 *	found get the first bit set and check for the
	 *	function.
	 */
	for( ; ; ) {
		if((bit = ffs(mask)) == FFS_ERROR )
			return 0 ;
E 15
E 14
E 9
E 7

D 15
	if( mag_array[i].mag_display == 0 ) {
D 7
		mvprintw(LINES-1, 0, "monitor: no magnify function: %s.\n",
E 7
I 7
		mvprintw(LINES-1, 0, "monitor: magnify: no function: %s.\n",
E 7
			records[i].rec_string);
E 15
I 15
		bit -= 1 ;
E 15
I 7

E 7
D 15
		refresh() ;
E 15
I 15
		if( mag_array[bit].mag_display )
			break ;
E 15

D 15
		return 's' ;
E 15
I 15
		mask &= ~(1 << bit) ;
E 15
	}

I 15
	/*
	 *	Remember the display functions the first time
	 *	magnify is called.
	 */
E 15
D 3
	display_function = op->display ;
E 3
I 3
	if( display_function == 0 ) {
		display_function = op->display ;
		redraw_function = op->redraw_display ;
I 17
		help_function = op->help_display ;
E 17
	}
E 3

D 3
	(*mag_array[i].mag_open)(op) ;

E 3
D 15
	op->display = mag_array[i].mag_display ;
I 3
	op->redraw_display = mag_array[i].mag_open ;
E 15
I 15
	/*
	 *	Setup the new display functions.
	 */
	op->display = mag_array[bit].mag_display ;
	op->open_display = mag_array[bit].mag_open ;
	op->redraw_display = mag_array[bit].mag_open ;
I 17
	op->help_display = mag_array[bit].mag_help ;
E 17
E 15
E 3

I 3
D 15
	current_function = i ;
E 15
I 15
	/*
	 *	Save the index of the new display functions.
	 */
	current_function = bit ;
E 15

E 3
D 15
	return 'e' ;
E 15
I 15
	return bit ;
E 15
}

/*
 *	Undo the effect of a magnify.
I 10
 *
 *	To prevent the various fields from overflowing we'll run
 *	the delta_...() functions.
E 10
 */
unmagnify(op)
OPTION	*op ;
{
I 10
D 15
	register i ;

E 15
E 10
I 8
	if( display_function == 0 )
		return ;
I 10

D 15
	if( op->opt_fork && current_function != MON$K_FORK )
E 15
I 15
D 20
	/*
	 *	Update the data when we go back.
	 */
D 17
	deltas(op, neq) ;
E 17
I 17
	deltas(op) ;
E 17

E 20
	op->display = display_function ;
	op->redraw_display = redraw_function ;
I 17
	op->help_display = help_function ;
E 17

D 17
	(*op->redraw_display)(op) ;
E 17
I 17
	if( op->redraw_display )
		(*op->redraw_display)(op) ;
E 17

D 17
	display_function = redraw_function = 0 ;
E 17
I 17
	display_function = redraw_function = help_function = 0 ;
E 17
	current_function = -1 ;
D 20
}

/*
 *	Call all of the delta functions that need to be
 *	called.  The relational operator is passed as
 *	function.
 */
D 17
deltas(op, funct)
E 17
I 17
deltas(op)
E 17
OPTION	*op ;
D 17
int	(*funct)() ;
E 17
{
	register i ;

D 17
	if( op->opt_fork && funct(current_function, MON$K_FORK))
E 17
I 17
	if( op->opt_fork && current_function != MON$K_FORK )
E 17
E 15
		delta_fork() ;

D 15
	if( op->opt_netif && current_function != MON$K_NETIF )
E 15
I 15
D 17
	if( op->opt_cpu && funct(current_function, MON$K_CPU))
E 17
I 17
	if( op->opt_cpu && current_function != MON$K_CPU )
E 17
		for(i = 0; i < n_cpu; i++)
			(void)delta_cpu(cpu + i) ;

D 17
	if( op->opt_netif && funct(current_function, MON$K_NETIF))
E 17
I 17
	if( op->opt_netif && current_function != MON$K_NETIF )
E 17
E 15
		for(i = 0; i < n_netif; i++)
			delta_netif(netif + i);

D 15
	if( op->opt_disk && current_function != MON$K_DISK )
E 15
I 15
D 17
	if( op->opt_disk && funct(current_function, MON$K_DISK))
E 17
I 17
	if( op->opt_disk && current_function != MON$K_DISK )
E 17
E 15
		for(i = 0; i < n_disk; i++)
			delta_disk(disk + i);

D 15
	if( op->opt_tty && current_function != MON$K_TTY )
E 15
I 15
D 17
	if( op->opt_tty && funct(current_function, MON$K_TTY))
E 17
I 17
	if( op->opt_tty && current_function != MON$K_TTY )
E 17
E 15
		delta_tty() ;
E 20
I 15
}
E 15
E 10

E 8
D 3
	screen_redraw(op) ;

E 3
D 15
	op->display = display_function ;
I 3
	op->redraw_display = redraw_function ;
E 15
I 15
D 17
eq(a, b)
{
	return a == b ;
}
E 15
E 3

D 3
	display_function = 0 ;
E 3
I 3
D 15
	(*op->redraw_display)(op) ;

	display_function = redraw_function = 0 ;
	current_function = -1 ;
E 15
I 15
neq(a, b)
{
	return a != b ;
I 16
}

E 17
I 17
/*
 *	Help function for the magnify menu.
 */
E 17
help_magnify()
{
D 25
	clear() ;
E 25
I 25
D 26
	wclear(stdscr) ;
E 26
I 26
	wclear(wp) ;
E 26
E 25

D 25
	move(0, 0) ;
	printw("Help - Magnify menu.\n\n") ;
E 25
I 25
D 26
	wmove(stdscr, 0, 0) ;
	wprintw(stdscr, "Help - Magnify menu.\n\n") ;
E 26
I 26
	wmove(wp, 0, 0) ;
	wprintw(wp, "Help - Magnify menu.\n\n") ;
E 26
E 25

D 25
	printw("\t'j' - Move the cursor down.\n") ;
	printw("\t'k' - Move the cursor up.\n") ;
	printw("\t'd' - Dump a copy of the screen.\n") ;
	printw("\t's' - Select a record.\n") ;
	printw("\t'r' - Redraw the screen.\n") ;
	printw("\t'h' - This help screen.\n") ;
	printw("\t'?' - This help screen.\n") ;
	printw("\t'e' - Return to the previous display.\n\n") ;
E 25
I 25
D 26
	wprintw(stdscr, "\t'j' - Move the cursor down.\n") ;
	wprintw(stdscr, "\t'k' - Move the cursor up.\n") ;
	wprintw(stdscr, "\t'd' - Dump a copy of the screen.\n") ;
	wprintw(stdscr, "\t's' - Select a record.\n") ;
	wprintw(stdscr, "\t'r' - Redraw the screen.\n") ;
	wprintw(stdscr, "\t'h' - This help screen.\n") ;
	wprintw(stdscr, "\t'?' - This help screen.\n") ;
	wprintw(stdscr, "\t'e' - Return to the previous display.\n\n") ;
E 26
I 26
	wprintw(wp, "\t'j' - Move the cursor down.\n") ;
	wprintw(wp, "\t'k' - Move the cursor up.\n") ;
	wprintw(wp, "\t'd' - Dump a copy of the screen.\n") ;
	wprintw(wp, "\t's' - Select a record.\n") ;
	wprintw(wp, "\t'r' - Redraw the screen.\n") ;
	wprintw(wp, "\t'h' - This help screen.\n") ;
	wprintw(wp, "\t'?' - This help screen.\n") ;
	wprintw(wp, "\t'e' - Return to the previous display.\n\n") ;
E 26
E 25

D 17
	mvprintw(LINES-1, 0, "Type any character to continue> ") ;

	refresh() ;

	(void)getch() ;
E 17
I 17
	continue_prompt() ;
E 17
E 16
E 15
E 3
E 2
}
E 1
