h62097
s 00005/00001/00848
d D 1.60 90/08/21 22:43:21 alan 60 59
c dust off lint
e
s 00010/00000/00839
d D 1.59 90/03/29 16:16:29 alan 59 58
c The hack to fix the DECmumble include file problem.
e
s 00001/00001/00838
d D 1.58 89/12/28 15:43:07 alan 58 57
c Changed uses of vmunix to op->opt_kernel and setup opt_kernel correctly.
c 
e
s 00007/00011/00832
d D 1.57 89/12/27 11:35:26 alan 57 56
c move tty stuff to tty.c
e
s 00009/00010/00834
d D 1.56 89/12/25 19:34:12 alan 56 55
c cleaned up namelist stuff
e
s 00047/00045/00797
d D 1.55 89/12/25 15:35:32 alan 55 54
c Merge in V4.0 changes to base code
e
s 00001/00001/00841
d D 1.54 89/05/18 15:11:12 alan 54 53
c fix another occurance of n_type in a namelist check
e
s 00005/00000/00837
d D 1.53 89/05/13 16:39:00 alan 53 52
c fixed the way context switches on the PMAX were collected
e
s 00006/00001/00831
d D 1.52 89/04/30 18:54:52 alan 52 51
c dust off lint from adding new elapsed time code
e
s 00080/00013/00752
d D 1.51 89/04/28 23:26:12 alan 51 50
c added code to use gettimeofday()
e
s 00034/00021/00731
d D 1.50 89/03/11 16:00:37 alan 50 49
c changed the structure of mon_fork and the other changes that required
e
s 00001/00001/00751
d D 1.49 89/02/25 09:56:49 alan 49 48
c editorial change to rec_ elements
e
s 00002/00000/00750
d D 1.48 89/02/16 19:03:08 alan 48 47
c convert pgtok() and btok() macros to functions that uses data set in the FIRST record
e
s 00006/00001/00744
d D 1.47 89/02/15 19:28:31 alan 47 46
c properly set mon_flag in all records
e
s 00003/00000/00742
d D 1.46 89/02/13 17:41:03 alan 46 45
c fixed bug that didn't set first.mon_buf
e
s 00013/00013/00729
d D 1.45 89/02/10 15:21:11 alan 45 44
c Change for new BUF record and RECONF record.
c 
e
s 00001/00003/00741
d D 1.44 89/01/29 10:03:34 alan 44 43
c dusted off lint
e
s 00010/00000/00734
d D 1.43 89/01/16 18:53:14 alan 43 42
c pound out bugs in the data collection for swap, namei cache and buffer cache
e
s 00083/00048/00651
d D 1.42 89/01/16 16:07:02 alan 42 41
c Added code and data namei and buffer cache.
c 
e
s 00069/00003/00630
d D 1.41 89/01/15 20:38:24 alan 41 40
c changes for CPU, PAGE and SWAP
e
s 00037/00040/00596
d D 1.40 89/01/04 10:54:38 alan 40 39
c V1.1 changes for MIPS support.  This is a check-point of the support
e
s 00009/00003/00627
d D 1.39 88/07/04 16:41:34 alan 39 38
c see Mods for July 4, 1988
e
s 00064/00004/00566
d D 1.38 88/06/29 23:30:55 alan 38 37
c See the modification history for 29-June-1988.
c 
e
s 00012/00002/00558
d D 1.37 88/06/27 18:14:41 alan 37 36
c changed include of monitor.h and record.h
e
s 00005/00000/00555
d D 1.36 88/03/17 14:34:31 alan 36 35
c fixed length problem of Ultrix version string
e
s 00003/00003/00552
d D 1.35 87/11/18 16:39:31 alan 35 34
c V0.99 -> T1.0-1
e
s 00010/00000/00545
d D 1.34 87/11/18 12:16:44 alan 34 33
c V0.98
e
s 00002/00002/00543
d D 1.33 87/08/12 15:25:41 alan 33 32
c error message clean up - V0.95
e
s 00099/00116/00446
d D 1.32 87/04/03 13:15:34 alan 32 31
c Removed V20 dependencies, generally cleaned things up and rearranged
c include files that they compile under VAXC.  For some reason they
c don't run.
c 
e
s 00145/00080/00417
d D 1.31 87/03/03 15:42:20 alan 31 30
c see the commentary for V0.83 in version.c
e
s 00002/00012/00495
d D 1.30 87/02/05 16:27:55 alan 30 29
c See comment on V0.81 in version.c.
c 
e
s 00003/00023/00504
d D 1.29 87/02/02 16:22:16 alan 29 28
c V0.79 in version.c
e
s 00047/00018/00480
d D 1.28 87/01/21 16:35:37 alan 28 27
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00015/00043/00483
d D 1.27 86/12/07 22:22:38 alan 27 26
c See V0.57 in version.c
e
s 00001/00001/00525
d D 1.26 86/11/19 09:40:04 alan 26 25
c See commentary on V0.56 in version.c
c 
e
s 00002/00002/00524
d D 1.25 86/11/18 12:41:42 alan 25 24
c See commentary on V0.55 in version.c
c 
e
s 00105/00096/00421
d D 1.24 86/11/17 17:03:40 alan 24 23
c See V0.53 in version.c.
c 
e
s 00001/00001/00516
d D 1.23 86/08/26 18:04:12 alan 23 22
c modify all SccsId strings
e
s 00006/00006/00511
d D 1.22 86/07/31 14:07:31 alan 22 21
c Change many fprintf's to info's and add arguments to assorted warning and
c fatal error messages.
c 
e
s 00025/00039/00492
d D 1.21 86/07/30 17:27:50 alan 21 20
c Much code changed.  Most of it involved turning disks and tapes into array
c instead of linked lists, and netif and cpu in dynamically allocated arrays.
c I also combined some of the I/O vector code into one place and changed all
c the various references.
c 
c The code at this point is reasonably lint free but needs a LOT of clean up
c work.  There is a lot of inconsistant usage of "first.mon_..." and "n_...".
c 
c TODO: All the code needs to looked over and cleaned up.  The "total"
c structure for disks and tapes need to become static instead of dynamic.
c I need to merge the stack code into the approproiate mba and uba code.
c 
c The multiple CPU code needs to be tested.  I can probably simulate a
c save file from a Multiple CPU run, but...
c 
e
s 00000/00000/00531
d D 1.20 86/07/27 14:09:26 alan 20 19
c Convert CPU's to array's instead of linked lists.  I also cleaned up some
c lint in the process.  Disks and tapes will be next...
c 
e
s 00001/00001/00530
d D 1.19 86/07/13 14:39:58 alan 19 18
c dust off even more lint
e
s 00015/00011/00516
d D 1.18 86/07/11 19:31:53 alan 18 17
c Dust off LOTS of lint...
c 
e
s 00002/00002/00525
d D 1.17 86/07/01 12:56:16 alan 17 16
c Since delta_fork and delta_tty always know where their data structure
c is, I removed the argument and replace it with the external reference.
c 
e
s 00000/00003/00527
d D 1.16 86/06/30 17:14:59 alan 16 15
c Fixed bug that was causing _cp_time not to be collected unless disk or
c tty were options.
c 
e
s 00001/00001/00529
d D 1.15 86/06/29 12:57:32 alan 15 14
c fix typo
e
s 00015/00003/00515
d D 1.14 86/06/27 16:41:47 alan 14 13
c Moved the initialization of the first record from save.c to live.c
c 
e
s 00014/00031/00504
d D 1.13 86/06/24 08:34:54 alan 13 12
c Move the various version of mon_etime into the sample record.
c 
e
s 00002/00001/00533
d D 1.12 86/06/16 13:54:13 alan 12 11
c make call to live_cpu dependent on the optioni being turned on.
e
s 00003/00018/00531
d D 1.11 86/06/14 18:04:59 alan 11 10
c More first pass of adding multi-processor support.  I moved the code
c for collecting live CPU data from live.c to cpu.c.  I also added
c a check on "maxcpu" to determine if this is a pre-V1.2 system or V2.0
c system.
c 
e
s 00001/00008/00548
d D 1.10 86/06/12 14:19:49 alan 10 9
c Continued first pass of adding multi-processor code.
c 1.  Removed references to mon_rate.
c 
e
s 00002/00002/00554
d D 1.9 86/05/30 16:28:16 alan 9 8
c Added checks and return to do the "right" thing with MON_NORMAL, MON_EXIT
c and MON_CONTINUE.
c 
e
s 00002/00001/00554
d D 1.8 86/05/29 14:37:48 alan 8 7
c fix bug that was causing users() to be called even if opt_user wasn't
c turned on.
c 
e
s 00017/00001/00538
d D 1.7 86/05/29 11:16:16 alan 7 6
c Changes to incorporate addition of users.
c 
e
s 00002/00001/00537
d D 1.6 86/05/28 16:43:34 alan 6 5
c Save elasped time in netif structures.
c 
e
s 00010/00012/00528
d D 1.5 86/05/28 15:57:43 alan 5 4
c First pass of changes in order to get data selection to work.  Data
c selection during the replay function still needs to be written.
c 
c 1.  Due to the heavy use of the code like:
c 
c 	if( nel ) {
c 		p = sprintf(buf, "%s%d", name, unit);
c 
c 		if( !bsearch(&p, base, nel, sizeof(key *), compare))
c 			;
c 	}
c I sould impliment it as a function somewhere.  Probably in the 2nd or
c third pass.
c 
e
s 00003/00003/00537
d D 1.4 86/05/26 19:24:39 alan 4 3
c Bug fixes caused by changes to record.h
c 
e
s 00033/00022/00507
d D 1.3 86/05/26 15:53:30 alan 3 2
c I combined the mon_state and mon_cpu structures into one (mon_cpu) which
c is supposed to be all the system data that is kept on a per CPU basis.
c See record.h for more info.  Most of the changes that occured in the files
c were a result of removing references to mon_state and opt_state.
c 
c Other changes unrelated to this:
c 1.  Changed NM_PAGE to NM_RATE.  This was in three files, monitor.h and
c     two of the others.
c 2.  I added loop for the collecting the "tape" data to save.c.  This is
c     a very short loop since there is no tape data in the system.
c 
e
s 00000/00002/00529
d D 1.2 86/05/26 14:14:00 alan 2 1
c dust off some (not all) lint
e
s 00531/00000/00000
d D 1.1 86/05/24 19:55:48 alan 1 0
c date and time created 86/05/24 19:55:48 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 24
 *	%M% - This file contains code for collecting system data.  It will
 *	fill the structure (or structures) provided based on the "options"
 *	argument.
E 24
I 24
 *	%M% - This file contains code for collecting system data.
 *	It will fill the structure (or structures) provided based 
 *	on the "options" argument.
E 24
 *
 *	Derived from:
 *
 *		@(#)gather.c	1.17 5/24/86
 */
#ifndef	lint
D 23
static	char	SccsId[] = "%W% %G%" ;
E 23
I 23
D 24
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 24
I 24
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 24
E 23
#endif

I 37
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 38
 *
 * 29-June-1988 -- arr
 *
 *	Added code from pid.c to setup for process data collection.
 *	This changed open_live(), close_live() and added setup_proc()
 *	to live().
 *
 *	Added a call to collect_pid() if opt_pid is turned on.
 *
 *	Added a check on opt_data to see if it was necessary to
 *	call collect_kernel().
 *
 *	Dust of some acculated lint.
I 39
 *
 *  1-July-1988 -- arr
 *
 *	Allow live() to collect other data when opt_pid is turned
 *	on.  Live() will return MON_EXIT whenever collect_pid()
 *	does.
I 40
 *
 * 29-November-1988 -- arr
 *
 *	Fix the load average code to work on the PMAX.
 *
 *  2-December-1988 -- arr
 *
 *	Fix disk data collection code to work on the PMAX.
I 41
 *
 *  Jan. 5, 1989 -- arr
 *
 *	Fixed collection of paging data to understand the individual
 *	fields.
 *
 * Jan. 15, 1989 -- arr
 *
 *	Run the swap space collection functions.
 *
D 45
 *	TODO: Check namelist for swap space stuff.
E 45
I 45
 * Feb. 10, 1989 -- arr
 *
 *	Added a case for BUF records to the switch that calculates
 *	the size of a record.
I 47
 *
 * Feb. 15, 1989 -- arr
 *
 *	Correctly set mon_flag with MON$M_VALID (in FIRST and SAMPLE).
I 50
 *
 * March 11, 1989 -- arr
 *
 *	Changed needed for change to mon_fork structure in monitor.h.
I 51
 *
 * April 28, 1989 -- arr
 *
 *	Added a new method of collecting the number of clock ticks
 *	the system has been running.  This was added in anticipation
 *	of SMP Ultrix.  It's currently turned by the USE_GETTIMEOFDAY
 *	constant.
I 55
 *
 * November 1989 -- arr
 *
 *	Changes for CPU data structures on SMP systems.
 *
 * Dec. 25, 1989 -- arr
 *
 *	Added a data structure needed to fully resolve all the
 *	different ways of tracking devices.
I 56
 *
 *	Cleaned up namelist setup and checking for private namelists.
I 57
 *
 * Dec. 27, 1989 -- arr
 *
 *	Move tty namelist check and collection to tty.c.
I 59
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 59
E 57
E 56
E 55
E 51
E 50
E 47
E 45
E 41
E 40
E 39
E 38
 */

E 37
#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
I 28
D 30
#include <sys/devio.h>
E 30
E 28
#include <sys/dk.h>
I 28
#include <sys/param.h>
#include <sys/dir.h>
I 59

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 59
#include <sys/user.h>
E 28
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
I 55

#ifdef	V4_ULTRIX
#	include <sys/namei.h>
#endif
E 55
I 40
#ifdef	mips
#	include <sys/fixpoint.h>
#endif
E 40

#include <net/if.h>
#include <netinet/in.h>

D 37
#include "monitor.h"
E 37
I 37
#include "include.h"
E 37
D 32
#include "extern.h"
E 32
#include "options.h"
D 37
#include "record.h"
E 37
I 37
#include "monitor.h"
E 37
I 32
#include "extern.h"
E 32

I 24
/*
I 38
 *	The list of data options that collect_kernel() will
 *	want to look at.
 */
#define	MON$M_KERNEL	(MON$M_CPU | MON$M_TTY | MON$M_DISK | MON$M_FORK | \
			 MON$M_FREE | MON$M_PAGE | MON$M_PROC | MON$M_MEMORY | \
D 42
			 MON$M_LOADAVE)
E 42
I 42
			 MON$M_LOADAVE | MON$M_NAMEI )
E 42

/*
E 38
 *	The module name for the error functions.
 */
static	char	*module = "live" ;

I 27
/*
 *	Declarations for function that don't return (int).
 */
E 27
E 24
I 18
char	*strcpy() ;

I 27
void	exit(),
	nlist() ;

long	time() ;

E 27
E 18
/*
I 28
 *	The record version is declared and maintained in version.c.
 *	This is the only other file that uses it.
 */
extern	dev_t	record_version ;

/*
I 38
 *	These get used from open_live() and close_live().
 */
extern	int	mem, swap ;

/*
E 38
E 28
 *	Most of the kernel data will be read directly into the
 *	mon_... structures.  However some of it needs to shuffled
 *	off to a variety of places.  These are the objects for that
 *	info.
 */
D 50
struct vmtotal	Total ;
D 27
struct vmmeter	Rate ;
E 27
I 27
D 32
struct vmmeter	Rate, Sum ;
E 32
I 32
D 41
struct vmmeter	Sum ;
E 41
I 41
struct vmmeter	Sum, Rate ;
I 42
struct nchstats nchstats ;
E 42
E 41
E 32
I 28
int		free_memory ;
E 28
E 27
long		current[CPUSTATES] ;
D 32
int		dk_busy ;
E 32
long		dk_time[DK_NDRIVE] ;
long		dk_seek[DK_NDRIVE] ;
long		dk_xfer[DK_NDRIVE] ;
long		dk_wds[DK_NDRIVE] ;
E 50
I 50
struct vmtotal	 Total ;
struct vmmeter	 Sum, Rate ;
struct nchstats  Namei ;
struct forkstat  Fork ;
int		 free_memory ;
D 52
long		 current[CPUSTATES] ;
E 52
long		 dk_time[DK_NDRIVE] ;
long		 dk_seek[DK_NDRIVE] ;
long		 dk_xfer[DK_NDRIVE] ;
long		 dk_wds[DK_NDRIVE] ;
I 55
/*
 *	This could be done as a bitmap.  It is used to keep
 *	track of what disks have been found.  It's kept here
 *	because this is where data for the other dk_xxx[]
 *	arrays are.
 */
char		 dk_map[DK_NDRIVE] ;
E 55
E 50

I 52
D 55
#ifndef	USE_GETTIMEOFDAY
long		 current[CPUSTATES] ;
#endif

E 55
E 52
/*
I 40
 *	Space for the load average.
 */
D 56
#ifdef	mips
fix		avenrun[MON$N_LOADAVE] ;
#endif
E 56
#ifdef	vax
D 56
double		avenrun[MON$N_LOADAVE] ;
E 56
I 56
	double	avenrun[MON$N_LOADAVE] ;
#elif 	mips
	fix	avenrun[MON$N_LOADAVE] ;
E 56
#endif

/*
E 40
D 29
 *	Other local data and declarations.
 */
D 18
static	double	elapsed_time = 0.0 ;
E 18
D 28
static	long	prev_time[CPUSTATES] ;
E 28
I 28
static	long	prev_ticks = 0 ;
E 28
D 2
static	int	passno = 0 ;

E 2

/*
E 29
D 32
 *	Table of stuff to read.  The "flag" can be used to determine
D 5
 *	if the data is available.  There are will probably be more than
 *	version of this table.  One for "static" data and the other for
 *	"dynamic" data.  This is the "dynamic" data table.  The NM_
 *	#define's can be used as indexes into the dynamic data table
 *	because all the dynamic data appears at the beginning and is
 *	in the correct order.  If any dynamic data is added all the
 *	indexs will need to change accordingly.
E 5
I 5
 *	if the data is available.
 *
 *	This is the "dynamic" data table.  The NM_ #define's can be used 
 *	as indexes into the dynamic data table because all the dynamic 
 *	data appears at the beginning and is in the correct order.  If 
 *	any dynamic data is added all the indexs will need to change 
 *	accordingly.
E 5
 */

/*
 *	These are macro's to make the table below more readable.
D 5
 *
 *	I hope.
E 5
 */
#define	NORMAL(name, where, flag) \
	{ (char *)&(name), sizeof((name)), (where), (flag), }

#define	ARRAY(name, where, flag) \
	{ (char *)(name), sizeof((name)), (where), (flag), }

struct	{
	char	*addr ;		/* address of target */
	int	len ;		/* length of data */
	long	where ;		/* value of namelist entry */
	int	flag ;		/* misc */
} dynamic[] = {
D 28
	NORMAL(freemem.mon_freemem, 0, 1),
	NORMAL(Total, 		    0, 1),
E 28
I 28
	NORMAL(free_memory, 0, 1),
	NORMAL(Total, 	    0, 1),
I 31
/*
 *	This used to be the entry for the time in CPU states data
 *	which is now ALWAYS collected.  It was necessary to keep
 *	the numbering of the other entries in sync.
 */
	{ 0, 0, 0, 0 },
E 31
E 28

D 31
	ARRAY(current,		   0, 1),
	ARRAY(loadave.mon_loadave, 0, 1),
	NORMAL(Rate, 		   0, 1),
I 27
	NORMAL(Sum, 		   0, 1),
E 27
	NORMAL(page.mon_deficit,   0, 1),
D 26
	NORMAL(fork.mon_fork,      0, 1),
E 26
I 26
	NORMAL(forkstat.mon_fork,  0, 1),
E 31
I 31
	ARRAY(loadave.mon_loadave,   0, 1),
	NORMAL(Rate, 		     0, 1),
	NORMAL(Sum, 		     0, 1),
	NORMAL(mon_page.mon_deficit, 0, 1),
	NORMAL(mon_fork.mon_fork,    0, 1),
E 31
E 26

	(char *)&dk_busy,	sizeof(dk_busy), 0, 1, 
	(char *)dk_time,	sizeof(dk_time), 0, 1,
	(char *)dk_seek,	sizeof(dk_seek), 0, 1,
	(char *)dk_xfer,	sizeof(dk_xfer), 0, 1,
	(char *)dk_wds,		sizeof(dk_wds),  0, 1, 

	(char *)&tty.mon_ttyin,  sizeof(tty.mon_ttyin),  0, 1,
	(char *)&tty.mon_ttyout, sizeof(tty.mon_ttyout), 0, 1,
};

/*
E 32
D 24
 *	Initialize static data, verify options vs. namelist to see what
 *	can really be collected.  We also make one pass on the kernel and
 *	run the delta functions for disks, netif, forks and ttys.  Tapes
 *	will be added once they are needed.
E 24
I 24
 *	Initialize the static data, verify the options vs. the 
 *	namelist to see what can really be collected.  We also 
 *	make one pass on the kernel and run the delta functions 
D 32
 *	for disks, netif, forks and ttys.  Tapes will be added 
 *	once they are needed.
E 32
I 32
 *	for disks, netif, forks and ttys. 
E 32
E 24
 */
open_live(op)
OPTION	*op ;
{
D 32
	int	i, save() ;

E 32
D 24
/*
 *	Initialize the namelist.
 */
E 24
I 24
	/*
D 56
	 *	Initialize the namelist.
E 56
I 56
	 *	Initialize the namelist.  If the data collection
	 *	functions with private namelist are the only ones
	 *	used this doesn't need to be called.  I'll have to
	 *	work on that.
E 56
	 */
E 24
D 58
	nlist("/vmunix", namelist);		/* no error returned */
E 58
I 58
	nlist(op->opt_kernel, namelist);	/* no error returned */
E 58

D 24
/*
 *	Open /dev/kmem.
 */
E 24
I 24
	/*
	 *	Open /dev/kmem.
	 */
E 24
	if((kmem = open("/dev/kmem", O_RDONLY, 0)) == -1 )
D 18
		fatal("monitor: can't open /dev/kmem: %s.\n");
E 18
I 18
D 25
		fatal("monitor: live: can't open /dev/kmem: %s.\n");
E 25
I 25
D 33
		fatal("can't open /dev/kmem: %s.\n", module);
E 33
I 33
		fatal("Can't open /dev/kmem: %s.\n", module);
E 33
E 25
E 18

D 24
/*
I 7
 *	Open the system who file (/etc/wtmp, but it should be kept in
 *	memory somewhere).  If we can't open the file for some reason
 *	print an error message (in open_whofile()) and turn off the
 *	option.
 */
E 24
I 24
	/*
I 38
	 *	If we're collecting data on processes, open /dev/mem
	 *	and /dev/drum.
	 */
	if( op->opt_pid ) {
		if((mem = open("/dev/mem", O_RDONLY, 0)) == -1 )
			fatal("Can't open /dev/mem: %s.\n", module);

		if((swap = open("/dev/drum", O_RDONLY, 0)) == -1 )
			fatal("Can't open /dev/drum: %s.\n", module);
	}

	/*
E 38
	 *	Open the system who file (/etc/wtmp, but it should be kept in
	 *	memory somewhere).  If we can't open the file for some reason
	 *	print an error message (in open_whofile()) and turn off the
	 *	option.
	 */
E 24
	if( op->opt_user )
		if( open_whofile() == -1 )
			op->opt_user = 0 ;

D 24
/*
E 7
 *	Check the contents of the namelist and turn off the options
 *	that we can't access information for.
 */
E 24
I 24
	/*
	 *	Check the contents of the namelist and turn off the options
	 *	that we can't access information for.
	 */
E 24
	check_namelist(op) ;

D 24
/*
 *	Initialize the dynamic array namelist info.
 */
E 24
I 24
	/*
I 41
D 42
	 *
E 42
I 42
	 *	Do the setup stuff for swap space.  This also checks
	 *	the namelist.
E 42
	 */
	if( op->opt_swap )
D 42
		setup_swap() ;
E 42
I 42
		setup_swap(op) ;
E 42

	/*
I 42
	 *	Do the setup stuff for swap space.  This also checks
	 *	the namelist.
	 */
	if( op->opt_buf )
D 44
		setup_buf(op) ;
E 44
I 44
		setup_buf() ;
E 44

	/*
E 42
E 41
D 32
	 *	Initialize the dynamic array namelist info.
	 */
E 24
	for(i = 0; i < sizeof(dynamic)/sizeof(dynamic[0]); i++)
		dynamic[i].where = (long)namelist[i].n_value ;

D 24
/*
 *	Collect the static info.
 */
E 24
I 24
	/*
E 32
	 *	Collect the static info.
	 */
E 24
	collect_static(op);

D 24
/*
 *	This is where we look at the data options and figure out what
 *	items from the name list we can turn off.
 */
E 24
I 24
	/*
D 32
	 *	This is where we look at the data options and figure
	 *	out what items from the name list we can turn off.
E 32
I 32
	 *	Set all the fields in the first record.
E 32
	 */
E 24
D 32
	check_options(op) ;

E 32
D 24
/*
I 14
 *	Initialize the rest of the "first" record.
 */
E 24
I 24
D 31
	/*
	 *	Initialize the rest of the "first" record.
	 */
E 24
	first.mon_options = op->opt_data ;
	first.mon_sleep   = op->opt_sleep ;
	first.mon_cpu     = n_cpu ;
	first.mon_disk    = n_disk ;
D 30
	first.mon_tape    = n_tape ;
E 30
	first.mon_netif   = n_netif ;
	first.mon_pid 	  = getpid();
D 18
	first.mon_sdate	  = time(0);
E 18
I 18
D 27
	first.mon_sdate	  = time((time_t *)0);
E 27
I 27
	first.mon_sdate	  = time((long *)0);
I 28
	first.mon_record  = record_version ;
E 31
I 31
	setup_first(op) ;
E 31
E 28
E 27
E 18

D 24
/*
E 14
 *	By now we know how many total structures we need.  We only
 *	need these for some display functions.  We don't need the
 *	data for save() and will return.
 */
E 24
I 24
	/*
	 *	By now we know how many total structures we need.  We only
	 *	need these for some display functions.  We don't need the
	 *	data for save() and will return.
	 */
E 24
D 14
	if( op->display_mode != OPT_SAVE )
		allocate_totals(op) ;
	else
E 14
I 14
	if( op->display_mode == OPT_SAVE )
E 14
		return ;
I 14
	else
		allocate_totals(op) ;
E 14
D 27

D 24
/*
 *	Like the replay() function we need to make pass of the data
 *	and initialize some of the differences.
 */
E 24
I 24
	/*
	 *	Like the replay() function we need to make pass of the data
	 *	and initialize some of the differences.
	 */
E 24
	live(op);

	if( op->opt_fork )
D 17
		delta_fork(&fork);
E 17
I 17
		delta_fork();
E 17

	if( op->opt_tty )
D 17
		delta_tty(&tty);
E 17
I 17
		delta_tty();
E 17

D 21
	if( op->opt_disk ) {
		struct mon_disk *dp = disk ;
E 21
I 21
	if( op->opt_disk )
		for(i = 0; i < n_disk; i++)
			delta_disk(disk + i) ;
E 21

D 21
		while( dp ) {
			delta_disk(dp);
			dp = dp->mon_next ;
		}
	}

E 21
	if( op->opt_netif ) {
D 21
		struct mon_netif *np = netif ;

		while( np ) {
			delta_netif(np);
			np = np->mon_next ;
		}
E 21
I 21
		for(i = 0; i < n_netif; i++)
			delta_netif(netif + i);
E 21
	}
E 27
}

/*
 *	Collect data out of the running kernel.
 */
live(op)
OPTION	*op ;
{
D 21
	time_t		 time() ;
D 13
	register	 i, etime ;
E 13
I 13
	register	 i, etime, tmp ;
E 13
I 3
D 11
	struct mon_cpu   *cp = cpu ;
E 11
E 3
	struct mon_disk  *dp = disk ;
I 3
	struct mon_tape	 *tp = tape ;
E 3
	struct mon_netif *ip = netif ;
E 21
I 21
	register struct mon_netif *ip ;
D 28
	register i, etime, tmp ;
E 28
I 28
D 29
	register i, ticks, tmp ;
E 29
I 29
D 31
	register i, ticks ;
E 31
I 31
D 39
	register i ;
E 39
I 39
	register i, rc = MON_NORMAL ;
E 39
E 31
E 29
E 28
	struct ifnet ifnet ;
D 27
	time_t time() ;
E 27
E 21
D 3
	struct mon_state *sp = state ;
E 3

I 32
	/*
	 *	Read the kernel data used by all data options.
	 */
E 32
D 24
/*
 *	Collect the timestamp here so that the screen function will have
 *	it.
 */
E 24
I 24
D 31
	/*
	 *	Collect the timestamp here so that the screen 
	 *	function will have it.
	 */
E 24
D 18
	sample.mon_timestamp = time(0) ;
E 18
I 18
D 27
	sample.mon_timestamp = time((time_t *)0) ;
E 27
I 27
	sample.mon_timestamp = time((long *)0) ;
E 31
I 31
	collect_common(op) ;
E 31
E 27
E 18

I 38
	if( op->opt_pid )
D 39
		return collect_pid(op) ;
E 39
I 39
		rc = collect_pid(op) ;
E 39

E 38
D 24
/*
I 7
 *	Get the number of users.
 */
E 24
I 24
	/*
I 32
D 42
	 *	Read the data specific kernel data.
	 */
D 38
	collect_kernel(op) ;
E 38
I 38
	if( op->opt_data & MON$M_KERNEL )
		collect_kernel(op) ;
E 38

	/*
E 42
I 41
	 *	Collect the swap space data.
	 */
	if( op->opt_swap )
		collect_swap() ;

	/*
I 42
	 *	Collect the buffer cache data.
	 */
	if( op->opt_buf )
		collect_buffer_cache() ;

	/*
	 *	Read the data specific kernel data.
	 */
	if( op->opt_data & MON$M_KERNEL )
		collect_kernel(op) ;

	/*
E 42
E 41
E 32
	 *	Get the number of users.
	 */
E 24
D 8
	user.mon_user = users() ;
E 8
I 8
	if( op->opt_user )
D 31
		user.mon_user = users() ;
E 31
I 31
		mon_user.mon_user = users() ;
E 31
E 8

D 24
/*
E 7
 *	This loop will collect the common dynamic data.
 */
E 24
I 24
	/*
D 32
	 *	This loop will collect the common dynamic data.
E 32
I 32
	 *	Get the CPU information.
E 32
	 */
E 24
D 32
	for(i = 0; i < sizeof(dynamic)/sizeof(dynamic[0]); i++) {
		if( dynamic[i].flag == 0 )
			continue ;

		readk(dynamic[i].where, dynamic[i].addr, dynamic[i].len);
E 32
I 32
	if( op->opt_cpu ) {
I 55
		/*
		 *	This hasn't moved in V4.0.
		 */
		cpu[0].mon_pdma = Sum.v_pdma ;

		/*
		 *	In V4.0 this is in the cpudata structure.
		 */
#ifndef	V4_ULTRIX
E 55
		cpu[0].mon_trap = Sum.v_trap ;
		cpu[0].mon_intr = Sum.v_intr ;
D 55
		cpu[0].mon_pdma = Sum.v_pdma ;
E 55
		cpu[0].mon_syscall = Sum.v_syscall ;
I 55
#ifdef	mips
		cpu[0].mon_swtch = Sum.v_swtch ;	
#endif
#endif
E 55
I 41

D 55
#ifdef	vax
E 55
I 53
		/*
D 55
		 *	Context switches will be filled in by
		 *	live_cpu() from the cpudata structure.
E 55
I 55
		 *	These are still in the vmmeter structure
		 *	in V4.0, but aren't there on the VAX.
E 55
		 */
I 55
#ifdef	vax
E 55
E 53
		cpu[0].mon_tlbpid = 0 ;
		cpu[0].mon_soft = 0 ;
#endif
#ifdef	mips
I 53
D 55
		cpu[0].mon_swtch = Sum.v_swtch ;
E 55
E 53
		cpu[0].mon_tlbpid = Sum.v_tlbpid ;
		cpu[0].mon_soft = Sum.v_soft ;
#endif
D 55

E 55
E 41
		live_cpu() ;
E 32
	}

D 11
/*
D 3
 *	The loop here will collect the CPU state data.  Another
E 3
I 3
 *	The loop here will collect the per CPU data.  Another
E 3
 *	function sets up the linked list of CPU's.  It will have
D 3
 *	worry about the true implimentation of multiple CPU machines
E 3
I 3
 *	worry about the true implimentation of multiple CPU machines.
D 10
 *
 *	Since some of the data comes from the paging "rate" structure,
 *	we will have to read a "private" copy of it if the page data
 *	isn't turned on.
E 10
E 3
 */
I 3
	while( cp ) {
		readk((long)cp->mon_where, (char *)cp->mon_time,
			sizeof(cp->mon_time));
E 11
I 11
D 12
	live_cpu(&Rate) ;
E 12
I 12
D 32
	if( op->opt_cpu )
D 27
		live_cpu(&Rate) ;
E 27
I 27
		live_cpu(&Sum) ;
E 27
E 12
E 11
E 3

E 32
D 3
	while( sp ) {
		readk(sp->mon_where, (char *)sp->mon_time,
			sizeof(sp->mon_time));
E 3
I 3
D 10
		if( op->opt_page == 0 )
			readk((long)cp->mon_rate, (char *)&Rate, sizeof(Rate));
E 3

E 10
D 3
		sp = sp->mon_next ;
E 3
I 3
D 11
		cp->mon_swtch   = Rate.v_swtch ;
		cp->mon_trap    = Rate.v_trap ;
		cp->mon_syscall = Rate.v_syscall ;
		cp->mon_intr    = Rate.v_intr ;
		cp->mon_pdma    = Rate.v_pdma ;

		cp = cp->mon_next ;
E 3
	}

E 11
D 24
/*
D 13
 *	The disk and tty data need to know the number of clock ticks
 *	which have elapsed since the last sample.  Since the CPU data
 *	may not be turned we will collect what we need here.  There is
 *	a little extra overhead if the state data is turned on, but
 *	the code to do it most effienciely doesn't seem worth the
 *	trouble right now.
I 3
 *
 *	Tapes will probably want this also.
I 11
 *
 *	Should this be moved into the sample record?
E 13
I 13
 *	Many of the other records will want to know how much time
 *	as elapsed since the last sample.  Mon_etime is the elapsed
 *	time as calculated from _cp_time.
E 13
E 11
E 3
 */
E 24
I 24
	/*
D 28
	 *	Many of the other records will want to know how much time
	 *	as elapsed since the last sample.  Mon_etime is the elapsed
	 *	time as calculated from _cp_time.
E 28
I 28
D 31
	 *	The display functions need to maintain the elapsed 
	 *	time between samples.  To do this we'll find the
	 *	and store the number of clock ticks that have occured
	 *	since the system booted.  The functions that need to
	 *	keep track of clock ticks will use this number.
	 *
	 *	Mon_etime was used in previous versions to do this
	 *	but didn't work for all cases.  It is in the process
	 *	of being fixed.
	 *
	 *	If Ultrix ever supports SMP this will break.
E 28
	 */
E 24
D 3
	if( op->opt_disk || op->opt_tty ) {
E 3
I 3
D 6
	if( op->opt_disk || op->opt_tty || op->opt_tape ) {
E 6
I 6
D 13
	if( op->opt_disk || op->opt_tty || op->opt_tape || op->opt_netif ) {
E 6
E 3
		register tmp ;

		for(i = 0, etime = 0; i < CPUSTATES; i++) {
			tmp = current[i] ;
			current[i] -= prev_time[i] ;
			prev_time[i] = tmp ;
			etime += current[i] ;
		}

		if( etime == 0 )
			etime = 1 ;

		elapsed_time = (double)etime / first.mon_hz ;
E 13
I 13
D 28
	for(i = 0, etime = 0; i < CPUSTATES; i++) {
		tmp = current[i] ;
		current[i] -= prev_time[i] ;
		prev_time[i] = tmp ;
		etime += current[i] ;
E 13
	}
E 28
I 28
	for(i = 0, ticks = 0; i < CPUSTATES; i++)
		ticks += current[i] ;
E 28

D 13
	if( op->opt_tty )
		tty.mon_etime = elapsed_time ;
E 13
I 13
D 28
	if( etime == 0 )
		etime = 1 ;
E 28
I 28
	sample.mon_ticks = ticks ;
E 28
E 13

I 13
D 28
	sample.mon_etime = (double)etime / first.mon_hz ;
E 28
I 28
D 29
	ticks -= prev_ticks ;
	prev_ticks = sample.mon_ticks ;
E 28

I 28
	if( ticks == 0 )
		ticks = 1 ;

	sample.mon_etime = (double)ticks / first.mon_hz ;

E 29
E 28
E 13
D 24
/*
 *	The loop here will collect the network interface dynamic data.
 */
E 24
I 24
	/*
E 31
	 *	The loop here will collect the network interface 
 	 *	dynamic data.
	 */
E 24
D 21
	while( ip ) {
		struct ifnet ifnet ;
E 21
I 21
	for(i = 0; i < n_netif; i++) {
E 21
D 29

E 29
I 21
		ip = netif + i ;

E 21
		readk((long)ip->mon_ifnet, (char *)&ifnet, sizeof(ifnet));

D 4
		ip->mon_flags	   = ifnet.if_flags ;
E 4
I 4
		ip->mon_if_flags   = ifnet.if_flags ;
E 4
		ip->mon_ipackets   = ifnet.if_ipackets ;
		ip->mon_ierrors    = ifnet.if_ierrors ;
		ip->mon_opackets   = ifnet.if_opackets ;
		ip->mon_oerrors    = ifnet.if_oerrors ;
		ip->mon_collisions = ifnet.if_collisions ;
I 6
D 13
		ip->mon_etime      = elapsed_time ;
E 13
E 6
D 21

		ip = ip->mon_next ;
E 21
	}

D 24
/*
 *	Collect the disk data from the approiate places.
 */
E 24
I 24
	/*
	 *	Collect the disk data from the approiate places.
	 */
E 24
D 21
	while( dp ) {
		int	dk = dp->mon_dk ;
E 21
I 21
D 29
	for(i = 0; i < first.mon_disk ; i++) {
		int	dk = disk[i].mon_dk ;
E 29
I 29
	for(i = 0; i < n_disk; i++) {
		register dk = disk[i].mon_dk ;
E 29
E 21

D 13
		dp->mon_etime = elapsed_time ;	/* elapsed time in seconds */
E 13
D 21
		dp->mon_time = dk_time[dk] ;
		dp->mon_seek = dk_seek[dk] ;
		dp->mon_xfer = dk_xfer[dk] ;
		dp->mon_wds = dk_wds[dk] ;

		dp = dp->mon_next ;
E 21
I 21
		disk[i].mon_time = dk_time[dk] ;
		disk[i].mon_seek = dk_seek[dk] ;
		disk[i].mon_xfer = dk_xfer[dk] ;
		disk[i].mon_wds = dk_wds[dk] ;
E 21
	}
D 29

D 24
/*
D 3
 *	This will be where we move the collected data into the appropriate place
 *	if it wasn't read directly.  
E 3
I 3
D 4
 *	There current isn't any tape data to collect, but we should
 *	be prepared.
E 4
I 4
 *	Collect what little tape data is available.
E 4
E 3
 */
E 24
I 24
	/*
	 *	Collect what little tape data is available.
	 */
E 24
D 3
	if( op->opt_cpu ) {
		cpu.mon_swtch   = Rate.v_swtch ;
		cpu.mon_trap    = Rate.v_trap ;
		cpu.mon_syscall = Rate.v_syscall ;
		cpu.mon_intr    = Rate.v_intr ;
		cpu.mon_pdma    = Rate.v_pdma ;
E 3
I 3
D 21
	while( tp ) {
I 4
D 13
		tp->mon_etime = elapsed_time ;
E 13
E 4
		tp = tp->mon_next ;
E 3
	}
E 21
I 21
	for(i = 0; i < first.mon_tape; i++)
		;
E 29
E 21

I 28
	/*
	 *	Start moving around the collected dynamic data.
	 */
	if( op->opt_free )
D 31
		freemem.mon_freemem = free_memory ;
E 31
I 31
		mon_free.mon_freemem = free_memory ;
E 31

I 42
	if( op->opt_loadave ) {
		for(i = 0; i < MON$N_LOADAVE; i++) {
#ifdef	vax
			loadave.mon_loadave[i] = avenrun[i] ;
#endif
#ifdef	mips
			loadave.mon_loadave[i] = FIX_TO_DBL(avenrun[i]) ;
#endif
		}
	}

E 42
E 28
	if( op->opt_memory ) {
		memory.mon_vm     = Total.t_vm ;
		memory.mon_avm    = Total.t_avm ;
		memory.mon_rm     = Total.t_rm ;
		memory.mon_arm    = Total.t_arm ;
		memory.mon_vmtxt  = Total.t_vmtxt ;
		memory.mon_avmtxt = Total.t_avmtxt ;
		memory.mon_rmtxt  = Total.t_rmtxt ;
		memory.mon_armtxt = Total.t_armtxt ;
		memory.mon_free   = Total.t_free ;
	}

	if( op->opt_proc ) {
D 31
		proc.mon_rq = Total.t_rq ;
		proc.mon_dw = Total.t_dw ;
		proc.mon_pw = Total.t_pw ;
		proc.mon_sl = Total.t_sl ;
		proc.mon_sw = Total.t_sw ;
E 31
I 31
		mon_proc.mon_rq = Total.t_rq ;
		mon_proc.mon_dw = Total.t_dw ;
		mon_proc.mon_pw = Total.t_pw ;
		mon_proc.mon_sl = Total.t_sl ;
		mon_proc.mon_sw = Total.t_sw ;
E 31
	}

D 28
	if( op->opt_page )
E 28
I 28
	if( op->opt_page ) {
E 28
D 31
		page.mon_meter = Rate ;
I 28
		page.mon_freemem = free_memory ;
E 31
I 31
D 32
		mon_page.mon_meter = Rate ;
E 32
		mon_page.mon_freemem = free_memory ;
I 42

		mon_page.mon_pswpin  = Rate.v_pswpin ;
		mon_page.mon_pswpout = Rate.v_pswpout ;
		mon_page.mon_pgin    = Rate.v_pgin ;
		mon_page.mon_pgout   = Rate.v_pgout ;
		mon_page.mon_pgpgin  = Rate.v_pgpgin ;
		mon_page.mon_pgpgout = Rate.v_pgpgout ;

		mon_page.mon_intrans = Rate.v_intrans ;
		mon_page.mon_pgrec   = Rate.v_pgrec ;
		mon_page.mon_xifrec  = Rate.v_xifrec ;
		mon_page.mon_xsfrec  = Rate.v_xsfrec ;

		mon_page.mon_zfod    = Rate.v_zfod ;
		mon_page.mon_nexfod  = Rate.v_nexfod ;
		mon_page.mon_nvrfod  = Rate.v_nvrfod ;
		mon_page.mon_exfod   = Rate.v_exfod ;
		mon_page.mon_vrfod   = Rate.v_vrfod ;
		mon_page.mon_nzfod   = Rate.v_nzfod ;

		mon_page.mon_pgfrec    = Rate.v_pgfrec ;
		mon_page.mon_scan      = Rate.v_scan ;
		mon_page.mon_fastpgrec = Rate.v_fastpgrec ;
		mon_page.mon_faults    = Rate.v_faults ;
		mon_page.mon_rev       = Rate.v_rev ;
		mon_page.mon_seqfree   = Rate.v_seqfree ;
		mon_page.mon_dfree     = Rate.v_dfree ;

		mon_page.mon_swpin  = Rate.v_swpin ;
		mon_page.mon_swpout = Rate.v_swpout ;
E 42
E 31
	}
E 28

I 50
	if( op->opt_fork ) {
		mon_fork.mon_fork       = Fork.cntfork ;
		mon_fork.mon_fork_size  = Fork.sizfork ;
		mon_fork.mon_vfork      = Fork.cntvfork ;
		mon_fork.mon_vfork_size = Fork.sizvfork ; 
	}

E 50
I 43
	if( op->opt_namei ) {
D 50
		namei.mon_goodhits  = nchstats.ncs_goodhits ;
		namei.mon_badhits   = nchstats.ncs_badhits ;
		namei.mon_falsehits = nchstats.ncs_falsehits ;
		namei.mon_miss      = nchstats.ncs_miss ;
		namei.mon_long      = nchstats.ncs_long ;
		namei.mon_pass2     = nchstats.ncs_pass2 ;
		namei.mon_2passes   = nchstats.ncs_2passes ;
E 50
I 50
		namei.mon_goodhits  = Namei.ncs_goodhits ;
D 55
		namei.mon_badhits   = Namei.ncs_badhits ;
		namei.mon_falsehits = Namei.ncs_falsehits ;
E 55
		namei.mon_miss      = Namei.ncs_miss ;
D 55
		namei.mon_long      = Namei.ncs_long ;
E 55
		namei.mon_pass2     = Namei.ncs_pass2 ;
		namei.mon_2passes   = Namei.ncs_2passes ;
I 55
#ifdef	V4_ULTRIX
		namei.mon_badhits   = 0 ;
		namei.mon_falsehits = 0 ;
		namei.mon_long      = Namei.ncs_too_long ;
#else
		namei.mon_badhits   = Namei.ncs_badhits ;
		namei.mon_falsehits = Namei.ncs_falsehits ;
		namei.mon_long      = Namei.ncs_long ;
#endif
E 55
E 50
	}

E 43
	/*
D 9
 	 *	-1 is an error condition for opt_collect functions.
E 9
I 9
 	 *	MON_EXIT is an error condition for opt_collect functions.
E 9
	 */
D 9
	return 1 ;
E 9
I 9
D 39
	return MON_NORMAL ;
E 39
I 39
	return rc ;
E 39
E 9
}

/*
 *	Free all the space allocated by init_ and generally clean up.
 */
close_live(op)
OPTION	*op ;
{
I 42
	if( op->opt_buf )
		finish_buf() ;

E 42
I 41
	if( op->opt_swap )
		free_swap() ;

E 41
D 7
	int	save() ;
E 7
I 7
	if( op->opt_user )
		close_whofile() ;
E 7

	if( op->display_mode != OPT_SAVE )
		free_totals(op);

	if( close(kmem) == -1 )
D 18
		fatal("monitor: can't close /dev/kmem: %s.\n");
E 18
I 18
D 25
		fatal("monitor: live: can't close /dev/kmem: %s.\n");
E 25
I 25
D 33
		fatal("can't close /dev/kmem: %s.\n", module);
E 33
I 33
		fatal("Can't close /dev/kmem: %s.\n", module);
I 38

	if( op->opt_pid ) {
		if( close(mem) == -1 )
			fatal("Can't close /dev/mem: %s.\n", module);

		if( close(swap) == -1 )
			fatal("Can't close /dev/drum: %s.\n", module);
	}
E 38
E 33
E 25
E 18
}

/*
 *	Gather the static data (names of devices, physmem, etc).
D 40
 *
 *	Eventually the functions which collect names will be
 *	responseable for doing the handling the command line
 *	options like "disk=ra0,hp1,ra2".
E 40
 */
collect_static(op)
OPTION	*op ;
{
I 21
D 40
	register	i, dk ;
E 21
D 27
#ifdef	sun
	float		dk_bps[DK_NDRIVE] ;
#else
E 27
	float		dk_mspw[DK_NDRIVE] ;
D 27
#endif
E 27
I 27

E 27
D 24
/*
 *	Determine from options what sort of device information
 *	we are interested in.
 */
E 24
I 24
	/*
	 *	Determine from options what sort of device information
	 *	we are interested in.
	 */
E 40
E 24
D 30
	if( op->opt_disk || op->opt_tape )
		uba_devices(op);	/* Unibus/Qbus disks and tapes */
E 30
I 30
	if( op->opt_disk )
D 40
		uba_devices(op);	/* Unibus/Qbus disks */
E 40
I 40
		collect_disk(op) ;
E 40
E 30

I 3
	if( op->opt_cpu )
D 5
		cpus(op) ;		/* CPU's for state info */
E 5
I 5
D 55
		cpus() ;		/* CPU's for state info */
E 55
I 55
		config_cpus() ;		/* CPU's for state info */
E 55
E 5

E 3
D 40
	if( op->opt_disk )
D 5
		mba_devices(op);	/* MASSBUS disks */
E 5
I 5
		mba_devices();		/* MASSBUS disks */
E 5

E 40
D 30
	if( op->opt_tape )
D 5
		mba_slaves(op);		/* MASSBUS tapes */
E 5
I 5
		mba_slaves();		/* MASSBUS tapes */
E 5

E 30
	if( op->opt_netif )
D 18
		net_devices(op);	/* network interfaces */
E 18
I 18
		net_devices();		/* network interfaces */
E 18
D 3

	if( op->opt_state )
		cpus(op) ;		/* CPU's for state info */
E 3
D 24
/*
 *	Read in the version string.
 */
E 24
I 24

	/*
D 31
	 *	Read in the version string.
	 */
E 24
D 18
	readk(namelist[NM_VERSION].n_value, (char *)first.mon_version,
E 18
I 18
	readk((long)namelist[NM_VERSION].n_value, (char *)first.mon_version,
E 18
		MON$S_VERSION);

D 24
/*
 *	Read in "_hz".
 */
E 24
I 24
	/*
	 *	Read in "_hz".
	 */
E 24
D 18
	readk(namelist[NM_HZ].n_value, (char *)&first.mon_hz,
E 18
I 18
	readk((long)namelist[NM_HZ].n_value, (char *)&first.mon_hz,
E 18
		sizeof(first.mon_hz));

D 24
/*
 *	Read in the amount of physical memory.
 */
E 24
I 24
	/*
	 *	Read in the amount of physical memory.
	 */
E 24
D 18
	readk(namelist[NM_PHYSMEM].n_value, (char *)&first.mon_physmem,
E 18
I 18
	readk((long)namelist[NM_PHYSMEM].n_value, (char *)&first.mon_physmem,
E 18
		sizeof(first.mon_physmem));

D 24
/*
 *	Get the hostname.  We are going to use a normal system call here...
 */
E 24
I 24
	/*
	 *	Get the hostname.  We are going to use a normal 
	 *	system call here...
	 */
E 24
	if( gethostname(first.mon_hostname, MON$S_HOSTNAME) == -1 )
D 19
		strcpy(first.mon_hostname, "Who am I?");
E 19
I 19
		(void)strcpy(first.mon_hostname, "Who am I?");
E 19

D 24
/*
 *	Collect more static disk data.
 */
E 24
I 24
	/*
E 31
D 40
	 *	Collect more static disk data.
	 */
E 24
	if( op->opt_disk ) {
D 21
		register struct mon_disk *dp = disk ;
E 21
D 27
#ifdef	sun
D 18
		readk(namelist[NM_DK_BPS].n_value, (char *)dk_bps,
E 18
I 18
		readk((long)namelist[NM_DK_BPS].n_value, (char *)dk_bps,
E 18
			sizeof(dk_bps));
#else
E 27
D 18
		readk(namelist[NM_DK_MSPW].n_value, (char *)dk_mspw,
E 18
I 18
		readk((long)namelist[NM_DK_MSPW].n_value, (char *)dk_mspw,
E 18
			sizeof(dk_mspw));
D 27
#endif
E 27

D 21
		while( dp ) {
E 21
I 21
D 31
		for(i = 0; i < first.mon_disk ; i++) {
E 31
I 31
		for(i = 0; i < n_disk ; i++) {
E 31
			dk = disk[i].mon_dk ;
E 21
D 27
#ifdef	sun
D 21
			dp->mon_bps = dk_bps[dp->mon_unit] ;
E 21
I 21
			disk[i].mon_bps = dk_bps[dk] ;
E 21
#else
E 27
D 21
			dp->mon_mspw = dk_mspw[dp->mon_dk] ;
E 21
I 21
			disk[i].mon_mspw = dk_mspw[dk] ;
E 21
D 27
#endif
E 27
D 21
			dp = dp->mon_next ;
E 21
		}
	}
I 38

	/*
E 40
	 *	If we're collecting data on processes, do some setup
	 *	here.
	 */
	if( op->opt_pid )
		setup_proc(op) ;
E 38
}

/*
 *	This is where we check the namelist values to determine what
 *	is available.  If a needed namelist entry is 0, they we
 *	turn off the approiate option.
 *
 *	The real question is when and why a namelist entry might be
 *	zero.  Under what circumstances is this to be expected and
 *	and if unexpected should we panic()?
 *
 *	The current version of this code check for things which
 *	I believe might not be there.
 */
check_namelist(op)
OPTION	*op ;
{
I 38
D 56
	if( op->opt_proc ) {
		if( namelist[NM_PROC].n_value == 0 || namelist[NM_NPROC].n_value == 0 )
			fatal("No process table.\n", module) ;
	}

E 56
E 38
	/*
D 31
	 *	If the CPU states aren't available then we can't
	 *	use them directory or indirectly for the calculation
	 *	of disk and tty I/O (etime).
E 31
I 31
D 55
	 *	If the CPU states aren't available then we're in big
	 *	trouble.
E 31
	 */
D 38
	if( namelist[NM_STATES].n_value == 0 ) {
E 38
I 38
	if( namelist[NM_STATES].n_value == 0 )
E 38
D 22
		printf("Time in CPU states is not available.\n");
E 22
I 22
D 24
		info("monitor: live: Time in CPU states is not available.\n");
E 24
I 24
D 31
		info("Time in CPU states is not available.\n", module);
E 31
I 31
		fatal("Time in CPU states is not available.\n", module);
E 31
E 24
E 22
D 3
		op->opt_state = op->opt_disk = op->opt_tty = 0 ;
E 3
I 3
D 13
		op->opt_cpu = op->opt_disk = op->opt_tty = 0 ;
E 13
I 13
D 38
		exit(0);
E 13
E 3
	}
E 38

	/*
E 55
I 32
	 *	See if the per CPU data is available.
	 */
D 55
	if( namelist[NM_MAXCPU].n_value == 0 || namelist[NM_CPUDATA].n_value == 0 ) {
E 55
I 55
	if( namelist[NM_CPUDATA].n_value == 0 ) {
E 55
		info("The CPU data is not available.\n", module) ;
		op->opt_cpu = 0 ;
	}

	/*
E 32
D 15
	 *	We'll used dk_busy to determine if the disk I/O info
E 15
I 15
	 *	We'll use dk_busy to determine if the disk I/O info
E 15
	 *	is available.
	 */
	if( namelist[NM_DK_BUSY].n_value == 0 ) {
D 22
		printf("Disk I/O data is not available.\n");
E 22
I 22
D 24
		info("monitor: live: Disk I/O data is not available.\n");
E 24
I 24
		info("Disk I/O data is not available.\n", module);
E 24
E 22
		op->opt_disk = 0 ;
	}

I 32
D 57
	/*
	 *	Check to see if the tty data is available.
	 */
E 32
	if( !namelist[NM_TTY_IN].n_value || !namelist[NM_TTY_OUT].n_value ) {
D 22
		printf("TTY I/O data is not available.\n");
E 22
I 22
D 24
		info("monitor: live: TTY I/O data is not available.\n");
E 24
I 24
		info("TTY I/O data is not available.\n", module);
E 24
E 22
		op->opt_tty = 0 ;
	}
E 57
I 57
D 60
	check_tty_namelist() ;
E 60
I 60
	/*
	 *	Between V3.1 and V4.0 the tty namelist is different
	 *	enough we'll put the code in it's own function.
	 */
	check_tty_namelist(op) ;
E 60
E 57

D 40
	/*
	 *	Check some of the static namelist elements to determine
	 *	what options need to be turned off.
	 */
	if( !namelist[NM_UBDINIT].n_value && !namelist[NM_MBDINIT].n_value ) {
D 22
		printf("Disk I/O data is not available.\n");
E 22
I 22
D 24
		info("monitor: live: Disk I/O data is not available.\n");
E 24
I 24
		info("Disk I/O data is not available.\n", module);
E 24
E 22
		op->opt_disk = 0 ;
D 30
	}

	if( !namelist[NM_UBDINIT].n_value && !namelist[NM_MBSINIT].n_value ) {
D 22
		printf("Tape I/O data is not available.\n");
E 22
I 22
D 24
		info("monitor: live: Tape I/O data is not available.\n");
E 24
I 24
		info("Tape I/O data is not available.\n", module);
E 24
E 22
		op->opt_tape = 0 ;
E 30
	}

E 40
	if( namelist[NM_IFNET].n_value == 0 ) {
D 22
		printf("Network interface data is not available.\n");
E 22
I 22
D 24
		info("monitor: live: Network interface data not available.\n");
E 24
I 24
		info("Network interface data not available.\n", module);
E 24
E 22
		op->opt_netif = 0 ;
	}
I 42

	/*
	 *	Make sure the namei stats are available.
	 */
D 54
	if( namelist[NM_NAMEI].n_type == 0 ) {
E 54
I 54
	if( namelist[NM_NAMEI].n_value == 0 ) {
E 54
                info("Namei statistics are not available.\n", module);
		op->opt_namei = 0 ;
        }
E 42
}

/*
D 32
 *	This is where we check opt_... to turn off data that we don't
 *	need.
 */
check_options(op)
OPTION	*op ;
{
	if( op->opt_loadave == 0 )
		dynamic[NM_LOADAVE].flag = 0 ;

	if( op->opt_netif == 0 )
		dynamic[NM_IFNET].flag = 0 ;

D 28
	if( op->opt_free == 0 )
E 28
I 28
	if( op->opt_free == 0 && op->opt_page == 0 )
E 28
		dynamic[NM_FREE].flag = 0 ;

	if( op->opt_proc == 0 && op->opt_memory == 0 )
		dynamic[NM_TOTAL].flag = 0 ;

D 16
	if( op->opt_disk == 0 && op->opt_tty == 0 )
		dynamic[NM_STATES].flag = 0 ;

E 16
D 3
	if( op->opt_page == 0 && op->opt_cpu == 0 )
		dynamic[NM_PAGE].flag = 0 ;
E 3
I 3
D 10
	if( op->opt_page == 0 )
E 10
I 10
	if( op->opt_page == 0 && op->opt_cpu == 0 )
E 10
D 27
		dynamic[NM_RATE].flag = 0 ;
E 27
I 27
		dynamic[NM_SUM].flag = 0 ;
E 27
E 3

	if( op->opt_page == 0 )
		dynamic[NM_DEFICIT].flag = 0 ;

	if( op->opt_disk == 0 ) {
		dynamic[NM_DK_BUSY].flag = dynamic[NM_DK_TIME].flag = 0 ;
		dynamic[NM_DK_SEEK].flag = dynamic[NM_DK_XFER].flag = 0 ;
		dynamic[NM_DK_WDS].flag = 0 ;
	}

	if( op->opt_tty == 0 )
		dynamic[NM_TTY_IN].flag = dynamic[NM_TTY_OUT].flag = 0 ;

	if( op->opt_fork == 0 )
		dynamic[NM_FORK].flag = 0 ;
I 31
}

/*
E 32
 *	Setup the first record.
 */
setup_first(op)
OPTION	*op ;
{
I 36
	char	*newline, *strchr() ;

E 36
	/*
	 *	The easy stuff.
	 */
	first.mon_options = op->opt_data ;
	first.mon_sleep   = op->opt_sleep ;
I 47
	first.mon_flag    = MON$M_VALID ;
E 47
I 46

E 46
	first.mon_cpu     = n_cpu ;
	first.mon_disk    = n_disk ;
	first.mon_netif   = n_netif ;
I 46
	first.mon_buf     = n_buf ;

E 46
	first.mon_pid 	  = getpid();
	first.mon_sdate	  = time((long *)0);
	first.mon_record  = record_version ;
I 41
	first.mon_arch    = architecture ;
I 48
	first.mon_nbpg    = NBPG ;
	first.mon_bsize   = DEV_BSIZE ;
E 48
E 41

	/*
	 *	Read in the version string.
	 */
	readk((long)namelist[NM_VERSION].n_value, (char *)first.mon_version,
		MON$S_VERSION);

I 34
	first.mon_version[MON$S_VERSION] = '\0' ;
I 36

	if((newline = strchr(first.mon_version, '\n')) != NULL )
		*newline = '\0' ;
E 36

E 34
	/*
	 *	Read in "_hz".
	 */
D 45
	readk((long)namelist[NM_HZ].n_value, (char *)&first.mon_hz,
		sizeof(first.mon_hz));
E 45
I 45
	first.mon_hz = get_word((long)namelist[NM_HZ].n_value) ;
E 45

	/*
	 *	Read in the amount of physical memory.
	 */
D 45
	readk((long)namelist[NM_PHYSMEM].n_value, (char *)&first.mon_physmem,
		sizeof(first.mon_physmem));
E 45
I 45
	first.mon_physmem = get_word((long)namelist[NM_PHYSMEM].n_value) ;
E 45

	/*
I 34
	 *	Read the boot time.
	 */
	readk((long)namelist[NM_BOOT].n_value, (char *)&first.mon_boot,
		sizeof(first.mon_boot)) ;
	
	/*
E 34
	 *	Get the hostname.  We are going to use a normal 
	 *	system call here...
	 */
	if( gethostname(first.mon_hostname, MON$S_HOSTNAME) == -1 )
		(void)strcpy(first.mon_hostname, "Who am I?");
I 34

	first.mon_hostname[MON$S_HOSTNAME] = '\0' ;
E 34
}

/*
 *	Collect the common data needed for each sample.
 */
collect_common(op)
OPTION	*op ;
{
I 52
D 55
#ifndef	USE_GETTIMEOFDAY
E 52
	register ticks, i ;
I 52
#endif
E 52

E 55
	/*
	 *	Collect the timestamp.
	 */
	sample.mon_timestamp = time((long *)0) ;

	/*
	 *	Find size of the data sample.
	 */
	sample.mon_datalen = sample_size(op->opt_data) ;

D 51
	/*
	 *	Get the current time in CPU states.
	 */
	readk((long)namelist[NM_STATES].n_value, (char *)current, sizeof(current)) ;
E 51
I 51
	sample.mon_flag  = MON$M_VALID ;
E 51

	/*
	 *	The display functions need to maintain the elapsed 
	 *	time between samples.  To do this we'll find the
	 *	and store the number of clock ticks that have occured
	 *	since the system booted.  The functions that need to
	 *	keep track of clock ticks will use this number.
	 *
D 51
	 *	Mon_etime was used in previous versions to do this
	 *	but didn't work for all cases.  It is in the process
	 *	of being fixed.
	 *
	 *	If Ultrix ever supports SMP this will break.
E 51
I 51
	 *	There are three ways of doing this, two of which
	 *	are below.  The third assumes that the processor
	 *	with the most clock ticks represents how long the
	 *	system has been up.  I won't use it.
E 51
	 */
D 51
	for(i = 0, ticks = 0; i < CPUSTATES; i++)
		ticks += current[i] ;
E 51

D 51
	sample.mon_ticks = ticks ;
I 32
D 47

E 47
I 47
	sample.mon_flag  = MON$M_VALID ;
E 51
I 51
D 55
#ifdef	USE_GETTIMEOFDAY
E 55
 	/*
	 *	This method uses the current time, the boottime and
	 *	and the clock speed to figure out how many clock
	 *	ticks have happened.  It stands a fair chance of
	 *	working on many versions of Ultrix, but is new and
	 *	untested.
	 */
	sample.mon_ticks = get_ticks() ;
D 55
#else
	/*
	 *	This method reads a kernel data structure that records
	 *	the clock ticks in various states of the processor (or
	 *	or Master processor in an ASMP system.  It breaks on
	 *	SMP Ultrix.
	 */
	readk((long)namelist[NM_STATES].n_value, (char *)current, sizeof(current)) ;

	/*
	 *	Add up the number of ticks in each state.
	 */
	for(i = 0, sample.mon_ticks = 0; i < CPUSTATES; i++)
		sample.mon_ticks += current[i] ;
#endif
E 55
E 51
E 47
}
I 51

D 55
#ifdef	USE_GETTIMEOFDAY

E 55
/*
 *	Number of microseconds in a second.
 */
#define	MICROSEC	(1000000)

/*
 *	This uses the boottime and clock speed from the first
 *	record to find out how many clock ticks the system has
 *	been up.
 */
get_ticks()
{
	register ticks ;
	register struct timeval *np, *bp ;
	struct timeval now ;
	struct timezone tz ;
	double   parts ;

	np = &now ;
	bp = &first.mon_boot ;

	/*
	 *	Get the current time.
 	 */
	if( gettimeofday(np, &tz) == -1 )
		fatal("gettimeofday(2) failed: %s.\n", module) ;

	ticks = (np->tv_sec - bp->tv_sec) * first.mon_hz ;

	if( np->tv_usec < bp->tv_usec ) {
		ticks -= first.mon_hz ;
		parts = bp->tv_usec - np->tv_usec ;
	}
	else
		parts = np->tv_usec - bp->tv_usec ;

	parts /= MICROSEC ;

	return ticks + (int)(parts * first.mon_hz) ;
}
D 55
#endif
E 55
E 51

/*
 *	Read most of the kernel data.  The only exceptions are the
 *	_cpudata structures and the network interface data.
 */
collect_kernel(op)
OPTION	*op ;
{
I 40
D 44
	int	i ;

E 44
E 40
	/*
	 *	Read the data from the kernel that's used by more
	 *	than one data option.
 	 */
	if( op->opt_free || op->opt_page )
D 45
		readk((long)namelist[NM_FREE].n_value, (char *)&free_memory,
			sizeof(free_memory)) ;
E 45
I 45
		free_memory = get_word((long)namelist[NM_FREE].n_value) ;
E 45

	if( op->opt_memory || op->opt_proc )
		readk((long)namelist[NM_TOTAL].n_value, (char *)&Total,
			sizeof(Total)) ;

	/*
	 *	The cpu and page options require the contents of the
	 *	_sum structure.
	 */
	if( op->opt_cpu || op->opt_page )
		readk((long)namelist[NM_SUM].n_value, (char *)&Sum, sizeof(Sum)) ;

	/*
	 *	Read the disk data.
	 */
	if( op->opt_disk ) {
		readk((long)namelist[NM_DK_WDS].n_value, (char *)dk_wds,
			sizeof(dk_wds)) ;
		readk((long)namelist[NM_DK_XFER].n_value, (char *)dk_xfer, 
			sizeof(dk_xfer)) ;
		readk((long)namelist[NM_DK_SEEK].n_value, (char *)dk_seek, 
			sizeof(dk_seek)) ;
		readk((long)namelist[NM_DK_TIME].n_value, (char *)dk_time, 
			sizeof(dk_time)) ;
	}

D 57
	if( op->opt_tty ) {
D 45
		readk((long)namelist[NM_TTY_IN].n_value, (char *)&tty.mon_ttyin,
			sizeof(tty.mon_ttyin)) ;
		readk((long)namelist[NM_TTY_OUT].n_value, (char *)&tty.mon_ttyout,
			sizeof(tty.mon_ttyout)) ;
E 45
I 45
		tty.mon_ttyin = get_word((long)namelist[NM_TTY_IN].n_value) ;
		tty.mon_ttyout = get_word((long)namelist[NM_TTY_OUT].n_value) ;
E 45
	}
E 57
I 57
	if( op->opt_tty )
		collect_tty() ;
E 57

D 40
	if( op->opt_loadave )
		readk((long)namelist[NM_LOADAVE].n_value, (char *)loadave.mon_loadave,
			sizeof(loadave.mon_loadave)) ;
E 40
I 40
	if( op->opt_loadave ) {
		readk((long)namelist[NM_LOADAVE].n_value, (char *)avenrun,
			sizeof(avenrun)) ;
D 42

		for(i = 0; i < MON$N_LOADAVE; i++) {
#ifdef	vax
			loadave.mon_loadave[i] = avenrun[i] ;
#endif
#ifdef	mips
			loadave.mon_loadave[i] = FIX_TO_DBL(avenrun[i]) ;
#endif
		}
E 42
	}
E 40

D 50
	if( op->opt_fork )
		readk((long)namelist[NM_FORK].n_value, (char *)&mon_fork.mon_fork,
			sizeof(mon_fork.mon_fork)) ;
E 50
I 50
	if( op->opt_fork ) {
		readk((long)namelist[NM_FORK].n_value, (char *)&Fork,
			sizeof(Fork)) ;
	}
E 50

	/*
	 *	Read the _rate and _deficit data for the page option.
	 */
	if( op->opt_page ) {
D 41
		readk((long)namelist[NM_RATE].n_value, (char *)&mon_page.mon_meter,
			sizeof(mon_page.mon_meter)) ;
E 41
I 41
		readk((long)namelist[NM_RATE].n_value, (char *)&Rate, sizeof(Rate)) ;

D 42
		mon_page.mon_pswpin  = Rate.v_pswpin ;
		mon_page.mon_pswpout = Rate.v_pswpout ;
		mon_page.mon_pgin    = Rate.v_pgin ;
		mon_page.mon_pgout   = Rate.v_pgout ;
		mon_page.mon_pgpgin  = Rate.v_pgpgin ;
		mon_page.mon_pgpgout = Rate.v_pgpgout ;

		mon_page.mon_intrans = Rate.v_intrans ;
		mon_page.mon_pgrec   = Rate.v_pgrec ;
		mon_page.mon_xifrec  = Rate.v_xifrec ;
		mon_page.mon_xsfrec  = Rate.v_xsfrec ;

		mon_page.mon_zfod    = Rate.v_zfod ;
		mon_page.mon_nexfod  = Rate.v_nexfod ;
		mon_page.mon_nvrfod  = Rate.v_nvrfod ;
		mon_page.mon_exfod   = Rate.v_exfod ;
		mon_page.mon_vrfod   = Rate.v_vrfod ;
		mon_page.mon_nzfod   = Rate.v_nzfod ;

		mon_page.mon_pgfrec    = Rate.v_pgfrec ;
		mon_page.mon_scan      = Rate.v_scan ;
		mon_page.mon_fastpgrec = Rate.v_fastpgrec ;
		mon_page.mon_faults    = Rate.v_faults ;
		mon_page.mon_rev       = Rate.v_rev ;
		mon_page.mon_seqfree   = Rate.v_seqfree ;
		mon_page.mon_dfree     = Rate.v_dfree ;

		mon_page.mon_swpin  = Rate.v_swpin ;
		mon_page.mon_swpout = Rate.v_swpout ;
E 41

E 42
D 45
		readk((long)namelist[NM_DEFICIT].n_value, (char *)&mon_page.mon_deficit,
			sizeof(mon_page.mon_deficit)) ;
E 45
I 45
		mon_page.mon_deficit = get_word((long)namelist[NM_DEFICIT].n_value) ;
E 45
	}
I 42

	/*
	 *	Read _nchstats.
	 */
	if( op->opt_namei )
D 50
		readk((long)namelist[NM_NAMEI].n_value, (char *)&nchstats,
                	sizeof(nchstats)) ;
E 50
I 50
		readk((long)namelist[NM_NAMEI].n_value, (char *)&Namei,
                	sizeof(Namei)) ;
E 50
E 42

E 32
}

/*
 *	Find just the size of a data sample.  This is a stripped
 *	version of the code in iovec.c.
 */
sample_size(data)
int	data ;
{
	register int i, size = 0 ;

	for(i = 0; i < sizeof(struct opt_data_bits) * NBBY; i++) {
		if((data & (1 << i)) == 0 )
			continue ;

		switch( i ) {
D 35
		case MON$K_DISK:
E 35
I 35
		case MON$C_DISK:
E 35
			size += (MON$S_DISK * n_disk) ;
			break ;
D 35
		case MON$K_NETIF:
E 35
I 35
		case MON$C_NETIF:
E 35
			size += (MON$S_NETIF * n_netif) ;
			break ;
D 35
		case MON$K_CPU:
E 35
I 35
		case MON$C_CPU:
E 35
			size += (MON$S_CPU * n_cpu) ;
I 45
			break ;
		case MON$C_BUF:
			size += (MON$S_BUF * n_buf) ;
E 45
			break ;
		default:
D 49
			size += records[i].rec_size ;
E 49
I 49
			size += records[i].size ;
E 49
			break ;
		}
	}

	return size ;
E 31
}
I 18
D 27
/*
D 24
	gethostname, arg. 2 used inconsistently	llib-lc(50)  ::  live.c(406)
E 24
I 24
gethostname, arg. 2 used inconsistently	llib-lc(50)  ::  live.c(406)
E 24
*/
E 27
E 18
E 1
