h12384
s 00010/00000/00282
d D 1.43 90/03/29 16:17:22 alan 43 42
c The hack to fix the DECmumble include file problem.
e
s 00000/00012/00282
d D 1.42 89/12/27 10:54:10 alan 42 41
c moved tty code to it's own file
e
s 00004/00014/00290
d D 1.41 89/02/26 11:13:25 alan 41 40
c Move FORK functions and data to fork.c
c 
e
s 00011/00011/00293
d D 1.40 89/02/25 09:56:45 alan 40 39
c editorial change to rec_ elements
e
s 00000/00021/00304
d D 1.39 89/02/20 16:28:17 alan 39 38
c move f_netif() to netif.c
e
s 00003/00038/00322
d D 1.38 89/02/17 17:57:12 alan 38 37
c moved f_pid to pid.c
e
s 00005/00082/00355
d D 1.37 89/02/17 13:33:53 alan 37 36
c changed format of sample display to match dump of first record.  Also moved control record dump functions from functions.c to sample.c
e
s 00005/00028/00432
d D 1.36 89/02/16 20:21:41 alan 36 35
c added mon_name to CPU record and moved f_cpu()
e
s 00002/00003/00458
d D 1.35 89/02/16 19:02:59 alan 35 34
c convert pgtok() and btok() macros to functions that uses data set in the FIRST record
e
s 00003/00003/00458
d D 1.34 89/02/15 20:19:54 alan 34 33
c Check mon_flag for VALID data before printing record
e
s 00086/00000/00375
d D 1.33 89/02/15 19:28:21 alan 33 32
c properly set mon_flag in all records
e
s 00014/00001/00361
d D 1.32 89/02/13 19:19:09 alan 32 31
c added n_buf to f_first()
e
s 00005/00023/00357
d D 1.31 89/01/24 17:16:45 alan 31 30
c moved some f_ functions to other files
e
s 00004/00002/00376
d D 1.30 89/01/16 18:39:04 alan 30 29
c only print available pieces on non-zero
e
s 00027/00003/00351
d D 1.29 89/01/16 18:29:04 alan 29 28
c added functions for namei and buffer caches
e
s 00053/00028/00301
d D 1.28 89/01/15 20:23:20 alan 28 27
c added functions for swap space
e
s 00006/00002/00323
d D 1.27 89/01/04 10:45:25 alan 27 26
c V1.1 changes for MIPS support.  This is a check-point of the current
c support.
c 
e
s 00017/00001/00308
d D 1.26 88/06/29 23:30:48 alan 26 25
c See the modification history for 29-June-1988.
c 
e
s 00011/00001/00298
d D 1.25 88/06/27 18:14:25 alan 25 24
c changed include of monitor.h and record.h
e
s 00017/00002/00282
d D 1.24 87/11/18 16:39:41 alan 24 23
c V0.99 -> T1.0-1
e
s 00002/00000/00282
d D 1.23 87/11/18 12:17:02 alan 23 22
c V0.98
e
s 00004/00004/00278
d D 1.22 87/09/14 18:55:54 alan 22 21
c see V0.96 in version.c for details
e
s 00011/00012/00271
d D 1.21 87/08/11 17:51:12 alan 21 20
c V0.94 - new version of pgtok macro and the addition of "units" to some of the
c output.
c 
e
s 00001/00001/00282
d D 1.20 87/04/03 14:32:29 alan 20 19
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00027/00000/00256
d D 1.19 87/03/03 15:43:14 alan 19 18
c see the commentary for V0.83 in version.c
e
s 00000/00014/00256
d D 1.18 87/02/05 16:27:32 alan 18 17
c See comment on V0.81 in version.c.
c 
e
s 00000/00001/00270
d D 1.17 87/02/02 16:22:26 alan 17 16
c V0.79 in version.c
e
s 00010/00005/00261
d D 1.16 87/01/21 16:35:19 alan 16 15
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00006/00007/00260
d D 1.15 86/12/07 22:23:45 alan 15 14
c See V0.57 in version.c
e
s 00004/00002/00263
d D 1.14 86/11/19 09:40:20 alan 14 13
c See commentary on V0.56 in version.c
c 
e
s 00006/00023/00259
d D 1.13 86/11/16 16:32:15 alan 13 12
c See comments for V0.51 in version.c
c 
e
s 00005/00004/00277
d D 1.12 86/10/30 20:54:52 alan 12 11
c Change f_loadave to reflect reality.  F_loadave was still of the mind
c that there were 4 load averages, instead of MON$N_LOADAVE.  It is now
c sensible about such things.
c 
e
s 00001/00001/00280
d D 1.11 86/10/30 14:46:14 alan 11 10
c change read_extern.h to extern.h
e
s 00003/00001/00278
d D 1.10 86/10/30 14:23:56 alan 10 9
c dust off lint
e
s 00013/00012/00266
d D 1.9 86/07/14 08:16:42 alan 9 8
c remove references to print_ functions
e
s 00001/00003/00277
d D 1.8 86/06/24 14:20:58 alan 8 7
c update for change in mon_etime
e
s 00007/00005/00273
d D 1.7 86/06/14 18:11:19 alan 7 6
c change mon_cpuid to mon_ident and add mon_state
e
s 00001/00001/00277
d D 1.6 86/05/29 11:16:24 alan 6 5
c Changes to incorporate addition of users.
c 
e
s 00039/00067/00239
d D 1.5 86/05/28 18:21:30 alan 5 4
c move print_ functions from functions.c to print.c
e
s 00009/00006/00297
d D 1.4 86/05/26 19:15:03 alan 4 3
c fixes due to record.h changes
e
s 00008/00013/00295
d D 1.3 86/05/26 16:57:53 alan 3 2
c Changes due to change in mon_cpu and mon_state structures.
c 
e
s 00000/00000/00308
d D 1.2 86/05/20 09:32:13 alan 2 1
c 1.  Broke read.c up into modules:
c     read.c - read records out of the file and call approproiate function.
c     functions.c - The data functions.
c     read_data.c - Global data.
c     read_extern.h - Declarations of global data.
c 
e
s 00308/00000/00000
d D 1.1 86/05/20 09:27:59 alan 1 0
c date and time created 86/05/20 09:27:59 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 13
 *	%M% - The functions used by the read program to print out the
 *		contents of the data records.
E 13
I 13
 *	%M% - The functions used by the read display function to print
 *	out the contents of the data records.
E 13
 */
#ifndef	lint
D 13
static	char	SccsId[] = "%W% %G%" ;
E 13
I 13
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 13
#endif

I 25
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 26
 *
 * 29-June-1988 -- arr
 *
 *	Fixed f_first() to NULL terminate long version strings.
I 27
 *
 * 29-November-1988 -- arr
 *
 *	Removed sc_sp and sc_ps from the function to print the 
 *	LAST record.  These are not in the MIPS signal context
 *	and don't seem very useful.
I 28
 *
 * jan. 4, 1989 -- arr
 *
 *	Remove all the scp stuff.
 *
 * Jan. 5, 1989 -- arr
 *
 *	Fix the references to the mon_meter structure.
 *
 * Jan. 15, 1989 -- arr
 *
D 29
 *	Populate the function to print swap data.
E 29
I 29
 *	Populate the functions to print swap data, buffer cache and
 *	namei cache..
I 31
 *
 * Jan. 24, 1989 -- arr
 *
 *	Move the f_buf and f_namei functions to buf.c and namei.c
 *	respectively.
I 32
 *
D 38
 * Feb. 13, 1989 -- arr
E 38
I 38
 * Week ending Feb. 18, 1989 -- arr
E 38
 *
 *	Added n_buf to f_first().
I 33
 *
D 38
 * Feb. 15, 1989 -- arr
 *
E 38
 *	Moved title printf's from read.c to here.  I also
 *	now check the mon_flag field to see if the VALID
 *	bit is set.
I 36
 *
D 38
 * Feb. 16, 1989 -- arr
 *
E 38
 *	Moved f_cpu() to cpu.c.
I 37
 *
D 38
 * Feb. 17, 1989 -- arr
E 38
I 38
 *	Moved f_first(), f_last() and f_sample() to sample.c.
E 38
 *
D 38
 *	Moved f_first(), f_last() and f_sample() to sample.c
E 38
I 38
 *	Moved f_pid() to pid.c.
I 41
 *
 * Feb. 26, 1989 -- arr
 *
 *	Moved f_fork() to it's own file, fork.c.
I 43
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 43
E 41
E 38
E 37
E 36
E 33
E 32
E 31
E 29
E 28
E 27
E 26
 */

E 25
#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/file.h>
I 16
D 18
#include <sys/devio.h>
E 18
E 16
#include <sys/socket.h>
#include <sys/dk.h>
I 16
#include <sys/param.h>
#include <sys/dir.h>
I 43

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 43
#include <sys/user.h>
E 16
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

D 35
#include <machine/param.h>

D 21
#define	pgtok(x)	((x)*NBPG/1024)

E 21
I 21
#include "pgtok.h"
E 35
I 25
#include "include.h"
E 25
E 21
D 13
#include "read.h"
E 13
I 13
#include "monitor.h"
E 13
D 11
#include "read_extern.h"
E 11
I 11
D 20
#include "extern.h"
E 20
E 11
D 25
#include "record.h"
E 25
I 20
#include "extern.h"
E 20

I 15
/*
 *	Functions that don't return (int).
 */
E 15
I 9
D 10
char	*str_data(),
E 10
I 10
D 37
char	*ctime(),
	*str_data(),
E 10
	*str_disk(),
E 37
I 37
char	*str_disk(),
E 37
D 18
	*str_tape(),
E 18
	*str_netif(),
I 19
	*str_stats(),
E 19
I 10
	*str_state(),
I 19
D 36
	*str_flags(),
E 19
E 10
	*str_cpuid() ;
E 36
I 36
	*str_flags() ;
E 36

E 9
/*
D 9
 *
E 9
I 9
 *	Print the record name and number.
E 9
 */
D 13
nop(p)
E 13
I 13
f_nop(p)
E 13
struct mon_header *p ;
{
D 13
	printf("%s (%d).\n", array[p->mon_type].mon_string, p->mon_type);
E 13
I 13
D 40
	printf("%s (%d).\n", records[p->mon_type].rec_string, p->mon_type);
E 40
I 40
	printf("%s (%d).\n", records[p->mon_type].string, p->mon_type);
E 40
E 13
}

I 24
/*
 *
 */
f_panic()
{
	printf("\tThis wasn't supposed to happen.\n") ;
D 37
}

E 24
f_first(p)
struct mon_first *p ;
{
I 26
D 32
	char	*strchr(), *newline ;
E 32
I 32
	char	*strchr(), *newline, *arch_string ;
E 32

I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_FIRST].rec_string) ;

E 33
	/*
	 *	If the version string has a newline in it, replace it
	 *	with a NULL.  Otherwise force a NULL at the end of the
	 *	allocated space.
	 */
	if((newline = strchr(p->mon_version, '\n')) != NULL )
		*newline = '\0' ;
	else
		p->mon_version[MON$S_VERSION] = '\0' ;

E 26
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
D 21
	printf("\tsleep:    %d\n", p->mon_sleep);
E 21
I 21
	printf("\tsleep:    %d seconds\n", p->mon_sleep);
E 21
D 5
	printf("\toptions:  %o\n", p->mon_options);
E 5
I 5
D 9

	print_data("\toptions:  <", p->mon_options);

E 9
I 9
	printf("\toptions:  <%s>\n", str_data(p->mon_options));
E 9
E 5
	printf("\tpid:      %d\n", p->mon_pid);
	printf("\thz:       %d\n", p->mon_hz);
I 35
	printf("\tnbpg:     %d\n", p->mon_nbpg) ;
	printf("\tbsize:    %d\n", p->mon_bsize) ;
E 35
	printf("\tphysmem:  %d Kb.\n", pgtok(p->mon_physmem));
I 23
	printf("\tboot:     %s", ctime((long *)&p->mon_boot.tv_sec)) ;
E 23
D 15
	printf("\tsdate:    %s", ctime(&p->mon_sdate));
E 15
I 15
	printf("\tsdate:    %s", ctime((long *)&p->mon_sdate));
E 15
	printf("\tcpu:      %d\n", p->mon_cpu);
	printf("\tdisk:     %d\n", p->mon_disk);
D 18
	printf("\ttape:     %d\n", p->mon_tape);
E 18
	printf("\tnetif:    %d\n", p->mon_netif);
I 32
	printf("\tbuf:      %d\n", p->mon_buf);

	if( p->mon_arch == MON$C_VAX )
		arch_string = "VAX" ;
	else
		arch_string = "MIPS" ;

	printf("\tarch:     %s\n", arch_string) ;
E 32
I 16
	printf("\trecord:   V%d.%d\n", major(p->mon_record),
		minor(p->mon_record)) ;
I 32

E 32
E 16
D 26
	printf("\tversion:  %s", p->mon_version);
E 26
I 26
	printf("\tversion:  %s\n", p->mon_version);
E 26
	printf("\thostname: %s\n", p->mon_hostname);
}

D 5

f_sample(p)
struct mon_sample *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\ttimestamp: %s", ctime(&p->mon_timestamp));
	printf("\tdatalen:   %d\n", p->mon_datalen);
}

E 5
I 5
/*
 *	Print the contents of the "last" record.
 */
E 5
f_last(p)
struct mon_last *p ;
{
I 34
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

E 34
I 33
	printf("%s.\n", records[MON$C_LAST].rec_string) ;

D 34
	printf("\ttype:    %d\n", p->mon_type) ;
	printf("\tflag:    %d\n", p->mon_flag) ;
	printf("\tlength:  %d\n", p->mon_length) ;
E 34
E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
D 15
	printf("\tedate:   %s", ctime(&p->mon_edate));
E 15
I 15
	printf("\tedate:   %s", ctime((long *)&p->mon_edate));
E 15
	printf("\tsignal:  %d\n", p->mon_signal);
	printf("\tcode:    %d\n", p->mon_code);
D 28
	printf("\tonstack: %d\n", p->mon_scp.sc_onstack);
	printf("\tmask:    %d\n", p->mon_scp.sc_mask);
D 27
	printf("\tsp:      %x\n", p->mon_scp.sc_sp);
E 27
	printf("\tpc:      %x\n", p->mon_scp.sc_pc);
E 28
D 27
	printf("\tpsl:     %x\n", p->mon_scp.sc_ps);
E 27
}

/*
I 5
 *	Print the contents of the sample record.
 */
f_sample(p)
struct mon_sample *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_SAMPLE].rec_string) ;

E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
D 15
	printf("\ttimestamp: %s", ctime(&p->mon_timestamp));
E 15
I 15
	printf("\ttimestamp: %s", ctime((long *)&p->mon_timestamp));
E 15
	printf("\tdatalen:   %d\n", p->mon_datalen);
I 8
D 17
	printf("\tetime:     %.2f\n", p->mon_etime);
E 17
I 16
D 21
	printf("\tticks:     %d\n", p->mon_ticks) ;
E 21
I 21
	printf("\tticks:     %d ticks\n", p->mon_ticks) ;
E 37
E 21
E 16
E 8
}

/*
E 5
 *	Here start the functions to print out data records.
 */
D 36

f_cpu(p)
struct mon_cpu *p ;
{
I 7
	register state ;

I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_CPU].rec_string) ;

E 33
E 7
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
I 5
D 7
	print_cpuid("\tcpuid:   ", p->mon_cpuid);
E 7
I 7
D 9
	print_cpuid("\tident:   ", p->mon_ident);
E 9
I 9
D 16
	printf("\tident:   %s\n", str_cpuid(p->mon_ident));
E 16
I 16
	printf("\tident:   %s\n", str_cpuid(p->mon_ident, p->mon_subtype));
E 16
E 9
E 7

E 5
I 3
D 7
	printf("\t[0]:     %d\n", p->mon_time[0]);
	printf("\t[1]:     %d\n", p->mon_time[1]);
	printf("\t[2]:     %d\n", p->mon_time[2]);
	printf("\t[3]:     %d\n", p->mon_time[3]);
E 7
I 7
	for(state = 0 ; state < CPUSTATES; state++)
D 21
		printf("\t[%d]:     %d\n", state, p->mon_time[state]);
E 21
I 21
		printf("\t[%d]:     %d ticks\n", state, p->mon_time[state]);
E 21

D 9
	printf("\tstate:   %x\n", p->mon_state);
E 9
I 9
	printf("\tstate:   <%s>\n", str_state(p->mon_state));
E 9
E 7
D 5
	printf("\tcpuid:   %x\n", p->mon_cpuid);
E 5
	printf("\tcpu:     %d\n", p->mon_cpu);
I 5
	printf("\tindex:   %d\n", p->mon_index);
E 5
E 3
	printf("\tswtch:   %u\n", p->mon_swtch);
	printf("\ttrap:    %u\n", p->mon_trap);
	printf("\tsyscall: %u\n", p->mon_syscall);
	printf("\tintr:    %u\n", p->mon_intr);
	printf("\tpdma:    %u\n", p->mon_pdma);
I 16
	printf("\tsubtype: %d\n", p->mon_subtype) ;
E 16
I 3
D 5
	printf("\twhere:   %x\n", p->mon_where);
	printf("\trate:    %x\n", p->mon_rate);
E 5
E 3
}
E 36

D 42
f_tty(p)
struct mon_tty *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 40
	printf("%s.\n", records[MON$C_TTY].rec_string) ;
E 40
I 40
	printf("%s.\n", records[MON$C_TTY].string) ;
E 40

E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
D 21
	printf("\tttyin:  %d\n", p->mon_ttyin);
	printf("\tttyout: %d\n", p->mon_ttyout);
E 21
I 21
	printf("\tttyin:  %d chars.\n", p->mon_ttyin);
	printf("\tttyout: %d chars.\n", p->mon_ttyout);
E 21
D 5
	printf("\tetime:  %f\n", p->mon_etime);
E 5
I 5
D 8
	printf("\tetime:  %.1f seconds.\n", p->mon_etime);
E 8
E 5
}

E 42
f_disk(p)
struct mon_disk *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 40
	printf("%s.\n", records[MON$C_DISK].rec_string) ;
E 40
I 40
	printf("%s.\n", records[MON$C_DISK].string) ;
E 40

E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
	printf("\tname:       %s%d\n", p->mon_name, p->mon_unit);
	printf("\tdk:         %d\n", p->mon_dk);
I 5
	printf("\tindex:      %d\n", p->mon_index);
E 5
D 16
	printf("\tcontroller: %d\n", p->mon_controller);
	printf("\tbus:        %d\n", p->mon_bus);
E 16
I 9
	printf("\tdisk:       <%x>\n", p->mon_disk);
E 9
D 4
	printf("\tetime:      %f\n", p->mon_etime);
	printf("\ttime:       %d\n", p->mon_time);
	printf("\tseek:       %d\n", p->mon_seek);
	printf("\txfer:       %d\n", p->mon_xfer);
	printf("\twds:        %d\n", p->mon_wds);
E 4
I 4
D 5
	printf("\tdisk:       %x\n", p->mon_disk);
E 5
I 5

D 9
	print_disk("\tdisk:       <", p->mon_disk);

E 9
E 5
E 4
D 15
#ifdef	sun
	printf("\tbps:	      %f\n", p->mon_bps);
#else
E 15
	printf("\tmspw:       %f\n", p->mon_mspw);
D 15
#endif
E 15
I 4
D 8
	printf("\tetime:      %f\n", p->mon_etime);
E 8
D 21
	printf("\ttime:       %d\n", p->mon_time);
E 21
I 21
D 22
	printf("\ttime:       %d ticks\n", p->mon_time);
E 21
	printf("\tseek:       %d\n", p->mon_seek);
	printf("\txfer:       %d\n", p->mon_xfer);
	printf("\twds:        %d\n", p->mon_wds);
E 22
I 22
	printf("\ttime:       %u ticks\n", p->mon_time);
	printf("\tseek:       %u\n", p->mon_seek);
	printf("\txfer:       %u\n", p->mon_xfer);
	printf("\twds:        %u\n", p->mon_wds);
E 22
E 4
}

f_free(p)
struct mon_free *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 40
	printf("%s.\n", records[MON$C_FREE].rec_string) ;
E 40
I 40
	printf("%s.\n", records[MON$C_FREE].string) ;
E 40

E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
	printf("\tfree: %d Kb.\n", pgtok(p->mon_freemem));
D 41
}

f_fork(p)
struct mon_fork *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 40
	printf("%s.\n", records[MON$C_FORK].rec_string) ;
E 40
I 40
	printf("%s.\n", records[MON$C_FORK].string) ;
E 40

E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
	printf("\tcntfork:  %d\n", p->mon_fork.cntfork);
	printf("\tcntvfork: %d\n", p->mon_fork.cntvfork);
D 21
	printf("\tsizfork:  %d\n", p->mon_fork.sizfork);
	printf("\tsizvfork: %d\n", p->mon_fork.sizvfork);
E 21
I 21
	printf("\tsizfork:  %d Kb.\n", pgtok(p->mon_fork.sizfork));
	printf("\tsizvfork: %d Kb.\n", pgtok(p->mon_fork.sizvfork));
E 41
E 21
}

D 29
f_page(p)
E 29
I 29
f_paging(p)
E 29
struct mon_page *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 40
	printf("%s.\n", records[MON$C_PAGE].rec_string) ;
E 40
I 40
	printf("%s.\n", records[MON$C_PAGE].string) ;
E 40

E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
	printf("\tdeficit:   %d\n", p->mon_deficit);
I 16
D 21
	printf("\tfreemem:   %d\n", p->mon_freemem) ;
E 21
I 21
	printf("\tfreemem:   %d Kb.\n", pgtok(p->mon_freemem)) ;
E 21
E 16
D 28
	printf("\tpswpin:    %u\n", p->mon_meter.v_pswpin);
	printf("\tpswpout:   %u\n", p->mon_meter.v_pswpout);
	printf("\tpgin:      %u\n", p->mon_meter.v_pgin);
	printf("\tpgout:     %u\n", p->mon_meter.v_pgout);
	printf("\tpgpgin:    %u\n", p->mon_meter.v_pgpgin);
	printf("\tpgpgout:   %u\n", p->mon_meter.v_pgpgout);
	printf("\tintrans:   %u\n", p->mon_meter.v_intrans);
	printf("\tpgrec:     %u\n", p->mon_meter.v_pgrec);
	printf("\txsfrec:    %u\n", p->mon_meter.v_xsfrec);
	printf("\txifrec:    %u\n", p->mon_meter.v_xifrec);
	printf("\texfod:     %u\n", p->mon_meter.v_exfod);
	printf("\tzfod:      %u\n", p->mon_meter.v_zfod);
	printf("\tvrfod:     %u\n", p->mon_meter.v_vrfod);
	printf("\tnexfod:    %u\n", p->mon_meter.v_nexfod);
	printf("\tnzfod:     %u\n", p->mon_meter.v_nzfod);
	printf("\tnvrfod:    %u\n", p->mon_meter.v_nvrfod);
	printf("\tpgfrec:    %u\n", p->mon_meter.v_pgfrec);
	printf("\tfaults:    %u\n", p->mon_meter.v_faults);
	printf("\tscan:      %u\n", p->mon_meter.v_scan);
	printf("\trev:       %u\n", p->mon_meter.v_rev);
	printf("\tseqfree:   %u\n", p->mon_meter.v_seqfree);
	printf("\tdfree:     %u\n", p->mon_meter.v_dfree);
	printf("\tfastpgrec: %u\n", p->mon_meter.v_fastpgrec);
	printf("\tswpout:    %u\n", p->mon_meter.v_swpout);
	printf("\tswpin:     %u\n", p->mon_meter.v_swpin);
E 28
I 28
	printf("\tpswpin:    %u\n", p->mon_pswpin);
	printf("\tpswpout:   %u\n", p->mon_pswpout);
	printf("\tpgin:      %u\n", p->mon_pgin);
	printf("\tpgout:     %u\n", p->mon_pgout);
	printf("\tpgpgin:    %u\n", p->mon_pgpgin);
	printf("\tpgpgout:   %u\n", p->mon_pgpgout);
	printf("\tintrans:   %u\n", p->mon_intrans);
	printf("\tpgrec:     %u\n", p->mon_pgrec);
	printf("\txsfrec:    %u\n", p->mon_xsfrec);
	printf("\txifrec:    %u\n", p->mon_xifrec);
	printf("\texfod:     %u\n", p->mon_exfod);
	printf("\tzfod:      %u\n", p->mon_zfod);
	printf("\tvrfod:     %u\n", p->mon_vrfod);
	printf("\tnexfod:    %u\n", p->mon_nexfod);
	printf("\tnzfod:     %u\n", p->mon_nzfod);
	printf("\tnvrfod:    %u\n", p->mon_nvrfod);
	printf("\tpgfrec:    %u\n", p->mon_pgfrec);
	printf("\tfaults:    %u\n", p->mon_faults);
	printf("\tscan:      %u\n", p->mon_scan);
	printf("\trev:       %u\n", p->mon_rev);
	printf("\tseqfree:   %u\n", p->mon_seqfree);
	printf("\tdfree:     %u\n", p->mon_dfree);
	printf("\tfastpgrec: %u\n", p->mon_fastpgrec);
	printf("\tswpout:    %u\n", p->mon_swpout);
	printf("\tswpin:     %u\n", p->mon_swpin);
E 28
}

D 29
f_proc(p)
E 29
I 29
f_process(p)
E 29
struct mon_proc *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 40
	printf("%s.\n", records[MON$C_PROC].rec_string) ;
E 40
I 40
	printf("%s.\n", records[MON$C_PROC].string) ;
E 40

E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
	printf("\trq:   %d\n", p->mon_rq);
	printf("\tdw:   %d\n", p->mon_dw);
	printf("\tpw:   %d\n", p->mon_pw);
	printf("\tsl:   %d\n", p->mon_sl);
	printf("\tsw:   %d\n", p->mon_sw);
I 28
}

f_swap(p)
struct mon_swap *p ;
{
	int	i ;

I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 40
	printf("%s.\n", records[MON$C_SWAP].rec_string) ;
E 40
I 40
	printf("%s.\n", records[MON$C_SWAP].string) ;
E 40

E 33
	printf("\ttotal:    %d Kb.\n", btok(p->mon_total)) ;
	printf("\tused:     %d Kb.\n", btok(p->mon_used)) ;
	printf("\ttext:     %d Kb.\n", btok(p->mon_text)) ;
	printf("\tsmem:     %d Kb.\n", btok(p->mon_smem)) ;
	printf("\tfree:     %d Kb.\n", btok(p->mon_free)) ;
	printf("\twasted:   %d Kb.\n", btok(p->mon_wasted)) ;

D 30
	for(i = 0; i < MON$C_MAXSWAP-1; i++)
		printf("\tavail[%d]: %d of %d Kb.\n", i, p->mon_avail[i], 1 << i) ;
E 30
I 30
	for(i = 0; i < MON$C_MAXSWAP; i++)
		if( p->mon_avail[i] )
			printf("\tavail[%d]: %d of %d Kb.\n",
				i, p->mon_avail[i], 1 << i) ;
E 30
E 28
}

D 14
f_swap(p)
struct mon_swap *p ;
E 14
I 14
/*
D 24
 *	Someday there may be something here.
E 24
I 24
 *	Not Implimented.  This is used for the SWAP, BUF, NFS and NAMEI
 *	records.
E 24
 */
D 24
f_swap()
E 24
I 24
f_ni()
E 24
E 14
{
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
	printf("\tNot implimented.\n");
D 18
}

f_tape(p)
struct mon_tape *p ;
{
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
	printf("\tname:       %s%d\n", p->mon_name, p->mon_unit);
	printf("\ttp:         %d\n", p->mon_tp);
I 5
	printf("\tindex:      %d\n", p->mon_index);
E 5
D 16
	printf("\tcontroller: %d\n", p->mon_controller);
	printf("\tbus:        %d\n", p->mon_bus);
E 16
I 5

D 9
	print_tape("\ttape:       <", p->mon_tape);
E 9
I 9
	printf("\ttape:       <%x>\n", p->mon_tape);
E 9

E 18
E 5
I 4
D 8
	printf("\tetime:      %f\n", p->mon_etime);
E 8
D 5
	printf("\ttape:       %x\n", p->mon_tape);
E 5
E 4
}

I 24
/*
 *	Number of users.
 */
E 24
f_user(p)
struct mon_user *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 40
	printf("%s.\n", records[MON$C_USER].rec_string) ;
E 40
I 40
	printf("%s.\n", records[MON$C_USER].string) ;
E 40

E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
D 6
	printf("\tNot implimented.\n");
E 6
I 6
	printf("\tusers:      %d\n", p->mon_user);
E 6
}

I 24
D 39
/*
 *
 */
E 24
f_netif(p)
struct mon_netif *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_NETIF].rec_string) ;

E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
	printf("\tname:       %s%d\n", p->mon_name, p->mon_unit);
D 9

D 4
	print_if(p->mon_flags, "\tflags:      <");
E 4
I 4
D 5
	print_if(p->mon_if_flags, "\tif_flags:   <");
E 5
I 5
	print_netif("\tif_flags:   <", p->mon_if_flags);
E 5
E 4

E 9
I 9
	printf("\tif_flags:   <%s>\n", str_netif(p->mon_if_flags));
E 9
	printf("\tipackets:   %d\n", p->mon_ipackets);
	printf("\tierrors:    %d\n", p->mon_ierrors);
	printf("\topackets:   %d\n", p->mon_opackets);
	printf("\toerrors:    %d\n", p->mon_oerrors);
	printf("\tcollisions: %d\n", p->mon_collisions);
	printf("\taddr:       %x\n", p->mon_ifnet);
D 3
}

f_state(p)
struct mon_state *p ;
{
	printf("%s.\n", array[p->mon_type].mon_string);
	printf("\t[0]:   %d\n", p->mon_time[0]);
	printf("\t[1]:   %d\n", p->mon_time[1]);
	printf("\t[2]:   %d\n", p->mon_time[2]);
	printf("\t[3]:   %d\n", p->mon_time[3]);
	printf("\twhere: %x\n", p->mon_where);
	printf("\tcpuid: %x\n", p->mon_cpuid);
	printf("\tcpu:   %d\n", p->mon_cpu);
E 3
}

E 39
f_memory(p)
struct mon_memory *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 40
	printf("%s.\n", records[MON$C_MEMORY].rec_string) ;
E 40
I 40
	printf("%s.\n", records[MON$C_MEMORY].string) ;
E 40

E 33
D 13
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
D 5
	printf("\tvm:     %d Kb.\n", pgtok(p->mon_vm));
	printf("\tavm:    %d Kb.\n", pgtok(p->mon_avm));
	printf("\trm:     %d Kb.\n", pgtok(p->mon_rm));
	printf("\tarm:    %d Kb.\n", pgtok(p->mon_arm));
	printf("\tvmtxt:  %d Kb.\n", pgtok(p->mon_vmtxt));
	printf("\tavmtxt: %d Kb.\n", pgtok(p->mon_avmtxt));
	printf("\trmtxt:  %d Kb.\n", pgtok(p->mon_rmtxt));
	printf("\tarmtxt: %d Kb.\n", pgtok(p->mon_armtxt));
	printf("\tfree:   %d Kb.\n", pgtok(p->mon_free));
E 5
I 5
	printf("\tvm:         %d Kb.\n", pgtok(p->mon_vm));
	printf("\tavm:        %d Kb.\n", pgtok(p->mon_avm));
	printf("\trm:         %d Kb.\n", pgtok(p->mon_rm));
	printf("\tarm:        %d Kb.\n", pgtok(p->mon_arm));
	printf("\tvmtxt:      %d Kb.\n", pgtok(p->mon_vmtxt));
	printf("\tavmtxt:     %d Kb.\n", pgtok(p->mon_avmtxt));
	printf("\trmtxt:      %d Kb.\n", pgtok(p->mon_rmtxt));
	printf("\tarmtxt:     %d Kb.\n", pgtok(p->mon_armtxt));
	printf("\tfree:       %d Kb.\n", pgtok(p->mon_free));
E 5
}

f_loadave(p)
struct mon_loadave *p ;
{
I 12
	register i ;
D 13

E 12
	printf("%s.\n", array[p->mon_type].mon_string);
E 13
D 12
	printf("\t[0]: %.2f\n", p->mon_loadave[0]);
	printf("\t[1]: %.2f\n", p->mon_loadave[1]);
	printf("\t[2]: %.2f\n", p->mon_loadave[2]);
	printf("\t[3]: %.2f\n", p->mon_loadave[3]);
E 12
I 12

I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 40
	printf("%s.\n", records[MON$C_LOADAVE].rec_string) ;
E 40
I 40
	printf("%s.\n", records[MON$C_LOADAVE].string) ;
E 40

E 33
	for(i = 0; i < MON$N_LOADAVE; i++)
		printf("\t[%d]: %.2f\n", i, p->mon_loadave[i]);
I 19
D 38
}

f_pid(p)
struct mon_pid *p ;
{
I 33
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_PID].rec_string) ;

E 33
	printf("\tpid:    %d\n", p->mon_pid) ;
	printf("\tpgrp:   %d\n", p->mon_pgrp ) ;
	printf("\tpri:    %d\n", p->mon_pri ) ;
	printf("\tnice:   %d\n", p->mon_nice ) ;
I 23
	printf("\twchan:  %x\n", p->mon_wchan) ;
E 23
	printf("\tttyd:   <%d,%d>\n", major(p->mon_ttyd), minor(p->mon_ttyd)) ;
	printf("\tpflag:  <%s>\n", str_flags(p->mon_pflag)) ;
	printf("\tstat:   %s\n", str_stats(p->mon_stat)) ;
	printf("\tcomm:   %s\n", p->mon_comm) ;
D 21
	printf("\trssize: %d\n", p->mon_rssize) ;
E 21
I 21
	printf("\trssize: %d Kb.\n", pgtok(p->mon_rssize)) ;
E 21

	printf("\tcpundx: %x\n", p->mon_cpundx) ;

	printf("\tself:\n") ;
	print_rusage(&p->mon_self, "\t\t") ;

	printf("\tchild:\n") ;
	print_rusage(&p->mon_child, "\t\t") ;

	printf("\tcred:\n") ;
	print_cred(&p->mon_cred, "\t\t") ;
E 38
I 29
D 31
}

f_buf(p)
struct mon_buf *p ;
{
	printf("\tnbuf:     %d\n", p->mon_nbuf) ;
	printf("\tbufpages: %d\n", p->mon_bufpages) ;
	printf("\tnused:    %d\n", p->mon_nused) ;
	printf("\tmemuse:   %d\n", p->mon_memuse) ;
	printf("\tmemalloc: %d\n", p->mon_memalloc) ;
	printf("\tcache:    %d\n", p->mon_cache) ;
}

f_namei(p)
struct mon_namei *p ;
{
	printf("\tgoodhits:  %d\n", p->mon_goodhits) ;
	printf("\tbadhits:   %d\n", p->mon_badhits) ;
	printf("\tfalsehits: %d\n", p->mon_falsehits) ;
	printf("\tmiss:      %d\n", p->mon_miss) ;
	printf("\tlong:      %d\n", p->mon_long) ;
	printf("\tpass2:     %d\n", p->mon_pass2) ;
	printf("\t2passes:   %d\n", p->mon_2passes) ;
E 31
E 29
E 19
E 12
D 5
}

/*
 *	Print out the names of the interface flag bits.
 */
static	char	*netif_names[] = {
	"up", 			/* 01 */
	"broadcast", 		/* 02 */
	"debug", 		/* 04 */
	"route",		/* 010 */
	"pointopoint",		/* 020 */
	"notrailers",		/* 040 */
	"running",		/* 0100 */
	"noarp",		/* 0200 */
	"local",		/* 0400 */
	"dynproto",		/* 01000 */
	"loopback",		/* 02000 */
	"04000",		/* 04000 */
	"010000",
	"020000",
	"040000",
	"0100000",
};

print_if(flags, format)
short	flags ;
char	*format ;
{
	int	i, comma = 0 ;

	printf("%s", format);

	for(i = 0; i < sizeof(flags) * 8; i++) {
		if((1 << i) & flags ) {
			if( comma++ )
				putchar(',');
			printf("%s", netif_names[i]);
		}
	}

	printf(">\n");
E 5
}
E 1
