h00463
s 00004/00004/00219
d D 1.9 86/07/11 19:32:26 alan 9 8
c Dust off LOTS of lint...
c 
e
s 00000/00002/00223
d D 1.8 86/07/11 15:39:28 alan 8 7
c Dusted off some lint.  I may merge this back into screen.c since both are
c fairly stable now.
c 
e
s 00011/00004/00214
d D 1.7 86/05/29 17:45:55 alan 7 6
c Finished adding code that would print disk totals when opt_total was
c turned on.  There was also a bug in limit() which caused a and b to
c set to the same value if they had to changed and a > b.
c Changed the number of lines really available to reflect reality.
c 
e
s 00001/00001/00217
d D 1.6 86/05/27 10:55:00 alan 6 5
c add module description
e
s 00001/00001/00217
d D 1.5 86/05/27 10:44:20 alan 5 4
c center the tape data under the disk data
e
s 00005/00008/00213
d D 1.4 86/05/26 15:53:48 alan 4 3
c I combined the mon_state and mon_cpu structures into one (mon_cpu) which
c is supposed to be all the system data that is kept on a per CPU basis.
c See record.h for more info.  Most of the changes that occured in the files
c were a result of removing references to mon_state and opt_state.
c 
c Other changes unrelated to this:
c 1.  Changed NM_PAGE to NM_RATE.  This was in three files, monitor.h and
c     two of the others.
c 2.  I added loop for the collecting the "tape" data to save.c.  This is
c     a very short loop since there is no tape data in the system.
c 
e
s 00010/00000/00211
d D 1.3 86/05/26 13:22:44 alan 3 2
c add code to limit()
e
s 00164/00000/00047
d D 1.2 86/05/25 18:36:46 alan 2 1
c Added "smart" code to setup the format of the screen.
c format.c still needs work.  It is very ugly and don't run out screen
c space gracefully even though the most of the code is there.  (limit()
c is empty)
c 
e
s 00047/00000/00000
d D 1.1 86/05/25 13:22:55 alan 1 0
c date and time created 86/05/25 13:22:55 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 6
 *	%M% - 
E 6
I 6
 *	%M% - Attempt to intelligently format the screen.
E 6
 */
#ifndef	lint
static	char	SccsId[] = "%W% %G%" ;
#endif

I 2
#include <stdio.h>
#include <signal.h>
E 2
#include <curses.h>

I 2
#include <sys/types.h>
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "record.h"
E 2
#include "options.h"
#include "screen.h"

I 2
#define	SPACE	(3)
E 2
/*
 *	<x,y> positions for the various fields.
 */
int	cpu_y = CPU_Y, cpu_x = CPU_X,
	tty_y = TTY_Y, tty_x = TTY_X,
	proc_y = PROC_Y, proc_x = PROC_X,
I 2
	tape_y = TAPE_Y, tape_x = TAPE_X,
E 2
	free_y = FREE_Y, free_x = FREE_X,
	fork_y = FORK_Y, fork_x = FORK_X,
	disk_y = DISK_Y, disk_x = DISK_X,
	netif_y = NETIF_Y, netif_x = NETIF_X,
	page1_y = PAGE1_Y, page1_x = PAGE1_X,
	page2_y = PAGE2_Y, page2_x = PAGE2_X,
D 4
	memory_y = MEMORY_Y, memory_x = MEMORY_X,
	states_y = STATES_Y, states_x = STATES_X ;
E 4
I 4
	memory_y = MEMORY_Y, memory_x = MEMORY_X ;
E 4
/*
 *	Line that the last ... will be on because of lack of space.
 */
int	last_disk, last_tape, last_cpu, last_netif ;

screen_format(op, cpus, disks, tapes, netifs)
D 9
OPTION	*op ;
int	cpus, disks, tapes, netifs ;
E 9
I 9
OPTION	 *op ;
unsigned cpus, disks, tapes, netifs ;
E 9
{
	int	area1_y = PROC_Y ;
	int	area1_x = PROC_X ;
	int	area2_y = FORK_Y ;
D 7
	int	area1_len = LINES - 3 ;
	int	area2_len = LINES - 3 ;
E 7
I 7
	int	area1_len = LINES - 4 ;
	int	area2_len = LINES - 4 ;
E 7
	int	area_width = DISK_X - PROC_X - 1 ;
I 2
	int	area_lines ;

	if( op->opt_proc ) {
		if( area_width >= PROC_LEN ) {
			proc_x = area1_x ;
			proc_y = area1_y ;
			area1_x += (PROC_LEN + SPACE) ;
			area_width -= (PROC_LEN + SPACE) ;
		}
	}

	if( op->opt_memory ) {
		if( area_width >= MEMORY_LEN ) {
			memory_x = area1_x ;
			memory_y = area1_y ;
			area1_x += (MEMORY_LEN + SPACE) ;
			area_width -= (MEMORY_LEN + SPACE) ;
		}
	}
	else if( op->opt_free ) {
		if( area_width >= FREE_LEN ) {
			free_x = area1_x ;
			free_y = area1_y ;
			area1_x += (FREE_LEN + SPACE) ;
			area_width -= (FREE_LEN + SPACE) ;
		}
	}

	if( op->opt_fork ) {
		if( area_width < FORK_LEN ) {
			fork_y = area2_y ;
			area2_y += 3 ;
			area2_len -= 3 ;
		}
		else {
			fork_x = area1_x ;
			fork_y = area1_y ;
			area1_x += (FORK_LEN + SPACE) ;
			area_width -= (FORK_LEN + SPACE) ;
		}
	}

	if( op->opt_tty ) {
		if( area_width < TTY_LEN ) {
			tty_y = area2_y ;
			area2_y += 3 ;
			area2_len -= 3 ;
		}
		else {
			tty_x = area1_x ;
			tty_y = area1_y ;
			area1_x += (TTY_LEN + SPACE) ;
			area_width -= (TTY_LEN + SPACE) ;
		}
	}

	if( area1_x != PROC_X )
		area1_y += 3 ;

	if( op->opt_page ) {
		page1_y = area1_y ;
		page2_y = area1_y + 3 ;

		area1_x = PAGE1_LEN ;
		area1_y += 6 ;
		area1_len -= 6 ;
	}

	/*
 	 *	Figure out how many lines are available to display
	 *	CPU's and NETIF's.  If there are more CPU's and NETIF's
	 *	than lines, only display those that will fix and turn
	 *	on the approproiate "<more>" indicator.
	 */

D 4
	area_lines = area1_len ;
	area_lines -= (op->opt_cpu || op->opt_state) ? 1 : 0 ;
	area_lines -= op->opt_netif ? 1 : 0 ;
E 4
I 4
	area_lines = area1_len - (op->opt_cpu ? 1 : 0 + op->opt_netif ? 1 : 0) ;
E 4

D 4
	if((op->opt_cpu || op->opt_state) && op->opt_netif )
E 4
I 4
	if( op->opt_cpu && op->opt_netif )
E 4
		area_lines-- ;

	if((cpus + netifs) > area_lines )
		limit(area_lines, &cpus, &netifs);

D 4
	if( op->opt_cpu || op->opt_state ) {
		cpu_y = states_y = area1_y ;
E 4
I 4
	if( op->opt_cpu ) {
		cpu_y = area1_y ;
E 4
		area1_x = CPU_LEN ;
		area1_y += (2 + cpus) ;
		last_cpu = cpu_y + cpus ;
	}

	if( op->opt_netif ) {
		netif_y = area1_y ;
		area1_x = NETIF_LEN ;
		last_netif = netif_y + netifs ;
	}

	/*
 	 *	Do the same thing for disks, but also figure out if
	 *	we want to put them in area1.
	 */

	if( area1_x == PROC_X ) {
		area_lines = area1_len - 1;
		area2_y = area1_y ;
		disk_x = PROC_X ;
		tape_x = PROC_X + DISK_LEN + SPACE ;

		if( disks > area_lines )
			disks = area_lines ;

		if( tapes > area_lines )
			tapes = area_lines ;
	}
	else {
		area_lines = area2_len - (op->opt_disk ? 1 : 0 + op->opt_tape ? 1 : 0) ;

		if( op->opt_disk && op->opt_tape )
			area_lines-- ;

I 7
		if( op->opt_total )
			area_lines -= 2 ;

E 7
		disk_x = DISK_X ;
D 5
		tape_x = DISK_X ;
E 5
I 5
		tape_x = TAPE_X ;
E 5

		if((disks + tapes) > area_lines )
			limit(area_lines, &disks, &tapes) ;
	}

	if( op->opt_disk ) {
		disk_y = area2_y ;
		last_disk = disk_y + disks ;

D 7
		if( disk_x != PROC_X )
E 7
I 7
		if( disk_x != PROC_X ) {
E 7
			area2_y += (2 + disks) ;
I 7

			if( op->opt_total )
				area2_y += 2 ;
		}
E 7
	}

	if( op->opt_tape ) {
		tape_y = area2_y ;
		last_tape = tape_y + tapes ;
	}
}

/*
 *	Change the value of a and/or b so that their total is <= total.
 */
limit(total, a, b)
D 9
int	total ;
int	*a, *b ;
E 9
I 9
int	 total ;
unsigned *a, *b ;
E 9
{
I 3
D 8
	double	percent ;

E 8
	if( *a > *b ) {
		*a = ((double)(*a)/(*a + *b)) * total ;
D 7
		*b = total - *b ;
E 7
I 7
		*b = total - *a ;
E 7
	}
	else {
		*b = ((double)(*b)/(*a + *b)) * total ;
		*a = total - *b ;
	}
E 3
E 2
}
E 1
