h18176
s 00005/00005/00074
d D 1.10 87/08/10 21:27:12 alan 10 9
c See commentary on V0.92 in version.c
e
s 00038/00028/00041
d D 1.9 87/05/20 17:14:51 alan 9 8
c changed all curses calls to use w... versions
e
s 00006/00005/00063
d D 1.8 87/04/17 15:46:55 alan 8 7
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00020/00021/00048
d D 1.7 86/12/07 22:22:49 alan 7 6
c See V0.57 in version.c
e
s 00003/00013/00066
d D 1.6 86/11/16 16:31:50 alan 6 5
c See comments for V0.51 in version.c
c 
e
s 00001/00001/00078
d D 1.5 86/08/26 18:04:20 alan 5 4
c modify all SccsId strings
e
s 00002/00001/00077
d D 1.4 86/07/31 14:07:37 alan 4 3
c Change many fprintf's to info's and add arguments to assorted warning and
c fatal error messages.
c 
e
s 00045/00039/00033
d D 1.3 86/07/13 14:27:31 alan 3 2
c moved fopen() and fclose from monitor.c
e
s 00004/00002/00068
d D 1.2 86/07/11 19:32:08 alan 2 1
c Dust off LOTS of lint...
c 
e
s 00070/00000/00000
d D 1.1 86/05/18 12:49:43 alan 1 0
c date and time created 86/05/18 12:49:43 by alan
e
u
U
t
T
I 1
/*
D 3
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Function to dump the "screen" to a file.  Originally labeled:
 *
 *		@(#)dumpit.c	9.1 (Cyb) 12/28/84
 *
 */
E 3
I 3
D 7
*	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
*	File:	 %M%
*	Date:	 %G%
*	Version: %I%
*
*	%M% - Function to dump the "screen" to a file.  Originally labeled:
*
*		@(#)dumpit.c	9.1 (Cyb) 12/28/84
*
*/
E 7
I 7
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Function to dump the "screen" to a file.  Originally labeled:
 *
 *		@(#)dumpit.c	9.1 (Cyb) 12/28/84
 *
 */
E 7
E 3
#ifndef	lint
D 5
static	char	SccsId[] = "%W% %G%" ;
E 5
I 5
D 6
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 6
I 6
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 6
E 5
#endif

/*
D 3
 *	dumpit (Outfile)
 *	FILE *Outfile;
 *
 *		dump curscr (except for last line) to Outfile.
 */
E 3
I 3
D 7
*	dump_screen(Outfile)
*	char *Outfile;
*
*		dump curscr (except for last line) to Outfile.
*/
E 7
I 7
 *	dump_screen(fp)
 *	char *fp ;
 *
 *	Write the curses current screen (except for the last line) to
 *	to the file *fp.  This is modified version of the code taken
 *	from "mon" by Philip Dykstra.
 */
E 7
E 3

#include <stdio.h>
#include <curses.h>

I 2
D 9
char	*strncpy() ;
E 9
I 9
#include "options.h"
E 9

I 9
/*
 *	Default display.
 */
extern	OPTION	option ;
extern	WINDOW	*wp ;
extern	int	lines ;
D 10
extern	int	width ;
E 10
I 10
extern	int	cols ;
E 10

E 9
E 2
D 3
int     dumpit (Outfile)
FILE * Outfile;
E 3
I 3
D 6
dump_screen(Outfile)
char	*Outfile;
E 6
I 6
dump_screen(fp)
FILE	*fp ;
E 6
E 3
{
D 2
    int	    i, x, y, z;
E 2
I 2
D 3
    int	    i, z;
E 2
    char    buffer[BUFSIZ];
E 3
I 3
	int	i, z;
D 7
	char	buffer[BUFSIZ];
E 7
D 6
	FILE	*fp, *fopen() ;
E 6
E 3

I 3
D 6
	if((fp = fopen(Outfile, "a")) == NULL ) {
D 4
		warning("monitor: dumpit: can't open dump file: %s.\n");
E 4
I 4
		warning("monitor: dumpit: can't open dump file: %s (%s).\n",
			Outfile);
E 4
		return ;
	}

E 6
E 3
D 9
/*
 *  For all lines but the last one ...
 */
D 3
    for (i = 0; i < LINES - 1; i++)
    {
        mvprintw (LINES - 1, 0, "Dumping Screen Line %d", i + 1);
	clrtoeol ();
	refresh ();
E 3
I 3
	for (i = 0; i < LINES - 1; i++) {
D 8
		mvprintw (LINES - 1, 0, "Dumping Screen Line %d", i + 1);
		clrtoeol ();
		refresh ();
E 8
I 8
		wmove(stdscr, LINES - 1, 0) ;
		wprintw(stdscr, "Dumping Screen Line %d", i + 1);
		wclrtoeol(stdscr);
		wrefresh(stdscr);
E 9
I 9
	/*
	 *  For all lines but the last one ...
	 */
D 10
	for (i = 0; i < lines - 1; i++) {
E 10
I 10
	for (i = 0; i < lines; i++) {
E 10
		if( option.opt_inter )
D 10
			print_line_counter(i + 1) ;
E 10
I 10
			print_line_counter(i) ;
E 10
E 9
E 8
E 3

D 9
/*
 *  Search backwards on each line for a non-space.  Z is the count of
 *  significant characters.
 */
D 3
	for (z = COLS - 1; z > 0; z--)
	{
	    if (curscr -> _y[i][z] != ' ')
	    {
E 3
I 3
		for (z = COLS - 1; z > 0; z--) {
	    		if (curscr -> _y[i][z] != ' ') {
E 3
/*
 *  Non-space found, increment Z and exit loop
 */
E 9
I 9
		/*
		 * Search backwards on each line for a non-space.  Z is 
		 * the count of significant characters.
		 */
D 10
		for (z = width - 1; z > 0; z--) {
E 10
I 10
		for (z = cols - 1; z > 0; z--) {
E 10
	    		if ( wp->_y[i][z] != ' ') {

				/*
				 *  Non-space found, increment Z and exit loop
				 */
E 9
D 3
		z++;
		break;
	    }
	}
E 3
I 3
				z++;
				break;
	    		}
		}
E 3
D 9
/*
D 7
 *    Copy Z characters and append a \n and \0 to the string, then output it
E 7
I 7
 *	fprintf exactly 'z' character from the current line to
 *	the file *fp.
E 7
 */
D 2
	strncpy (buffer, curscr -> _y[i], z);
E 2
I 2
D 3
	(void)strncpy (buffer, curscr -> _y[i], z);
E 2
	buffer[z] = '\n';
	buffer[z + 1] = '\0';
	fputs (buffer, Outfile);
    }
E 3
I 3
D 7
		(void)strncpy(buffer, curscr->_y[i], z);
		buffer[z] = '\n';
		buffer[z + 1] = '\0';
		fputs (buffer, fp);
E 7
I 7
		fprintf(fp, "%*.*s\n", z, z, curscr->_y[i]) ;
E 9
I 9

		/*
		 *	fprintf exactly 'z' character from the current line to
		 *	the file *fp.
		 */
		fprintf(fp, "%*.*s\n", z, z, wp->_y[i]) ;
E 9
E 7
	}
I 9
}
E 9
E 3

D 9
/*
 *  Clear the status line, the prompt will appear the next time around
 */
D 3
    move (LINES - 1, 0);
    clrtoeol ();
E 3
I 3
D 8
	move (LINES - 1, 0);
	clrtoeol ();
E 8
I 8
	wmove(stdscr, LINES - 1, 0);
	wclrtoeol(stdscr);
E 9
I 9
print_line_counter(i)
{
D 10
	wmove(wp, lines - 1, 0);
E 10
I 10
	wmove(wp, LINES - 1, 0);
E 10
	wprintw(wp, "Dumping Screen Line %d", i) ;
	wclrtoeol(wp) ;
	wrefresh(wp) ;
E 9
E 8
D 6

	if( fclose(fp) == EOF )
		warning("monitor: dumpit: can't close dump file: %s.\n");
E 6
E 3
}
E 1
