h43983
s 00021/00000/00148
d D 1.5 90/05/23 21:27:48 alan 5 4
c added pause
e
s 00009/00001/00139
d D 1.4 89/01/04 11:01:44 alan 4 3
c Work-around curses bug turned up in MIPS support
e
s 00004/00004/00136
d D 1.3 87/08/12 15:27:17 alan 3 2
c error message clean up - V0.95
e
s 00032/00034/00108
d D 1.2 87/08/10 21:27:50 alan 2 1
c See commentary on V0.92 in version.c
e
s 00142/00000/00000
d D 1.1 87/05/22 17:16:35 alan 1 0
c date and time created 87/05/22 17:16:35 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Functions to handle curses style windows as opposed
 *	X style windows.
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

I 4
/*
 * Modification history.
 *
I 5
 * May 23, 1990 -- arr
 *
 *	Added curses function to "pause" screen.
 *
E 5
 * 28-December-1988 -- arr
 *
 *	Dust off V3.0 lint.
 */

E 4
#include <sys/types.h>
#include <sys/ioctl.h>

#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <curses.h>

#include "options.h"

/*
 *	Display data.
 *
 *	lines - Length of display actually being used.  This will be < LINES.
 *	cols  - Width of the display being used.  It will usually be == COLS.
 *	wp    - Address of a curses window where the drawing will take place.
 *	changed_size - A flag set when a window changes size.
 *
 *	Declared as extern in <curses.h>.
 *
 *	LINES - The actual length of the display area.  It will be set before
 *		initscr() is called.
 *	COLS  - Width of the display, like LINES.
 */
int	lines = 0 ;
int	cols = 0 ;
int	changed_size = 0 ;
WINDOW	*wp = (WINDOW *)NULL ;

/*
 *	Module name for error functions.
 */
static	char	*module = "curses" ;

/*
 *	Stuff defined elsewhere.
 */
extern	OPTION	option ;

/*
 *
 */
D 2
setup_curses(op)
E 2
I 2
setup_curses(op, max_lines, max_cols)
E 2
OPTION	*op ;
I 2
int	max_lines, max_cols ;
E 2
{
	struct winsize size ;

I 2
	/*
	 *	If getwindow size doesn't fail set LINES and COLS.
	 */
	if( getwindowsize(&size) != -1 ) {
		LINES = size.ws_row ;
		COLS  = size.ws_col ;
	}
	else if( max_lines != -1 )
		LINES = max_lines ;
	else if( max_cols != -1 )
		COLS  = max_cols ;

E 2
	if( initscr() == NULL )
D 3
		fatal("can't initialize screen: %s.\n", module);
E 3
I 3
		fatal("Can't initialize screen: %s.\n", module);
E 3

D 2
	if( getwindowsize(&size) != -1 ) {
		LINES = lines = size.ws_row ;
		COLS  = width = size.ws_col ;
	}
	else {
		lines = LINES ;
		width =  COLS ;
	}
E 2
I 2
	lines = LINES ;
	cols  = COLS ;
E 2

D 2
	if((wp = newwin(lines, width, 0, 0)) == NULL )
E 2
I 2
	if((wp = newwin(lines, cols, 0, 0)) == NULL )
E 2
D 3
		fatal("can't create window.\n", module) ;
E 3
I 3
		fatal("Can't create window.\n", module) ;
E 3

	op->opt_curses = 1 ;

	crmode();
	noecho();
}

/*
D 2
 *	Catch the signal that a window changed size, find out what
 *	the new size is.  We rely on the fact that if LINES and COLS
 *	are already set, curses appears to use the larger size.
E 2
I 2
 *	Catch notice of the fact that the screen changed size, then
 *	close your eyes (you don't want to see this...).
E 2
 *
D 2
 *	I don't want to think about how unreliable this is...
E 2
I 2
 *	1.  Turn off curses so that it looks like we're starting
 *	    over from scratch.
 *
 *	2.  Use setup_curses() to size the terminal windows and
 *	    create a display area.
 *
 *	3.  Set the changed_size flag.
 *
 *	4.  If there is a function to redraw the display, call it.
 *
 *	5.  Open your eyes.
E 2
 */
D 4
catch_sigwinch()
E 4
I 4
void	catch_sigwinch()
E 4
{
D 2
	struct winsize size ;
E 2
I 2
	endwin() ;
E 2

D 2
	if( getwindowsize(&size) != -1 ) {
		LINES = lines = size.ws_row ;
		COLS  = width = size.ws_col ;
	}
	else {
		lines = LINES ;
		width = COLS ;
	}

	if( option.opt_curses ) {
		if( wp )
			delwin(wp) ;

		if((wp = newwin(lines, width, 0, 0)) == NULL )
			fatal("can't create window.\n", module) ;

		crmode() ;
		noecho() ;
	}
E 2
I 2
	setup_curses(&option, -1, -1) ;
E 2

	changed_size = 1 ;

	if( option.redraw_display )
		(*option.redraw_display)(&option);
}

/*
 *	Use the "get window size" ioctl() to:
 *
 *	a.  If we are on a sizeing terminal, get the window
 *	    size.
 *
 *	b.  If we aren't on a sizeing terminal, punt...
 */
getwindowsize(w)
struct winsize *w ;
{
	if( ioctl(fileno(stdin), (int)TIOCGWINSZ, (char *)w) == -1 ) {
D 3
		warning("ioctl on size failed", module) ;
E 3
I 3
		warning("Ioctl TIOCGWINSZ failed: %s.\n", module) ;
E 3
		return -1 ;
	}

	if( w->ws_xpixel == 0 || w->ws_ypixel == 0 ) {
D 3
		info("window size is 0 x 0.\n", module) ;
E 3
I 3
		info("Window size is 0 x 0.\n", module) ;
E 3
		errno = EOPNOTSUPP ;
		return -1 ;
	}

	return 0 ;
I 5
}

curses_pause()
{
	/*
	 *	Move to the bottom of the screen and print
	 *	the message.
	 */
	wmove(wp, LINES - 1, 0) ;
	wprintw(wp, "Pausing; Press any key to continue...");
	wrefresh(wp) ;

	/*
	 *	Wait for a character to be typed.  We don't care what
	 *	it is.
	 */
	(void)wgetch(wp) ;
E 5
}
E 1
