h19594
s 00010/00000/00467
d D 1.14 90/03/29 16:17:20 alan 14 13
c The hack to fix the DECmumble include file problem.
e
s 00001/00001/00466
d D 1.13 89/05/18 14:46:37 alan 13 12
c fixed more error messages
e
s 00001/00001/00466
d D 1.12 89/05/18 14:30:31 alan 12 11
c Fixed use of n_type instead of n_value in namelist check
e
s 00002/00002/00465
d D 1.11 89/03/09 21:08:41 alan 11 10
c reorder local include files to satisify VAXC
e
s 00007/00004/00460
d D 1.10 89/03/03 10:08:16 alan 10 9
c removed info message saying that there were more device than BUF structures
e
s 00001/00001/00463
d D 1.9 89/02/25 09:57:22 alan 9 8
c editorial change to rec_ elements
e
s 00011/00001/00453
d D 1.8 89/02/15 19:29:32 alan 8 7
c properly set mon_flag in all records
e
s 00204/00117/00250
d D 1.7 89/02/13 16:10:57 alan 7 6
c added file system name and more flags to buf record
e
s 00008/00004/00359
d D 1.6 89/01/29 10:03:57 alan 6 5
c dusted off lint
e
s 00104/00031/00259
d D 1.5 89/01/27 17:41:57 alan 5 4
c added detail listing to screen
e
s 00132/00015/00158
d D 1.4 89/01/24 17:44:48 alan 4 3
c added code to fill detail structure
e
s 00031/00001/00142
d D 1.3 89/01/17 19:08:33 alan 3 2
c first pass at display functions
e
s 00068/00002/00075
d D 1.2 89/01/16 22:14:30 alan 2 1
c merge in experimental buffer cache code
e
s 00077/00000/00000
d D 1.1 89/01/16 11:56:23 alan 1 0
c date and time created 89/01/16 11:56:23 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Deal with the buffer cache stats.
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

I 4
/*
 * Modification history.
 *
 * Jan. 24, 1989 -- arr
 *
D 5
 *	Added to code to collect data for cache_detail structure.  Also
E 5
I 5
 *	Added to code to collect data for detail structure.  Also
E 5
 *	moved f_buf() from functions.c.
I 7
 *
 * Feb. 10, 1989 -- arr
 *
 *	Redesigned the way buffer cache data is collected and
 *	stored.
I 8
 *
 * Feb. 15, 1989 -- arr
 *
 *	Added checks of mon_flag to f_buf() and magnify_buf().
I 14
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 14
E 8
E 7
 */

E 4
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
I 7
#include <fstab.h>
E 7

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <sys/dir.h>
I 14

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 14
#include <sys/param.h>
#include <sys/user.h>
I 5
#include <sys/mount.h>
E 5

#include <net/if.h>
#include <netinet/in.h>

I 11
#include "monitor.h"
E 11
#include "options.h"
D 11
#include "extern.h"
E 11
#include "include.h"
D 11
#include "monitor.h"
E 11
I 11
#include "extern.h"
E 11

/*
 *	Data declared elsewhere.
 */
extern	int	lines ;
I 3
extern	WINDOW	*wp ;
E 3

/*
 *	Local data.
 */
D 2
static	int	buf_ticks = 0 ;
static	char	*module = "buf" ;
E 2
I 2
static	int		buf_ticks = 0 ;
I 7
static	int		missed_buffers = 0 ;
E 7
static	char		*module = "buf" ;
I 4
D 7
static	unsigned       	nelp = 0 ;
E 7
I 7
static	unsigned       	nelp = 1 ;
E 7

E 4
static	struct 	buf	*xbp = 0 ;
static	struct	buf	*addr ;

I 4
D 5
static	struct 	cache_detail	*dp = 0 ;
E 5
I 5
D 7
static	struct 	detail	*dp = 0 ;
E 7
I 7
static	struct mon_buf key = {
	MON$C_BUF, MON$M_VALID, MON$S_BUF,
	0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* flags */
	-1, 0, '\0',
};
E 7
E 5

E 4
/*
 *	Functions that don't return (int).  Mostly for form and
 *	to keep lint happy.
 */
long	lseek();
D 5
char	*calloc();
E 5
I 5
D 6
char	*calloc(), *get_fsname(), *strcpy();
E 6
I 6
D 7
char	*calloc(), *get_fsname(), *strcpy(), *lsearch();
E 7
I 7
char	*calloc(), *strcpy(), *lsearch(), *lfind(), *strncpy();
E 7
E 6
E 5
void	exit(), free(), perror(), nlist() ;
I 7
struct fstab *getfsent() ;
E 7

I 6
/*
 *	Setup the data structures needed to collect buffer
 *	cache info.
 */
E 6
setup_buf()
{
	unsigned nbuf ;
I 5
D 7
	int	 bufpages ;
E 7
I 7
	int	 i ;
E 7
E 5

D 12
	if( namelist[NM_BUF].n_type == 0 ) {
E 12
I 12
	if( namelist[NM_BUF].n_value == 0 ) {
E 12
D 4
		info("buffer_cache: _buf not in namelist.\n", module);
E 4
I 4
		info("Buffer cache data not in namelist.\n", module);
E 4
		exit(1);
	}

D 7
	readk((long)namelist[NM_NBUF].n_value, (char *)&mon_buf.mon_nbuf,
		sizeof(mon_buf.mon_nbuf));
E 7
I 7
	/*
D 10
	 *	Set aside enough buf entries for every file
	 *	system in /etc/fstab + 1.
E 10
I 10
	 *	Set aside enough buf entries for every file system in 
	 *	/etc/fstab + 1.  An interesting problem with this is 
	 *	that a buffer gets allocated to each disk when a chpt 
	 *	is done.  These will will eventually be recycled and 
	 *	used somewhere interesting, but they are hard allocate
	 *	a BUF structure for and might cause an entry to be
	 *	missed.
E 10
	 */
	n_buf = 1 ;
E 7

D 7
	nbuf = mon_buf.mon_nbuf ;
E 7
I 7
	while( getfsent() != NULL )
		n_buf++ ;
E 7

I 4
D 5
        if((dp = (struct cache_detail *)calloc(nbuf, sizeof(*dp))) == NULL )
E 5
I 5
D 7
        if((dp = (struct detail *)calloc(nbuf, sizeof(*dp))) == NULL )
E 5
                fatal("Can't allocate space for buffer table", module) ;
E 7
I 7
	/*
	 *	Allocate space for them.
	 */
	if((mon_buf = (struct mon_buf *)calloc(n_buf, MON$S_BUF)) == NULL )
D 13
		fatal("Can't allocate space for BUF records", module);
E 13
I 13
		fatal("Can't allocate space for BUF structures: %s.\n", module);
E 13
E 7

I 7
	/*
	 *	Initialize all the record headers.
	 */
	for(i = 0; i < n_buf; i++) {
		mon_buf[i].mon_type   = MON$C_BUF ;
		mon_buf[i].mon_device = -1 ;
		mon_buf[i].mon_flag   = 0 ;
		mon_buf[i].mon_length = MON$S_BUF ;
	}

	/*
	 *	Read the number of buffers.
	 */
	mon_buf[0].mon_nbuf = nbuf = get_word((long)namelist[NM_NBUF].n_value) ;

	/*
	 *	Allocate space for the buffer headers.
	 */
E 7
E 4
	if((xbp = (struct buf *)calloc(nbuf, sizeof (struct buf))) == NULL )
D 4
		fatal("can't allocate space for buffer list", module);
E 4
I 4
		fatal("Can't allocate space for buffer list", module);
E 4

D 7
	readk((long)namelist[NM_BUF].n_value, (char *)&addr, sizeof(addr));
E 7
I 7
	/*
	 *	Read some more stuff from the kernel.  Addr is the address
	 *	of the beginning of the buffer cache headers.  Bufpages
	 *	is the number of pages set aside for buffers.
	 */
	addr = (struct buf *)get_word((long)namelist[NM_BUF].n_value) ;
E 7

D 5
	readk((long)namelist[NM_BUFPAGES].n_value, (char *)&mon_buf.mon_bufpages,
		sizeof(mon_buf.mon_bufpages)) ;
E 5
I 5
D 7
	readk((long)namelist[NM_BUFPAGES].n_value, (char *)&bufpages,
		sizeof(bufpages)) ;
E 7
I 7
	mon_buf[0].mon_bufpages = get_word((long)namelist[NM_BUFPAGES].n_value) ;
E 7

D 7
	mon_buf.mon_bufpages = bufpages * CLSIZE * NBPG ;
E 7
I 7
	/*
	 *	Calculate the size of "bufpages".
	 */
	mon_buf[0].mon_bufpages *= CLSIZE * NBPG ;
	mon_buf[0].mon_flag = MON$M_VALID ;
	(void)strcpy(mon_buf[0].mon_fsname, "Total:") ;
	
E 7
E 5
}

I 4
/*
D 7
 *	The comparision function for qsort.
E 7
I 7
 *	Compare function for the qsort(3) in collect_buffer_cache().
E 7
 */
int	buf_qsort(a, b)
D 5
struct cache_detail *a, *b ;
E 5
I 5
D 7
struct detail *a, *b ;
E 7
I 7
register struct mon_buf *a, *b ;
E 7
E 5
{
D 7
	if( a->mon_count > b->mon_count )
E 7
I 7
        if( a->mon_nused > b->mon_nused )
E 7
                return -1 ;
D 7
        else if( a->mon_count == b->mon_count )
E 7
I 7
        else if( a->mon_nused == b->mon_nused )
E 7
                return 0 ;
        else
                return 1 ;
}

/*
 *	Read a copy of the buffer headers and make a pass
 *	through them collecting the data.
 */
E 4
collect_buffer_cache()
{
D 4
	int i ;
E 4
I 4
	register i ;
D 7
	unsigned nbuf = mon_buf.mon_nbuf ;
E 7
I 7
	unsigned nbuf = mon_buf[0].mon_nbuf ;
E 7
E 4

D 5
	mon_buf.mon_memuse = 0 ;
	mon_buf.mon_memalloc = 0 ;
E 5
I 5
D 7
	mon_buf.mon_bcount = 0 ;
	mon_buf.mon_bufsize = 0 ;
E 5
	mon_buf.mon_nused = 0 ;
	mon_buf.mon_cache = 0 ;
E 7
I 7
	mon_buf[0].mon_bcount = 0 ;
	mon_buf[0].mon_bufsize = 0 ;
	mon_buf[0].mon_nused = 0 ;
	mon_buf[0].mon_cache = 0 ;
	mon_buf[0].mon_delwri = 0 ;
	mon_buf[0].mon_read = 0 ;
	mon_buf[0].mon_busy = 0 ;
	mon_buf[0].mon_done = 0 ;
	mon_buf[0].mon_inval = 0 ;
	mon_buf[0].mon_error = 0 ;
E 7

D 4
	if( xbp == NULL )
		open_buf() ;
E 4
I 4
D 7
	if( xbp == NULL || dp == NULL )
E 7
I 7
	if( xbp == NULL || mon_buf == NULL )
E 7
		setup_buf() ;
E 4

I 4
D 7
	nelp = 0 ;
E 7
I 7
	/*
	 *	Restart the list.
	 */
	nelp = 1 ;
E 7

E 4
I 3
	/*
I 7
	 *	Invalidate all the existing records, except the first.
	 */
	for(i = 1; i < n_buf; i++)
		mon_buf[i].mon_flag = 0 ;

	/*
E 7
	 *	Read the headers of the buffer cache.
	 */
E 3
D 4
	readk((long)addr, (char *)xbp, mon_buf.mon_nbuf * sizeof(struct buf)) ;
E 4
I 4
D 6
	readk((long)addr, (char *)xbp, nbuf * sizeof(struct buf)) ;
E 6
I 6
	readk((long)addr, (char *)xbp, (int)(nbuf * sizeof(struct buf))) ;
E 6
E 4

D 4
	for(i = 0; i < mon_buf.mon_nbuf; i++) {
		if( xbp[i].b_dev != -1 ) {
			mon_buf.mon_memuse += xbp[i].b_bcount;
			mon_buf.mon_memalloc += xbp[i].b_bufsize;
			mon_buf.mon_nused++;
			if( xbp[i].b_flags & B_CACHE )
				mon_buf.mon_cache++;
		}
	}
E 4
I 4
	/*
	 *	Summarize the data from each buffer.
	 */
	for(i = 0; i < nbuf; i++)
		if( xbp[i].b_dev != -1 )
			add_buf(xbp + i) ;

D 7
	/*
	 *	Sort the detail array.  Eventually I'll chain the
	 *	BUF records so that I save all of the and don't
	 *	have to sort them to get the "Top MON$C_DETAIL".
	 */
D 5
	qsort((char *)dp, (int)nbuf, sizeof(struct cache_detail), buf_qsort) ;
E 5
I 5
	qsort((char *)dp, (int)nbuf, sizeof(struct detail), buf_qsort) ;
E 7
I 7
	for(i = 1; i < n_buf; i++)
		get_fsname(mon_buf[i].mon_device, mon_buf[i].mon_fsname) ;
E 7
E 5

D 7
	/*
	 *	Copy the contents of the 
	 */
	for(i = 0; i < MON$C_DETAIL; i++) {
                if( dp[i].mon_device == -1 )
                        continue ;

                mon_buf.mon_detail[i] = dp[i] ;
        }
E 7
I 7
	if( n_buf >= 2 )
		qsort((char *)(mon_buf + 1), (int)(n_buf - 1), MON$S_BUF, 
			buf_qsort) ;
E 7
E 4
}

/*
I 4
D 7
 *	Comparison function for lsearch(3).
E 7
I 7
 *	Comparison function for lsearch(3) or lfind().
E 7
 */
buf_equal(a, b)
D 5
struct cache_detail *a, *b ;
E 5
I 5
D 7
struct detail *a, *b ;
E 7
I 7
struct mon_buf *a, *b ;
E 7
E 5
{
        if( a->mon_device == b->mon_device )
                return 0 ;
        else
                return -1 ;
}

/*
 *
 */
add_buf(bp)
register struct buf *bp ;
{
D 5
        struct cache_detail key, *p ;
E 5
I 5
D 7
        struct detail key, *p ;
E 7
I 7
        register struct mon_buf *p ;
	char	*(*funct)() ;
E 7
E 5

I 7
	/*
	 *	Do the totals.
	 */
	mon_buf[0].mon_bcount  += bp->b_bcount ;
	mon_buf[0].mon_bufsize += bp->b_bufsize ;
	mon_buf[0].mon_nused++ ;

	check_bits(bp->b_flags, mon_buf + 0) ;

D 10

E 10
	/*
	 *	Setup the key for the search.
	 */
E 7
        key.mon_device = bp->b_dev ;
D 7
        key.mon_count = 0 ;
        key.mon_cache = 0 ;
E 7

D 5
        p = (struct cache_detail *)lsearch((char *)&key, (char *)dp, &nelp,
E 5
I 5
D 7
        p = (struct detail *)lsearch((char *)&key, (char *)dp, &nelp,
E 7
I 7
	/*
	 *	If we've run out of table, arrange to just do a lookup.
	 */
	if( nelp == n_buf )
		funct = lfind ;
	else
		funct = lsearch ;

	/*
	 *	Search the table for this buffer entry.
	 */
        p = (struct mon_buf *)(*funct)((char *)&key, (char *)mon_buf, &nelp,
E 7
E 5
                sizeof(key), buf_equal) ;

D 7
        p->mon_count++ ;
E 7
I 7
	/*
	 *	If we didn't find it, print a message and increment
	 *	a counter.  This should only happen when the search
	 *	function is lsearch(3).
	 */
	if( p == NULL ) {
D 10
		info("No room for buffer.\n", module) ;
E 10
		missed_buffers++ ;
		return ;
	}
E 7

D 5
        mon_buf.mon_memuse   += bp->b_bcount;
        mon_buf.mon_memalloc += bp->b_bufsize;
E 5
I 5
D 7
        mon_buf.mon_bcount  += bp->b_bcount;
        mon_buf.mon_bufsize += bp->b_bufsize;
E 5
        mon_buf.mon_nused++ ;
E 7
I 7
	/*
	 *	Then the per device.
	 */
        p->mon_bcount  += bp->b_bcount;
        p->mon_bufsize += bp->b_bufsize;
        p->mon_nused++ ;
E 7

D 7
        if( bp->b_flags & B_CACHE ) {
                mon_buf.mon_cache++;
                p->mon_cache++ ;
        }
E 7
I 7
	check_bits(bp->b_flags, p) ;
E 7
}

I 7
check_bits(flags, p)
register long flags ;
register struct mon_buf *p ;
{
        if( flags & B_CACHE )
		p->mon_cache++ ;

	if( flags & B_DELWRI )
		p->mon_delwri++ ;

	if( flags & B_READ )
		p->mon_read++ ;

	if( flags & B_BUSY )
		p->mon_busy++ ;

	if( flags & B_DONE )
		p->mon_done++ ;

	if( flags & B_INVAL )
		p->mon_inval++ ;

	if( flags & B_ERROR )
		p->mon_error++ ;
}

E 7
/*
E 4
 *	Clean-up when everything is done.
 */
finish_buf()
{
	free((char *)xbp);
I 4

D 7
	free((char *)dp) ;
E 7
I 7
	free((char *)mon_buf) ;
E 7
}

/*
 *	Function to dump a record for easy reading.
 */
f_buf(p)
struct mon_buf *p ;
{
I 8
	if((p->mon_flag & MON$M_VALID) == 0 )
                return ;

D 9
        printf("%s.\n", records[MON$C_BUF].rec_string) ;
E 9
I 9
        printf("%s.\n", records[MON$C_BUF].string) ;
E 9

E 8
D 7
	int	i ;

E 7
	printf("\tnbuf:     %d\n", p->mon_nbuf) ;
	printf("\tbufpages: %d\n", p->mon_bufpages) ;
	printf("\tnused:    %d\n", p->mon_nused) ;
D 5
	printf("\tmemuse:   %d\n", p->mon_memuse) ;
	printf("\tmemalloc: %d\n", p->mon_memalloc) ;
E 5
I 5
	printf("\tbcount:   %d\n", p->mon_bcount) ;
	printf("\tbufsize:  %d\n", p->mon_bufsize) ;
E 5
	printf("\tcache:    %d\n", p->mon_cache) ;
D 7
	printf("\tdetail:\n") ;

	for(i = 0; i < MON$C_DETAIL; i++)
		if( p->mon_detail[i].mon_count )
			printf("\t\t<%d,%d>: %d %d\n", 
				major(p->mon_detail[i].mon_device),
				minor(p->mon_detail[i].mon_device),
				p->mon_detail[i].mon_count,
				p->mon_detail[i].mon_cache) ;
E 7
I 7
	printf("\tdelwri:   %d\n", p->mon_delwri) ;
	printf("\tread:     %d\n", p->mon_read) ;
	printf("\tbusy:     %d\n", p->mon_busy) ;
	printf("\tdone:     %d\n", p->mon_done) ;
	printf("\tinval:    %d\n", p->mon_inval) ;
	printf("\terror:    %d\n", p->mon_error) ;
	printf("\tdevice:   <%d,%d>\n", major(p->mon_device),
		minor(p->mon_device)) ;
	printf("\tfsname:   %s\n", p->mon_fsname) ;
E 7
E 4
}
E 2

/*
 *	Number of lines used by the buffer cache screen.
 */
D 3
#define	BUF_LINES	(3)
E 3
I 3
D 5
#define	BUF_LINES	(13)
E 5
I 5
D 7
#define	BUF_LINES	(8)
E 7
I 7
#define	BUF_LINES	(6)
E 7
E 5
E 3

/*
I 3
 *	Constants for how things are placed.
 */
#define	BUF_X		(0)
#define	BUF_Y		(3)
I 5
#define	FS_WIDTH	(24)
E 5

I 5
#define	HALF		(22)
#define	BUF_X_OFFSET	(7)
#define	BUF_X2_OFFSET	(31)

E 5
/*
E 3
 *      Setup the static screen for displaying buffer cache 
 *      information.
 *
 *      ARGSUSED
 */
open_buf(op)
OPTION	*op ;
{
	sample_header() ;

	lines = BUF_LINES ;
I 3

	wmove(wp, BUF_Y, 0) ;

D 5
	wprintw(wp, "nbuf:     %10u\n", mon_buf.mon_nbuf) ;
	wprintw(wp, "nused:    %10u\n", mon_buf.mon_nused) ;
	wprintw(wp, "cache:    %10u\n\n", mon_buf.mon_cache) ;
E 5
I 5
D 7
	wprintw(wp, "nbuf:\n") ;
	wprintw(wp, "nused:\n") ;
	wprintw(wp, "cache:") ;
E 7
I 7
	wprintw(wp, "There are %d buffers using %d bytes of memory.\n\n",
		mon_buf[0].mon_nbuf, mon_buf[0].mon_bufpages) ;
E 7
E 5

D 5
	wprintw(wp, "bufpages: %10u\n", mon_buf.mon_bufpages * CLSIZE * NBPG) ;
	wprintw(wp, "memuse:   %10u\n", mon_buf.mon_memuse) ;
	wprintw(wp, "memalloc: %10u\n", mon_buf.mon_memalloc) ;
E 5
I 5
D 7
	wmove(wp, BUF_Y, HALF) ;
	wprintw(wp, "bufpages:") ;

	wmove(wp, BUF_Y+1, HALF) ;
	wprintw(wp, "bufsize:") ;

	wmove(wp, BUF_Y+2, HALF) ;
	wprintw(wp, "bcount:") ;
E 7
I 7
	wprintw(wp, "%-*.*s %9s %8s %12s %10s", FS_WIDTH-1, FS_WIDTH-1,
		"File System", "Bufs used", "Cache", "Bytes used", "Bufsize") ;
E 7
E 5
E 3
}

/*
 *      Display the dynamic data of the buffer cache information.
 *
 *      ARGSUSED
 */
magnify_buf(op)
OPTION	*op ;
{
I 5
D 6
	register i, lines_used ;
E 6
I 6
	register i ;
E 6

E 5
	sample_body((double)(sample.mon_ticks - buf_ticks)/first.mon_hz) ;
        buf_ticks = sample.mon_ticks ;
I 3

D 5
	wmove(wp, BUF_Y, 0) ;
E 5
I 5
D 7
	wmove(wp, BUF_Y, BUF_X_OFFSET) ;
	wprintw(wp, "%10u", mon_buf.mon_nbuf) ;
E 7
I 7
	wmove(wp, BUF_LINES, 0) ;
E 7
E 5

D 5
	wprintw(wp, "nbuf:     %10u\n", mon_buf.mon_nbuf) ;
	wprintw(wp, "nused:    %10u\n", mon_buf.mon_nused) ;
	wprintw(wp, "cache:    %10u\n\n", mon_buf.mon_cache) ;
E 5
I 5
D 7
	wmove(wp, BUF_Y+1, BUF_X_OFFSET) ;
	wprintw(wp, "%10u", mon_buf.mon_nused) ;
E 5

D 5
	wprintw(wp, "bufpages: %10u\n", mon_buf.mon_bufpages * CLSIZE * NBPG) ;
	wprintw(wp, "memuse:   %10u\n", mon_buf.mon_memuse) ;
	wprintw(wp, "memalloc: %10u\n", mon_buf.mon_memalloc) ;
E 5
I 5
	wmove(wp, BUF_Y+2, BUF_X_OFFSET) ;
	wprintw(wp, "%10u", mon_buf.mon_cache) ;

	wmove(wp, BUF_Y, BUF_X2_OFFSET) ;
	wprintw(wp, "%10u\n", mon_buf.mon_bufpages) ;

	wmove(wp, BUF_Y+1, BUF_X2_OFFSET) ;
	wprintw(wp, "%10u\n", mon_buf.mon_bufsize) ;

	wmove(wp, BUF_Y+2, BUF_X2_OFFSET) ;
	wprintw(wp, "%10u\n", mon_buf.mon_bcount) ;

	wmove(wp, BUF_Y+4, 0) ;

E 7
	lines = BUF_LINES ;

D 7
	for(i = 0; i < MON$C_DETAIL; i++) {
		if( mon_buf.mon_detail[i].mon_count == 0 )
E 7
I 7
	for(i = 1; i < n_buf ; i++) {
D 8
		if( mon_buf[i].mon_nused == 0 )
E 8
I 8
		if( mon_buf[i].mon_nused == 0 || 
		    (mon_buf[i].mon_flag & MON$M_VALID) == 0 )
E 8
E 7
			continue ;

D 7
		wprintw(wp, "%-*.*s %10u %10u\n", FS_WIDTH, FS_WIDTH,
			get_fsname(op, mon_buf.mon_detail[i].mon_device),
			mon_buf.mon_detail[i].mon_count,
			mon_buf.mon_detail[i].mon_cache) ;
E 7
I 7
		wprintw(wp, "%-*.*s %8u %8u %12u %10u\n", 
			FS_WIDTH, FS_WIDTH, mon_buf[i].mon_fsname,
			mon_buf[i].mon_nused, mon_buf[i].mon_cache,
			mon_buf[i].mon_bcount, mon_buf[i].mon_bufsize) ;
E 7

		lines++ ;

D 7
		if( lines == LINES - 1 )
E 7
I 7
		if( lines == (LINES - 3))
E 7
			break ;
	}

I 7
	lines += 3 ;

	wprintw(wp, "\n%-*.*s %8u %8u %12u %10u", 
		FS_WIDTH, FS_WIDTH, mon_buf[0].mon_fsname,
		mon_buf[0].mon_nused, mon_buf[0].mon_cache,
		mon_buf[0].mon_bcount, mon_buf[0].mon_bufsize) ;

E 7
	wclrtobot(wp) ;
}

D 7
char	*get_fsname(op, dev)
OPTION	*op ;
E 7
I 7
#define	FS_BUFS	(32)

get_fsname(dev, buf)
E 7
dev_t	dev ;
I 7
char	*buf ;
E 7
{
D 7
	static	char buf[MAXPATHLEN+1] ;
	struct fs_data buffer[MON$C_DETAIL] ;
D 6
	int	start = 0, rc, base, i ;
E 6
I 6
	int	start = 0, rc, i ;
E 7
I 7
	struct fs_data buffer[FS_BUFS] ;
	register i ;
	int	start = 0, rc ;
E 7
E 6

D 7

	if( op->collect_mode != OPT_LIVE ) {
		(void)sprintf(buf, "<%d,%d> Live", major(dev), minor(dev)) ;
		return buf ;
	}

	while((rc = getmountent(&start, buffer, MON$C_DETAIL)) > 0 ) {
E 7
I 7
	while((rc = getmountent(&start, buffer, FS_BUFS)) > 0 ) {
E 7
		for(i = 0; i < rc; i++)
			if( dev == buffer[i].fd_req.dev ) {
				(void)strcpy(buf, buffer[i].fd_req.path) ;
				buf[FS_WIDTH-1] = '/' ;
D 7
				return buf ;
E 7
I 7
				return ;
E 7
			}
	}
	
	(void)sprintf(buf, "<%d,%d>", major(dev), minor(dev)) ;

D 7
	return buf ;
E 7
I 7
	return ;
E 7
E 5
E 3
}
E 1
