--TEST--
strtotime() function
--SKIPIF--
<?php
if (substr(PHP_OS, 0, 3) != 'WIN') {
    print 'skip test for win32 only';
}
if (!@putenv("TZ=GST-1GDT") || getenv("TZ") != 'GST-1GDT') {
    die("skip unable to change TZ enviroment variable\n");
}
?>
--FILE--
<?php
    $dates = array (
        "1999-10-13",
        "Oct 13  1999",
        "2000-01-19",
        "Jan 19  2000",
        "2001-12-21",
        "Dec 21  2001",
        "2001-12-21 12:16",
        "Dec 21 2001 12:16",
        "2001-10-22 21:19:58",
        "2001-10-22 21:19:58-02",
        "2001-10-22 21:19:58-0213",
        "2001-10-22 21:19:58+02",
        "2001-10-22 21:19:58+0213"
    );

    putenv ("TZ=GMT");
    foreach ($dates as $date) {
        echo date("Y-m-d H:i:s\n", strtotime ($date));
    }

    putenv ("TZ=GST-1GDT");
    foreach ($dates as $date) {
        echo date("Y-m-d H:i:s\n", strtotime ($date));
    }
?>
--EXPECT--
1999-10-13 00:00:00
1999-10-13 00:00:00
2000-01-19 00:00:00
2000-01-19 00:00:00
2001-12-21 00:00:00
2001-12-21 00:00:00
2001-12-21 12:16:00
2001-12-21 12:16:00
2001-10-22 21:19:58
2001-10-22 23:19:58
2001-10-22 23:32:58
2001-10-22 19:19:58
2001-10-22 19:06:58
1999-10-13 00:00:00
1999-10-13 00:00:00
2000-01-19 00:00:00
2000-01-19 00:00:00
2001-12-21 00:00:00
2001-12-21 00:00:00
2001-12-21 12:16:00
2001-12-21 12:16:00
2001-10-22 21:19:58
2001-10-23 01:19:58
2001-10-23 01:32:58
2001-10-22 21:19:58
2001-10-22 21:06:58
