/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	applemac_ibmpc
#include <stdio.h>
#include "common.h"

static unsigned char translation_table[256] = 
  {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11, /* 11 */ 
     12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23, /* 23 */ 
     24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35, /* 35 */ 
     36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, /* 47 */ 
     48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59, /* 59 */ 
     60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71, /* 71 */ 
     72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83, /* 83 */ 
     84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, /* 95 */ 
     96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, /* 107 */
    108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, /* 119 */
    120, 121, 122, 123, 124, 125, 126, 127, 142, 143, 128, 144, /* 131 */
    165, 153, 154, 160, 133, 131, 132,   0, 134, 135, 130, 138, /* 143 */
    136, 137, 161, 141, 140, 139, 164, 162, 149, 147, 148,   0, /* 155 */
    163, 151, 150, 129,   0, 248, 155, 156,   0, 250,   0, 225, /* 167 */
      0, 169, 170, 171, 172,   0, 146,   0, 236, 241, 243, 242, /* 179 */
    157, 230, 235, 228, 184, 227, 186, 166, 167, 234, 145, 191, /* 191 */
    168, 173, 194, 195, 159, 247, 198, 174, 175, 201, 202, 203, /* 203 */
    204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 246, 215, /* 215 */
    216, 217, 218, 219, 220, 221, 222, 223, 224,   0, 226,   0, /* 227 */
      0, 229,   0, 231, 232, 233,   0,   0,   0, 237, 238, 239, /* 239 */
    240,   0,   0,   0, 244, 245,   0,   0,   0, 249,   0, 251, /* 251 */
    252, 253, 254, 255,
  };

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */
  int output_char;		/* translated character */

  while (input_char = getc (input_file), input_char != EOF)
    if (input_char == '\n')
      {
	putc (0x0D, output_file);
	putc (0x0A, output_file);
      }
    else
      if (output_char = translation_table[input_char], output_char != '\0')
	putc (output_char, output_file);
}
