/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	iconqnx_ibmpc
#include <stdio.h>
#include "common.h"

/* Previous obsolete lex code:

Esc			\031

%%

{Esc}Aa			{ output (0x85); }
{Esc}Ae			{ output (0x8A); }
{Esc}Au			{ output (0x97); }

{Esc}Be			{ output (0x82); }
{Esc}BE			{ output (0x90); }

{Esc}Ca			{ output (0x83); }
{Esc}Ce			{ output (0x88); }
{Esc}Ci			{ output (0x8C); }
{Esc}Co			{ output (0x93); }
{Esc}Cu			{ output (0x96); }

{Esc}He			{ output (0x89); }
{Esc}Hi			{ output (0x8B); }
{Esc}Hu			{ output (0x81); }

{Esc}Kc			{ output (0x87); }
{Esc}KC			{ output (0x80); }

*/

#define ESCAPE 0x19		/* Escape for diacritic application */
#define ENDLINE 0x1E		/* End-line code for QNX */

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */

  while (input_char = getc (input_file), input_char != EOF)
    {
      switch (input_char)
	{
	case ENDLINE:
	  putc (0x0D, output_file);
	  putc (0x0A, output_file);
	  break;

	case ESCAPE:
	  input_char = getc (input_file);
	  switch (input_char)
	    {
	    case 'A':
	      input_char = getc (input_file);
	      switch (input_char)
		{
		case 'a': input_char = 0x85; break;
		case 'e': input_char = 0x8a; break;
		case 'u': input_char = 0x97; break;
	      
		default:
		  putc (ESCAPE, output_file);
		  putc ('A', output_file);
		  if (input_char == EOF)
		    return;
		}
	      break;

	    case 'B':
	      input_char = getc (input_file);
	      switch (input_char)
		{
		case 'e': input_char = 0x82; break;
		case 'E': input_char = 0x90; break;
	      
		default:
		  putc (ESCAPE, output_file);
		  putc ('B', output_file);
		  if (input_char == EOF)
		    return;
		}
	      break;

	    case 'C':
	      input_char = getc (input_file);
	      switch (input_char)
		{
		case 'a': input_char = 0x83; break;
		case 'e': input_char = 0x88; break;
		case 'i': input_char = 0x8c; break;
		case 'o': input_char = 0x93; break;
		case 'u': input_char = 0x96; break;
	      
		default:
		  putc (ESCAPE, output_file);
		  putc ('C', output_file);
		  if (input_char == EOF)
		    return;
		}
	      break;

	    case 'H':
	      input_char = getc (input_file);
	      switch (input_char)
		{
		case 'e': input_char = 0x89; break;
		case 'i': input_char = 0x8b; break;
		case 'u': input_char = 0x81; break;
	      
		default:
		  putc (ESCAPE, output_file);
		  putc ('H', output_file);
		  if (input_char == EOF)
		    return;
		}
	      break;

	    case 'K':
	      input_char = getc (input_file);
	      switch (input_char)
		{
		case 'c': input_char = 0x87; break;
		case 'C': input_char = 0x80; break;
	      
		default:
		  putc (ESCAPE, output_file);
		  putc ('K', output_file);
		  if (input_char == EOF)
		    return;
		}
	      break;
	      
	    default:
	      putc (ESCAPE, output_file);
	      if (input_char == EOF)
		return;
	    }
	  /* fall through */

	default:
	  putc (input_char, output_file);
	}
    }
}
