/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	ibmpc_latin1
#include <stdio.h>
#include "common.h"

#define DOS_EOF	0x1A		/* MS-DOS old end-of-file */

static const char *translation_table[128] =
  {
    "\307",			/* \200  C, */
    "\374",			/* \201  u" */
    "\351",			/* \202  e' */
    "\342",			/* \203  a^ */
    "\344",			/* \204  a" */
    "\340",			/* \205  a` */
    "\345",			/* \206  aa */
    "\347",			/* \207  c, */
    "\352",			/* \210  e^ */
    "\353",			/* \211  e" */
    "\350",			/* \212  e` */
    "\357",			/* \213  i" */
    "\356",			/* \214  i^ */
    "\354",			/* \215  i` */
    "\304",			/* \216  A" */
    "\305",			/* \217  AA */
    "\311",			/* \220  E' */
    "\346",			/* \221  ae */
    "\306",			/* \222  AE */
    "\364",			/* \223  o^ */
    "\366",			/* \224  o" */
    "\362",			/* \225  o` */
    "\373",			/* \226  u^ */
    "\371",			/* \227  u` */
    "\377",			/* \230  y" */
    "\326",			/* \231  O" */
    "\334",			/* \232  U" */
    "\242",			/* \233  \cent */
    "\243",			/* \234  \pound */
    "\245",			/* \235  \yen */
    "<Pt>",			/* \236 */
    "<f>",			/* \237 */
    "\341",			/* \240  a' */
    "\355",			/* \241  i' */
    "\363",			/* \242  o' */
    "\372",			/* \243  u' */
    "\361",			/* \244  n~ */
    "\321",			/* \245  N~ */
    "\252",			/* \246  a_ */
    "\272",			/* \247  o_ */
    "\277",			/* \250  ?' */
    "<->",			/* \251 */
    "\254",			/* \252  \neg */
    "\274",			/* \253  1/2 */
    "\273",			/* \254  1/4 */
    "\241",			/* \255  !` */
    "\253",			/* \256  `` */
    "\273",			/* \257  '' */
    "#",			/* \260 */
    "#",			/* \261 */
    "#",			/* \262 */
    "|",			/* \263 */
    "+",			/* \264 */
    "|",			/* \265 */
    "+",			/* \266 */
    "+",			/* \267 */
    "=",			/* \270 */
    "=",			/* \271 */
    "|",			/* \272 */
    "=",			/* \273 */
    "=",			/* \274 */
    "+",			/* \275 */
    "=",			/* \276 */
    "+",			/* \277 */
    "+",			/* \300 */
    "+",			/* \301 */
    "+",			/* \302 */
    "+",			/* \303 */
    "-",			/* \304 */
    "+",			/* \305 */
    "|",			/* \306 */
    "+",			/* \307 */
    "=",			/* \310 */
    "=",			/* \311 */
    "=",			/* \312 */
    "=",			/* \313 */
    "=",			/* \314 */
    "=",			/* \315 */
    "=",			/* \316 */
    "=",			/* \317 */
    "+",			/* \320 */
    "=",			/* \321 */
    "+",			/* \322 */
    "+",			/* \323 */
    "=",			/* \324 */
    "=",			/* \325 */
    "+",			/* \326 */
    "+",			/* \327 */
    "=",			/* \330 */
    "+",			/* \331 */
    "+",			/* \332 */
    "#",			/* \333 */
    "#",			/* \334 */
    "#",			/* \335 */
    "#",			/* \336 */
    "#",			/* \337 */
    "<alpha>",			/* \340 */
    "\337",			/* \341  \ss */
    "<Gamma>",			/* \342 */
    "<pi>",			/* \343 */
    "<Sigma>",			/* \344 */
    "<sigma>",			/* \345 */
    "\265",			/* \346  \micro */
    "<tau>",			/* \347 */
    "<Phi>",			/* \350 */
    "<Theta>",			/* \351 */
    "<Omega>",			/* \352 */
    "<delta>",			/* \353 */
    "<infty>",			/* \354 */
    "<phi>",			/* \355 */
    "<in>",			/* \356 */
    "<cap>",			/* \357 */
    "<equiv>",			/* \360 */
    "\261",			/* \361  +- */
    ">=",			/* \362 */
    "<=",			/* \363 */
    "<integ1>",			/* \364 */
    "<integ2>",			/* \365 */
    "\327",			/* \366  \div */
    "<approx>",			/* \367 */
    "\260",			/* \370  \deg */
    "<*>",			/* \371 */
    "\267",			/* \372  \cdot */
    "<surd>",			/* \373 */
    "<^n>",			/* \374 */
    "\262",			/* \375  ^2 */
    "<#>",			/* \376 */
    "\240",			/* \377  \  */
  };

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */
  const char *output_string;	/* translated characters */

  input_char = getc (input_file);
  while (input_char != EOF && input_char != DOS_EOF)
    if ((input_char & 0377) < 0200)
      if (input_char == 0x0D)
	{
	  input_char = getc (input_file);
	  if (input_char == 0x0A)
	    {
	      putc ('\n', output_file);
	      input_char = getc (input_file);
	    }
	  else
	    putc (0x0D, output_file);
	}
      else
	{
	  putc (input_char, output_file);
	  input_char = getc (input_file);
	}
    else
      {
	if (output_string = translation_table[input_char & 0177],
	    output_string)
	  while (*output_string)
	    {
	      putc (*output_string, output_file);
	      output_string++;
	    }
	input_char = getc (input_file);
      }
}
