/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	ebcdic_cccascii
#include <stdio.h>
#include "common.h"

static unsigned char translation_table[256] = 
  {
    '\000', '\001', '\002', '\003', '\200', '\011', '\201', '\177',
    '\202', '\203', '\204', '\013', '\014', '\015', '\016', '\017',
    '\020', '\021', '\022', '\023', '\205', '\206', '\010', '\207',
    '\030', '\031', '\210', '\211', '\034', '\035', '\036', '\037',
    '\220', '\221', '\222', '\223', '\224', '\012', '\027', '\033',
    '\225', '\226', '\227', '\230', '\231', '\005', '\006', '\007',
    '\240', '\241', '\026', '\242', '\243', '\244', '\245', '\004',
    '\246', '\247', '\250', '\251', '\024', '\025', '\371', '\032',
    '\040', '\301', '\302', '\303', '\304', '\305', '\306', '\307',
    '\310', '\311', '\133', '\056', '\074', '\050', '\053', '\135',
    '\046', '\321', '\322', '\323', '\324', '\325', '\326', '\327',
    '\330', '\331', '\041', '\044', '\052', '\051', '\073', '\136',
    '\055', '\057', '\342', '\343', '\344', '\345', '\346', '\347',
    '\350', '\351', '\174', '\054', '\045', '\137', '\076', '\077',
    '\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
    '\370', '\140', '\072', '\043', '\100', '\047', '\075', '\042',
    '\300', '\141', '\142', '\143', '\144', '\145', '\146', '\147',
    '\150', '\151', '\212', '\213', '\214', '\215', '\216', '\217',
    '\320', '\152', '\153', '\154', '\155', '\156', '\157', '\160',
    '\161', '\162', '\232', '\233', '\234', '\235', '\236', '\237',
    '\340', '\176', '\163', '\164', '\165', '\166', '\167', '\170',
    '\171', '\172', '\252', '\253', '\254', '\255', '\256', '\257',
    '\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267',
    '\270', '\271', '\272', '\273', '\274', '\275', '\276', '\277',
    '\173', '\101', '\102', '\103', '\104', '\105', '\106', '\107',
    '\110', '\111', '\312', '\313', '\314', '\315', '\316', '\317',
    '\175', '\112', '\113', '\114', '\115', '\116', '\117', '\120',
    '\121', '\122', '\332', '\333', '\334', '\335', '\336', '\337',
    '\134', '\341', '\123', '\124', '\125', '\126', '\127', '\130',
    '\131', '\132', '\352', '\353', '\354', '\355', '\356', '\357',
    '\060', '\061', '\062', '\063', '\064', '\065', '\066', '\067',
    '\070', '\071', '\372', '\373', '\374', '\375', '\376', '\377',
  };

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */

  while (input_char = getc (input_file), input_char != EOF)
    putc (translation_table[input_char], output_file);
}
