/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	cdcascii_ebcdic
#include <stdio.h>
#include "common.h"

static unsigned char translation_table[256] = 
  {
     '\000', '\001', '\002', '\003', '\067', '\055', '\056', '\057',
     '\026', '\005', '\045', '\013', '\014', '\015', '\016', '\017',
     '\020', '\021', '\022', '\023', '\074', '\075', '\062', '\046',
     '\030', '\031', '\077', '\047', '\034', '\035', '\036', '\037',
     '\100', '\117', '\177', '\173', '\133', '\154', '\120', '\175',
     '\115', '\135', '\134', '\116', '\153', '\140', '\113', '\141',
     '\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
     '\370', '\371', '\172', '\136', '\114', '\176', '\156', '\157',
     '\174', '\301', '\302', '\303', '\304', '\305', '\306', '\307',
     '\310', '\311', '\321', '\322', '\323', '\324', '\325', '\326',
     '\327', '\330', '\331', '\342', '\343', '\344', '\345', '\346',
     '\347', '\350', '\351', '\112', '\340', '\132', '\137', '\155',
     '\171', '\201', '\202', '\203', '\204', '\205', '\206', '\207',
     '\210', '\211', '\221', '\222', '\223', '\224', '\225', '\226',
     '\227', '\230', '\231', '\242', '\243', '\244', '\245', '\246',
     '\247', '\250', '\251', '\300', '\152', '\320', '\241', '\007',
     '\040', '\041', '\042', '\043', '\044', '\025', '\006', '\027',
     '\050', '\051', '\052', '\053', '\054', '\011', '\012', '\033',
     '\060', '\061', '\032', '\063', '\064', '\065', '\066', '\010',
     '\070', '\071', '\072', '\073', '\004', '\024', '\076', '\341',
     '\101', '\102', '\103', '\104', '\105', '\106', '\107', '\110',
     '\111', '\121', '\122', '\123', '\124', '\125', '\126', '\127',
     '\130', '\131', '\142', '\143', '\144', '\145', '\146', '\147',
     '\150', '\151', '\160', '\161', '\162', '\163', '\164', '\165',
     '\166', '\167', '\170', '\200', '\212', '\213', '\214', '\215',
     '\216', '\217', '\220', '\232', '\233', '\234', '\235', '\236',
     '\237', '\240', '\252', '\253', '\254', '\255', '\256', '\257',
     '\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267',
     '\270', '\271', '\272', '\273', '\274', '\275', '\276', '\277',
     '\312', '\313', '\314', '\315', '\316', '\317', '\332', '\333',
     '\334', '\335', '\336', '\337', '\352', '\353', '\354', '\355',
     '\356', '\357', '\372', '\373', '\374', '\375', '\376', '\377',
};

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */

  while (input_char = getc (input_file), input_char != EOF)
    putc (translation_table[input_char], output_file);
}
