/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	ascii_flat
#include <stdio.h>
#include "common.h"

/* Previous obsolete lex code:

\n			{ ECHO; }

\000			{ output ('^'); output ('@'); }
\001			{ output ('^'); output ('A'); }
\002			{ output ('^'); output ('B'); }
\003			{ output ('^'); output ('C'); }
\004			{ output ('^'); output ('D'); }
\005			{ output ('^'); output ('E'); }
\006			{ output ('^'); output ('F'); }
\007			{ output ('\\'); output ('a'); }
\010			{ output ('\\'); output ('b'); }
\011			{ output ('\\'); output ('t'); }
\012			{ output ('\\'); output ('n'); }
\013			{ output ('^'); output ('K'); }
\014			{ output ('^'); output ('L'); }
\015			{ output ('^'); output ('M'); }
\016			{ output ('^'); output ('N'); }
\017			{ output ('^'); output ('O'); }
\020			{ output ('^'); output ('P'); }
\021			{ output ('^'); output ('Q'); }
\022			{ output ('^'); output ('R'); }
\023			{ output ('^'); output ('S'); }
\024			{ output ('^'); output ('T'); }
\025			{ output ('^'); output ('U'); }
\026			{ output ('^'); output ('V'); }
\027			{ output ('^'); output ('W'); }
\030			{ output ('^'); output ('X'); }
\031			{ output ('^'); output ('Y'); }
\032			{ output ('^'); output ('Z'); }
\033			{ output ('^'); output ('['); }
\034			{ output ('^'); output ('\\'); }
\035			{ output ('^'); output (']'); }
\036			{ output ('^'); output ('^'); }
\037			{ output ('^'); output ('_'); }

\177			{ output ('D'); output ('E'); output ('L'); }

['`^",_]\b.		{ output (yytext[2]); }
.\b['`^",_]		{ output (yytext[0]); }

*/

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */
  int temp_char;		/* look ahead character */

  input_char = getc (input_file);
  while (1)
    switch (input_char)
      {
      case EOF:
	return;

      case '\n':
	putc ('\n', output_file);
	input_char = getc (input_file);
	break;

      case '\b':
	input_char = getc (input_file);
	switch (input_char)
	  {
	  case EOF:
	    putc ('^', output_file);
	    putc ('H', output_file);
	    return;

	  case '\'':
	  case '`':
	  case '^':
	  case '"':
	  case ',':
	  case '_':
	    input_char = getc (input_file);
	    break;

	  default:
	    putc ('^', output_file);
	    putc ('H', output_file);
	  }
	break;

      case '\'':
      case '`':
      case '^':
      case '"':
      case ',':
      case '_':
	temp_char = getc (input_file);
	if (temp_char == '\b')
	  input_char = getc (input_file);
	else
	  {
	    putc (input_char, output_file);
	    input_char = temp_char;
	  }
	break;

      default:
	if (input_char & 0200)
	  {
	    putc ('M', output_file);
	    putc ('-', output_file);
	    input_char &= 0177;
	  }
	if (input_char < ' ' || input_char == 0177)
	  {
	    putc ('^', output_file);
	    input_char ^= 0100;
	  }
	putc (input_char, output_file);
	input_char = getc (input_file);
      }
}
