/* Here is the problem:
	bash globs wild cards in the argument list and passes them to the
	program, while OS/2 shells expect the application to do the globbing.
	This makes it very difficult for a program to act consistently under
	bash and OS/2 shell.  This program is designed to find out whether
	the enviornment will return the correct name of the string.
   The results are simple:
	under bash the enviornment variable SHELL is defined and references the
	full path name of the bash executable.  Under 4OS2, SHELL is undefined.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

char **globArgv (int argc,	int next, int *new, char **argv)
{
char	*pArg,
		*pch,
		*shellName;
char	**oldArg,
		**newArg,
		**tempArg,
		**useTemp;
int		i,
		oldArgCount,
		newArgCount;

*new = argc;
shellName = getenv("SHELL");
if(shellName)			/* bash returns value of SHELL environment variable.
						   No need to glob if this is the current shell.
						*/
	return argv;
oldArgCount = next;
if(next == argc)
	return argv;
oldArg = (char **)malloc(argc * sizeof(char *));
memcpy(oldArg, argv, next*(sizeof(char *)));
for(i=next, pArg=argv[next];	i<argc;	++i, pArg=argv[i])
	{tempArg = glob_filename(pArg);
	for(newArgCount=0, pch=*tempArg;	pch;	pch=*(tempArg+newArgCount))
		++newArgCount;
	if(newArgCount)
		useTemp = tempArg;
	else
		{newArgCount = 1;
		useTemp = &pArg;
		}
	*new = newArgCount + oldArgCount;
	newArg = (char **)realloc(oldArg, (oldArgCount+newArgCount)*sizeof(char *));
	memcpy(newArg+oldArgCount, useTemp, newArgCount*sizeof(char *));
	oldArgCount += newArgCount;
	oldArg = newArg;
	free(tempArg);
	}
return newArg;
}

#if defined(TEST)
main(int argc, char ** argv)
{
char	*pch;
int		i;

argv = globArgv(argc, 2, &argc, argv);
for(i=0, pch=*argv;	i<argc;	++i, pch=*(argv+i))
	printf("%s ", pch);
putchar('\n');
exit(0);
}
#endif
