/* emx/syscalls.h (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#if !defined (NULL)
#define NULL ((void *)0)
#endif

#if !defined (INIT)
#define EXTERN extern
#define INIT(x)
#endif

#define BEGIN do {
#define END   } while (0)

#if defined (_OS2EMX_H)

#define FTIMEZEROP(x) (*(USHORT *)&(x) == 0)
#define FDATEZEROP(x) (*(USHORT *)&(x) == 0)

struct find_data
{
  HDIR find_handle;
  ULONG find_count;
  FILEFINDBUF3 find_buf;
};

#endif /* _OS2EMX_H */

EXTERN void *_sys_heap_base INIT (NULL);
EXTERN void *_sys_heap_brk INIT (NULL);
EXTERN unsigned _sys_heap_size INIT (0);
EXTERN int _sys_umask INIT (0022);
EXTERN unsigned long _sys_clock0_lo INIT (0);
EXTERN unsigned long _sys_clock0_hi INIT (0);
EXTERN unsigned long _sys_clock0_ms INIT (0);
EXTERN long _sys_ino INIT (0x100000);

#if defined (__MT__)

#define MAX_THREADS 1024

/* This mutex semaphore protects the heap for __sbrk().  Note that
   HMTX is unsigned long. */
EXTERN unsigned long _sbrk_mutex INIT (0);

EXTERN void *_sys_private_heap INIT (NULL);

#if defined (_OS2EMX_H)
struct sys_thread_data
{
  struct find_data mt_fd;
};

EXTERN struct sys_thread_data *_sys_thread_table[MAX_THREADS];

struct sys_thread_data *_sys_thread (void);

#endif /* _OS2EMX_H */
#endif /* __MT__ */

void _sys_set_errno (unsigned long rc);
void _sys_get_clock (unsigned long *lo, unsigned long *hi, unsigned long *ms);

#if defined (_OS2EMX_H)
long _sys_p2t (FTIME t, FDATE d);
#endif /* _OS2EMX_H */
