/* fork.c (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <process.h>
#include <stdio.h>

#if defined(__DEBUG__)
#include <os2emx.h>
extern FILE		*debugFile;
extern HFILE	pipeReadHandle,
				pipeWriteHandle;
#define DEBUG_OUT writeDebugInfo
#else
#define DEBUG_OUT(a)
#endif

int fork (void)
{
int		newPid;

newPid = __fork();
#if defined(__DEBUG__)
DEBUG_OUT("fork: pid=%d, newPid=%d, pipeReadHandle=%d, pipeWriteHandle=%d\n",
	getpid(), newPid, pipeReadHandle, pipeWriteHandle);
#endif
return newPid;
}
