/* getopts.c, created from getopts.def. */
#line 23 "(null)getopts.def"

#line 60 "(null)getopts.def"

#include <stdio.h>
#include "../shell.h"
#include "getopt.h"

#ifndef NULL
#define NULL		0
#endif

#define G_EOF		(-1)
#define G_ILLEGAL_OPT	(-2)
#define G_ARG_MISSING	(-3)

extern char *this_command_name;

/* getopts_reset is magic code for when OPTIND is reset.  N is the
   value that has just been assigned to OPTIND. */
void
getopts_reset (newind)
     int newind;
{
  optind = newind;
}

/* Error handling is now performed as specified by Posix.2, draft 11
   (identical to that of ksh-88).  The special handling is enabled if
   the first character of the option string is a colon; this handling
   disables diagnostic messages concerning missing option arguments
   and illegal option characters.  The handling is as follows.

   ILLEGAL OPTIONS:
        name -> "?"
        if (special_error) then
                OPTARG = option character found
                no error output
        else
                OPTARG unset
                diagnostic message
        fi
 
  MISSING OPTION ARGUMENT;
        if (special_error) then
                name -> ":"
                OPTARG = option character found
        else
                name -> "?"
                OPTARG unset
                diagnostic message
        fi
 */

static int
dogetopts (argc, argv)
     int argc;
     char **argv;
{
  int ret, special_error, old_opterr = 0;
  char strval[2];
  char *optstr;			/* list of options */
  char *name;			/* variable to get flag val */
  char *t;

  if (argc < 3)
    {
      builtin_error("3 arguments expected");
      return (EXECUTION_FAILURE);
    }

  /* argv[0] is "getopts". */

  optstr = argv[1];
  name = argv[2];
  argc -= 2;
  argv += 2;

  special_error = optstr[0] == ':';

  if (special_error)
    {
      old_opterr = opterr;
      optstr++;
      opterr = 0;		/* suppress diagnostic messages */
    }

  if (argc > 1)
    {
      t = argv[0];
      argv[0] = dollar_vars[0];
      ret = getopt(argc, argv, optstr);
      argv[0] = t;
    }
  else
    {
      register int i;

      for (i = 0; dollar_vars[i]; i++);
      ret = getopt (i, dollar_vars, optstr);
    }

  if (special_error)
    opterr = old_opterr;

  /* Set the OPTIND variable in any case, to handle "--" skipping. */
  {
    char numval[16];

    sprintf (numval, "%d", optind);
    bind_variable ("OPTIND", numval);
  }

  /* If an error occurred, decide which one it is and set the return
     code appropriately.  In all cases, the option character in error
     is in OPTOPT.  If an illegal option was encountered, OPTARG is
     NULL.  If a required option argument was missing, OPTARG points
     to a NULL string (that is, optarg[0] == 0). */
  if (ret == '?')
    {
      if (optarg == NULL)
	ret = G_ILLEGAL_OPT;
      else if (optarg[0] == '\0')
	ret = G_ARG_MISSING;
    }
	    
  if (ret == G_EOF)
    {
      bind_variable (name, "?");
      return (EXECUTION_FAILURE);
    }

  if (ret == G_ILLEGAL_OPT)
    {
      /* Illegal option encountered. */
      strval[0] = '?';
      strval[1] = '\0';
      bind_variable (name, strval);

      if (special_error)
	{
	  strval[0] = (char) optopt;
	  strval[1] = '\0';
	  bind_variable ("OPTARG", strval);
	}
      else
	makunbound ("OPTARG", shell_variables);
      return (EXECUTION_SUCCESS);
    }

  if (ret == G_ARG_MISSING)
    {
      /* Required argument missing. */
      if (special_error)
	{
	  strval[0] = ':';
	  strval[1] = '\0';
	  bind_variable (name, strval);

	  strval[0] = (char) optopt;
	  strval[1] = '\0';
	  bind_variable ("OPTARG", strval);
	}
      else
	{
	  strval[0] = '?';
	  strval[1] = '\0';
	  bind_variable (name, strval);
	  makunbound ("OPTARG", shell_variables);
	}
      return (EXECUTION_SUCCESS);
    }			

  bind_variable ("OPTARG", optarg);

  strval[0] = (char) ret;
  strval[1] = '\0';
  bind_variable (name, strval);

  return (EXECUTION_SUCCESS);
}

/* The getopts builtin.  Build an argv, and call dogetopts with it. */
int
getopts_builtin (list)
     WORD_LIST *list;
{
  register int	i;
  char **av;
  int ac, ret;
  WORD_LIST *t = list;
  static int order_set = 0;

  if (!list)
    return EXECUTION_FAILURE;

  for (ac = 0; t; t = t->next, ac++);

  ac++;
  av = (char **)xmalloc ((1 + ac) * sizeof (char *));
  av[ac] = (char *) NULL;
  av[0] = savestring (this_command_name);

  for (t = list, i = 1; t; t = t->next, i++)
    av[i] = savestring (t->word->word);

  if (order_set == 0)
    {
      getopt_set_posix_option_order (1);
      order_set++;
    }

  ret = dogetopts (ac, av);
  free_array (av);
  return (ret);
}
