/* bind.c, created from bind.def. */
#line 23 "(null)bind.def"

#line 39 "(null)bind.def"

#include <stdio.h>
#include "../shell.h"
#include "../lib/readline/readline.h"		/* 2/93 ROB */
#include "../lib/readline/history.h"		/* 2/93 ROB */
#include <errno.h>						/* 3/93 ROB */

int
bind_builtin (list)
     WORD_LIST *list;
{
  extern int bash_readline_initialized;
  int processing_args = 1;
  int return_code = EXECUTION_SUCCESS;

  begin_unwind_frame ("bind");
  unwind_protect_pointer (rl_outstream);
  rl_outstream = stdout;

  if (!bash_readline_initialized)
    initialize_readline ();
    
  while (processing_args && list && list->word->word[0] == '-')
    {
      register int i;
      extern void rl_function_dumper ();
      char *word = list->word->word;

      list = list->next;

      for (i = 1; word[i]; i++)
	{
	  switch (word[i])
	    {
	    case 'l':
	      rl_list_funmap_names (0);
	      break;

	    case 'v':
	      rl_function_dumper (0);
	      break;

	    case 'd':
	      rl_function_dumper (1);
	      break;

	    case 'f':
	      if (!list)
		{
		  builtin_error ("-f requires a file name");
		  goto error_exit;
		}
	      else
		{
		  extern int errno;
		  char *initfile;

		  initfile = list->word->word;

		  if (rl_read_init_file (initfile) != 0)
		    {
		      builtin_error ("Cannot read %s: %s",
				     initfile, strerror (errno));
		      goto error_exit;
		    }
		  else
		    list = list->next;
		}
	      break;

	    case 'q':
	      if (!list)
		{
		  builtin_error ("-q requires the name of a function");
		  goto error_exit;
		}
	      else while (list)
		{
		  extern Function *rl_named_function ();
		  extern char **rl_invoking_keyseqs ();
		  Function *function;
		  char *name, **keyseqs;

		  name = list->word->word;
		  list = list->next;

		  function = rl_named_function (name);

		  if (!function)
		    {
		      builtin_error ("Unknown function name `%s'", name);
		      goto error_exit;
		    }

		  keyseqs = rl_invoking_keyseqs (function);

		  if (!keyseqs)
		    {
		      printf ("%s is not bound to any keys.\n", name);
		    }
		  else
		    {
		      register int j;

		      printf ("%s can be invoked via ", name);

		      for (j = 0; j < 5 && keyseqs[j]; j++)
			printf ("\"%s\"%s", keyseqs[j],
				keyseqs[j + 1] ? ", " : ".\n");

		      if (keyseqs[j])
			printf ("...\n");

		      free_array (keyseqs);
		    }
		}
	      break;

	    case '-':
	      processing_args = 0;
	      break;

	    default:
	      builtin_error ("Bad argument %c", word[i]);

	    error_exit:
	      return_code = EXECUTION_FAILURE;
	      goto bind_exit;
	    }
	}
    }

  while (list)
    {
      rl_parse_and_bind (list->word->word);
      list = list->next;
    }
 bind_exit:
  run_unwind_frame ("bind");
  return (return_code);
}
