/******************************************************************************
*******************************************************************************
**
** EXR0R3 - A ring 0/ring 3 IFS skeleton
** Copyright (C) 1993 by Andre Asselin
**
** R0R3SHAR.H - Shared structures between the ring 0 and ring 3 piece
**
** History:
** 6/22/93 - created
**
*******************************************************************************
******************************************************************************/

enum { FSCTL_FUNC_INIT = 0x9000, FSCTL_FUNC_NEXT, FSCTL_FUNC_KILL };

#if defined (__OS2__)
typedef void *LINADDR;
#endif

typedef struct InitStruc {
   LINADDR OpData;
   LINADDR Buf;
} INITSTRUC;

// Make enumerations take a byte or word if possible
#pragma option -b- -a-

typedef enum CPFUNCCODES {
   CPFC_ATTACH = 0x8000, 
   CPFC_CANCELLOCKREQUEST,
   CPFC_CHDIR,
   CPFC_CHGFILEPTR,
   CPFC_CLOSE,
   CPFC_COMMIT,
   CPFC_COPY,
   CPFC_DELETE,
   CPFC_FILEATTRIBUTE,
   CPFC_FILEINFO,
   CPFC_FILELOCKS,
   CPFC_FINDCLOSE,
   CPFC_FINDFIRST,
   CPFC_FINDFROMNAME,
   CPFC_FINDNEXT,
   CPFC_FLUSHBUF,
   CPFC_FSINFO,
   CPFC_MKDIR,
   CPFC_MOVE,
   CPFC_NEWSIZE,
   CPFC_OPENCREATE,
   CPFC_PATHINFO,
   CPFC_PROCESSNAME,
   CPFC_READ,
   CPFC_RMDIR,
   CPFC_VERIFYUNCNAME,
   CPFC_WRITE
} CPFUNCCODES;

typedef struct OpData {
   union {
      CPFUNCCODES funccode;
      unsigned short rc;
   };
   union {
      struct {
         unsigned short flag;
         struct vpfsd vpfsd;
         struct cdfsd cdfsd;
         unsigned short Len;
         char Dev[CCHMAXPATH];
      } attach;
      struct {
         struct sffsi sffsi;
         struct sffsd sffsd;
         struct filelock LockRange;
      } cancellockrequest;
      struct {
         unsigned short flag;
         struct cdfsi cdfsi;
         struct cdfsd cdfsd;
         unsigned short iCurDirEnd;
         char Dir[CCHMAXPATH];
      } chdir;
      struct {
         struct sffsi sffsi;
         struct sffsd sffsd;
         long offset;
         unsigned short type;
         unsigned short IOflag;
      } chgfileptr;
      struct {
         unsigned short type;
         unsigned short IOflag;
         struct sffsi sffsi;
         struct sffsd sffsd;
      } close;
      struct {
         unsigned short type;
         unsigned short IOflag;
         struct sffsi sffsi;
         struct sffsd sffsd;
      } commit;
      struct {
         unsigned short flag;
         struct cdfsi cdfsi;
         struct cdfsd cdfsd;
         unsigned short iSrcCurDirEnd;
         unsigned short iDstCurDirEnd;
         unsigned short nameType;
         char Src[CCHMAXPATH];
         char Dst[CCHMAXPATH];
      } copy;
      struct {
         struct cdfsi cdfsi;
         struct cdfsd cdfsd;
         unsigned short iCurDirEnd;
         char File[CCHMAXPATH];
      } fsdelete;
      struct {
         unsigned short flag;
         struct cdfsi cdfsi;
         struct cdfsd cdfsd;
         unsigned short iCurDirEnd;
         unsigned short Attr;
         char Name[CCHMAXPATH];
      } fileattribute;
      struct {
         unsigned short flag;
         struct sffsi sffsi;
         struct sffsd sffsd;
         unsigned short level;
         unsigned short cbData;
         unsigned short IOflag;
         unsigned long oError;
      } fileinfo;
      struct {
         struct sffsi sffsi;
         struct sffsd sffsd;
         struct filelock UnLockRange;
         struct filelock LockRange;
         unsigned long timeout;
         unsigned long flags;
      } filelocks;
      struct {
         struct fsfsi fsfsi;
         struct fsfsd fsfsd;
      } findclose;
      struct {
         struct cdfsi cdfsi;
         struct cdfsd cdfsd;
         unsigned short iCurDirEnd;
         unsigned short attr;
         struct fsfsi fsfsi;
         struct fsfsd fsfsd;
         unsigned short cbData;
         unsigned short cMatch;
         unsigned short level;
         unsigned short flags;
         unsigned long oError;
         char Name[CCHMAXPATH];
      } findfirst;
      struct {
         struct fsfsi fsfsi;
         struct fsfsd fsfsd;
         unsigned short cbData;
         unsigned short cMatch;
         unsigned short level;
         unsigned short position;
         unsigned short flags;
         unsigned long oError;
         char Name[CCHMAXPATH];
      } findfromname;
      struct {
         struct fsfsi fsfsi;
         struct fsfsd fsfsd;
         unsigned short cbData;
         unsigned short cMatch;
         unsigned short level;
         unsigned short flags;
         unsigned long oError;
      } findnext;
      struct {
         struct vpfsd vpfsd;
         unsigned short flag;
      } flushbuf;
      struct {
         unsigned short flag;
         struct vpfsd vpfsd;
         unsigned short cbData;
         unsigned short level;
      } fsinfo;
      struct {
         struct cdfsi cdfsi;
         struct cdfsd cdfsd;
         unsigned short iCurDirEnd;
         unsigned short flags;
         unsigned long oError;
         char Name[CCHMAXPATH];
      } mkdir;
      struct {
         struct cdfsi cdfsi;
         struct cdfsd cdfsd;
         unsigned short iSrcCurDirEnd;
         unsigned short iDstCurDirEnd;
         unsigned short flags;
         char Src[CCHMAXPATH];
         char Dst[CCHMAXPATH];
      } move;
      struct {
         struct sffsi sffsi;
         struct sffsd sffsd;
         unsigned long len;
         unsigned short IOflag;
      } newsize;
      struct {
         struct cdfsi cdfsi;
         struct cdfsd cdfsd;
         unsigned short iCurDirEnd;
         struct sffsi sffsi;
         struct sffsd sffsd;
         unsigned long ulOpenMode;
         unsigned short usOpenFlag;
         unsigned short usAction;
         unsigned short usAttr;
         unsigned short fgenflag;
         unsigned long oError;
         char Name[CCHMAXPATH];
      } opencreate;
      struct {
         unsigned short flag;
         struct cdfsi cdfsi;
         struct cdfsd cdfsd;
         unsigned short iCurDirEnd;
         unsigned short level;
         unsigned short cbData;
         unsigned long oError;
         char Name[CCHMAXPATH];
      } pathinfo;
      struct {
         char NameBuf[CCHMAXPATH];
      } processname;
      struct {
         struct sffsi sffsi;
         struct sffsd sffsd;
         unsigned short Len;
         unsigned short IOflag;
      } read;
      struct {
         struct cdfsi cdfsi;
         struct cdfsd cdfsd;
         unsigned short iCurDirEnd;
         char Name[CCHMAXPATH];
      } rmdir;
      struct {
         unsigned short flag;
         char Name[CCHMAXPATH];
      } verifyuncname;
      struct {
         struct sffsi sffsi;
         struct sffsd sffsd;
         unsigned short Len;
         unsigned short IOflag;
      } write;
   };
} OPDATA;
