/* This is an example MYKEYS.E file defining an undo key 
   <C> 1993 Joerg Schwieder, Berlin, Germany               */
 
def a_u=                                    -- define ALT-U
    universal undostates                    -- define an universal variable to store UNDOs taken

    undoaction 6, states                    -- get the first and the last actions stored in the UNDO-tree
    parse value states with sfirst slast    -- parse the 2 values into sfirst and slast
    undoakt = undostates                    -- copy our undo-states
    newstate = slast                        -- save the actual state to our new UNDO-state list
    slast = slast - 1                       -- last entry we could UNDO to
    while slast >= sfirst do                -- loop through the UNDO-tree
        parse value undoakt with thisone undoakt    -- look at our last undo
        if (thisone < slast) or (not thisone) or (thisone < sfirst) then
            leave                                   -- if its older than the last tree entry or if
                                                    -- we never undid - leave, it's OK!
        endif
        if thisone then newstate = newstate' 'thisone; endif    -- add our last UNDO to our new list
        if thisone = slast then slast = slast - 1; endif        -- if the actual tree entry is an old UNDO
                                                                -- look at the one before
    endwhile
    if slast >= sfirst then                 -- if a possible tree-entry was found,
        newstate = newstate' 'slast         -- add it to the start of the new UNDO-list
    endif
    while undoakt and (thisone >= sfirst) do    -- add the remaining old UNDO list to the new one
        newstate = newstate' 'thisone           -- but strip entries no longer in the UNDO tree
        parse value undoakt with thisone undoakt
    endwhile
    undostates = newstate                   -- set undostates to the new list
    if slast >= sfirst then                 -- if an entry was fond
        undoaction 7, slast                 -- UNDO
    else
        parse value undostates with . undostates    -- else remove the actual entry from the list
    endif
 
/* This is the sample ALT-S definition for SAVEALL */

def a_s=
    'saveall'

/* Include REVERSE and GLOBFIND keys from the EPM distribution demos if present. */

tryinclude 'reverse.e'
tryinclude 'globfind.e'
