/***************************************************************************/
/* This command file "installs" this issue of EDM/2 on your machine.       */
/***************************************************************************/
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/***************************************************************************/
/* Display the banner                                                      */
/***************************************************************************/
Say "EDM/2 Installation program  Version 1.00"
Say

/***************************************************************************/
/* Check the command line                                                  */
/***************************************************************************/
Parse Upper Arg DRIVE
If DRIVE="" Then DRIVE="C:"
If Length(DRIVE)<>2 | Right(DRIVE,1)<>":" Then Signal Help

/***************************************************************************/
/* Set the VOLUME and ISSUE variables                                      */
/***************************************************************************/
Call SetVars
THISONE="EDMI"||VOLUME||"-"||ISSUE

Say "Attempting to install volume" VOLUME||", issue" ISSUE||"."

/***************************************************************************/
/* Check to see if the boot drive is valid.  Note that we cannot verify    */
/* that this is the boot drive, so we'll have to trust the user            */
/***************************************************************************/
DRIVES=SysDriveMap()
GOOD=0

Do I=1 to Words(DRIVES)
   If DRIVE=Subword(DRIVES,I,1) Then GOOD=1
End

If GOOD=0 Then Do
   Say "Invalid drive specified.  Stop."
   Exit 2
End

/***************************************************************************/
/* Find the fully qualified names of the online document and its icon      */
/***************************************************************************/
WP_DESKTOP=DRIVE||"\OS!2" Left(SysOS2Ver(),3) "Desktop"

Call SysFileTree THISONE||".INF","SEARCH.","FO"
If SEARCH.0=0 Then Do
   Say THISONE||".INF is not in the current directory.  Stop."
   Exit 2
End

FULLNAME=SEARCH.1

Call SysFileTree THISONE||".ICO","SEARCH.","FO"
If SEARCH.0=0 Then Do
   Say THISONE||".ICO is not in the current directory.  Stop."
   Exit 2
End

FULLICON=SEARCH.1

/***************************************************************************/
/* Find the first folder with the title "EDM/2"                            */
/***************************************************************************/
Call SysFileTree WP_DESKTOP||"\EDM!2","SEARCH.","SDO"

If SEARCH.0=0 Then Do
   /************************************************************************/
   /* If a folder was not found, create one off of the desktop             */
   /************************************************************************/
   If SysCreateObject("WPFolder","EDM/2",WP_DESKTOP)=0 Then Do
      Say "Could not create EDM/2 folder.  Stop."
      Exit 2
   End

   SEARCH.1=WP_DESKTOP||"\EDM!2"
End

LOCATION=SEARCH.1

Say "Installing to folder" LOCATION

/***************************************************************************/
/* Create the shadow object and set the icon                               */
/***************************************************************************/
If SysCreateObject("WPShadow",THISONE,LOCATION,"SHADOWID="||FULLNAME)=0 Then Do
   Say "Could not create file object.  Stop."
   Exit 2
End

If SysSetIcon(FULLNAME,FULLICON) Then Do
   Say "Installation complete."
   Exit 0
End
Else Do
   Say "File object was created, but could not set file icon.  Ignored."
   Exit 0
End

Help:
Say "Syntax:  INSTALL [drive:]"
Say "  where 'drive' is an optional parameter specifying the boot drive"
Say "  of your system"
Exit 1

SetVars:
/*****************************************************************************/
/* This function sets the VOLUME and ISSUE variables used by the rest of the */
/* program and is generated by 'newissue.cmd'                                */
/*****************************************************************************/
VOLUME=1
ISSUE=5
Return
