#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#define INCL_GPI
#define INCL_WIN
#include "supergpi.h"

void SetupSegments(HPS hps) {
	SHORT x,y,counter;
	POINTL ptl,ptlTranslate,ptlCenter;
	POINTL ptlStar[6];
	PMATRIXLF translate,identity;
	FIXED afxScale[2];
	
	counter=1;
	GpiSetInitialSegmentAttrs(hps,
								  ATTR_VISIBLE |
								  ATTR_DETECTABLE |
								  ATTR_CHAINED,
								  ATTR_ON);
	identity=(PMATRIXLF)malloc(sizeof(MATRIXLF));
	ptlCenter.x=0;
	ptlCenter.y=0;
	afxScale[0]=MAKEFIXED(1,0);
	afxScale[1]=MAKEFIXED(1,0);
	GpiScale(hps,identity,TRANSFORM_REPLACE,afxScale,&ptlCenter);
	GpiSetViewingTransformMatrix(hps,9L,identity,TRANSFORM_REPLACE);
	ptlStar[0].x=18;
	ptlStar[0].y=-24;
	
	ptlStar[1].x=-28;
	ptlStar[1].y=9;
	
	ptlStar[2].x=28;
	ptlStar[2].y=9;
	
	ptlStar[3].x=-18;
	ptlStar[3].y=-24;
	
	ptlStar[4].x=0;
	ptlStar[4].y=30;
	for (x=0;x<3;x++) {
		for (y=0;y<3;y++) {
			GpiOpenSegment(hps,counter);
			GpiSetTag(hps,counter);
			GpiSetColor(hps,CLR_PALEGRAY);
			ptlTranslate.x=x*150+50;
			ptlTranslate.y=y*150+50;
			translate=(PMATRIXLF)malloc(sizeof(MATRIXLF));
			GpiTranslate(hps,
						 translate,
						 TRANSFORM_REPLACE,
						 &ptlTranslate);
			GpiSetSegmentTransformMatrix(hps,
										 counter,
										 9L,
										 translate,
										 TRANSFORM_REPLACE);
			free(translate);
			switch(counter) {
			case 9:
			case 1:
				ptl.x=0;
				ptl.y=30;
				GpiMove(hps,&ptl);
				GpiPolyLine(hps,5L,ptlStar);
				break;
			case 5:
				ptl.x=-30;
				ptl.y=-30;
				GpiMove(hps,&ptl);
				ptl.x=30;
				ptl.y=30;
				GpiBox(hps,
						   DRO_OUTLINE,
						   &ptl,
						   30L,
						   30L);
				break;
			case 7:
				ptl.x=-30;
				ptl.y=-15;
				GpiMove(hps,&ptl);
				ptl.x=30;
				ptl.y=15;
				GpiBox(hps,
						   DRO_OUTLINE,
						   &ptl,
						   60L,
						   30L);
				break;
			default:
				ptl.x=-30;
				ptl.y=-30;
				GpiMove(hps,&ptl);
				ptl.x=30;
				ptl.y=30;
				GpiBox(hps,
						   DRO_OUTLINE,
						   &ptl,
						   0,
						   0);
				break;
			}
			GpiSetModelTransformMatrix(hps,
										 9L,
										 identity,
										 TRANSFORM_REPLACE);
			GpiCloseSegment(hps);
			counter++;	
		}
	}
	free(identity);
}


MRESULT ClientWndProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2) {
	static SHORT btn1dn,btn2dn,width,height;
	static HPS hps;
	static HDC hdc;
	static SHORT selected;
	static POINTL ptl,mouse,center;
	LONG segtags[4],lMaxHits,lMaxDepth;
	SIZEL sizlPSPage,size;
	PMATRIXLF translate,rotate;
	MATRIXLF matrix;
	FIXED fxAngle;
	POINTL ptlTranslate;
	
	switch(msg) {
	case WM_COMMAND:
		switch(SHORT1FROMMP(mp1)) {
		case IDM_COMPLETE_REFRESH:
			WinPostMsg(hwnd,WM_REFRESH_ALL,NULL,NULL);
			break;
		}
		return(0);
	case WM_BUTTON1DOWN:
		btn1dn=TRUE;
		ptl.x=(LONG)SHORT1FROMMP(mp1);
		ptl.y=(LONG)SHORT2FROMMP(mp1);
		mouse.x=ptl.x;
		mouse.y=ptl.y;
		GpiSetPickAperturePosition(hps,&ptl);
		if (GpiCorrelateChain(hps,
								 PICKSEL_ALL,
								 &ptl,
								 1L,
								 1L,
								 segtags)) {
			selected=segtags[0];
			GpiQuerySegmentTransformMatrix(hps,selected,9L,&matrix);
		} else {
			selected=0;
		}
		return(WinDefWindowProc(hwnd,msg,mp1,mp2));
	case WM_BUTTON1UP:
		btn1dn=FALSE;
		return(WinDefWindowProc(hwnd,msg,mp1,mp2));
	case WM_BUTTON2DOWN:
		btn2dn=TRUE;
		ptl.x=(LONG)SHORT1FROMMP(mp1);
		ptl.y=(LONG)SHORT2FROMMP(mp1);
		mouse.x=ptl.x;
		mouse.y=ptl.y;
		GpiSetPickAperturePosition(hps,&ptl);
		if (GpiCorrelateChain(hps,
								 PICKSEL_ALL,
								 &ptl,
								 1L,
								 1L,
								 segtags)) {
			selected=segtags[0];
		} else {
			selected=0;
		}
		return(WinDefWindowProc(hwnd,msg,mp1,mp2));
	case WM_BUTTON2UP:
		btn2dn=FALSE;
		return(WinDefWindowProc(hwnd,msg,mp1,mp2));
	case WM_MOUSEMOVE:
		if (btn2dn && selected) {
			GpiSetMix(hps,FM_XOR);
			GpiDrawSegment(hps,selected);
			translate=(PMATRIXLF)malloc(sizeof(MATRIXLF));
			ptlTranslate.x=-mouse.x+SHORT1FROMMP(mp1);
			ptlTranslate.y=-mouse.y+SHORT2FROMMP(mp1);
			GpiTranslate(hps,
						 translate,
						 TRANSFORM_REPLACE,
						 &ptlTranslate);
			GpiSetSegmentTransformMatrix(hps,
										 selected,
										 9L,translate,TRANSFORM_ADD);
			free(translate);
			mouse.x=SHORT1FROMMP(mp1);
			mouse.y=SHORT2FROMMP(mp1);
			GpiDrawSegment(hps,selected);
			return(WinDefWindowProc(hwnd,msg,mp1,mp2));
		}
		return(WinDefWindowProc(hwnd,msg,mp1,mp2));
	case WM_CHAR:
		if (SHORT1FROMMP(mp1) & KC_KEYUP) return(0);
	else
		if (SHORT1FROMMP(mp1) & KC_CHAR) {
			fxAngle=MAKEFIXED(3,0);
			switch(SHORT1FROMMP(mp2)) {
			case '=':
			case '+':
				break;
			case '-':
			case '_':
				fxAngle=-fxAngle;
				break;
			default:
				return(0);
			}
			GpiSetMix(hps,FM_XOR);
			GpiDrawSegment(hps,selected);
			rotate=(PMATRIXLF)malloc(sizeof(MATRIXLF));
			center.x=0;
			center.y=0;
			GpiRotate(hps,
					  rotate,
					  TRANSFORM_REPLACE,
					  fxAngle,
					  &center);
			GpiSetSegmentTransformMatrix(hps,
										 selected,
										 9L,
										 rotate,
										 TRANSFORM_PREEMPT);
			free(rotate);
			GpiDrawSegment(hps,selected);
		}
		return(0);
	case WM_CREATE:
		selected=0;
		btn1dn=btn2dn=0;
		sizlPSPage.cx=0L;
		sizlPSPage.cy=0L;
		hdc=WinOpenWindowDC(hwnd); 
		hps=GpiCreatePS(hab,
						hdc,
						&sizlPSPage,
						PU_PELS | 
						GPIF_DEFAULT |
						GPIT_NORMAL |
						GPIA_ASSOC);
		GpiSetDrawingMode(hps,DM_RETAIN);
		size.cx=10L;
		size.cy=10L;
		GpiSetPickApertureSize(hps,PICKAP_REC,&size);
		GpiSetMix(hps,FM_XOR);
		SetupSegments(hps);
		return(0);
	case WM_CLOSE:
		GpiAssociate(hps,NULLHANDLE);
		GpiDestroyPS(hps);
		break;
	case WM_SIZE:
		width=SHORT1FROMMP(mp2);
		height=SHORT2FROMMP(mp2);
		return(0);
	case WM_REFRESH_ALL:
		GpiErase(hps);
		GpiDrawChain(hps);
		return(0);
	case WM_PAINT:
		WinBeginPaint(hwnd,hps,NULL);
		GpiErase(hps);
		GpiSetMix(hps,FM_XOR);
		GpiDrawChain(hps); 
		WinEndPaint(hps);
		return(0);
	}
	return(WinDefWindowProc(hwnd,msg,mp1,mp2));
}




