/* sys/ftime.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include <os2emx.h>
#include <sys/timeb.h>
#include <time.h>
#include <emx/time.h>
#include <emx/syscalls.h>
#include "syscalls.h"

void __ftime (struct timeb *ptr)
{
  DATETIME now;
  struct tm tm;

  DosGetDateTime (&now);
  tm.tm_sec = now.seconds;
  tm.tm_min = now.minutes;
  tm.tm_hour = now.hours;
  tm.tm_mday = now.day;
  tm.tm_mon = now.month - 1;
  tm.tm_year = now.year - 1900;
  tm.tm_isdst = -1;             /* unknown */
  ptr->time = (time_t)_mktime (&tm);
  ptr->millitm = now.hundredths * 10;
  ptr->timezone = now.timezone;
  ptr->dstflag = 0;
}
