/ copysig.s (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes

#include <emx/asm386.h>

#define FUNC    MATHSUFFIX2(copysign)

        .globl  LABEL(FUNC)

        .text

        ALIGN

#if defined (LONG_DOUBLE)

/ long double copysignl (long double x, long double y)

#define x(i)    4+i(%esp)
#define y(i)    16+i(%esp)

LABEL(FUNC):
        PROFILE_NOFRAME
        movb    y(9), %al
        andb    $0x7f, x(9)
        andb    $0x80, %al
        orb     %al, x(9)
        fldt    x(0)
        EPILOGUE(FUNC)

#elif defined (FLOAT)

/ float copysignf (float x, float y)

#define x(i)    4+i(%esp)
#define y(i)    8+i(%esp)

LABEL(FUNC):
        PROFILE_NOFRAME
        movb    y(3), %al
        andb    $0x7f, x(3)
        andb    $0x80, %al
        orb     %al, x(3)
        flds    x(0)
        EPILOGUE(FUNC)

#else

/ double copysign (double x, double y)

#define x(i)    4+i(%esp)
#define y(i)    12+i(%esp)

LABEL(FUNC):
        PROFILE_NOFRAME
        movb    y(7), %al
        andb    $0x7f, x(7)
        andb    $0x80, %al
        orb     %al, x(7)
        fldl    x(0)
        EPILOGUE(FUNC)

#endif
