
"
chapman.st - ChapMan installation script
This script installs the ChapMan system
Execute the script by filing it in or invoking doit.
"

| srcDir dllDir file doit newApp newApp2 chappClass regVer chapManDLL path |
srcDir := Prompter
	prompt: 'Enter directory of the installation files'
	default: Disk fullDirName.
srcDir isNil ifTrue: [^nil].
srcDir := Directory pathName: srcDir.

dllDir := Prompter
	prompt: 'Enter directory wher to put the DLLs'
	default: Disk fullDirName.
dllDir isNil ifTrue: [^nil].
dllDir := Directory pathName: dllDir.

(regVer := File exists: 'chapm11r.dll' in: srcDir)
	ifTrue: [chapManDLL := 'chapm11r']
	ifFalse: [chapManDLL := 'chapm11u'].

Transcript cr.
doit := true.
(Smalltalk includesKey: #ChApplication) ifTrue: [
	doit := MessageBox confirm: 'ChapMan already installed. Installing a new version causes all applications and class comments to be lost. You must have saved all applications in order to recreate them. In addition you must allow the reinitialization of the
 window system, which closes all windows. Proceed?'.
	doit ifTrue: [
		Transcript cr; show: 'Unbinding old ChapMan DLL...'.
		#('chapmu' 'chapmr' 'chapm11u' 'chapm11r') do: [:each |
			(ObjectLibraryBind isBound: each) ifTrue: [
				ObjectLibraryBind unBind: each]
			]
		]
	].

doit ifTrue: [
	dllDir fullDirName ~= srcDir fullDirName ifTrue: [
		path := dllDir fullDirName.
		dllDir pathName trimBlanks size > 1 
			ifTrue: [path := path copyFrom: 1 to: path size - 1].
		Transcript cr; show: 'Copying (new) DLL files...'.
		(Array with: 'chapmres.dll' with: chapManDLL, '.dll') do: [:each |
			File copy: srcDir fullDirName, each to: path]
		].

	file := srcDir fileReadOnly: 'BugFix20.cls'.
	Transcript cr; show: 'Filing in ', file pathName, '...'.
	file fileIn; close.

	Transcript cr; show: 'Binding object library ', chapManDLL, '...'.
	ObjectLibraryBind bindTo: chapManDLL.

	(ObjectLibraryBind isBound: 'vpmolb20') ifFalse: [
		Transcript
			cr; show: 'Object Library Builder not installed.';
			cr; show: 'Binding object library vpmolb20.dll...'.
		ObjectLibraryBind bindTo: 'vpmolb20'].
		

	file := srcDir fileReadOnly: 'ChapMInt.cls'.
	Transcript cr; show: 'Filing in ', file pathName, '...'.
	file fileIn; close.

	Transcript cr; show: 'Filing in application data...'.
	chappClass := Smalltalk at: #ChUserApplication.
	#('bugfix20.cha' 'ChapMInt.cha') do: [:each |
		newApp := chappClass newFromFile: srcDir fullDirName, 
			each subApplications: false.
		chappClass subApplication: newApp of: nil].
	
	newApp2 := chappClass newFromFile: srcDir fullDirName, 
		'ChapMan.cha' subApplications: false.
	chappClass subApplication: newApp2 of: newApp.

	#('Register.cha' 'GenTools.cha') do: [:each |
		newApp := chappClass newFromFile: srcDir fullDirName,
			each subApplications: false.
		chappClass subApplication: newApp of: newApp2].

	Transcript cr; show: 'ChapMan installed.'; cr.
	MessageBox message: 'Reinitialization of the window system will be done.'.
	Notifier reinitialize]

ifFalse: [
	Transcript cr; show: 'Installation aborted'] !

