/* 1134, Wed 17 Mar 93

   PRTSERV.H: Globals for RS232 Print Server

   Copyright (C) 1993 by Nevil Brownlee
   Computer Centre,  University of Auckland */

#ifndef EXTERN
#define EXTERN  extern
#define DECLARE  0
#define INIT(v)
#else
#define EXTERN
#define DECLARE  1
#define INIT(v)  = v
#endif

EXTERN time_t
   startup_t INIT(0),
   last_reset_t INIT(0);

EXTERN unsigned int ln_speed_v INIT(9600);
EXTERN char ln_parity_v INIT('N');
EXTERN int bufsz_v INIT(4096),
   maxchar_v INIT(1000), minchar_v INIT(200);

struct printer_i_s {
   char printer_name[20];
   int tcpport_nbr;
   unsigned int address;
   char int_level;
   unsigned int ln_speed;
   char ln_parity;
   int bufsz, maxchar, minchar;

   int high_water;
   long chars_sent;
   char xoff_sent;
   struct asy_port *ap;
   };

EXTERN struct printer_i_s printer_info[4]
#if DECLARE
   = {
      { "printer1", 2001, 0x3F8, 4, 0 },
      { "printer2", 2002, 0x2F8, 3, 0 },
      { "printer3", 2003, 0x3E8, 5, 0 },
      { "printer4", 2004, 0x2E8, 2, 0 }
      }
#endif
   ;

EXTERN char
   server_name[40] INIT("AU Async Print Server"),
   server_password[25] INIT("sesame");

typedef struct {
   char status;
   tcp_Socket socket;
   int tcpport;

   char print_ix;  /* COM port for this tcp session (0 = control) */
   } prtinfo;

#define MAXPRTSES      5

EXTERN int ps_sessions INIT(MAXPRTSES);
EXTERN prtinfo *prt[MAXPRTSES];

#define S_INIT  0  /* Session states */
#define S_WAIT  1
#define S_CONN  2  /* Connected and talking */
#define S_CLOS  3

EXTERN char messagebuf[1024];  /* Incoming messages land here */

/* Telnet globals and routines .. */

#define RBUFSIZ 160
EXTERN char *rbp, replybuf[RBUFSIZ];
#define TSBUFSIZ 41
EXTERN char sb[TSBUFSIZ];

EXTERN int tobufx,tobuflim;
EXTERN tcp_Socket *tn;

EXTERN int TOdebug INIT(0),  /* Display telnet options */
   sgaflg INIT(0),  /* Telnet SGA flag */
   echo INIT(0);  /* Default off (host will echo locally) */

void printTO(char *msg,int cmd,int opt);
void send_iac(int cmd,int opt);
void please_echo(void);
int tn_sttyp(void);
int tn_ini(void);
int ttinc(void);
int tn_doop(int c);
int TO_parse(tcp_Socket *tn, int len);

/* COM Port globals and routines .. */

#define CR           13  /* ASCII special characters */
#define LF           10
#define SOH           1
#define SP           32
#define DEL         127
#define BS            8
#define ESC          27
#define CTLC          3
#define CTLE          5
#define CTLX         24
#define CTLZ         26
#define XON          17
#define XOFF         19

struct asy_port {  /* Hardware-related COM port data */
   char far *apbase;
   unsigned int rxbmsk,rxbmax,rxbemp, txbmsk,txbmax;
   unsigned int combase,comctrl,comiir,commdm,comline;
   unsigned int intctrl,intmask;
   unsigned int txhead,txtail,txcount;
   unsigned int rxhead,rxtail,rxspace,rxlost;
   unsigned int comadr,portseg;
   unsigned int txbuf;
   unsigned char intlev,eoici,mskci,enaci;
   unsigned char xonctl;
   unsigned char txXOFF,lecho;
   unsigned char rxXOFF,usrXOFF,rxbad;
#ifdef DBTRACE  /* Trace buffer for ntasy routines */
   unsigned int trctail;
   unsigned char trcbuf[8192];
#endif
   };

struct asy_port *COMopen(int comport);

void cominit(struct asy_port *);      /* Initialise com handling */
void comfin(struct asy_port *);       /* Restore DOS com handling */
int reg(struct asy_port *,int,int,int);  /* Read/write 8250 register */
int comrecv(struct asy_port *);       /* Receive a char,
                                            -1 if none in rx buffer */
int comsend(struct asy_port *,int);   /* Send a char,
                                            -1 if no room in tx buffer */
int comrbuf(struct asy_port *,int);   /* Nbr of chars in rx buffer */
int comrerr(struct asy_port *);       /* Nbr of chars lost.
                                            Resets lost-char count */
int comsbuf(struct asy_port *,int);   /* abs(result) = chars in send buffer,
					       <0 if waiting for XON.
					    c nonzero to clear txXOFF */

void print_config(tcp_Socket *t);  /* Routines in prtcom */
void get_prt_config(void);

void put_msg(tcp_Socket *t,char *msg);  /* Routines in prtserv */
void print_state(tcp_Socket *t);

