#include <stdio.h>

#include <stropts.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <net/if.h>

#include <sys/file.h>
#include <sys/ioctl.h>
#include <net/nit_if.h>
#include <net/nit_pf.h>
#include <net/nit_buf.h>

#define NIT_DEV "/dev/nit"
char *device = "le0";

#define CHUNKSIZE  50000
#define SNAPLEN       62
/* #define SNAPLEN       38  /* 6+6+2 + 8+8+8 */

int if_fd;  /* nit file descriptor */

initdevice(if_flags, snaplen, chunksize)
u_long if_flags,
   snaplen,
   chunksize;
{
   struct strioctl     si;
   struct ifreq   ifr;
   struct timeval timeout;

   if_fd = open(NIT_DEV, O_RDONLY);

   /* Arrange to get discrete messages from the stream. */
   ioctl(if_fd, I_SRDOPT, (char *)RMSGD);

   si.ic_timout = INFTIM;

   /* and configure the buffering module. */
   ioctl(if_fd, I_PUSH, "nbuf");

   timeout.tv_sec = 1;
   timeout.tv_usec = 0;
   si.ic_cmd = NIOCSTIME;
   si.ic_len = sizeof timeout;
   si.ic_dp = (char *)&timeout;
   ioctl(if_fd, I_STR, (char *)&si);

   si.ic_cmd = NIOCSCHUNK;
   si.ic_len = sizeof chunksize;
   si.ic_dp = (char *)&chunksize;

   ioctl(if_fd, I_STR, (char *)&si);

   /* Configure the nit device, binding it to the proper
      underlying interface, setting the snapshot length,
      and setting nit_if-level flags. */

   strcpy(ifr.ifr_name, device);
   si.ic_cmd = NIOCBIND;
   si.ic_len = sizeof ifr;
   si.ic_dp = (char *)&ifr;
   ioctl(if_fd, I_STR, (char *)&si);

   if (snaplen > 0) {
      si.ic_cmd = NIOCSSNAP;
      si.ic_len = sizeof snaplen;
      si.ic_dp = (char *)&snaplen;
      ioctl(if_fd, I_STR, (char *)&si);
      }

   if (if_flags != 0) {
      si.ic_cmd = NIOCSFLAGS;
      si.ic_len = sizeof if_flags;
      si.ic_dp = (char *)&if_flags;
      ioctl(if_fd, I_STR, (char *)&si);
      }

   /* Flush the read queue, to get rid of anything that accumulated
      before the device reached its final configuration. */

   if (ioctl(if_fd, I_FLUSH, (char *)FLUSHR) < 0) {
      close(if_fd);
      printf("FLUSH failed\n");
      }
   }

#include "decnet.h"

#define MAXPKTLEN  1526
#define NPKTTYPES   100
#define NSNAPTYPES   50
#define NIPXPAIRS   200
#define DECFLAGS    100

struct pt_entry {
   u_char type[2];  /* snmp variables */
   u_long packets;
   u_long bytes;

   int pkt_type;    /* for searching the table */
   };
struct pt_entry pt_table[NPKTTYPES+1] = {
   {{0,0}, 0,0, 0 }
   };
int packet_types = 0;

struct snap_entry {
   u_char type[2];  /* snmp variables */
   u_long packets;
   u_long bytes;

   int pkt_type;    /* for searching the table */
   };
struct snap_entry snap_table[NSNAPTYPES+1] = {
   {{0,0}, 0,0, 0 }
   };
int snap_types = 0;

struct ipx_pair {
   u_char dest_net[4];
   u_char source_net[4];
   u_long packets;
   u_long bytes;

   int marker;
   };
struct ipx_pair ipx_table[NIPXPAIRS+1] = {
   {{0,0,0,0},{0,0,0,0}, 0,0, 0 }
   };
int ipx_pairs = 0;

struct dn_entry {
   u_char type[2];  /* snmp variables */
   u_long packets;
   u_long bytes;

   int pkt_type;    /* for searching the table */
   };
struct dn_entry dn_table[DECFLAGS+1] = {
   {{0,0}, 0,0, 0 }
   };
int dec_flags = 0;

int dn_node(dn_addr)
unsigned char *dn_addr;
{
   return dn_addr[1]<<8 | dn_addr[0];
   }

#define dn_area(node) (node >> 10)
#define dn_host(node) (node & 0x3FF)

void main(argc,argv)
int argc;
char *argv[];
{
   int cc;
   unsigned char buf[CHUNKSIZE];

   int tflag = 0, dflag = 0, lflag = 1;

   int j;
   int pkt_type;
   FILE *log;
   int npkts = 36000/2;  /* Log this many, then stop */
                    /* 0101 packets: 20 in 5s, 100 in 15s */
                    /* Fred says there are 10 per second */
   struct pt_entry *ptep;
   struct snap_entry *snep;
   struct ipx_pair *ipxp;
   struct dn_entry *dnep;

   union decnet *dp;
   int dlen, snode, dnode, dtype, area, host;

   unsigned long n_0101, n_other;

   u_long flags = NI_PROMISC;

   if (tflag) flags |= NI_TIMESTAMP;
   if (dflag) flags |= NI_DROPS;
   if (lflag) flags |= NI_LEN;
   initdevice(flags,SNAPLEN,CHUNKSIZE);

   n_0101 = n_other = 0;

   log = fopen("nit.log","wb");

   while ((cc = read(if_fd, buf, CHUNKSIZE)) >= 0) {
      register u_char *bp = buf,
         *bufstop = buf+cc;

      /* Loop through each message in the chunk. */

      while (bp < bufstop) {
         register u_char     *cp = bp;
         struct nit_bufhdr   *hdrp;
         struct timeval      *tvp;
         u_long              drops;
         u_long              pktlen;

         hdrp = (struct nit_bufhdr *)cp;
         cp += sizeof *hdrp;
         if (tflag) {
            struct nit_iftime   *ntp;

            ntp = (struct nit_iftime *)cp;
            cp += sizeof *ntp;

            tvp = &ntp->nh_timestamp;
            }
         if (dflag) {
            struct nit_ifdrops  *ndp;

            ndp = (struct nit_ifdrops *)cp;
            cp += sizeof *ndp;

            drops = ndp->nh_drops;
            }
         if (lflag) {
            struct nit_iflen    *nlp;

            nlp = (struct nit_iflen *)cp;
            cp += sizeof *nlp;

            pktlen = nlp->nh_pktlen;
            }
         else
            pktlen = hdrp->nhb_msglen;

         bp += hdrp->nhb_totlen;

         /* Process the packet. */

	 pkt_type = cp[12]<<8 | cp[13];
         if (pkt_type > MAXPKTLEN) {  /* Blue Book packet */
	    for (ptep = pt_table; ptep->pkt_type != 0; ++ptep) {
		if (ptep->pkt_type == pkt_type) break;
		}
	    if (ptep->pkt_type == 0  /* Packet type not found */
		    && packet_types != NPKTTYPES) {  
		ptep->type[0] = cp[12];  ptep->type[1] = cp[13];
		ptep->pkt_type = pkt_type;
		ptep->packets = ptep->bytes = 0;
		(ptep + 1)->pkt_type = 0;
		packet_types += 1;
		}
            ptep->packets += 1;
            ptep->bytes += pktlen;

            if (pkt_type == 0x6003) {  /* DECnet */
	       pkt_type = cp[16]<<8 | cp[17];
	       for (dnep = dn_table; dnep->pkt_type != 0; ++dnep) {
		   if (dnep->pkt_type == pkt_type) break;
		   }
	       if (dnep->pkt_type == 0  /* Packet type not found */
		     && packet_types != DECFLAGS) {  
	          dnep->type[0] = cp[16];  dnep->type[1] = cp[17];
	          dnep->pkt_type = pkt_type;
	          dnep->packets = dnep->bytes = 0;
	          (dnep + 1)->pkt_type = 0;
	          dec_flags += 1;
	          }
               dnep->packets += 1;
               dnep->bytes += pktlen;

	       dlen = cp[15]<<8 | cp[14];
               if (pktlen > 60 && dlen != pktlen-16) printf(
                  "type=%02x %02x, dlen=%d, pktlen-16=%d\n", 
                  cp[16],cp[17], dlen,pktlen-16);

               dtype = cp[16];
               if (dtype != 0x81) dp = (union decnet *)&cp[17];
               else {
                  dtype = cp[17];
                  dp = (union decnet *)&cp[18];
	          }
               switch (dtype) {
	       case 0x07:  /* Level 1 routing */
                  snode = dn_node(dp->l1r.src_dn_addr);
                  printf("Level 1 routing from %d.%d\n",
                     dn_area(snode),dn_host(snode));
                  break;
	       case 0x09:  /* Level 2 routing */
                  snode = dn_node(dp->l2r.src_dn_addr);
                  printf("Level 2 routing from %d.%d\n",
                     dn_area(snode),dn_host(snode));
                  break;
	       case 0x0B:  /* Router hello */
                  snode = dn_node(dp->rh.src_dn_addr);
                  dnode = dn_node(dp->rh.rtr_dn_addr);
                  printf("Router hello from %d.%d, other router %d.%d\n",
                     dn_area(snode),dn_host(snode),
                     dn_area(dnode),dn_host(dnode) );
                  break;
	       case 0x0D:  /* Endnode hello */
                  snode = dn_node(dp->eh.src_dn_addr);
                  dnode = dn_node(dp->eh.rtr_dn_addr);
                  printf("Endnode hello from %d.%d, designated router %d.%d\n",
                     dn_area(snode),dn_host(snode),
                     dn_area(dnode),dn_host(dnode) );
                  break;
	       case 0x26:  /* Data */
	       case 0x2E:  /* Data */
                  dnode = dn_node(dp->d.dest_dn_addr);
                  snode = dn_node(dp->d.src_dn_addr);
                  printf("Data to %d.%d from %d.%d\n",
                     dn_area(dnode),dn_host(dnode),
                     dn_area(snode),dn_host(snode) );
                  break;
	       default:  /* Unknown DECnet type */
                  printf("Unexpected DECnet packet, type %02x, data: ",
                     cp[16]);
                  for (j=17; j != 34; ++j) printf(" %02x",cp[j]);
                  printf("\n");
                  break;
	          }
               fflush(stdout);
               }
	    }
         else if (cp[14] == 0xAA && cp[15] == 0xAA) {  /* SNAP packet */
	    pkt_type = cp[20]<<8 | cp[21];
	    for (snep = snap_table; snep->pkt_type != 0; ++snep) {
		if (snep->pkt_type == pkt_type) break;
		}
	    if (snep->pkt_type == 0  /* Packet type not found */
		    && snap_types != NSNAPTYPES) {  
		snep->type[0] = cp[20];  snep->type[1] = cp[21];
		snep->pkt_type = pkt_type;
		snep->packets = snep->bytes = 0;
		(snep + 1)->pkt_type = 0;
		snap_types += 1;
		}
            snep->packets += 1;
            snep->bytes += pktlen;
            }
         else if (cp[14] == 0xFF && cp[15] == 0xFF) {  /* IPX */
	    for (ipxp = ipx_table; ipxp->marker != 0; ++ipxp) {
                if (memcmp(ipxp->dest_net,&cp[20],4) == 0 &&
                   memcmp(ipxp->source_net,&cp[32],4) == 0) break;
		}
	    if (ipxp->marker == 0  /* Packet type not found */
		    && ipx_pairs != NIPXPAIRS) {  
                memcpy(ipxp->dest_net,&cp[20],4);
                memcpy(ipxp->source_net,&cp[32],4);
		ipxp->marker = 1;
		ipxp->packets = ipxp->bytes = 0;
		(ipxp + 1)->marker = 0;
		ipx_pairs += 1;
		}
            ipxp->packets += 1;
            ipxp->bytes += pktlen;
            }
         else if (cp[14] == 0x01 && cp[15] == 0x01) {
            n_0101 += 1;  /* Time */
            if (npkts-- == 0) {

   printf("\n%lu 'Other' packets,  %lu '0101' packets\n",
      n_other,n_0101);
   printf("\nBlue Book Packet Types ..    type     packets       bytes\n");
   for (ptep = pt_table; ptep->pkt_type != 0; ++ptep) {
      printf("                             %02x %02x     %6lu  %10lu\n",
         ptep->type[0],ptep->type[1], ptep->packets, ptep->bytes);
         }
   printf("\n802.2 SNAP Packet Types ..   type     packets       bytes\n");
   for (snep = snap_table; snep->pkt_type != 0; ++snep) {
      printf("                             %02x %02x     %6lu  %10lu\n",
         snep->type[0],snep->type[1], snep->packets, snep->bytes);
         }
   printf("\nIPX Pairs ..   dest      source       packets       bytes\n");
   for (ipxp = ipx_table; ipxp->marker != 0; ++ipxp) {
      printf("          %02x %02x %02x %02x  %02x %02x %02x %02x     %6lu  %10lu\n",
         ipxp->dest_net[0],ipxp->dest_net[1],
            ipxp->dest_net[2],ipxp->dest_net[3],
         ipxp->source_net[0],ipxp->source_net[1],
            ipxp->source_net[2],ipxp->source_net[3],
         ipxp->packets, ipxp->bytes);
         }
   printf("\nDECnet flag values      ..   type     packets       bytes\n");
   for (dnep = dn_table; dnep->pkt_type != 0; ++dnep) {
      printf("                             %02x %02x     %6lu  %10lu\n",
         dnep->type[0],dnep->type[1], dnep->packets, dnep->bytes);
         }

               exit(0);
               }
            }
         else n_other += 1;

         }
      }

   }
